/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.objectstyle.cayenne.Persistent;
import org.objectstyle.cayenne.map.EntityResolver;
import org.objectstyle.cayenne.map.ObjEntity;
import org.objectstyle.cayenne.map.ObjRelationship;
import org.objectstyle.cayenne.property.Property;
import org.objectstyle.cayenne.query.RelationshipQuery;

public abstract class RelationshipFault {
    protected Persistent relationshipOwner;
    protected String relationshipName;

    protected RelationshipFault() {
    }

    public RelationshipFault(Persistent relationshipOwner, String relationshipName) {
        if (relationshipOwner == null) {
            throw new NullPointerException("'relationshipOwner' can't be null.");
        }
        if (relationshipName == null) {
            throw new NullPointerException("'relationshipName' can't be null.");
        }
        this.relationshipOwner = relationshipOwner;
        this.relationshipName = relationshipName;
    }

    public String getRelationshipName() {
        return this.relationshipName;
    }

    public Persistent getRelationshipOwner() {
        return this.relationshipOwner;
    }

    protected boolean isTransientParent() {
        int state = this.relationshipOwner.getPersistenceState();
        return state == 2 || state == 1;
    }

    protected boolean isUncommittedParent() {
        int state = this.relationshipOwner.getPersistenceState();
        return state == 4 || state == 6;
    }

    protected List resolveFromDB() {
        if (this.isTransientParent()) {
            return new ArrayList();
        }
        List resolved = this.relationshipOwner.getObjectContext().performQuery(new RelationshipQuery(this.relationshipOwner.getObjectId(), this.relationshipName, false));
        if (resolved.isEmpty()) {
            return resolved;
        }
        EntityResolver resolver = this.relationshipOwner.getObjectContext().getEntityResolver();
        ObjEntity sourceEntity = resolver.lookupObjEntity(this.relationshipOwner.getObjectId().getEntityName());
        ObjRelationship relationship = (ObjRelationship)sourceEntity.getRelationship(this.relationshipName);
        ObjRelationship reverse = relationship.getReverseRelationship();
        if (reverse != null && !reverse.isToMany()) {
            Property property = resolver.getClassDescriptor(reverse.getSourceEntity().getName()).getProperty(reverse.getName());
            Iterator it = resolved.iterator();
            while (it.hasNext()) {
                property.writePropertyDirectly(it.next(), null, this.relationshipOwner);
            }
        }
        return resolved;
    }
}

