/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.Predicate;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.objectstyle.cayenne.conf.Configuration;

public class ResourceLocator {
    private static Logger logObj;
    protected boolean skipAbsolutePath;
    protected boolean skipClasspath;
    protected boolean skipCurrentDirectory;
    protected boolean skipHomeDirectory;
    protected List additionalClassPaths = new ArrayList();
    protected List additionalFilesystemPaths = new ArrayList();
    protected ClassLoader classLoader;

    public static InputStream findResourceInClasspath(String name) {
        try {
            URL url = ResourceLocator.findURLInClasspath(name);
            if (url != null) {
                logObj.debug("resource found in classpath: " + url);
                return url.openStream();
            }
            logObj.debug("resource not found in classpath: " + name);
            return null;
        }
        catch (IOException ioex) {
            return null;
        }
    }

    public static InputStream findResourceInFileSystem(String name) {
        try {
            File file = ResourceLocator.findFileInFileSystem(name);
            if (file != null) {
                logObj.debug("resource found in file system: " + file);
                return new FileInputStream(file);
            }
            logObj.debug("resource not found in file system: " + name);
            return null;
        }
        catch (IOException ioex) {
            return null;
        }
    }

    public static File findFileInFileSystem(String name) {
        File file = ResourceLocator.findFileInHomeDirectory(name);
        if (file == null) {
            file = ResourceLocator.findFileInCurrentDirectory(name);
        }
        if (file != null) {
            logObj.debug("file found in file system: " + file);
        } else {
            logObj.debug("file not found in file system: " + name);
        }
        return file;
    }

    public static File findFileInHomeDirectory(String name) {
        String homeDirPath = System.getProperty("user.home") + File.separator + name;
        try {
            File file = new File(homeDirPath);
            if (file.exists() && file.canRead()) {
                logObj.debug("file found in home directory: " + file);
            } else {
                file = null;
                logObj.debug("file not found in home directory: " + name);
            }
            return file;
        }
        catch (SecurityException se) {
            logObj.debug("permission denied reading file: " + homeDirPath, se);
            return null;
        }
    }

    public static File findFileInCurrentDirectory(String name) {
        String currentDirPath = System.getProperty("user.dir") + File.separator + name;
        try {
            File file = new File(currentDirPath);
            if (file.exists() && file.canRead()) {
                logObj.debug("file found in current directory: " + file);
            } else {
                logObj.debug("file not found in current directory: " + name);
                file = null;
            }
            return file;
        }
        catch (SecurityException se) {
            logObj.debug("permission denied reading file: " + currentDirPath, se);
            return null;
        }
    }

    public static URL findURLInClasspath(String name) {
        ClassLoader classLoader = ResourceLocator.class.getClassLoader();
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        return ResourceLocator.findURLInClassLoader(name, classLoader);
    }

    public static URL findURLInClassLoader(String name, ClassLoader loader) {
        URL url = loader.getResource(name);
        if (url != null) {
            logObj.debug("URL found with classloader: " + url);
        } else {
            logObj.debug("URL not found with classloader: " + name);
        }
        return url;
    }

    public static String classBaseUrl(Class aClass) {
        URL selfUrl;
        String pathToClass = aClass.getName().replace('.', '/') + ".class";
        ClassLoader classLoader = aClass.getClassLoader();
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        if ((selfUrl = classLoader.getResource(pathToClass)) == null) {
            return null;
        }
        String urlString = selfUrl.toExternalForm();
        return urlString.substring(0, urlString.length() - pathToClass.length());
    }

    public InputStream findResourceStream(String name) {
        URL url = this.findResource(name);
        if (url == null) {
            return null;
        }
        try {
            return url.openStream();
        }
        catch (IOException ioex) {
            logObj.debug("Error reading URL, ignoring", ioex);
            return null;
        }
    }

    public URL findResource(String name) {
        File f;
        if (!this.willSkipAbsolutePath()) {
            f = new File(name);
            if (f.isAbsolute() && f.exists()) {
                logObj.debug("File found at absolute path: " + name);
                try {
                    return f.toURL();
                }
                catch (MalformedURLException ex) {
                    logObj.debug("Malformed url, ignoring.", ex);
                }
            } else {
                logObj.debug("No file at absolute path: " + name);
            }
        }
        if (!this.willSkipHomeDirectory() && (f = ResourceLocator.findFileInHomeDirectory(name)) != null) {
            try {
                return f.toURL();
            }
            catch (MalformedURLException ex) {
                logObj.debug("Malformed url, ignoring", ex);
            }
        }
        if (!this.willSkipCurrentDirectory() && (f = ResourceLocator.findFileInCurrentDirectory(name)) != null) {
            try {
                return f.toURL();
            }
            catch (MalformedURLException ex) {
                logObj.debug("Malformed url, ignoring", ex);
            }
        }
        if (!this.additionalFilesystemPaths.isEmpty()) {
            logObj.debug("searching additional paths: " + this.additionalFilesystemPaths);
            Iterator pi = this.additionalFilesystemPaths.iterator();
            while (pi.hasNext()) {
                File f2 = new File((String)pi.next(), name);
                logObj.debug("searching for: " + f2.getAbsolutePath());
                if (!f2.exists()) continue;
                try {
                    return f2.toURL();
                }
                catch (MalformedURLException ex) {
                    logObj.debug("Malformed URL, ignoring.", ex);
                }
            }
        }
        if (!this.willSkipClasspath()) {
            URL url;
            if (!this.additionalClassPaths.isEmpty()) {
                logObj.debug("searching additional classpaths: " + this.additionalClassPaths);
                Iterator cpi = this.additionalClassPaths.iterator();
                while (cpi.hasNext()) {
                    String fullName = cpi.next() + "/" + name;
                    logObj.debug("searching for: " + fullName);
                    URL url2 = ResourceLocator.findURLInClassLoader(fullName, this.getClassLoader());
                    if (url2 == null) continue;
                    return url2;
                }
            }
            if ((url = ResourceLocator.findURLInClassLoader(name, this.getClassLoader())) != null) {
                return url;
            }
        }
        return null;
    }

    public URL findDirectoryResource(String name) {
        URL url = this.findResource(name);
        if (url == null) {
            return null;
        }
        try {
            String urlSt = url.toExternalForm();
            return urlSt.endsWith("/") ? url : new URL(urlSt + "/");
        }
        catch (MalformedURLException ex) {
            logObj.debug("Malformed URL, ignoring.", ex);
            return null;
        }
    }

    public boolean willSkipHomeDirectory() {
        return this.skipHomeDirectory;
    }

    public void setSkipHomeDirectory(boolean skipHomeDir) {
        this.skipHomeDirectory = skipHomeDir;
    }

    public boolean willSkipCurrentDirectory() {
        return this.skipCurrentDirectory;
    }

    public void setSkipCurrentDirectory(boolean skipCurDir) {
        this.skipCurrentDirectory = skipCurDir;
    }

    public boolean willSkipClasspath() {
        return this.skipClasspath;
    }

    public void setSkipClasspath(boolean skipClasspath) {
        this.skipClasspath = skipClasspath;
    }

    public ClassLoader getClassLoader() {
        ClassLoader loader = this.classLoader;
        if (loader == null) {
            loader = Thread.currentThread().getContextClassLoader();
        }
        if (loader == null) {
            loader = this.getClass().getClassLoader();
        }
        if (loader == null) {
            loader = ClassLoader.getSystemClassLoader();
        }
        return loader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public boolean willSkipAbsolutePath() {
        return this.skipAbsolutePath;
    }

    public void setSkipAbsolutePath(boolean skipAbsPath) {
        this.skipAbsolutePath = skipAbsPath;
    }

    public void addClassPath(String customPath) {
        this.additionalClassPaths.add(customPath);
    }

    public void addFilesystemPath(String path) {
        if (path == null) {
            throw new IllegalArgumentException("Path must not be null.");
        }
        this.additionalFilesystemPaths.add(path);
    }

    public void addFilesystemPath(File path) {
        if (path == null || !path.isDirectory()) {
            throw new IllegalArgumentException("Path '" + path + "' is not a directory.");
        }
        this.addFilesystemPath(path.getPath());
    }

    static {
        Predicate p = new Predicate(){

            public boolean evaluate(Object o) {
                return Configuration.isLoggingConfigured();
            }
        };
        logObj = new PredicateLogger(ResourceLocator.class, p);
    }

    protected static class PredicateLogger
    extends Logger {
        private Logger _target;
        private Predicate _predicate;

        private PredicateLogger(String name) {
            super(name);
        }

        public PredicateLogger(Class clazz, Predicate condition) {
            this(clazz.getName(), condition);
        }

        public PredicateLogger(String name, Predicate condition) {
            this(name);
            this._target = Logger.getLogger(name);
            this._predicate = condition;
        }

        public void debug(Object arg0, Throwable arg1) {
            this.log(Level.DEBUG, arg0, arg1);
        }

        public void debug(Object arg0) {
            this.log(Level.DEBUG, arg0);
        }

        public void info(Object arg0, Throwable arg1) {
            this.log(Level.INFO, arg0, arg1);
        }

        public void info(Object arg0) {
            this.log(Level.INFO, arg0);
        }

        public void warn(Object arg0, Throwable arg1) {
            this.log(Level.WARN, arg0, arg1);
        }

        public void warn(Object arg0) {
            this.log(Level.WARN, arg0);
        }

        public void error(Object arg0, Throwable arg1) {
            this.log(Level.ERROR, arg0, arg1);
        }

        public void error(Object arg0) {
            this.log(Level.ERROR, arg0);
        }

        public void fatal(Object arg0, Throwable arg1) {
            this.log(Level.FATAL, arg0, arg1);
        }

        public void fatal(Object arg0) {
            this.log(Level.FATAL, arg0);
        }

        public void log(Priority arg0, Object arg1, Throwable arg2) {
            if (this._predicate.evaluate(arg1)) {
                this._target.log(arg0, arg1);
            }
        }

        public void log(Priority arg0, Object arg1) {
            if (this._predicate.evaluate(arg1)) {
                this._target.log(arg0, arg1);
            }
        }
    }
}

