/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.tools.ij;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.Stack;
import org.apache.derby.iapi.services.info.ProductVersionHolder;
import org.apache.derby.iapi.tools.i18n.LocalizedInput;
import org.apache.derby.iapi.tools.i18n.LocalizedOutput;
import org.apache.derby.iapi.tools.i18n.LocalizedResource;
import org.apache.derby.impl.tools.ij.ConnectionEnv;
import org.apache.derby.impl.tools.ij.ParseException;
import org.apache.derby.impl.tools.ij.StatementFinder;
import org.apache.derby.impl.tools.ij.TokenMgrError;
import org.apache.derby.impl.tools.ij.UCode_CharStream;
import org.apache.derby.impl.tools.ij.ij;
import org.apache.derby.impl.tools.ij.ijException;
import org.apache.derby.impl.tools.ij.ijFatalException;
import org.apache.derby.impl.tools.ij.ijResult;
import org.apache.derby.impl.tools.ij.ijRowResult;
import org.apache.derby.impl.tools.ij.ijTokenException;
import org.apache.derby.impl.tools.ij.ijTokenManager;
import org.apache.derby.impl.tools.ij.util;
import org.apache.derby.tools.JDBCDisplayUtil;

public class utilMain
implements PrivilegedAction {
    private StatementFinder[] commandGrabber;
    UCode_CharStream charStream;
    ijTokenManager ijTokMgr;
    ij ijParser;
    ConnectionEnv[] connEnv;
    private int currCE;
    private final int numConnections;
    private boolean fileInput;
    private boolean initialFileInput;
    private boolean mtUse;
    private boolean firstRun = true;
    private LocalizedOutput out = null;
    private Properties connAttributeDefaults;
    private Hashtable ignoreErrors;
    private final boolean showErrorCode;
    private final String ijExceptionTrace;
    public static final int BUFFEREDFILESIZE = 2048;
    Stack oldGrabbers = new Stack();
    LocalizedResource langUtil = LocalizedResource.getInstance();

    utilMain(int n, LocalizedOutput localizedOutput) throws ijFatalException {
        this(n, localizedOutput, null);
    }

    public utilMain(int n, LocalizedOutput localizedOutput, Hashtable hashtable) throws ijFatalException {
        this.charStream = new UCode_CharStream(new StringReader(" "), 1, 1);
        this.ijTokMgr = new ijTokenManager(this.charStream);
        this.ijParser = new ij(this.ijTokMgr, this);
        this.out = localizedOutput;
        this.ignoreErrors = hashtable;
        this.showErrorCode = Boolean.valueOf(util.getSystemProperty("ij.showErrorCode"));
        this.ijExceptionTrace = util.getSystemProperty("ij.exceptionTrace");
        this.numConnections = n;
        this.commandGrabber = new StatementFinder[n];
        this.connEnv = new ConnectionEnv[n];
        for (int i = 0; i < n; ++i) {
            this.commandGrabber[i] = new StatementFinder(this.langUtil.getNewInput(System.in), localizedOutput);
            this.connEnv[i] = new ConnectionEnv(i, n > 1, n == 1);
        }
        this.currCE = 0;
        this.fileInput = false;
        this.initialFileInput = false;
        this.firstRun = true;
    }

    public void initFromEnvironment() {
        this.ijParser.initFromEnvironment();
        for (int i = 0; i < this.numConnections; ++i) {
            try {
                this.connEnv[i].init(this.out);
                continue;
            }
            catch (SQLException sQLException) {
                JDBCDisplayUtil.ShowException(this.out, (Throwable)sQLException);
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                JDBCDisplayUtil.ShowException(this.out, (Throwable)classNotFoundException);
                continue;
            }
            catch (InstantiationException instantiationException) {
                JDBCDisplayUtil.ShowException(this.out, (Throwable)instantiationException);
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                JDBCDisplayUtil.ShowException(this.out, (Throwable)illegalAccessException);
            }
        }
    }

    public void go(LocalizedInput[] localizedInputArray, LocalizedOutput localizedOutput, Properties properties) throws ijFatalException {
        this.out = localizedOutput;
        this.connAttributeDefaults = properties;
        this.ijParser.setConnection(this.connEnv[this.currCE], this.numConnections > 1);
        this.initialFileInput = !localizedInputArray[this.currCE].isStandardInput();
        this.fileInput = this.initialFileInput;
        for (int i = 0; i < this.commandGrabber.length; ++i) {
            this.commandGrabber[i].ReInit(localizedInputArray[i]);
        }
        if (this.firstRun) {
            int n;
            InputStream inputStream = (InputStream)AccessController.doPrivileged(this);
            ProductVersionHolder productVersionHolder = ProductVersionHolder.getProductVersionHolderFromMyEnv(inputStream);
            String string = productVersionHolder != null ? "" + productVersionHolder.getMajorVersion() + "." + productVersionHolder.getMinorVersion() : "?";
            localizedOutput.println(this.langUtil.getTextMessage("IJ_IjVers30C199", string));
            for (n = this.connEnv.length - 1; n >= 0; --n) {
                Connection connection = this.connEnv[n].getConnection();
                if (connection == null) continue;
                JDBCDisplayUtil.ShowWarnings((PrintWriter)localizedOutput, connection);
            }
            this.firstRun = false;
            n = Boolean.valueOf(util.getSystemProperty("ij.showNoCountForSelect")).booleanValue() ? 1 : 0;
            JDBCDisplayUtil.showSelectCount = n == 0;
            boolean bl = Boolean.valueOf(util.getSystemProperty("ij.showNoConnectionsAtStart"));
            if (!bl) {
                try {
                    ijResult ijResult2 = this.ijParser.showConnectionsMethod(true);
                    this.displayResult(localizedOutput, ijResult2, this.connEnv[this.currCE].getConnection());
                }
                catch (SQLException sQLException) {
                    this.handleSQLException(localizedOutput, sQLException);
                }
            }
        }
        this.out = localizedOutput;
        this.runScriptGuts();
        this.cleanupGo(localizedInputArray);
    }

    public int goScript(Connection connection, LocalizedInput localizedInput) {
        JDBCDisplayUtil.showSelectCount = false;
        this.connEnv[0].addSession(connection, null);
        this.initialFileInput = !localizedInput.isStandardInput();
        this.fileInput = this.initialFileInput;
        this.commandGrabber[0].ReInit(localizedInput);
        return this.runScriptGuts();
    }

    private int runScriptGuts() {
        int n = 0;
        boolean bl = false;
        String string = null;
        while (!this.ijParser.exit && !bl) {
            try {
                this.ijParser.setConnection(this.connEnv[this.currCE], this.numConnections > 1);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.connEnv[this.currCE].doPrompt(true, this.out);
            try {
                string = null;
                this.out.flush();
                string = this.commandGrabber[this.currCE].nextStatement();
                while (string == null && !this.oldGrabbers.empty()) {
                    if (this.fileInput) {
                        this.commandGrabber[this.currCE].close();
                    }
                    this.commandGrabber[this.currCE] = (StatementFinder)this.oldGrabbers.pop();
                    if (this.oldGrabbers.empty()) {
                        this.fileInput = this.initialFileInput;
                    }
                    string = this.commandGrabber[this.currCE].nextStatement();
                }
                if (string == null && this.oldGrabbers.empty()) {
                    bl = true;
                } else {
                    boolean bl2 = this.ijParser.getElapsedTimeState();
                    long l = 0L;
                    if (this.fileInput) {
                        this.out.println(string + ";");
                        this.out.flush();
                    }
                    this.charStream.ReInit(new StringReader(string), 1, 1);
                    this.ijTokMgr.ReInit(this.charStream);
                    this.ijParser.ReInit(this.ijTokMgr);
                    if (bl2) {
                        l = System.currentTimeMillis();
                    }
                    ijResult ijResult2 = this.ijParser.ijStatement();
                    this.displayResult(this.out, ijResult2, this.connEnv[this.currCE].getConnection());
                    if (bl2) {
                        long l2 = System.currentTimeMillis();
                        this.out.println(this.langUtil.getTextMessage("IJ_ElapTime0Mil", this.langUtil.getNumberAsString(l2 - l)));
                    }
                }
            }
            catch (ParseException parseException) {
                if (string != null) {
                    n += this.doCatch(string) ? 0 : 1;
                }
            }
            catch (TokenMgrError tokenMgrError) {
                if (string != null) {
                    n += this.doCatch(string) ? 0 : 1;
                }
            }
            catch (SQLException sQLException) {
                ++n;
                this.handleSQLException(this.out, sQLException);
            }
            catch (ijException ijException2) {
                ++n;
                this.out.println(this.langUtil.getTextMessage("IJ_IjErro0", ijException2.getMessage()));
                this.doTrace(ijException2);
            }
            catch (Throwable throwable) {
                ++n;
                this.out.println(this.langUtil.getTextMessage("IJ_JavaErro0", throwable.toString()));
                this.doTrace(throwable);
            }
            ++this.currCE;
            this.currCE %= this.connEnv.length;
        }
        return n;
    }

    private void cleanupGo(LocalizedInput[] localizedInputArray) {
        int n;
        try {
            for (n = 0; n < this.connEnv.length; ++n) {
                this.connEnv[n].removeAllSessions();
            }
        }
        catch (SQLException sQLException) {
            this.handleSQLException(this.out, sQLException);
        }
        for (n = 0; n < this.numConnections; ++n) {
            try {
                localizedInputArray[n].close();
                continue;
            }
            catch (Exception exception) {
                this.out.println(this.langUtil.getTextMessage("IJ_CannotCloseInFile", exception.toString()));
            }
        }
        if (this.ijParser.exit || this.initialFileInput && !this.mtUse) {
            Driver driver = null;
            try {
                driver = DriverManager.getDriver("jdbc:derby:");
            }
            catch (Throwable throwable) {
                driver = null;
            }
            if (driver != null) {
                try {
                    DriverManager.getConnection("jdbc:derby:;shutdown=true");
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        }
    }

    private void displayResult(LocalizedOutput localizedOutput, ijResult ijResult2, Connection connection) throws SQLException {
        if (ijResult2 != null) {
            if (ijResult2.isConnection()) {
                if (ijResult2.hasWarnings()) {
                    JDBCDisplayUtil.ShowWarnings((PrintWriter)localizedOutput, ijResult2.getSQLWarnings());
                    ijResult2.clearSQLWarnings();
                }
            } else if (ijResult2.isStatement()) {
                Statement statement = ijResult2.getStatement();
                try {
                    JDBCDisplayUtil.DisplayResults(localizedOutput, statement, this.connEnv[this.currCE].getConnection());
                }
                catch (SQLException sQLException) {
                    ijResult2.closeStatement();
                    throw sQLException;
                }
                ijResult2.closeStatement();
            } else if (ijResult2.isNextRowOfResultSet()) {
                ResultSet resultSet = ijResult2.getNextRowOfResultSet();
                JDBCDisplayUtil.DisplayCurrentRow(localizedOutput, resultSet, this.connEnv[this.currCE].getConnection());
            } else if (ijResult2.isVector()) {
                util.DisplayVector(localizedOutput, ijResult2.getVector());
                if (ijResult2.hasWarnings()) {
                    JDBCDisplayUtil.ShowWarnings((PrintWriter)localizedOutput, ijResult2.getSQLWarnings());
                    ijResult2.clearSQLWarnings();
                }
            } else if (ijResult2.isMulti()) {
                try {
                    util.DisplayMulti(localizedOutput, (PreparedStatement)ijResult2.getStatement(), ijResult2.getResultSet(), this.connEnv[this.currCE].getConnection());
                }
                catch (SQLException sQLException) {
                    ijResult2.closeStatement();
                    throw sQLException;
                }
                ijResult2.closeStatement();
                if (ijResult2.hasWarnings()) {
                    JDBCDisplayUtil.ShowWarnings((PrintWriter)localizedOutput, ijResult2.getSQLWarnings());
                    ijResult2.clearSQLWarnings();
                }
            } else if (ijResult2.isResultSet()) {
                ResultSet resultSet = ijResult2.getResultSet();
                try {
                    JDBCDisplayUtil.DisplayResults(localizedOutput, resultSet, this.connEnv[this.currCE].getConnection(), ijResult2.getColumnDisplayList(), ijResult2.getColumnWidthList());
                }
                catch (SQLException sQLException) {
                    ijResult2.closeStatement();
                    throw sQLException;
                }
                ijResult2.closeStatement();
            } else if (ijResult2.isMultipleResultSetResult()) {
                List list = ijResult2.getMultipleResultSets();
                try {
                    JDBCDisplayUtil.DisplayMultipleResults(localizedOutput, list, this.connEnv[this.currCE].getConnection(), ijResult2.getColumnDisplayList(), ijResult2.getColumnWidthList());
                }
                catch (SQLException sQLException) {
                    ijResult2.closeStatement();
                    throw sQLException;
                }
            } else if (ijResult2.isException()) {
                JDBCDisplayUtil.ShowException(localizedOutput, (Throwable)ijResult2.getException());
            }
        }
    }

    private boolean doCatch(String string) {
        try {
            boolean bl = this.ijParser.getElapsedTimeState();
            long l = 0L;
            if (bl) {
                l = System.currentTimeMillis();
            }
            ijResult ijResult2 = this.ijParser.executeImmediate(string);
            this.displayResult(this.out, ijResult2, this.connEnv[this.currCE].getConnection());
            if (bl) {
                long l2 = System.currentTimeMillis();
                this.out.println(this.langUtil.getTextMessage("IJ_ElapTime0Mil_4", this.langUtil.getNumberAsString(l2 - l)));
            }
            return true;
        }
        catch (SQLException sQLException) {
            this.handleSQLException(this.out, sQLException);
        }
        catch (ijException ijException2) {
            this.out.println(this.langUtil.getTextMessage("IJ_IjErro0_5", ijException2.getMessage()));
            this.doTrace(ijException2);
        }
        catch (ijTokenException ijTokenException2) {
            this.out.println(this.langUtil.getTextMessage("IJ_IjErro0_6", ijTokenException2.getMessage()));
            this.doTrace(ijTokenException2);
        }
        catch (Throwable throwable) {
            this.out.println(this.langUtil.getTextMessage("IJ_JavaErro0_7", throwable.toString()));
            this.doTrace(throwable);
        }
        return false;
    }

    private void handleSQLException(LocalizedOutput localizedOutput, SQLException sQLException) throws ijFatalException {
        String string = null;
        SQLException sQLException2 = null;
        String string2 = this.showErrorCode ? this.langUtil.getTextMessage("IJ_Erro0", this.langUtil.getNumberAsString(sQLException.getErrorCode())) : "";
        while (sQLException != null) {
            block6: {
                block5: {
                    if (this.ignoreErrors == null) break block5;
                    string = sQLException.getSQLState();
                    if (string != null && this.ignoreErrors.get(string) != null) break block6;
                    sQLException2 = sQLException;
                }
                String string3 = JDBCDisplayUtil.mapNull(sQLException.getSQLState(), this.langUtil.getTextMessage("IJ_NoSqls"));
                String string4 = JDBCDisplayUtil.mapNull(sQLException.getMessage(), this.langUtil.getTextMessage("IJ_NoMess"));
                localizedOutput.println(this.langUtil.getTextMessage("IJ_Erro012", string3, string4, string2));
                this.doTrace(sQLException);
            }
            sQLException = sQLException.getNextException();
        }
        if (sQLException2 != null) {
            throw new ijFatalException(sQLException2);
        }
    }

    private void doTrace(Throwable throwable) {
        if (this.ijExceptionTrace != null) {
            throwable.printStackTrace(this.out);
        }
        this.out.flush();
    }

    void newInput(String string) {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw ijException.fileNotFound();
        }
        if (fileInputStream == null) {
            return;
        }
        this.oldGrabbers.push(this.commandGrabber[this.currCE]);
        this.commandGrabber[this.currCE] = new StatementFinder(this.langUtil.getNewInput(new BufferedInputStream(fileInputStream, 2048)), null);
        this.fileInput = true;
    }

    void newResourceInput(String string) {
        InputStream inputStream = util.getResourceAsStream(string);
        if (inputStream == null) {
            throw ijException.resourceNotFound();
        }
        this.oldGrabbers.push(this.commandGrabber[this.currCE]);
        this.commandGrabber[this.currCE] = new StatementFinder(this.langUtil.getNewEncodedInput(new BufferedInputStream(inputStream, 2048), "UTF8"), null);
        this.fileInput = true;
    }

    static void doPrompt(boolean bl, LocalizedOutput localizedOutput, String string) {
        if (bl) {
            localizedOutput.print("ij" + (string == null ? "" : string) + "> ");
        } else {
            localizedOutput.print("> ");
        }
        localizedOutput.flush();
    }

    void setMtUse(boolean bl) {
        this.mtUse = bl;
    }

    private void checkScrollableCursor(ResultSet resultSet, String string) throws ijException, SQLException {
        if (resultSet.getType() == 1003) {
            throw ijException.forwardOnlyCursor(string);
        }
    }

    ijResult absolute(ResultSet resultSet, int n) throws SQLException {
        this.checkScrollableCursor(resultSet, "ABSOLUTE");
        return new ijRowResult(resultSet, resultSet.absolute(n));
    }

    ijResult relative(ResultSet resultSet, int n) throws SQLException {
        this.checkScrollableCursor(resultSet, "RELATIVE");
        return new ijRowResult(resultSet, resultSet.relative(n));
    }

    ijResult beforeFirst(ResultSet resultSet) throws SQLException {
        this.checkScrollableCursor(resultSet, "BEFORE FIRST");
        resultSet.beforeFirst();
        return new ijRowResult(resultSet, false);
    }

    ijResult first(ResultSet resultSet) throws SQLException {
        this.checkScrollableCursor(resultSet, "FIRST");
        return new ijRowResult(resultSet, resultSet.first());
    }

    ijResult afterLast(ResultSet resultSet) throws SQLException {
        this.checkScrollableCursor(resultSet, "AFTER LAST");
        resultSet.afterLast();
        return new ijRowResult(resultSet, false);
    }

    ijResult last(ResultSet resultSet) throws SQLException {
        this.checkScrollableCursor(resultSet, "LAST");
        return new ijRowResult(resultSet, resultSet.last());
    }

    ijResult previous(ResultSet resultSet) throws SQLException {
        this.checkScrollableCursor(resultSet, "PREVIOUS");
        return new ijRowResult(resultSet, resultSet.previous());
    }

    int getCurrentRowNumber(ResultSet resultSet) throws SQLException {
        this.checkScrollableCursor(resultSet, "GETCURRENTROWNUMBER");
        return resultSet.getRow();
    }

    Properties getConnAttributeDefaults() {
        return this.connAttributeDefaults;
    }

    public final Object run() {
        return this.getClass().getResourceAsStream("/org/apache/derby/info/tools.properties");
    }
}

