/*
 * Decompiled with CFR 0.152.
 */
package jode.flow;

import jode.expr.BinaryOperator;
import jode.expr.ConvertOperator;
import jode.expr.Expression;
import jode.expr.LocalLoadOperator;
import jode.expr.LocalStoreOperator;
import jode.expr.Operator;
import jode.expr.StoreInstruction;
import jode.expr.StringAddOperator;
import jode.flow.InstructionBlock;
import jode.flow.InstructionContainer;
import jode.flow.SequentialBlock;
import jode.flow.SpecialBlock;
import jode.flow.StructuredBlock;
import jode.type.Type;

public class CreateAssignExpression {
    public static boolean transform(InstructionContainer instructionContainer, StructuredBlock structuredBlock) {
        if (!(structuredBlock.outer instanceof SequentialBlock && instructionContainer.getInstruction() instanceof StoreInstruction && instructionContainer.getInstruction().isVoid())) {
            return false;
        }
        return CreateAssignExpression.createAssignOp(instructionContainer, structuredBlock) || CreateAssignExpression.createAssignExpression(instructionContainer, structuredBlock);
    }

    public static boolean createAssignOp(InstructionContainer instructionContainer, StructuredBlock structuredBlock) {
        Expression expression;
        int n;
        StructuredBlock structuredBlock2;
        SequentialBlock sequentialBlock = (SequentialBlock)structuredBlock.outer;
        StoreInstruction storeInstruction = (StoreInstruction)instructionContainer.getInstruction();
        if (!storeInstruction.isFreeOperator()) {
            return false;
        }
        Expression expression2 = storeInstruction.getSubExpressions()[0];
        int n2 = expression2.getFreeOperandCount();
        boolean bl = false;
        if (sequentialBlock.subBlocks[0] instanceof SpecialBlock) {
            structuredBlock2 = (SpecialBlock)sequentialBlock.subBlocks[0];
            if (((SpecialBlock)structuredBlock2).type != SpecialBlock.DUP || ((SpecialBlock)structuredBlock2).depth != n2 || ((SpecialBlock)structuredBlock2).count != expression2.getType().stackSize() || !(sequentialBlock.outer instanceof SequentialBlock)) {
                return false;
            }
            sequentialBlock = (SequentialBlock)sequentialBlock.outer;
            bl = true;
        }
        if (!(sequentialBlock.subBlocks[0] instanceof InstructionBlock)) {
            return false;
        }
        structuredBlock2 = (InstructionBlock)sequentialBlock.subBlocks[0];
        if (!(((InstructionContainer)structuredBlock2).getInstruction() instanceof Operator)) {
            return false;
        }
        Operator operator = (Operator)((InstructionContainer)structuredBlock2).getInstruction();
        if (operator.getFreeOperandCount() != n2) {
            return false;
        }
        Type type = operator.getType();
        SpecialBlock specialBlock = null;
        if (n2 > 0) {
            if (!(sequentialBlock.outer instanceof SequentialBlock) || !(sequentialBlock.outer.getSubBlocks()[0] instanceof SpecialBlock)) {
                return false;
            }
            SequentialBlock sequentialBlock2 = (SequentialBlock)sequentialBlock.outer;
            specialBlock = (SpecialBlock)sequentialBlock2.subBlocks[0];
            if (specialBlock.type != SpecialBlock.DUP || specialBlock.depth != 0 || specialBlock.count != n2) {
                return false;
            }
        }
        if (operator instanceof ConvertOperator && operator.getSubExpressions()[0] instanceof Operator && operator.getType().isOfType(expression2.getType())) {
            operator = (Operator)operator.getSubExpressions()[0];
            while (operator instanceof ConvertOperator && operator.getSubExpressions()[0] instanceof Operator) {
                operator = (Operator)operator.getSubExpressions()[0];
            }
        }
        if (operator instanceof BinaryOperator) {
            n = operator.getOperatorIndex();
            if (n < 1 || n >= 12) {
                return false;
            }
            if (!(operator.getSubExpressions()[0] instanceof Operator)) {
                return false;
            }
            Operator operator2 = (Operator)operator.getSubExpressions()[0];
            while (operator2 instanceof ConvertOperator && operator2.getSubExpressions()[0] instanceof Operator) {
                operator2 = (Operator)operator2.getSubExpressions()[0];
            }
            if (!storeInstruction.lvalueMatches(operator2) || !operator2.isFreeOperator(n2)) {
                return false;
            }
            if (expression2 instanceof LocalStoreOperator) {
                ((LocalLoadOperator)operator2).getLocalInfo().combineWith(((LocalStoreOperator)expression2).getLocalInfo());
            }
            expression = operator.getSubExpressions()[1];
        } else {
            Expression expression3;
            expression = expression3 = operator.simplifyString();
            Operator operator3 = null;
            Operator operator4 = null;
            while (expression3 instanceof StringAddOperator) {
                operator4 = operator3;
                operator3 = (Operator)expression3;
                expression3 = operator3.getSubExpressions()[0];
            }
            if (!(operator3 != null && expression3 instanceof Operator && storeInstruction.lvalueMatches((Operator)expression3) && ((Operator)expression3).isFreeOperator(n2))) {
                return false;
            }
            if (expression2 instanceof LocalStoreOperator) {
                ((LocalLoadOperator)expression3).getLocalInfo().combineWith(((LocalStoreOperator)expression2).getLocalInfo());
            }
            if (operator4 != null) {
                operator4.setSubExpressions(0, operator3.getSubExpressions()[1]);
            } else {
                expression = operator3.getSubExpressions()[1];
            }
            n = 1;
        }
        if (specialBlock != null) {
            specialBlock.removeBlock();
        }
        ((InstructionContainer)structuredBlock2).setInstruction(expression);
        expression2.setType(type);
        storeInstruction.makeOpAssign(12 + n);
        if (bl) {
            storeInstruction.makeNonVoid();
        }
        structuredBlock.replace(sequentialBlock.subBlocks[1]);
        return true;
    }

    public static boolean createAssignExpression(InstructionContainer instructionContainer, StructuredBlock structuredBlock) {
        SequentialBlock sequentialBlock = (SequentialBlock)structuredBlock.outer;
        StoreInstruction storeInstruction = (StoreInstruction)instructionContainer.getInstruction();
        if (sequentialBlock.subBlocks[0] instanceof SpecialBlock && storeInstruction.isFreeOperator()) {
            Expression expression = storeInstruction.getSubExpressions()[0];
            SpecialBlock specialBlock = (SpecialBlock)sequentialBlock.subBlocks[0];
            if (specialBlock.type != SpecialBlock.DUP || specialBlock.depth != expression.getFreeOperandCount() || specialBlock.count != expression.getType().stackSize()) {
                return false;
            }
            specialBlock.removeBlock();
            storeInstruction.makeNonVoid();
            return true;
        }
        return false;
    }
}

