/*
 * Decompiled with CFR 0.152.
 */
package jode.obfuscator;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Set;
import jode.bytecode.BytecodeInfo;
import jode.bytecode.Reference;
import jode.bytecode.TypeSignature;
import jode.jvm.Interpreter;
import jode.jvm.InterpreterException;
import jode.jvm.SimpleRuntimeEnvironment;
import jode.obfuscator.FieldIdentifier;
import jode.obfuscator.Main;
import jode.obfuscator.MethodIdentifier;

public class ConstantRuntimeEnvironment
extends SimpleRuntimeEnvironment {
    static Set whiteList = new HashSet();
    private Interpreter interpreter = new Interpreter(this);

    static void addWhite(Reference reference) {
        whiteList.add(reference);
    }

    public static boolean isWhite(Reference reference) {
        return whiteList.contains(reference);
    }

    public static boolean isWhite(String string) {
        return string.length() == 1 || whiteList.contains(string);
    }

    public static Object getDefaultValue(String string) {
        switch (string.charAt(0)) {
            case 'B': 
            case 'C': 
            case 'I': 
            case 'S': 
            case 'Z': {
                return new Integer(0);
            }
            case 'J': {
                return new Long(0L);
            }
            case 'D': {
                return new Double(0.0);
            }
            case 'F': {
                return new Float(0.0f);
            }
        }
        return null;
    }

    public Object getField(Reference reference, Object object) throws InterpreterException {
        if (ConstantRuntimeEnvironment.isWhite(reference)) {
            return super.getField(reference, object);
        }
        FieldIdentifier fieldIdentifier = (FieldIdentifier)Main.getClassBundle().getIdentifier(reference);
        if (fieldIdentifier != null && !fieldIdentifier.isNotConstant()) {
            Object object2 = fieldIdentifier.getConstant();
            if (object2 == null) {
                object2 = ConstantRuntimeEnvironment.getDefaultValue(reference.getType());
            }
            return object2;
        }
        throw new InterpreterException("Field " + reference + " not constant");
    }

    public void putField(Reference reference, Object object, Object object2) throws InterpreterException {
        throw new InterpreterException("Modifying Field " + reference + ".");
    }

    public Object invokeConstructor(Reference reference, Object[] objectArray) throws InterpreterException, InvocationTargetException {
        if (ConstantRuntimeEnvironment.isWhite(reference)) {
            return super.invokeConstructor(reference, objectArray);
        }
        throw new InterpreterException("Creating new Object " + reference + ".");
    }

    public Object invokeMethod(Reference reference, boolean bl, Object object, Object[] objectArray) throws InterpreterException, InvocationTargetException {
        BytecodeInfo bytecodeInfo;
        if (ConstantRuntimeEnvironment.isWhite(reference)) {
            return super.invokeMethod(reference, bl, object, objectArray);
        }
        MethodIdentifier methodIdentifier = (MethodIdentifier)Main.getClassBundle().getIdentifier(reference);
        if (methodIdentifier != null && (bytecodeInfo = methodIdentifier.info.getBytecode()) != null) {
            return this.interpreter.interpretMethod(bytecodeInfo, object, objectArray);
        }
        throw new InterpreterException("Invoking library method " + reference + ".");
    }

    public boolean instanceOf(Object object, String string) throws InterpreterException {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new InterpreterException("Class " + classNotFoundException.getMessage() + " not found");
        }
        return object != null && clazz.isInstance(object);
    }

    public Object newArray(String string, int[] nArray) throws InterpreterException, NegativeArraySizeException {
        if (string.length() == nArray.length + 1) {
            Class clazz;
            try {
                clazz = TypeSignature.getClass(string.substring(nArray.length));
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new InterpreterException("Class " + classNotFoundException.getMessage() + " not found");
            }
            return Array.newInstance(clazz, nArray);
        }
        throw new InterpreterException("Creating object array.");
    }

    static {
        ConstantRuntimeEnvironment.addWhite(Reference.getReference("Ljava/lang/String;", "toCharArray", "()[C"));
        ConstantRuntimeEnvironment.addWhite(Reference.getReference("Ljava/lang/StringBuffer;", "<init>", "(Ljava/lang/String;)V"));
        ConstantRuntimeEnvironment.addWhite(Reference.getReference("Ljava/lang/StringBuffer;", "<init>", "()V"));
        ConstantRuntimeEnvironment.addWhite(Reference.getReference("Ljava/lang/StringBuffer;", "append", "(Ljava/lang/String;)Ljava/lang/StringBuffer;"));
        ConstantRuntimeEnvironment.addWhite(Reference.getReference("Ljava/lang/StringBuffer;", "append", "(C)Ljava/lang/StringBuffer;"));
        ConstantRuntimeEnvironment.addWhite(Reference.getReference("Ljava/lang/StringBuffer;", "append", "(B)Ljava/lang/StringBuffer;"));
        ConstantRuntimeEnvironment.addWhite(Reference.getReference("Ljava/lang/StringBuffer;", "append", "(S)Ljava/lang/StringBuffer;"));
        ConstantRuntimeEnvironment.addWhite(Reference.getReference("Ljava/lang/StringBuffer;", "append", "(Z)Ljava/lang/StringBuffer;"));
        ConstantRuntimeEnvironment.addWhite(Reference.getReference("Ljava/lang/StringBuffer;", "append", "(F)Ljava/lang/StringBuffer;"));
        ConstantRuntimeEnvironment.addWhite(Reference.getReference("Ljava/lang/StringBuffer;", "append", "(I)Ljava/lang/StringBuffer;"));
        ConstantRuntimeEnvironment.addWhite(Reference.getReference("Ljava/lang/StringBuffer;", "append", "(J)Ljava/lang/StringBuffer;"));
        ConstantRuntimeEnvironment.addWhite(Reference.getReference("Ljava/lang/StringBuffer;", "append", "(D)Ljava/lang/StringBuffer;"));
        ConstantRuntimeEnvironment.addWhite(Reference.getReference("Ljava/lang/StringBuffer;", "toString", "()Ljava/lang/String;"));
        ConstantRuntimeEnvironment.addWhite(Reference.getReference("Ljava/lang/String;", "<init>", "()V"));
        ConstantRuntimeEnvironment.addWhite(Reference.getReference("Ljava/lang/String;", "<init>", "([C)V"));
        ConstantRuntimeEnvironment.addWhite(Reference.getReference("Ljava/lang/String;", "<init>", "([CII)V"));
        ConstantRuntimeEnvironment.addWhite(Reference.getReference("Ljava/lang/String;", "<init>", "(Ljava/lang/String;)V"));
        ConstantRuntimeEnvironment.addWhite(Reference.getReference("Ljava/lang/String;", "<init>", "(Ljava/lang/StringBuffer;)V"));
        ConstantRuntimeEnvironment.addWhite(Reference.getReference("Ljava/lang/String;", "length", "()I"));
        ConstantRuntimeEnvironment.addWhite(Reference.getReference("Ljava/lang/String;", "replace", "(CC)Ljava/lang/String;"));
        ConstantRuntimeEnvironment.addWhite(Reference.getReference("Ljava/lang/String;", "valueOf", "(Z)Ljava/lang/String;"));
        ConstantRuntimeEnvironment.addWhite(Reference.getReference("Ljava/lang/String;", "valueOf", "(B)Ljava/lang/String;"));
        ConstantRuntimeEnvironment.addWhite(Reference.getReference("Ljava/lang/String;", "valueOf", "(S)Ljava/lang/String;"));
        ConstantRuntimeEnvironment.addWhite(Reference.getReference("Ljava/lang/String;", "valueOf", "(C)Ljava/lang/String;"));
        ConstantRuntimeEnvironment.addWhite(Reference.getReference("Ljava/lang/String;", "valueOf", "(D)Ljava/lang/String;"));
        ConstantRuntimeEnvironment.addWhite(Reference.getReference("Ljava/lang/String;", "valueOf", "(F)Ljava/lang/String;"));
        ConstantRuntimeEnvironment.addWhite(Reference.getReference("Ljava/lang/String;", "valueOf", "(I)Ljava/lang/String;"));
        ConstantRuntimeEnvironment.addWhite(Reference.getReference("Ljava/lang/String;", "valueOf", "(J)Ljava/lang/String;"));
        ConstantRuntimeEnvironment.addWhite(Reference.getReference("Ljava/lang/String;", "valueOf", "(Ljava/lang/Object;)Ljava/lang/String;"));
        ConstantRuntimeEnvironment.addWhite(Reference.getReference("Ljava/lang/String;", "substring", "(I)Ljava/lang/String;"));
        ConstantRuntimeEnvironment.addWhite(Reference.getReference("Ljava/lang/String;", "substring", "(II)Ljava/lang/String;"));
        ConstantRuntimeEnvironment.addWhite(Reference.getReference("Ljava.lang/reflect/Modifier;", "toString", "(I)Ljava/lang/String;"));
        ConstantRuntimeEnvironment.addWhite(Reference.getReference("Ljava/lang/Math;", "abs", "(D)D"));
        ConstantRuntimeEnvironment.addWhite(Reference.getReference("Ljava/lang/Math;", "abs", "(F)F"));
        ConstantRuntimeEnvironment.addWhite(Reference.getReference("Ljava/lang/Math;", "abs", "(I)I"));
        ConstantRuntimeEnvironment.addWhite(Reference.getReference("Ljava/lang/Math;", "abs", "(J)J"));
        ConstantRuntimeEnvironment.addWhite(Reference.getReference("Ljava/lang/Math;", "acos", "(D)D"));
        ConstantRuntimeEnvironment.addWhite(Reference.getReference("Ljava/lang/Math;", "asin", "(D)D"));
        ConstantRuntimeEnvironment.addWhite(Reference.getReference("Ljava/lang/Math;", "atan", "(D)D"));
        ConstantRuntimeEnvironment.addWhite(Reference.getReference("Ljava/lang/Math;", "atan2", "(D)D"));
        ConstantRuntimeEnvironment.addWhite(Reference.getReference("Ljava/lang/Math;", "ceil", "(D)D"));
        ConstantRuntimeEnvironment.addWhite(Reference.getReference("Ljava/lang/Math;", "cos", "(D)D"));
        ConstantRuntimeEnvironment.addWhite(Reference.getReference("Ljava/lang/Math;", "exp", "(D)D"));
        ConstantRuntimeEnvironment.addWhite(Reference.getReference("Ljava/lang/Math;", "floor", "(D)D"));
        ConstantRuntimeEnvironment.addWhite(Reference.getReference("Ljava/lang/Math;", "IEEEremainder", "(DD)D"));
        ConstantRuntimeEnvironment.addWhite(Reference.getReference("Ljava/lang/Math;", "log", "(D)D"));
        ConstantRuntimeEnvironment.addWhite(Reference.getReference("Ljava/lang/Math;", "max", "(DD)D"));
        ConstantRuntimeEnvironment.addWhite(Reference.getReference("Ljava/lang/Math;", "max", "(FF)F"));
        ConstantRuntimeEnvironment.addWhite(Reference.getReference("Ljava/lang/Math;", "max", "(II)I"));
        ConstantRuntimeEnvironment.addWhite(Reference.getReference("Ljava/lang/Math;", "max", "(JJ)J"));
        ConstantRuntimeEnvironment.addWhite(Reference.getReference("Ljava/lang/Math;", "min", "(DD)D"));
        ConstantRuntimeEnvironment.addWhite(Reference.getReference("Ljava/lang/Math;", "min", "(FF)F"));
        ConstantRuntimeEnvironment.addWhite(Reference.getReference("Ljava/lang/Math;", "min", "(II)I"));
        ConstantRuntimeEnvironment.addWhite(Reference.getReference("Ljava/lang/Math;", "min", "(JJ)J"));
        ConstantRuntimeEnvironment.addWhite(Reference.getReference("Ljava/lang/Math;", "pow", "(DD)D"));
        ConstantRuntimeEnvironment.addWhite(Reference.getReference("Ljava/lang/Math;", "rint", "(D)D"));
        ConstantRuntimeEnvironment.addWhite(Reference.getReference("Ljava/lang/Math;", "round", "(D)J"));
        ConstantRuntimeEnvironment.addWhite(Reference.getReference("Ljava/lang/Math;", "round", "(F)I"));
        ConstantRuntimeEnvironment.addWhite(Reference.getReference("Ljava/lang/Math;", "sin", "(D)D"));
        ConstantRuntimeEnvironment.addWhite(Reference.getReference("Ljava/lang/Math;", "sqrt", "(D)D"));
        ConstantRuntimeEnvironment.addWhite(Reference.getReference("Ljava/lang/Math;", "tan", "(D)D"));
        ConstantRuntimeEnvironment.addWhite(Reference.getReference("Ljava/lang/Math;", "toDegrees", "(D)D"));
        ConstantRuntimeEnvironment.addWhite(Reference.getReference("Ljava/lang/Math;", "toRadians", "(D)D"));
        ConstantRuntimeEnvironment.addWhite(Reference.getReference("Ljava/lang/Math;", "E", "D"));
        ConstantRuntimeEnvironment.addWhite(Reference.getReference("Ljava/lang/Math;", "PI", "D"));
        whiteList.add("Ljava/lang/String;");
    }
}

