/*
 * Decompiled with CFR 0.152.
 */
package jode.obfuscator;

import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Collections;
import jode.GlobalOptions;
import jode.obfuscator.ClassBundle;
import jode.obfuscator.ParseException;
import jode.obfuscator.ScriptParser;

public class Main {
    public static boolean swapOrder = false;
    public static final int OPTION_STRONGOVERLOAD = 1;
    public static final int OPTION_PRESERVESERIAL = 2;
    public static int options = 2;
    private static final LongOpt[] longOptions = new LongOpt[]{new LongOpt("cp", 1, null, 99), new LongOpt("classpath", 1, null, 99), new LongOpt("destpath", 1, null, 100), new LongOpt("help", 0, null, 104), new LongOpt("version", 0, null, 86), new LongOpt("verbose", 2, null, 118), new LongOpt("debug", 2, null, 68)};
    public static final String[] stripNames = new String[]{"unreach", "inner", "lvt", "lnt", "source"};
    public static final int STRIP_UNREACH = 1;
    public static final int STRIP_INNERINFO = 2;
    public static final int STRIP_LVT = 4;
    public static final int STRIP_LNT = 8;
    public static final int STRIP_SOURCE = 16;
    public static int stripping = 1;
    private static ClassBundle bundle;

    public static void usage() {
        PrintWriter printWriter = GlobalOptions.err;
        printWriter.println("usage: jode.Obfuscator flags* script");
        printWriter.println("  -h, --help           show this information.");
        printWriter.println("  -V, --version        output version information and exit.");
        printWriter.println("  -v, --verbose        be verbose (multiple times means more verbose).");
        printWriter.println("  -c, --classpath <path> search for classes in specified classpath.");
        printWriter.println("                       The directories should be separated by ','.");
        printWriter.println("  -d, --dest <dir>     write decompiled files to disk into directory destdir.");
        printWriter.println("  -D, --debug=...      use --debug=help for more information.");
    }

    public static ClassBundle getClassBundle() {
        return bundle;
    }

    public static void main(String[] stringArray) {
        Object object;
        if (stringArray.length == 0) {
            Main.usage();
            return;
        }
        String string = null;
        String string2 = null;
        GlobalOptions.err.println("Jode (c) 1998-2001 Jochen Hoenicke <jochen@gnu.org>");
        bundle = new ClassBundle();
        boolean bl = false;
        Getopt getopt = new Getopt("jode.obfuscator.Main", stringArray, "hVvc:d:D:", longOptions, true);
        int n = getopt.getopt();
        while (n != -1) {
            switch (n) {
                case 0: {
                    break;
                }
                case 104: {
                    Main.usage();
                    bl = true;
                    break;
                }
                case 86: {
                    GlobalOptions.err.println("1.1");
                    break;
                }
                case 99: {
                    string = getopt.getOptarg();
                    break;
                }
                case 100: {
                    string2 = getopt.getOptarg();
                    break;
                }
                case 118: {
                    object = getopt.getOptarg();
                    if (object == null) {
                        ++GlobalOptions.verboseLevel;
                        break;
                    }
                    try {
                        GlobalOptions.verboseLevel = Integer.parseInt((String)object);
                    }
                    catch (NumberFormatException numberFormatException) {
                        GlobalOptions.err.println("jode.obfuscator.Main: Argument `" + (String)object + "' to --verbose must be numeric:");
                        bl = true;
                    }
                    break;
                }
                case 68: {
                    object = getopt.getOptarg();
                    if (object == null) {
                        object = "help";
                    }
                    bl |= !GlobalOptions.setDebugging((String)object);
                    break;
                }
                default: {
                    bl = true;
                    break;
                }
            }
            n = getopt.getopt();
        }
        if (bl) {
            return;
        }
        if (getopt.getOptind() != stringArray.length - 1) {
            GlobalOptions.err.println("You must specify exactly one script.");
            return;
        }
        try {
            String string3 = stringArray[getopt.getOptind()];
            object = new ScriptParser(string3.equals("-") ? new InputStreamReader(System.in) : new FileReader(string3));
            ((ScriptParser)object).parseOptions(bundle);
        }
        catch (IOException iOException) {
            GlobalOptions.err.println("IOException while reading script file.");
            iOException.printStackTrace(GlobalOptions.err);
            return;
        }
        catch (ParseException parseException) {
            GlobalOptions.err.println("Syntax error in script file: ");
            GlobalOptions.err.println(parseException.getMessage());
            if (GlobalOptions.verboseLevel > 5) {
                parseException.printStackTrace(GlobalOptions.err);
            }
            return;
        }
        if (string != null) {
            bundle.setOption("classpath", Collections.singleton(string));
        }
        if (string2 != null) {
            bundle.setOption("dest", Collections.singleton(string2));
        }
        bundle.run();
    }
}

