/*
 * Decompiled with CFR 0.152.
 */
package jode.obfuscator.modules;

import java.util.BitSet;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Stack;
import java.util.Vector;
import jode.AssertError;
import jode.GlobalOptions;
import jode.bytecode.BytecodeInfo;
import jode.bytecode.Handler;
import jode.bytecode.Instruction;
import jode.bytecode.LocalVariableInfo;
import jode.bytecode.Opcodes;
import jode.bytecode.TypeSignature;
import jode.obfuscator.CodeTransformer;
import jode.obfuscator.Main;

public class LocalOptimizer
implements Opcodes,
CodeTransformer {
    BytecodeInfo bc;
    TodoQueue changedInfos;
    InstrInfo firstInfo;
    Hashtable instrInfos;
    boolean produceLVT;
    int maxlocals;
    LocalInfo[] paramLocals;
    private InstrInfo CONFLICT = new InstrInfo();

    Vector merge(Vector vector, Vector vector2) {
        if (vector == null || vector.isEmpty()) {
            return vector2;
        }
        if (vector2 == null || vector2.isEmpty()) {
            return vector;
        }
        Vector vector3 = (Vector)vector.clone();
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (vector3.contains(e)) continue;
            vector3.addElement(e);
        }
        return vector3;
    }

    void promoteReads(InstrInfo instrInfo, Instruction instruction, BitSet bitSet, boolean bl) {
        InstrInfo instrInfo2 = (InstrInfo)this.instrInfos.get(instruction);
        int n = -1;
        if (instruction.getOpcode() >= 54 && instruction.getOpcode() <= 58 && instrInfo.nextReads[n = instruction.getLocalSlot()] != null) {
            instrInfo2.local.combineInto(instrInfo.nextReads[n].local);
        }
        int n2 = 0;
        while (n2 < this.maxlocals) {
            if (instrInfo.nextReads[n2] != null && n2 != n && (bitSet == null || bitSet.get(n2) != bl)) {
                if (instrInfo2.nextReads[n2] == null) {
                    instrInfo2.nextReads[n2] = instrInfo.nextReads[n2];
                    this.changedInfos.add(instrInfo2);
                } else {
                    instrInfo2.nextReads[n2].local.combineInto(instrInfo.nextReads[n2].local);
                }
            }
            ++n2;
        }
    }

    void promoteReads(InstrInfo instrInfo, Instruction instruction) {
        this.promoteReads(instrInfo, instruction, null, false);
    }

    public LocalVariableInfo findLVTEntry(LocalVariableInfo[] localVariableInfoArray, int n, int n2) {
        LocalVariableInfo localVariableInfo = null;
        int n3 = 0;
        while (n3 < localVariableInfoArray.length) {
            if (localVariableInfoArray[n3].slot == n && localVariableInfoArray[n3].start.getAddr() <= n2 && localVariableInfoArray[n3].end.getAddr() >= n2) {
                if (!(localVariableInfo == null || localVariableInfo.name.equals(localVariableInfoArray[n3].name) && localVariableInfo.type.equals(localVariableInfoArray[n3].type))) {
                    return null;
                }
                localVariableInfo = localVariableInfoArray[n3];
            }
            ++n3;
        }
        return localVariableInfo;
    }

    public LocalVariableInfo findLVTEntry(LocalVariableInfo[] localVariableInfoArray, Instruction instruction) {
        int n = instruction.getOpcode() >= 54 && instruction.getOpcode() <= 58 ? instruction.getNextAddr() : instruction.getAddr();
        return this.findLVTEntry(localVariableInfoArray, instruction.getLocalSlot(), n);
    }

    /*
     * Unable to fully structure code
     */
    public void calcLocalInfo() {
        this.maxlocals = this.bc.getMaxLocals();
        var1_1 = this.bc.getExceptionHandlers();
        var2_2 = this.bc.getLocalVariableTable();
        if (var2_2 != null) {
            this.produceLVT = true;
        }
        var3_3 = this.bc.getMethodInfo().getType();
        var4_5 = (this.bc.getMethodInfo().isStatic() != false ? 0 : 1) + TypeSignature.getArgumentSize((String)var3_3);
        this.paramLocals = new LocalInfo[var4_5];
        var5_7 = 0;
        if (!this.bc.getMethodInfo().isStatic()) {
            v0 = this;
            if (v0 == null) {
                throw null;
            }
            var6_10 = v0.new LocalInfo();
            if (var2_2 != null && (var7_17 = this.findLVTEntry(var2_2, 0, 0)) != null) {
                var6_10.name = var7_17.name;
                var6_10.type = var7_17.type;
            }
            var6_10.size = 1;
            this.paramLocals[var5_7++] = var6_10;
        }
        var6_11 = 1;
        while (var6_11 < var3_3.length() && var3_3.charAt(var6_11) != ')') {
            v1 = this;
            if (v1 == null) {
                throw null;
            }
            var7_17 = v1.new LocalInfo();
            if (var2_2 != null && (var8_19 = this.findLVTEntry(var2_2, var5_7, 0)) != null) {
                var7_17.name = var8_19.name;
            }
            var8_18 = var6_11;
            var6_11 = TypeSignature.skipType((String)var3_3, var6_11);
            var7_17.type = var3_3.substring(var8_18, var6_11);
            var7_17.size = TypeSignature.getTypeSize(var7_17.type);
            this.paramLocals[var5_7] = var7_17;
            var5_7 += var7_17.size;
        }
        this.changedInfos = new TodoQueue();
        this.instrInfos = new Hashtable<K, V>();
        this.firstInfo = new InstrInfo();
        var3_3 = this.firstInfo;
        var4_6 = this.bc.getInstructions().iterator();
        while (true) {
            var5_8 = (Instruction)var4_6.next();
            this.instrInfos.put(var5_8, var3_3);
            var3_3.instr = var5_8;
            var3_3.nextReads = new InstrInfo[this.maxlocals];
            if (var5_8.hasLocalSlot()) {
                v2 = this;
                if (v2 == null) {
                    throw null;
                }
                var3_3.local = v2.new LocalInfo((InstrInfo)var3_3);
                if (var2_2 != null && (var6_12 = this.findLVTEntry(var2_2, var5_8)) != null) {
                    var3_3.local.name = var6_12.name;
                    var3_3.local.type = var6_12.type;
                }
                var3_3.local.size = 1;
                switch (var5_8.getOpcode()) {
                    case 22: 
                    case 24: {
                        var3_3.local.size = 2;
                    }
                    case 21: 
                    case 23: 
                    case 25: 
                    case 132: {
                        var3_3.nextReads[var5_8.getLocalSlot()] = var3_3;
                        this.changedInfos.add((InstrInfo)var3_3);
                        break;
                    }
                    case 169: {
                        var3_3.usedBySub = new BitSet();
                        var3_3.nextReads[var5_8.getLocalSlot()] = var3_3;
                        this.changedInfos.add((InstrInfo)var3_3);
                        break;
                    }
                    case 55: 
                    case 57: {
                        var3_3.local.size = 2;
                    }
                }
            }
            if (!var4_6.hasNext()) ** GOTO lbl125
            var3_3.nextInfo = new InstrInfo();
            var3_3 = var3_3.nextInfo;
        }
lbl-1000:
        // 1 sources

        {
            var3_3 = this.changedInfos.remove();
            var4_6 = var3_3.instr;
            if (var4_6.hasLocalSlot()) {
                var5_9 = var4_6.getLocalSlot();
                var6_13 = 0;
                while (var6_13 < this.maxlocals) {
                    var7_17 = var3_3.nextReads[var6_13];
                    if (var7_17 != null && var7_17.instr.getOpcode() == 169 && !var7_17.usedBySub.get(var5_9)) {
                        var7_17.usedBySub.set(var5_9);
                        if (var7_17.jsrTargetInfo != null) {
                            this.changedInfos.add(var7_17.jsrTargetInfo);
                        }
                    }
                    ++var6_13;
                }
            }
            if ((var5_8 = var4_6.getPrevByAddr()) != null) {
                if (!var5_8.doesAlwaysJump()) {
                    this.promoteReads((InstrInfo)var3_3, var5_8);
                } else if (var5_8.getOpcode() == 168) {
                    var6_14 = (InstrInfo)this.instrInfos.get(var5_8.getSingleSucc());
                    if (var6_14.retInfo != null) {
                        this.promoteReads((InstrInfo)var3_3, var6_14.retInfo.instr, var6_14.retInfo.usedBySub, false);
                        this.promoteReads((InstrInfo)var3_3, var5_8, var6_14.retInfo.usedBySub, true);
                    }
                }
            }
            if (var4_6.getPreds() != null) {
                var6_15 = 0;
                while (var6_15 < var4_6.getPreds().length) {
                    var7_17 = var4_6.getPreds()[var6_15];
                    if (var4_6.getPreds()[var6_15].getOpcode() == 168) {
                        if (var3_3.instr.getOpcode() != 58) {
                            throw new AssertError("Non standard jsr");
                        }
                        var8_20 = var3_3.nextInfo.nextReads[var3_3.instr.getLocalSlot()];
                        if (var8_20 != null) {
                            if (var8_20.instr.getOpcode() != 169) {
                                throw new AssertError("reading return address");
                            }
                            var3_3.retInfo = var8_20;
                            var8_20.jsrTargetInfo = var3_3;
                            var9_21 = var7_17.getNextByAddr();
                            var10_22 = (InstrInfo)this.instrInfos.get(var9_21);
                            this.promoteReads(var10_22, var8_20.instr, var8_20.usedBySub, false);
                            this.promoteReads(var10_22, (Instruction)var7_17, var8_20.usedBySub, true);
                        }
                    }
                    this.promoteReads((InstrInfo)var3_3, var4_6.getPreds()[var6_15]);
                    ++var6_15;
                }
            }
            var6_16 = 0;
            while (var6_16 < var1_1.length) {
                if (var1_1[var6_16].catcher == var4_6) {
                    var7_17 = var1_1[var6_16].start;
                    while (var7_17 != var1_1[var6_16].end.getNextByAddr()) {
                        this.promoteReads((InstrInfo)var3_3, (Instruction)var7_17);
                        var7_17 = var7_17.getNextByAddr();
                    }
                }
                ++var6_16;
            }
lbl125:
            // 2 sources

            ** while (!this.changedInfos.isEmpty())
        }
lbl126:
        // 1 sources

        this.changedInfos = null;
        var3_4 = 0;
        while (var3_4 < this.paramLocals.length) {
            if (this.firstInfo.nextReads[var3_4] != null) {
                this.firstInfo.nextReads[var3_4].local.combineInto(this.paramLocals[var3_4]);
                this.paramLocals[var3_4] = this.paramLocals[var3_4].getReal();
            }
            ++var3_4;
        }
    }

    public void stripLocals() {
        ListIterator<Instruction> listIterator = this.bc.getInstructions().listIterator();
        InstrInfo instrInfo = this.firstInfo;
        while (instrInfo != null) {
            Instruction instruction = (Instruction)listIterator.next();
            if (instrInfo.local != null && instrInfo.local.usingInstrs.size() == 1) {
                switch (instruction.getOpcode()) {
                    case 54: 
                    case 56: 
                    case 58: {
                        listIterator.set(new Instruction(87));
                        break;
                    }
                    case 55: 
                    case 57: {
                        listIterator.set(new Instruction(88));
                        break;
                    }
                }
            }
            instrInfo = instrInfo.nextInfo;
        }
    }

    void distributeLocals(Vector vector) {
        Object object;
        if (vector.size() == 0) {
            return;
        }
        int n = Integer.MAX_VALUE;
        LocalInfo localInfo = null;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            LocalInfo localInfo2 = (LocalInfo)enumeration.nextElement();
            int n2 = 0;
            object = localInfo2.conflictingLocals.elements();
            while (object.hasMoreElements()) {
                if (((LocalInfo)object.nextElement()).newSlot == -2) continue;
                ++n2;
            }
            if (n2 >= n) continue;
            n = n2;
            localInfo = localInfo2;
        }
        vector.removeElement(localInfo);
        localInfo.newSlot = -2;
        this.distributeLocals(vector);
        int n3 = 0;
        while (true) {
            block6: {
                Enumeration enumeration2 = localInfo.conflictingLocals.elements();
                while (enumeration2.hasMoreElements()) {
                    object = (LocalInfo)enumeration2.nextElement();
                    if (localInfo.size == 2 && ((LocalInfo)object).newSlot == n3 + 1) {
                        ++n3;
                        break block6;
                    }
                    if (((LocalInfo)object).size == 2 && ((LocalInfo)object).newSlot + 1 == n3) break block6;
                    if (((LocalInfo)object).newSlot != n3) continue;
                    if (((LocalInfo)object).size != 2) break block6;
                    ++n3;
                    break block6;
                }
                break;
            }
            ++n3;
        }
        localInfo.newSlot = n3;
    }

    public void distributeLocals() {
        int n = 0;
        while (n < this.paramLocals.length) {
            if (this.paramLocals[n] != null) {
                this.paramLocals[n].newSlot = n;
            }
            ++n;
        }
        Object object = this.firstInfo;
        while (object != null) {
            if (((InstrInfo)object).instr.getOpcode() >= 54 && ((InstrInfo)object).instr.getOpcode() <= 58) {
                int n2 = 0;
                while (n2 < this.maxlocals) {
                    if (n2 != ((InstrInfo)object).instr.getLocalSlot() && ((InstrInfo)object).nextReads[n2] != null) {
                        ((InstrInfo)object).local.conflictsWith(((InstrInfo)object).nextReads[n2].local);
                    }
                    if (((InstrInfo)object).nextInfo.nextReads[n2] != null && ((InstrInfo)object).nextInfo.nextReads[n2].jsrTargetInfo != null) {
                        Instruction[] instructionArray = ((InstrInfo)object).nextInfo.nextReads[n2].jsrTargetInfo.instr.getPreds();
                        int n3 = 0;
                        while (n3 < instructionArray.length) {
                            InstrInfo instrInfo = (InstrInfo)this.instrInfos.get(instructionArray[n3]);
                            int n4 = 0;
                            while (n4 < this.maxlocals) {
                                if (!((InstrInfo)object).nextInfo.nextReads[n2].usedBySub.get(n4) && instrInfo.nextReads[n4] != null) {
                                    ((InstrInfo)object).local.conflictsWith(instrInfo.nextReads[n4].local);
                                }
                                ++n4;
                            }
                            ++n3;
                        }
                    }
                    ++n2;
                }
            }
            object = ((InstrInfo)object).nextInfo;
        }
        object = new Vector();
        InstrInfo instrInfo = this.firstInfo;
        while (instrInfo != null) {
            if (instrInfo.local != null && instrInfo.local.newSlot == -1 && !((Vector)object).contains(instrInfo.local)) {
                ((Vector)object).addElement(instrInfo.local);
            }
            instrInfo = instrInfo.nextInfo;
        }
        this.distributeLocals((Vector)object);
        instrInfo = this.firstInfo;
        while (instrInfo != null) {
            if (instrInfo.local != null) {
                instrInfo.instr.setLocalSlot(instrInfo.local.newSlot);
            }
            instrInfo = instrInfo.nextInfo;
        }
        if (this.produceLVT) {
            this.buildNewLVT();
        }
    }

    boolean promoteLifeLocals(LocalInfo[] localInfoArray, InstrInfo instrInfo) {
        if (instrInfo.lifeLocals == null) {
            instrInfo.lifeLocals = (LocalInfo[])localInfoArray.clone();
            return true;
        }
        boolean bl = false;
        int n = 0;
        while (n < this.maxlocals) {
            LocalInfo localInfo = instrInfo.lifeLocals[n];
            if (localInfo != null) {
                localInfo = localInfo.getReal();
                LocalInfo localInfo2 = localInfoArray[n];
                if (localInfo2 != null) {
                    localInfo2 = localInfo2.getReal();
                }
                if (localInfo != localInfo2) {
                    instrInfo.lifeLocals[n] = null;
                    bl = true;
                }
            }
            ++n;
        }
        return bl;
    }

    public void buildNewLVT() {
        LocalInfo[] localInfoArray;
        LocalInfo[] localInfoArray2;
        LocalVariableInfo[] localVariableInfoArray;
        Object object;
        InstrInfo instrInfo = this.firstInfo;
        while (instrInfo != null) {
            if (instrInfo.usedBySub != null) {
                instrInfo.usedBySub = new BitSet();
            }
            instrInfo = instrInfo.nextInfo;
        }
        instrInfo = this.firstInfo;
        while (instrInfo != null) {
            if (instrInfo.local != null) {
                int n = 0;
                while (n < instrInfo.nextReads.length) {
                    if (instrInfo.nextReads[n] != null && instrInfo.nextReads[n].instr.getOpcode() == 169) {
                        instrInfo.nextReads[n].usedBySub.set(instrInfo.local.newSlot);
                    }
                    ++n;
                }
            }
            instrInfo = instrInfo.nextInfo;
        }
        this.firstInfo.lifeLocals = new LocalInfo[this.maxlocals];
        int n = 0;
        while (n < this.paramLocals.length) {
            this.firstInfo.lifeLocals[n] = this.paramLocals[n];
            ++n;
        }
        Stack<Object> stack = new Stack<Object>();
        stack.push(this.firstInfo);
        Handler[] handlerArray = this.bc.getExceptionHandlers();
        while (!stack.isEmpty()) {
            int n2;
            InstrInfo instrInfo2;
            Object object2;
            int n3;
            object = (InstrInfo)stack.pop();
            localVariableInfoArray = ((InstrInfo)object).instr;
            localInfoArray2 = ((InstrInfo)object).lifeLocals;
            if (localVariableInfoArray.hasLocalSlot()) {
                n3 = localVariableInfoArray.getLocalSlot();
                object2 = ((InstrInfo)object).local.getReal();
                localInfoArray2 = (LocalInfo[])localInfoArray2.clone();
                localInfoArray2[n3] = object2;
                if (((LocalInfo)object2).name != null) {
                    int n4 = 0;
                    while (n4 < localInfoArray2.length) {
                        if (n4 != n3 && localInfoArray2[n4] != null && ((LocalInfo)object2).name.equals(localInfoArray2[n4].name)) {
                            localInfoArray2[n4] = null;
                        }
                        ++n4;
                    }
                }
            }
            if (!localVariableInfoArray.doesAlwaysJump() && this.promoteLifeLocals(localInfoArray2, instrInfo2 = ((InstrInfo)object).nextInfo)) {
                stack.push(instrInfo2);
            }
            if (localVariableInfoArray.hasSuccs()) {
                Instruction[] instructionArray = localVariableInfoArray.getSuccs();
                int n5 = 0;
                while (n5 < instructionArray.length) {
                    InstrInfo instrInfo3 = (InstrInfo)this.instrInfos.get(instructionArray[n5]);
                    if (this.promoteLifeLocals(localInfoArray2, instrInfo3)) {
                        stack.push(instrInfo3);
                    }
                    ++n5;
                }
            }
            n3 = 0;
            while (n3 < handlerArray.length) {
                if (handlerArray[n3].start.compareTo((Instruction)localVariableInfoArray) <= 0 && handlerArray[n3].end.compareTo((Instruction)localVariableInfoArray) >= 0 && this.promoteLifeLocals(localInfoArray2, (InstrInfo)(object2 = (InstrInfo)this.instrInfos.get(handlerArray[n3].catcher)))) {
                    stack.push(object2);
                }
                ++n3;
            }
            if (((InstrInfo)object).instr.getOpcode() == 168) {
                Instruction instruction = ((InstrInfo)object).instr.getSingleSucc();
                object2 = (InstrInfo)this.instrInfos.get(instruction);
                InstrInfo instrInfo4 = ((InstrInfo)object2).retInfo;
                if (instrInfo4 != null && instrInfo4.lifeLocals != null) {
                    localInfoArray = (LocalInfo[])localInfoArray2.clone();
                    n2 = 0;
                    while (n2 < this.maxlocals) {
                        if (instrInfo4.usedBySub.get(n2)) {
                            localInfoArray[n2] = instrInfo4.lifeLocals[n2];
                        }
                        ++n2;
                    }
                    if (this.promoteLifeLocals(localInfoArray, ((InstrInfo)object).nextInfo)) {
                        stack.push(((InstrInfo)object).nextInfo);
                    }
                }
            }
            if (((InstrInfo)object).jsrTargetInfo == null) continue;
            Instruction instruction = ((InstrInfo)object).jsrTargetInfo.instr;
            int n6 = 0;
            while (n6 < instruction.getPreds().length) {
                InstrInfo instrInfo5 = (InstrInfo)this.instrInfos.get(instruction.getPreds()[n6]);
                if (instrInfo5.lifeLocals != null) {
                    localInfoArray = (LocalInfo[])localInfoArray2.clone();
                    n2 = 0;
                    while (n2 < this.maxlocals) {
                        if (!((InstrInfo)object).usedBySub.get(n2)) {
                            localInfoArray[n2] = instrInfo5.lifeLocals[n2];
                        }
                        ++n2;
                    }
                    if (this.promoteLifeLocals(localInfoArray, instrInfo5.nextInfo)) {
                        stack.push(instrInfo5.nextInfo);
                    }
                }
                ++n6;
            }
        }
        object = new Vector();
        localVariableInfoArray = new LocalVariableInfo[this.maxlocals];
        localInfoArray2 = new LocalInfo[this.maxlocals];
        int n7 = 0;
        while (n7 < this.paramLocals.length) {
            if (this.paramLocals[n7] != null) {
                localInfoArray2[n7] = this.paramLocals[n7];
                if (localInfoArray2[n7].name != null) {
                    localVariableInfoArray[n7] = new LocalVariableInfo();
                    ((Vector)object).addElement(localVariableInfoArray[n7]);
                    localVariableInfoArray[n7].name = localInfoArray2[n7].name;
                    localVariableInfoArray[n7].type = Main.getClassBundle().getTypeAlias(localInfoArray2[n7].type);
                    localVariableInfoArray[n7].start = (Instruction)this.bc.getInstructions().get(0);
                    localVariableInfoArray[n7].slot = n7;
                }
            }
            ++n7;
        }
        Instruction instruction = null;
        InstrInfo instrInfo6 = this.firstInfo;
        while (instrInfo6 != null) {
            int n8 = 0;
            while (n8 < this.maxlocals) {
                LocalInfo[] localInfoArray3 = localInfoArray = instrInfo6.lifeLocals != null ? instrInfo6.lifeLocals[n8] : null;
                if (!(localInfoArray == localInfoArray2[n8] || localInfoArray != null && localInfoArray2[n8] != null && localInfoArray.name != null && localInfoArray.type != null && localInfoArray.name.equals(localInfoArray2[n8].name) && localInfoArray.type.equals(localInfoArray2[n8].type))) {
                    if (localVariableInfoArray[n8] != null) {
                        localVariableInfoArray[n8].end = instrInfo6.instr.getPrevByAddr();
                    }
                    localVariableInfoArray[n8] = null;
                    localInfoArray2[n8] = localInfoArray;
                    if (localInfoArray2[n8] != null && localInfoArray2[n8].name != null && localInfoArray2[n8].type != null) {
                        localVariableInfoArray[n8] = new LocalVariableInfo();
                        ((Vector)object).addElement(localVariableInfoArray[n8]);
                        localVariableInfoArray[n8].name = localInfoArray2[n8].name;
                        localVariableInfoArray[n8].type = Main.getClassBundle().getTypeAlias(localInfoArray2[n8].type);
                        localVariableInfoArray[n8].start = instrInfo6.instr;
                        localVariableInfoArray[n8].slot = n8;
                    }
                }
                ++n8;
            }
            instruction = instrInfo6.instr;
            instrInfo6 = instrInfo6.nextInfo;
        }
        int n9 = 0;
        while (n9 < this.maxlocals) {
            if (localVariableInfoArray[n9] != null) {
                localVariableInfoArray[n9].end = instruction;
            }
            ++n9;
        }
        Object[] objectArray = new LocalVariableInfo[((Vector)object).size()];
        ((Vector)object).copyInto(objectArray);
        this.bc.setLocalVariableTable((LocalVariableInfo[])objectArray);
    }

    public void dumpLocals() {
        Vector<LocalInfo> vector = new Vector<LocalInfo>();
        Object object = this.firstInfo;
        while (object != null) {
            GlobalOptions.err.println(((InstrInfo)object).instr.getDescription());
            GlobalOptions.err.print("nextReads: ");
            int n = 0;
            while (n < this.maxlocals) {
                if (((InstrInfo)object).nextReads[n] == null) {
                    GlobalOptions.err.print("-,");
                } else {
                    GlobalOptions.err.print(((InstrInfo)object).nextReads[n].instr.getAddr() + ",");
                }
                ++n;
            }
            if (((InstrInfo)object).usedBySub != null) {
                GlobalOptions.err.print("  usedBySub: " + ((InstrInfo)object).usedBySub);
            }
            if (((InstrInfo)object).retInfo != null) {
                GlobalOptions.err.print("  ret info: " + ((InstrInfo)object).retInfo.instr.getAddr());
            }
            if (((InstrInfo)object).jsrTargetInfo != null) {
                GlobalOptions.err.print("  jsr info: " + ((InstrInfo)object).jsrTargetInfo.instr.getAddr());
            }
            GlobalOptions.err.println();
            if (((InstrInfo)object).local != null && !vector.contains(((InstrInfo)object).local)) {
                vector.addElement(((InstrInfo)object).local);
            }
            object = ((InstrInfo)object).nextInfo;
        }
        object = vector.elements();
        while (object.hasMoreElements()) {
            Object object2;
            LocalInfo localInfo = (LocalInfo)object.nextElement();
            int n = ((InstrInfo)localInfo.usingInstrs.elementAt((int)0)).instr.getLocalSlot();
            GlobalOptions.err.print("Slot: " + n + " conflicts:");
            Enumeration enumeration = localInfo.conflictingLocals.elements();
            while (enumeration.hasMoreElements()) {
                object2 = (LocalInfo)enumeration.nextElement();
                GlobalOptions.err.print(((LocalInfo)object2).getFirstAddr() + ", ");
            }
            GlobalOptions.err.println();
            GlobalOptions.err.print(localInfo.getFirstAddr());
            GlobalOptions.err.print("     instrs: ");
            object2 = localInfo.usingInstrs.elements();
            while (object2.hasMoreElements()) {
                GlobalOptions.err.print(((InstrInfo)object2.nextElement()).instr.getAddr() + ", ");
            }
            GlobalOptions.err.println();
        }
        GlobalOptions.err.println("-----------");
    }

    public void transformCode(BytecodeInfo bytecodeInfo) {
        this.bc = bytecodeInfo;
        this.calcLocalInfo();
        if ((GlobalOptions.debuggingFlags & 0x100) != 0) {
            GlobalOptions.err.println("Before Local Optimization: ");
            this.dumpLocals();
        }
        this.stripLocals();
        this.distributeLocals();
        if ((GlobalOptions.debuggingFlags & 0x100) != 0) {
            GlobalOptions.err.println("After Local Optimization: ");
            this.dumpLocals();
        }
        this.firstInfo = null;
        this.changedInfos = null;
        this.instrInfos = null;
        this.paramLocals = null;
    }

    class LocalInfo {
        LocalInfo shadow = null;
        String name;
        String type;
        Vector usingInstrs = new Vector();
        Vector conflictingLocals = new Vector();
        int size;
        int newSlot = -1;

        public LocalInfo getReal() {
            LocalInfo localInfo = this;
            while (localInfo.shadow != null) {
                localInfo = localInfo.shadow;
            }
            return localInfo;
        }

        void conflictsWith(LocalInfo localInfo) {
            if (this.shadow != null) {
                this.getReal().conflictsWith(localInfo);
            } else if (!this.conflictingLocals.contains(localInfo = localInfo.getReal())) {
                this.conflictingLocals.addElement(localInfo);
                localInfo.conflictingLocals.addElement(this);
            }
        }

        void combineInto(LocalInfo localInfo) {
            if (this.shadow != null) {
                this.getReal().combineInto(localInfo);
                return;
            }
            if (this == (localInfo = localInfo.getReal())) {
                return;
            }
            this.shadow = localInfo;
            if (this.shadow.name == null) {
                this.shadow.name = this.name;
                this.shadow.type = this.type;
            }
            Enumeration enumeration = this.usingInstrs.elements();
            while (enumeration.hasMoreElements()) {
                InstrInfo instrInfo = (InstrInfo)enumeration.nextElement();
                instrInfo.local = localInfo;
                localInfo.usingInstrs.addElement(instrInfo);
            }
        }

        public int getFirstAddr() {
            int n = Integer.MAX_VALUE;
            Enumeration enumeration = this.usingInstrs.elements();
            while (enumeration.hasMoreElements()) {
                InstrInfo instrInfo = (InstrInfo)enumeration.nextElement();
                if (instrInfo.instr.getAddr() >= n) continue;
                n = instrInfo.instr.getAddr();
            }
            return n;
        }

        LocalInfo() {
        }

        LocalInfo(InstrInfo instrInfo) {
            this.usingInstrs.addElement(instrInfo);
        }
    }

    private static class TodoQueue {
        public final InstrInfo LAST;
        InstrInfo first;

        public void add(InstrInfo instrInfo) {
            if (instrInfo.nextTodo == null) {
                instrInfo.nextTodo = this.first;
                this.first = instrInfo;
            }
        }

        public boolean isEmpty() {
            return this.first == this.LAST;
        }

        public InstrInfo remove() {
            if (this.first == this.LAST) {
                throw new NoSuchElementException();
            }
            InstrInfo instrInfo = this.first;
            this.first = instrInfo.nextTodo;
            instrInfo.nextTodo = null;
            return instrInfo;
        }

        TodoQueue() {
            this.first = this.LAST = new InstrInfo();
        }
    }

    static class InstrInfo {
        InstrInfo nextTodo;
        LocalInfo local;
        InstrInfo[] nextReads;
        BitSet usedBySub;
        LocalInfo[] lifeLocals;
        InstrInfo retInfo;
        InstrInfo jsrTargetInfo;
        Instruction instr;
        InstrInfo nextInfo;

        InstrInfo() {
        }
    }
}

