/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSCoding;
import com.webobjects.foundation.NSData;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSKeyValueCoding;
import com.webobjects.foundation.NSKeyValueCodingAdditions;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSNotification;
import com.webobjects.foundation.NSNumberFormatter;
import com.webobjects.foundation.NSTimeZone;
import com.webobjects.foundation.NSTimestamp;
import com.webobjects.foundation._NSCollectionPrimitives;
import com.webobjects.foundation._NSCollectionReaderWriterLock;
import com.webobjects.foundation._NSReadReentrantReaderWriterLock;
import com.webobjects.foundation._NSStringUtilities;
import com.webobjects.foundation._NSThreadsafeMutableArray;
import com.webobjects.foundation._NSThreadsafeMutableDictionary;
import com.webobjects.foundation._NSUtilitiesExtra;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public final class _NSUtilities {
    public static final Class _CLASS = _NSUtilitiesExtra._classWithFullySpecifiedNamePrime("com.webobjects.foundation._NSUtilities");
    private static final Class _touchedDictionary = NSDictionary._CLASS;
    private static final Class _touchedArray = NSArray._CLASS;
    private static final _NSThreadsafeMutableDictionary _classesByPartialName = new _NSThreadsafeMutableDictionary(new NSMutableDictionary(1024));
    private static final _NSThreadsafeMutableArray _packages = new _NSThreadsafeMutableArray(new NSMutableArray(32));
    private static volatile _ResourceSearcher _privateResourceSearcher = null;
    static boolean _principalClassLoadingWarningsNeeded = true;
    public static final String WebObjectsRootPropertyKey = "WORootDirectory";
    public static final String WebObjectsLocalRootPropertyKey = "WOLocalRootDirectory";
    public static final String WebObjectsUserDirectoryPropertyKey = "WOUserDirectory";
    public static final String WebObjectsVersionPropertyKey = "webobjects.version";
    public static final Class _ObjectClass = _NSUtilities._classWithFullySpecifiedName("java.lang.Object");
    public static final Class _ClassClass = _NSUtilities._classWithFullySpecifiedName("java.lang.Class");
    public static final Class _StringClass = _NSUtilities._classWithFullySpecifiedName("java.lang.String");
    public static final Class _NumberClass = _NSUtilities._classWithFullySpecifiedName("java.lang.Number");
    public static final Class _BigDecimalClass = _NSUtilities._classWithFullySpecifiedName("java.math.BigDecimal");
    public static final Class _BigIntegerClass = _NSUtilities._classWithFullySpecifiedName("java.math.BigInteger");
    public static final Class _BooleanClass = _NSUtilities._classWithFullySpecifiedName("java.lang.Boolean");
    public static final Class _DateClass = _NSUtilities._classWithFullySpecifiedName("java.util.Date");
    public static final Class _LocaleClass = _NSUtilities._classWithFullySpecifiedName("java.util.Locale");
    public static final Class _ShortClass = _NSUtilities._classWithFullySpecifiedName("java.lang.Short");
    public static final Class _ByteClass = _NSUtilities._classWithFullySpecifiedName("java.lang.Byte");
    public static final Class _IntegerClass = _NSUtilities._classWithFullySpecifiedName("java.lang.Integer");
    public static final Class _LongClass = _NSUtilities._classWithFullySpecifiedName("java.lang.Long");
    public static final Class _DoubleClass = _NSUtilities._classWithFullySpecifiedName("java.lang.Double");
    public static final Class _FloatClass = _NSUtilities._classWithFullySpecifiedName("java.lang.Float");
    public static final Class _VoidClass = _NSUtilities._classWithFullySpecifiedName("java.lang.Void");
    public static final Class _CharacterClass = _NSUtilities._classWithFullySpecifiedName("java.lang.Character");
    public static final Object[] _NoObjectArray = new Object[0];
    public static final byte[] _NoByteArray = new byte[0];
    public static final int[] _NoIntArray = new int[0];
    public static final Class[] _NoClassArray = new Class[0];
    public static final String[] _NoStringArray = new String[0];
    public static final Class[] _ObjectClassArray = new Class[]{_ObjectClass};
    public static final Class[] _StringClassArray = new Class[]{_StringClass};
    public static final Class[] _ArrayClassArray = new Class[]{NSArray._CLASS};
    public static final Class[] _DictionaryClassArray = new Class[]{NSDictionary._CLASS};
    public static final Class[] _NotificationClassArray = new Class[]{NSNotification._CLASS};
    public static final Class _DateFormatSymbolsClass = _NSUtilities._classWithFullySpecifiedName("java.text.DateFormatSymbols");
    public static final Class _DecimalFormatSymbolsClass = _NSUtilities._classWithFullySpecifiedName("java.text.DecimalFormatSymbols");
    public static final Class _ObjectArrayClass = new Object[0].getClass();
    private static final JavaArchiveFilter TheJavaArchiveFilter = new JavaArchiveFilter();
    private static final JavaClassFilter TheJavaClassFilter = new JavaClassFilter();
    private static final BigDecimal _zeroBigDecimal = BigDecimal.valueOf(0L);
    private static final BigInteger _zeroBigInteger = BigInteger.valueOf(0L);
    private static final Integer[] _integers;
    private static final int _intMin = -3;
    private static final int _intMax = 513;
    private static final int _intOffset = 3;
    protected static final Short _shortFalse;
    protected static final Short _shortTrue;
    private static final String _isoLatinEncoding;
    public static final String MacOSRomanStringEncoding = "MacRoman";
    public static final String ASCIIStringEncoding = "ASCII";
    public static final String NEXTSTEPStringEncoding;
    public static final String JapaneseEUCStringEncoding = "EUC_JP";
    public static final String UTF8StringEncoding = "UTF8";
    public static final String ISOLatin1StringEncoding;
    public static final String SymbolStringEncoding = "MacSymbol";
    public static final String NonLossyASCIIStringEncoding = "ASCII";
    public static final String ShiftJISStringEncoding = "SJIS";
    public static final String ISOLatin2StringEncoding = "ISO8859_2";
    public static final String UnicodeStringEncoding = "Unicode";
    public static final String WindowsCP1251StringEncoding = "Cp1251";
    public static final String WindowsCP1252StringEncoding = "Cp1252";
    public static final String WindowsCP1253StringEncoding = "Cp1253";
    public static final String WindowsCP1254StringEncoding = "Cp1254";
    public static final String WindowsCP1250StringEncoding = "Cp1250";
    public static final String ISO2022JPStringEncoding = "ISO2022JP";

    public static Object valueForKeyArray(NSKeyValueCoding kvcObject, NSArray keyArray) {
        NSKeyValueCoding retVal = null;
        Object currentObject = kvcObject;
        if (keyArray != null) {
            Enumeration e = keyArray.objectEnumerator();
            while (e.hasMoreElements()) {
                String s = e.nextElement().toString();
                if (currentObject instanceof NSKeyValueCoding) {
                    currentObject = currentObject.valueForKey(s);
                }
                if (currentObject != null) continue;
                return null;
            }
            retVal = currentObject;
        }
        return retVal;
    }

    public static Integer IntegerForInt(int i) {
        if (i < 513 && i >= -3) {
            return _integers[i + 3];
        }
        return new Integer(i);
    }

    public static String shortClassName(Object obj) {
        if (obj == null) {
            return "null";
        }
        return _NSStringUtilities.lastComponentInString(obj.getClass().getName(), '.');
    }

    public static Class _classWithFullySpecifiedName(String className) {
        Throwable throwable = null;
        try {
            Class<?> result = Class.forName(className);
            _classesByPartialName.setObjectForKey(result, className);
            return result;
        }
        catch (ClassNotFoundException exception) {
            throwable = exception;
        }
        catch (ClassFormatError exception) {
            throwable = exception;
        }
        catch (SecurityException exception) {
            throwable = exception;
        }
        NSLog.err.appendln("Cannot load class with name " + className);
        if (NSLog.debugLoggingAllowedForLevel(1)) {
            NSLog.debug.appendln(throwable);
        }
        throw NSForwardException._runtimeExceptionForThrowable(throwable);
    }

    public static Class classObjectForClass(Class objectClass) {
        if (objectClass.isPrimitive()) {
            if (objectClass == Boolean.TYPE) {
                return _BooleanClass;
            }
            if (objectClass == Short.TYPE) {
                return _ShortClass;
            }
            if (objectClass == Integer.TYPE) {
                return _IntegerClass;
            }
            if (objectClass == Long.TYPE) {
                return _LongClass;
            }
            if (objectClass == Double.TYPE) {
                return _DoubleClass;
            }
            if (objectClass == Float.TYPE) {
                return _FloatClass;
            }
            if (objectClass == Character.TYPE) {
                return _CharacterClass;
            }
            if (objectClass == Void.TYPE) {
                return _VoidClass;
            }
        }
        return objectClass;
    }

    public static _ResourceSearcher _resourceSearcher() {
        return _privateResourceSearcher;
    }

    public static void _setResourceSearcher(_ResourceSearcher resourceSearcher) {
        _privateResourceSearcher = resourceSearcher;
    }

    public static URL _pathURLForResourceWithName(Class resourceClass, String resourceName, String extension) {
        _ResourceSearcher searcher = _privateResourceSearcher;
        return searcher != null ? searcher._searchPathURLForResourceWithName(resourceClass, resourceName, extension) : null;
    }

    public static void _setPrincipalClassLoadingWarningsNeeded(boolean flag) {
        _principalClassLoadingWarningsNeeded = flag;
    }

    public static void registerPackage(String packageName) {
        if (packageName != null) {
            _packages.addObjectIfAbsent(packageName);
        }
    }

    public static void setClassForName(Class objectClass, String className) {
        _classesByPartialName.setObjectForKey(objectClass, className);
    }

    public static Class classWithName(String className) {
        Class objectClass;
        if (className != null && className.length() > 0 && (objectClass = _NSUtilities._classWithPartialName(className, className.indexOf(46) < 0)) != null) {
            return objectClass;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Class _classWithPartialName(String partialName, boolean extensiveSearch) {
        _NSThreadsafeMutableDictionary classesByPartialName = _classesByPartialName;
        Class objectClass = (Class)classesByPartialName.objectForKey(partialName);
        if (objectClass != null) {
            return objectClass != _NoClassUnderTheSun._CLASS ? objectClass : null;
        }
        try {
            objectClass = Class.forName(partialName);
            if (objectClass != null) {
                classesByPartialName.setObjectForKey(objectClass, partialName);
                return objectClass;
            }
        }
        catch (ClassNotFoundException e) {
            NSLog._conditionallyLogPrivateException(e);
        }
        catch (ClassFormatError e) {
            NSLog._conditionallyLogPrivateException(e);
        }
        catch (SecurityException e) {
            NSLog._conditionallyLogPrivateException(e);
        }
        catch (IllegalArgumentException e) {
            NSLog.err.appendln("The class name \"" + partialName + "\" is not a valid Java class name.");
            if (NSLog.debugLoggingAllowedForLevel(1)) {
                NSLog.debug.appendln(e);
            }
            throw e;
        }
        if (!extensiveSearch) {
            return null;
        }
        _packages.acquireReadLock();
        try {
            objectClass = _NSUtilities._searchForClassInPackages(partialName, _packages.array(), false, true);
        }
        finally {
            _packages.releaseReadLock();
        }
        if (objectClass != null) {
            return objectClass;
        }
        _ResourceSearcher searcher = _privateResourceSearcher;
        if (searcher != null && (objectClass = searcher._searchForClassWithName(partialName)) != null) {
            return objectClass;
        }
        classesByPartialName.setObjectForKey(_NoClassUnderTheSun._CLASS, partialName);
        return null;
    }

    static Class _searchForClassInPackages(String className, NSArray packages, boolean registerPackageOnHit, boolean sortPackageArray) {
        int count = packages.count();
        StringBuffer buffer = new StringBuffer(64 + className.length());
        for (int i = 0; i < count; ++i) {
            String toast;
            String packageName = (String)packages.objectAtIndex(i);
            if (packageName.length() > 0) {
                buffer.append(packageName);
                buffer.append('.');
                buffer.append(className);
                toast = buffer.toString();
            } else {
                toast = className;
            }
            try {
                Class<?> result = Class.forName(toast);
                if (result != null) {
                    _classesByPartialName.setObjectForKey(result, className);
                    if (registerPackageOnHit) {
                        _NSUtilities.registerPackage(packageName);
                    }
                    if (sortPackageArray) {
                        ((NSMutableArray)packages)._moveObjectAtIndexToIndex(i, 0);
                    }
                    return result;
                }
            }
            catch (ClassNotFoundException e) {
                NSLog._conditionallyLogPrivateException(e);
            }
            catch (ClassFormatError e) {
                NSLog._conditionallyLogPrivateException(e);
            }
            catch (SecurityException e) {
                NSLog._conditionallyLogPrivateException(e);
            }
            buffer.setLength(0);
        }
        return null;
    }

    public static NSArray classNamesFromArchiveInputStream(InputStream is) {
        NSMutableArray classes = null;
        if (is != null) {
            ZipEntry nextEntry;
            classes = new NSMutableArray();
            ZipInputStream zipStream = is instanceof ZipInputStream ? (ZipInputStream)is : new ZipInputStream(is);
            try {
                nextEntry = zipStream.getNextEntry();
            }
            catch (IOException e) {
                throw NSForwardException._runtimeExceptionForThrowable(e);
            }
            if (nextEntry != null) {
                do {
                    String nextName;
                    if (TheJavaClassFilter.accept(null, nextName = nextEntry.getName())) {
                        String nextClassName = nextName.substring(0, nextName.lastIndexOf(46));
                        nextClassName = nextClassName.replace('/', '.');
                        nextClassName = nextClassName.intern();
                        classes.addObject(nextClassName);
                    }
                    try {
                        nextEntry = zipStream.getNextEntry();
                    }
                    catch (IOException e) {
                        throw NSForwardException._runtimeExceptionForThrowable(e);
                    }
                } while (nextEntry != null);
            }
            try {
                zipStream.close();
            }
            catch (IOException e) {
                throw NSForwardException._runtimeExceptionForThrowable(e);
            }
        }
        if (classes == null || classes.count() == 0) {
            return NSArray.EmptyArray;
        }
        return classes;
    }

    public static NSArray classNamesFromArchive(File anArchive) {
        if (anArchive != null && anArchive.length() > 0L) {
            try {
                return _NSUtilities.classNamesFromArchiveInputStream(new FileInputStream(anArchive));
            }
            catch (FileNotFoundException fnfe) {
                throw NSForwardException._runtimeExceptionForThrowable(fnfe);
            }
        }
        return NSArray.EmptyArray;
    }

    public static NSArray classNamesFromArchiveAtPathURL(URL archivePathURL) {
        if (archivePathURL != null) {
            try {
                return _NSUtilities.classNamesFromArchiveInputStream(archivePathURL.openStream());
            }
            catch (IOException ioe) {
                throw NSForwardException._runtimeExceptionForThrowable(ioe);
            }
        }
        return NSArray.EmptyArray;
    }

    public static NSArray classNamesFromArchiveAtPath(String archivePath) {
        if (archivePath != null && !archivePath.equals("")) {
            File anArchive = new File(archivePath);
            return _NSUtilities.classNamesFromArchive(anArchive);
        }
        return NSArray.EmptyArray;
    }

    private static RuntimeException _explainInstantiationException(Class objectClass, Class[] parameters, Throwable throwable, boolean shouldLog) {
        String className;
        StringBuffer buffer = new StringBuffer(32);
        buffer.append('(');
        if (parameters != null) {
            for (int i = 0; i < parameters.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(parameters[i] == null ? "null" : parameters[i].getName());
            }
        }
        buffer.append(')');
        String parametersDescription = new String(buffer);
        String string = className = objectClass == null ? "null" : objectClass.getName();
        if (throwable instanceof InstantiationException) {
            return new NSForwardException(throwable, "<" + className + "> is an abstract class. It can not be instantiated !");
        }
        if (throwable instanceof IllegalArgumentException) {
            return new NSForwardException(throwable, "<" + className + "> Constructor 'new " + className + " " + parametersDescription + "' has wrong number of arguments, object can not be instantiated.");
        }
        if (throwable instanceof NoSuchMethodException) {
            return new NSForwardException(throwable, "<" + className + "> Constructor 'new " + className + " " + parametersDescription + "' does not exist, component can not be instantiated.");
        }
        if (throwable instanceof IllegalAccessException) {
            return new NSForwardException(throwable, "<" + className + "> Could not invoke constructor 'new " + className + parametersDescription + "' as it is not public.");
        }
        if (throwable instanceof InvocationTargetException) {
            return new NSForwardException(throwable);
        }
        if (throwable instanceof NoSuchMethodError) {
            return new NSForwardException(throwable, "<" + className + "> Could not find default initializer method " + className + "() :" + throwable.toString());
        }
        if (throwable instanceof SecurityException) {
            return new NSForwardException(throwable, "<" + className + "> There is no permission to create a new instance of " + className + ".");
        }
        return new NSForwardException(throwable, "<" + className + "> failed instantiation. Exception thrown :\n" + throwable + ": " + throwable.getMessage());
    }

    public static Object instantiateObject(Class objectClass, Class[] parameterTypes, Object[] parameters, boolean shouldThrow, boolean shouldLog) {
        try {
            if (parameterTypes != null && parameters != null) {
                Constructor constructor = objectClass.getDeclaredConstructor(parameterTypes);
                return constructor.newInstance(parameters);
            }
            return objectClass.newInstance();
        }
        catch (Throwable throwable) {
            NSLog._conditionallyLogPrivateException(throwable);
            RuntimeException exception = _NSUtilities._explainInstantiationException(objectClass, parameterTypes, throwable, shouldLog);
            if (shouldThrow) {
                throw exception;
            }
            if (shouldLog) {
                NSLog.err.appendln("<" + (objectClass == null ? "null" : objectClass.getName()) + "> Ignoring Exception During Instantiation: " + exception.toString());
            }
            return null;
        }
    }

    public static Object instantiateObjectWithConstructor(Constructor constructor, Class objectClass, Object[] parameters, boolean shouldThrow, boolean shouldLog) {
        try {
            if (constructor != null && parameters != null) {
                return constructor.newInstance(parameters);
            }
            return objectClass.newInstance();
        }
        catch (Throwable throwable) {
            NSLog._conditionallyLogPrivateException(throwable);
            RuntimeException exception = _NSUtilities._explainInstantiationException(objectClass, null, throwable, shouldLog);
            if (shouldThrow) {
                throw exception;
            }
            if (shouldLog) {
                NSLog.err.appendln("<" + (objectClass == null ? "null" : objectClass.getName()) + "> Ignoring Exception During Instantiation: " + exception.toString());
            }
            return null;
        }
    }

    public static Constructor constructorForClass(Class objectClass, Class[] parameterTypes) {
        try {
            return objectClass.getConstructor(parameterTypes);
        }
        catch (NoSuchMethodException ex) {
            NSLog._conditionallyLogPrivateException(ex);
        }
        catch (SecurityException ex) {
            NSLog._conditionallyLogPrivateException(ex);
        }
        return null;
    }

    public static boolean _isClassABoolean(Class valueClass) {
        return valueClass == Boolean.TYPE || valueClass == _BooleanClass;
    }

    public static boolean _isClassANumber(Class valueClass) {
        return valueClass == _NumberClass || valueClass == Integer.TYPE || valueClass == _IntegerClass || valueClass == Double.TYPE || valueClass == _DoubleClass || _NumberClass.isAssignableFrom(valueClass) || valueClass == Long.TYPE || valueClass == Float.TYPE || valueClass == Byte.TYPE || valueClass == Short.TYPE;
    }

    public static boolean _isClassANumberOrABoolean(Class valueClass) {
        return _NSUtilities._isClassANumber(valueClass) || _NSUtilities._isClassABoolean(valueClass);
    }

    public static Object tryToConvertIntoNumberOrBooleanValueClass(Object value, Class valueClass) {
        if (value != null && valueClass != null) {
            Class<?> originalValueClass = value.getClass();
            if (_NSUtilities._isClassABoolean(valueClass)) {
                if (_NSUtilities._isClassABoolean(originalValueClass)) {
                    return value;
                }
                if (_NSUtilities._isClassANumber(originalValueClass)) {
                    return _NSUtilities.convertNumberIntoBooleanValue((Number)value);
                }
            } else if (_NSUtilities._isClassANumber(valueClass)) {
                if (_NSUtilities._isClassABoolean(originalValueClass)) {
                    return _NSUtilities.convertBooleanIntoCompatibleNumberValue((Boolean)value, valueClass);
                }
                if (_NSUtilities._isClassANumber(originalValueClass)) {
                    return _NSUtilities.convertNumberIntoCompatibleValue((Number)value, valueClass);
                }
            }
        }
        return value;
    }

    public static Number convertBooleanIntoNumberValue(Boolean value) {
        if (value != null) {
            return value != false ? _shortTrue : _shortFalse;
        }
        return null;
    }

    public static Boolean convertNumberIntoBooleanValue(Number value) {
        if (value != null) {
            Class<?> valueClass = value.getClass();
            if (valueClass == _IntegerClass || valueClass == _ShortClass || valueClass == _ByteClass) {
                return value.intValue() != 0 ? Boolean.TRUE : Boolean.FALSE;
            }
            if (valueClass == _LongClass) {
                return value.longValue() != 0L ? Boolean.TRUE : Boolean.FALSE;
            }
            if (valueClass == _DoubleClass || valueClass == _FloatClass) {
                return value.doubleValue() != 0.0 ? Boolean.TRUE : Boolean.FALSE;
            }
            if (valueClass == _BigDecimalClass) {
                return ((BigDecimal)value).compareTo(_zeroBigDecimal) != 0 ? Boolean.TRUE : Boolean.FALSE;
            }
            if (valueClass == _BigIntegerClass) {
                return ((BigInteger)value).compareTo(_zeroBigInteger) != 0 ? Boolean.TRUE : Boolean.FALSE;
            }
            return value.doubleValue() != 0.0 ? Boolean.TRUE : Boolean.FALSE;
        }
        return null;
    }

    public static Number convertBooleanIntoCompatibleNumberValue(Boolean value, Class newValueType) {
        return _NSUtilities.convertNumberIntoCompatibleValue(_NSUtilities.convertBooleanIntoNumberValue(value), newValueType);
    }

    public static Number convertNumberIntoCompatibleValue(Number value, Class newValueType) {
        Class<?> valueClass;
        if (value != null && (valueClass = value.getClass()) != newValueType) {
            if (newValueType == Integer.TYPE || newValueType == _IntegerClass) {
                return _NSUtilities.IntegerForInt(value.intValue());
            }
            if (newValueType == Double.TYPE || newValueType == _DoubleClass) {
                return new Double(value.doubleValue());
            }
            if (newValueType == Float.TYPE || newValueType == _FloatClass) {
                return new Float(value.floatValue());
            }
            if (newValueType == Long.TYPE || newValueType == _LongClass) {
                return new Long(value.longValue());
            }
            if (newValueType == Short.TYPE || newValueType == _ShortClass) {
                return new Short(value.shortValue());
            }
            if (newValueType == Byte.TYPE || newValueType == _ByteClass) {
                return new Byte(value.byteValue());
            }
            if (newValueType == _BigDecimalClass) {
                if (valueClass == _IntegerClass || valueClass == _LongClass || valueClass == _ShortClass || valueClass == _ByteClass) {
                    return BigDecimal.valueOf(value.longValue());
                }
                if (value instanceof BigInteger) {
                    return new BigDecimal((BigInteger)value);
                }
                return new BigDecimal(value.doubleValue());
            }
            if (newValueType == _BigIntegerClass) {
                if (value instanceof BigDecimal) {
                    return ((BigDecimal)value).toBigInteger();
                }
                return BigInteger.valueOf(value.longValue());
            }
        }
        return value;
    }

    public static int compareNumbers(Number number1, Number number2) {
        double value2;
        int comparison;
        Class<?> numberClass;
        Class<?> class2;
        if (number1 == number2) {
            return 0;
        }
        if (number1 == null) {
            return -1;
        }
        if (number2 == null) {
            return 1;
        }
        Class<?> class1 = number1.getClass();
        if (class1 != (class2 = number2.getClass())) {
            boolean byteOrShortOrIntegerOrLong2;
            boolean byteOrShort1 = class1 == _ShortClass || class1 == _ByteClass;
            boolean byteOrShort2 = class2 == _ShortClass || class2 == _ByteClass;
            boolean byteOrShortOrIntegerOrLong1 = byteOrShort1 || class1 == _IntegerClass || class1 == _LongClass;
            boolean bl = byteOrShortOrIntegerOrLong2 = byteOrShort2 || class2 == _IntegerClass || class2 == _LongClass;
            if (byteOrShortOrIntegerOrLong1 && byteOrShortOrIntegerOrLong2) {
                long value22;
                long value1 = number1.longValue();
                if (value1 == (value22 = number2.longValue())) {
                    return 0;
                }
                return value1 < value22 ? -1 : 1;
            }
            if ((byteOrShort1 || class1 == _FloatClass || class1 == _DoubleClass) && (byteOrShort2 || class2 == _FloatClass || class2 == _DoubleClass)) {
                double value23;
                double value1 = number1.doubleValue();
                if (value1 == (value23 = number2.doubleValue())) {
                    return 0;
                }
                return value1 < value23 ? -1 : 1;
            }
            if ((byteOrShortOrIntegerOrLong1 || class1 == _BigIntegerClass) && (byteOrShortOrIntegerOrLong2 || class2 == _BigIntegerClass)) {
                if (class1 != _BigIntegerClass) {
                    number1 = BigInteger.valueOf(number1.longValue());
                }
                if (class2 != _BigIntegerClass) {
                    number2 = BigInteger.valueOf(number2.longValue());
                }
            } else {
                if (!_BigDecimalClass.isAssignableFrom(class1)) {
                    number1 = byteOrShortOrIntegerOrLong1 ? BigDecimal.valueOf(number1.longValue()) : (_BigIntegerClass.isAssignableFrom(class1) ? new BigDecimal((BigInteger)number1) : new BigDecimal(number1.doubleValue()));
                }
                if (!_BigDecimalClass.isAssignableFrom(class2)) {
                    number2 = byteOrShortOrIntegerOrLong2 ? BigDecimal.valueOf(number2.longValue()) : (_BigIntegerClass.isAssignableFrom(class2) ? new BigDecimal((BigInteger)number2) : new BigDecimal(number2.doubleValue()));
                }
            }
        }
        if ((numberClass = number1.getClass()) == _LongClass || numberClass == _IntegerClass || numberClass == _ShortClass || numberClass == _ByteClass) {
            long value24;
            long value1 = number1.longValue();
            if (value1 == (value24 = number2.longValue())) {
                return 0;
            }
            return value1 < value24 ? -1 : 1;
        }
        if (_BigDecimalClass.isAssignableFrom(numberClass)) {
            comparison = ((BigDecimal)number1).compareTo((BigDecimal)number2);
            if (comparison < 0) {
                return -1;
            }
            if (comparison > 0) {
                return 1;
            }
            return 0;
        }
        if (_BigIntegerClass.isAssignableFrom(numberClass)) {
            comparison = ((BigInteger)number1).compareTo((BigInteger)number2);
            if (comparison < 0) {
                return -1;
            }
            if (comparison > 0) {
                return 1;
            }
            return 0;
        }
        double value1 = number1.doubleValue();
        if (value1 == (value2 = number2.doubleValue())) {
            return 0;
        }
        return value1 < value2 ? -1 : 1;
    }

    public static Object convertNumberOrBooleanIntoCompatibleValue(Object value, Class newValueType) {
        if (value != null) {
            Class<?> valueClass = value.getClass();
            if (_NSUtilities._isClassABoolean(newValueType)) {
                return valueClass == _BooleanClass ? value : _NSUtilities.convertNumberIntoBooleanValue((Number)value);
            }
            return valueClass == _BooleanClass ? (Number)_NSUtilities.convertBooleanIntoCompatibleNumberValue((Boolean)value, newValueType) : (Number)_NSUtilities.convertNumberIntoCompatibleValue((Number)value, newValueType);
        }
        return value;
    }

    public static int compareNumbersOrBooleans(Object numericalValue1, Object numericalValue2) {
        if (numericalValue1 == numericalValue2) {
            return 0;
        }
        if (numericalValue1 == null) {
            return -1;
        }
        if (numericalValue2 == null) {
            return 1;
        }
        Class<?> valueClass1 = numericalValue1.getClass();
        Class<?> valueClass2 = numericalValue2.getClass();
        if (valueClass1 == _BooleanClass && valueClass2 == _BooleanClass) {
            boolean boolean2;
            boolean boolean1 = (Boolean)numericalValue1;
            if (boolean1 == (boolean2 = ((Boolean)numericalValue2).booleanValue())) {
                return 0;
            }
            if (boolean2) {
                return -1;
            }
            return 1;
        }
        if (valueClass1 == _BooleanClass) {
            return _NSUtilities.compareNumbers(_NSUtilities.convertBooleanIntoNumberValue((Boolean)numericalValue1), (Number)numericalValue2);
        }
        if (valueClass2 == _BooleanClass) {
            return _NSUtilities.compareNumbers((Number)numericalValue1, _NSUtilities.convertBooleanIntoNumberValue((Boolean)numericalValue2));
        }
        return _NSUtilities.compareNumbers((Number)numericalValue1, (Number)numericalValue2);
    }

    static String _isoLatinEncoding() {
        String encoding;
        block2: {
            encoding = "ISO8859_1";
            try {
                String string = "test";
                string.getBytes(encoding);
            }
            catch (UnsupportedEncodingException exception) {
                NSLog._conditionallyLogPrivateException(exception);
                if (!System.getProperty("java.vendor").startsWith("Microsoft")) break block2;
                encoding = "8859_1";
            }
        }
        return encoding;
    }

    public static String _encodingNameFromObjectiveC(String objectiveCEncodingName) {
        if (objectiveCEncodingName.equals("NSISOLatin1StringEncoding")) {
            return ISOLatin1StringEncoding;
        }
        if (objectiveCEncodingName.equals("NSMacOSRomanStringEncoding")) {
            return MacOSRomanStringEncoding;
        }
        if (objectiveCEncodingName.equals("NSASCIIStringEncoding")) {
            return "ASCII";
        }
        if (objectiveCEncodingName.equals("NSNEXTSTEPStringEncoding")) {
            return NEXTSTEPStringEncoding;
        }
        if (objectiveCEncodingName.equals("NSJapaneseEUCStringEncoding")) {
            return JapaneseEUCStringEncoding;
        }
        if (objectiveCEncodingName.equals("NSUTF8StringEncoding")) {
            return UTF8StringEncoding;
        }
        if (objectiveCEncodingName.equals("NSSymbolStringEncoding")) {
            return SymbolStringEncoding;
        }
        if (objectiveCEncodingName.equals("NSNonLossyASCIIStringEncoding")) {
            return "ASCII";
        }
        if (objectiveCEncodingName.equals("NSShiftJISStringEncoding")) {
            return ShiftJISStringEncoding;
        }
        if (objectiveCEncodingName.equals("NSISOLatin2StringEncoding")) {
            return ISOLatin2StringEncoding;
        }
        if (objectiveCEncodingName.equals("NSUnicodeStringEncoding")) {
            return UnicodeStringEncoding;
        }
        if (objectiveCEncodingName.equals("NSWindowsCP1251StringEncoding")) {
            return WindowsCP1251StringEncoding;
        }
        if (objectiveCEncodingName.equals("NSWindowsCP1252StringEncoding")) {
            return WindowsCP1252StringEncoding;
        }
        if (objectiveCEncodingName.equals("NSWindowsCP1253StringEncoding")) {
            return WindowsCP1253StringEncoding;
        }
        if (objectiveCEncodingName.equals("NSWindowsCP1254StringEncoding")) {
            return WindowsCP1254StringEncoding;
        }
        if (objectiveCEncodingName.equals("NSWindowsCP1250StringEncoding")) {
            return WindowsCP1250StringEncoding;
        }
        if (objectiveCEncodingName.equals("NSISO2022JPStringEncoding")) {
            return ISO2022JPStringEncoding;
        }
        return objectiveCEncodingName;
    }

    static {
        try {
            _packages.addObject("com.webobjects.foundation");
            _packages.addObject("java.lang");
            _packages.addObject("java.math");
            _packages.addObject("java.util");
            _classesByPartialName.setObjectForKey(NSDictionary._CLASS, "com.webobjects.foundation.NSDictionary");
            _classesByPartialName.setObjectForKey(NSArray._CLASS, "com.webobjects.foundation.NSArray");
            _classesByPartialName.setObjectForKey(NSMutableArray._CLASS, "com.webobjects.foundation.NSMutableArray");
            _classesByPartialName.setObjectForKey(_NSThreadsafeMutableArray._CLASS, "com.webobjects.foundation._NSThreadsafeMutableArray");
            _classesByPartialName.setObjectForKey(NSMutableDictionary._CLASS, "com.webobjects.foundation.NSMutableDictionary");
            _classesByPartialName.setObjectForKey(_NSThreadsafeMutableDictionary._CLASS, "com.webobjects.foundation._NSThreadsafeMutableDictionary");
            _classesByPartialName.setObjectForKey(_NSCollectionReaderWriterLock._CLASS, "com.webobjects.foundation._NSCollectionReaderWriterLock");
            _classesByPartialName.setObjectForKey(_NSReadReentrantReaderWriterLock._CLASS, "com.webobjects.foundation._NSReadReentrantReaderWriterLock");
            _classesByPartialName.setObjectForKey(NSCoding._CLASS, "com.webobjects.foundation.NSCoding");
            _classesByPartialName.setObjectForKey(NSKeyValueCoding._CLASS, "com.webobjects.foundation.NSKeyValueCoding");
            _classesByPartialName.setObjectForKey(NSKeyValueCoding.ErrorHandling._CLASS, "com.webobjects.foundation.NSKeyValueCoding$ErrorHandling");
            _classesByPartialName.setObjectForKey(NSKeyValueCoding.UnknownKeyException._CLASS, "com.webobjects.foundation.NSKeyValueCoding$UnknownKeyException");
            _classesByPartialName.setObjectForKey(NSKeyValueCoding.Null._CLASS, "com.webobjects.foundation.NSKeyValueCoding$Null");
            _classesByPartialName.setObjectForKey(NSKeyValueCoding.Utility._CLASS, "com.webobjects.foundation.NSKeyValueCoding$Utility");
            _classesByPartialName.setObjectForKey(NSKeyValueCoding.ValueAccessor._CLASS, "com.webobjects.foundation.NSKeyValueCoding$ValueAccessor");
            _classesByPartialName.setObjectForKey(NSKeyValueCoding._KeyBindingCreation._CLASS, "com.webobjects.foundation.NSKeyValueCoding$_KeyBindingCreation");
            _classesByPartialName.setObjectForKey(NSKeyValueCoding._KeyBinding._CLASS, "com.webobjects.foundation.NSKeyValueCoding$_KeyBinding");
            _classesByPartialName.setObjectForKey(NSKeyValueCoding.DefaultImplementation._CLASS, "com.webobjects.foundation.NSKeyValueCoding$DefaultImplementation");
            _classesByPartialName.setObjectForKey(NSKeyValueCoding._ReflectionKeyBindingCreation._CLASS, "com.webobjects.foundation.NSKeyValueCoding$_ReflectionKeyBindingCreation");
            _classesByPartialName.setObjectForKey(NSKeyValueCodingAdditions._CLASS, "com.webobjects.foundation.NSKeyValueCodingAdditions");
            _classesByPartialName.setObjectForKey(NSKeyValueCodingAdditions.Utility._CLASS, "com.webobjects.foundation.NSKeyValueCodingAdditions$Utility");
            _classesByPartialName.setObjectForKey(NSKeyValueCodingAdditions.DefaultImplementation._CLASS, "com.webobjects.foundation.NSKeyValueCodingAdditions$DefaultImplementation");
            _classesByPartialName.setObjectForKey(_NSCollectionPrimitives._CLASS, "com.webobjects.foundation._NSCollectionPrimitives");
            _classesByPartialName.setObjectForKey(NSForwardException._CLASS, "com.webobjects.foundation.NSForwardException");
            _classesByPartialName.setObjectForKey(_CLASS, "com.webobjects.foundation._NSUtilities");
            _classesByPartialName.setObjectForKey(Boolean.TYPE, "boolean");
            _classesByPartialName.setObjectForKey(Short.TYPE, "short");
            _classesByPartialName.setObjectForKey(Byte.TYPE, "byte");
            _classesByPartialName.setObjectForKey(Integer.TYPE, "int");
            _classesByPartialName.setObjectForKey(Long.TYPE, "long");
            _classesByPartialName.setObjectForKey(Double.TYPE, "double");
            _classesByPartialName.setObjectForKey(Float.TYPE, "float");
            _classesByPartialName.setObjectForKey(Character.TYPE, "char");
            _classesByPartialName.setObjectForKey(_StringClass, "NSString");
            _classesByPartialName.setObjectForKey(_NumberClass, "NSNumber");
            _classesByPartialName.setObjectForKey(_BigDecimalClass, "NSDecimalNumber");
            _classesByPartialName.setObjectForKey(_BigDecimalClass, "NSdoubleNumber");
            _classesByPartialName.setObjectForKey(NSData._CLASS, "NSData");
            _classesByPartialName.setObjectForKey(NSNumberFormatter._CLASS, "NSNumberFormatter");
            _classesByPartialName.setObjectForKey(NSTimeZone._CLASS, "NSTimeZone");
            try {
                _classesByPartialName.setObjectForKey(NSTimestamp._CLASS, "NSTimestamp");
                _classesByPartialName.setObjectForKey(NSTimestamp._CLASS, "NSCalendarDate");
                _classesByPartialName.setObjectForKey(NSTimestamp._CLASS, "NSGregorianDate");
            }
            catch (Throwable ex) {
                NSLog.err.appendln("Error during Foundation initialization. This could be a result of NSTimeZone being incompletely initialized.  Try moving any use of NSTimeZone further into your application.");
            }
            _classesByPartialName.setObjectForKey(NSKeyValueCoding.Null._CLASS, "EONull");
            _integers = new Integer[517];
            int c = 516;
            for (int i = 0; i < c; ++i) {
                _NSUtilities._integers[i] = new Integer(i - 3);
            }
        }
        catch (Throwable e) {
            NSLog.err.appendln("Exception occurred in initializer");
            if (NSLog.debugLoggingAllowedForLevel(1)) {
                NSLog.debug.appendln(e);
            }
            throw NSForwardException._runtimeExceptionForThrowable(e);
        }
        _shortFalse = new Short(0);
        _shortTrue = new Short(1);
        NEXTSTEPStringEncoding = _isoLatinEncoding = _NSUtilities._isoLatinEncoding();
        ISOLatin1StringEncoding = _isoLatinEncoding;
    }

    public static class JavaArchiveFilter
    implements FilenameFilter {
        private static final String JAR = ".jar";
        private static final String ZIP = ".zip";

        public boolean accept(File dir, String aName) {
            boolean result = false;
            if (aName != null && (aName.endsWith(JAR) || aName.endsWith(ZIP))) {
                result = true;
            }
            return result;
        }
    }

    public static class JavaClassFilter
    implements FilenameFilter {
        private static final String CLASS_SUFFIX = ".class";

        public boolean accept(File dir, String aName) {
            boolean result = false;
            if (aName != null && aName.endsWith(CLASS_SUFFIX)) {
                result = true;
            }
            return result;
        }
    }

    private static class _NoClassUnderTheSun {
        protected static final Class _CLASS = _NSUtilities._classWithFullySpecifiedName("com.webobjects.foundation._NSUtilities$_NoClassUnderTheSun");

        private _NoClassUnderTheSun() {
        }
    }

    static interface _ResourceSearcher {
        public Class _searchForClassWithName(String var1);

        public URL _searchPathURLForResourceWithName(Class var1, String var2, String var3);
    }
}

