/*
 * Decompiled with CFR 0.152.
 */
package net.spy.cache;

import java.lang.ref.Reference;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.spy.SpyObject;

public class SimpleCache
extends SpyObject {
    private static SimpleCache instance = null;
    private ConcurrentMap<String, Object> storage = new ConcurrentHashMap<String, Object>();
    private Timer timer = new Timer("SimpleCacheTimer", true);

    protected SimpleCache() {
    }

    public static synchronized SimpleCache getInstance() {
        if (instance == null) {
            instance = new SimpleCache();
        }
        return instance;
    }

    public static synchronized void setInstance(SimpleCache to) {
        if (instance != null) {
            SimpleCache.instance.timer.cancel();
        }
        instance = to;
    }

    public Object get(String key) {
        Reference ref;
        Object rv = this.storage.get(key);
        if (rv != null && rv instanceof Reference && (rv = (ref = (Reference)rv).get()) == null) {
            this.storage.remove(key, ref);
        }
        return rv;
    }

    public void store(String key, Object value, long timeout) {
        this.storage.put(key, value);
        if (timeout != Long.MAX_VALUE) {
            ClearTimer c = new ClearTimer(key, value);
            this.timer.schedule((TimerTask)c, timeout);
        }
    }

    public Object remove(String key) {
        return this.storage.remove(key);
    }

    public boolean remove(String key, Object value) {
        return this.storage.remove(key, value);
    }

    private static class ClearTimer
    extends TimerTask {
        private String key = null;
        private Object value = null;

        public ClearTimer(String k, Object v) {
            this.key = k;
            this.value = v;
        }

        public void run() {
            SimpleCache.getInstance().remove(this.key, this.value);
        }
    }
}

