/*
 * Decompiled with CFR 0.152.
 */
package net.spy.db;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.spy.SpyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GenericResultSetStub
extends SpyObject
implements Cloneable {
    private List<Object[]> results = null;
    private Iterator<Object[]> resultIter = null;
    private Map<String, Integer> columns = null;
    private Object[] result = null;
    private ResultSetMetaData metadata = null;
    private boolean wasNull = false;

    public GenericResultSetStub(ResultSet rs) throws SQLException {
        this.setMetaData(rs.getMetaData());
        this.initResults(rs);
    }

    protected GenericResultSetStub() throws SQLException {
    }

    private void initResults(ResultSet rs) throws SQLException {
        ArrayList<Object[]> r = new ArrayList<Object[]>();
        int ncolumns = this.metadata.getColumnCount();
        while (rs.next()) {
            Object[] ars = new Object[ncolumns];
            for (int i = 1; i <= ncolumns; ++i) {
                ars[i - 1] = rs.getObject(i);
                if (!rs.wasNull()) continue;
                ars[i - 1] = null;
            }
            r.add(ars);
        }
        this.setResults(r);
    }

    protected void resetResults() {
        this.resultIter = null;
    }

    protected void setResults(List<Object[]> to) {
        this.results = to;
        this.resetResults();
    }

    protected void setMetaData(ResultSetMetaData rsmd) throws SQLException {
        this.metadata = rsmd;
        int ncolumns = this.metadata.getColumnCount();
        this.columns = new HashMap<String, Integer>();
        for (int i = 1; i <= ncolumns; ++i) {
            String name = this.metadata.getColumnName(i).toLowerCase();
            this.columns.put(name, new Integer(i));
        }
    }

    protected Object getResultColumn(int index) throws SQLException {
        --index;
        if (this.result == null) {
            throw new SQLException("No current result.");
        }
        if (index < 0) {
            throw new SQLException("ResultSets start at one, nothing less.");
        }
        if (index >= this.result.length) {
            throw new SQLException("There are only " + this.result.length + " columns in this set.");
        }
        this.wasNull = this.result[index] == null;
        return this.result[index];
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(256);
        sb.append("Result row:\n");
        int ncolumns = 0;
        try {
            ncolumns = this.metadata.getColumnCount();
        }
        catch (SQLException e) {
            ncolumns = 0;
        }
        for (int i = 1; i <= ncolumns; ++i) {
            try {
                Object o = this.getResultColumn(i);
                if (o != null) {
                    sb.append("\t");
                    sb.append(this.metadata.getColumnName(i));
                    sb.append("=");
                    sb.append(o);
                    sb.append(" (");
                    sb.append(o.getClass().getName());
                    sb.append(")\n");
                    continue;
                }
                sb.append("\t");
                sb.append(this.metadata.getColumnName(i));
                sb.append(" - null\n");
                continue;
            }
            catch (SQLException e) {
                this.getLogger().info("Error with column %d", i, e);
            }
        }
        return sb.toString();
    }

    public boolean next() throws SQLException {
        boolean rv = true;
        if (this.resultIter == null) {
            this.resultIter = this.results.iterator();
        }
        if (this.resultIter.hasNext()) {
            this.result = this.resultIter.next();
        } else {
            rv = false;
        }
        return rv;
    }

    public void close() throws SQLException {
    }

    public boolean wasNull() throws SQLException {
        return this.wasNull;
    }

    public String getString(int index) throws SQLException {
        Object o = this.getResultColumn(index);
        if (o == null) {
            return null;
        }
        return o.toString();
    }

    public boolean getBoolean(int index) throws SQLException {
        boolean rv = false;
        Object o = this.getResultColumn(index);
        if (o != null) {
            Boolean b = (Boolean)o;
            rv = b;
        }
        return rv;
    }

    public short getShort(int index) throws SQLException {
        Number n = this.getNumber(index);
        return n.shortValue();
    }

    public int getInt(int index) throws SQLException {
        Number n = this.getNumber(index);
        return n.intValue();
    }

    public long getLong(int index) throws SQLException {
        Number n = this.getNumber(index);
        return n.longValue();
    }

    public float getFloat(int index) throws SQLException {
        Number n = this.getNumber(index);
        return n.floatValue();
    }

    public double getDouble(int index) throws SQLException {
        Number n = this.getNumber(index);
        return n.doubleValue();
    }

    private Number getNumber(int index) throws SQLException {
        Number n = null;
        Object o = this.getResultColumn(index);
        if (o != null) {
            try {
                n = (Number)o;
            }
            catch (ClassCastException e) {
                throw new SQLException("Error getting Number value:  " + e);
            }
        } else {
            n = new Integer(0);
        }
        return n;
    }

    public BigDecimal getBigDecimal(int index) throws SQLException {
        BigDecimal rv = null;
        Object o = this.getResultColumn(index);
        if (o != null) {
            try {
                rv = (BigDecimal)o;
            }
            catch (ClassCastException e) {
                throw new SQLException("Error getting date value:  " + e);
            }
        }
        return rv;
    }

    public Date getDate(int index) throws SQLException {
        Date rv = null;
        Object o = this.getResultColumn(index);
        if (o != null) {
            try {
                rv = (Date)o;
            }
            catch (ClassCastException e) {
                throw new SQLException("Error getting date value:  " + e);
            }
        }
        return rv;
    }

    public Time getTime(int index) throws SQLException {
        Time rv = null;
        Object o = this.getResultColumn(index);
        if (o != null) {
            try {
                rv = (Time)o;
            }
            catch (ClassCastException e) {
                throw new SQLException("Error getting time value:  " + e);
            }
        }
        return rv;
    }

    public Timestamp getTimestamp(int index) throws SQLException {
        Timestamp rv = null;
        Object o = this.getResultColumn(index);
        if (o != null) {
            try {
                rv = (Timestamp)o;
            }
            catch (ClassCastException e) {
                throw new SQLException("Error getting timestamp value:  " + e);
            }
        }
        return rv;
    }

    public Object getObject(int index) throws SQLException {
        return this.getResultColumn(index);
    }

    public int findColumn(String columnName) throws SQLException {
        String name = columnName.toLowerCase();
        Integer value = this.columns.get(name);
        if (value == null) {
            throw new SQLException("No such column:  " + columnName);
        }
        return value;
    }

    public String getString(String name) throws SQLException {
        return this.getString(this.findColumn(name));
    }

    public boolean getBoolean(String name) throws SQLException {
        return this.getBoolean(this.findColumn(name));
    }

    public short getShort(String name) throws SQLException {
        return this.getShort(this.findColumn(name));
    }

    public int getInt(String name) throws SQLException {
        return this.getInt(this.findColumn(name));
    }

    public long getLong(String name) throws SQLException {
        return this.getLong(this.findColumn(name));
    }

    public float getFloat(String name) throws SQLException {
        return this.getFloat(this.findColumn(name));
    }

    public double getDouble(String name) throws SQLException {
        return this.getDouble(this.findColumn(name));
    }

    public Date getDate(String name) throws SQLException {
        return this.getDate(this.findColumn(name));
    }

    public Time getTime(String name) throws SQLException {
        return this.getTime(this.findColumn(name));
    }

    public Timestamp getTimestamp(String name) throws SQLException {
        return this.getTimestamp(this.findColumn(name));
    }

    public BigDecimal getBigDecimal(String name) throws SQLException {
        return this.getBigDecimal(this.findColumn(name));
    }

    public Object getObject(String name) throws SQLException {
        return this.getObject(this.findColumn(name));
    }

    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    public void clearWarnings() throws SQLException {
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return this.metadata;
    }
}

