/*
 * Decompiled with CFR 0.152.
 */
package net.spy.db;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.spy.SpyObject;
import net.spy.db.DBSP;
import net.spy.db.KeyStore;
import net.spy.db.OverDrawnException;
import net.spy.db.SpyDB;
import net.spy.db.sp.SelectPrimaryKey;
import net.spy.db.sp.UpdatePrimaryKey;
import net.spy.util.CloseUtil;
import net.spy.util.SpyConfig;

public class GetPK
extends SpyObject {
    private static GetPK instance = null;
    private ConcurrentMap<String, KeyStore> caches = new ConcurrentHashMap<String, KeyStore>();

    protected GetPK() {
    }

    public static synchronized GetPK getInstance() {
        if (instance == null) {
            instance = new GetPK();
        }
        return instance;
    }

    public static synchronized void setInstance(GetPK to) {
        instance = to;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigDecimal getPrimaryKey(SpyConfig conf, String table) throws SQLException {
        BigDecimal rv = null;
        SpyDB db = new SpyDB(conf);
        try {
            rv = this.getPrimaryKey(db, table.toLowerCase(), this.makeDbTableKey(conf, table));
        }
        finally {
            CloseUtil.close(db);
        }
        return rv;
    }

    private String makeDbTableKey(SpyConfig conf, String table) {
        StringBuilder rc = new StringBuilder(512);
        rc.append(conf.get("dbSource"));
        rc.append(";");
        rc.append(conf.get("dbConnectionSource"));
        rc.append(";");
        rc.append(conf.get("dbDriverName"));
        rc.append(";");
        rc.append(conf.get("dbUser"));
        rc.append(";");
        rc.append(conf.get("dbPass"));
        rc.append(";");
        rc.append(conf.get("dbPoolName"));
        rc.append(";");
        rc.append(conf.get("dbPkKey"));
        rc.append(";");
        rc.append(table);
        return rc.toString();
    }

    private BigDecimal getPrimaryKey(SpyDB db, String table, String key) throws SQLException {
        BigDecimal rv = null;
        try {
            KeyStore ks = (KeyStore)this.caches.get(key);
            if (ks == null) {
                this.getKeysFromDB(db, table, key);
                ks = (KeyStore)this.caches.get(key);
                if (ks == null) {
                    throw new SQLException("Couldn't get initial keys for " + table);
                }
            }
            rv = ks.nextKey();
        }
        catch (OverDrawnException ode) {
            this.caches.remove(key);
            this.getKeysFromDB(db, table, key);
            KeyStore ks = (KeyStore)this.caches.get(key);
            try {
                rv = ks.nextKey();
            }
            catch (OverDrawnException ode2) {
                throw new AssertionError((Object)"Primary keys not available after load.");
            }
        }
        return rv;
    }

    protected DBSP getUpdateDBSP(Connection conn) throws SQLException {
        return new UpdatePrimaryKey(conn);
    }

    protected DBSP getSelectDBSP(Connection conn) throws SQLException {
        return new SelectPrimaryKey(conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getKeysFromDB(SpyDB db, String table, String key) throws SQLException {
        Connection conn = null;
        boolean complete = false;
        try {
            conn = db.getConn();
            conn.setAutoCommit(false);
            DBSP dbsp = this.getUpdateDBSP(conn);
            dbsp.set("table_name", table);
            int changed = 0;
            try {
                changed = dbsp.executeUpdate();
            }
            finally {
                dbsp.close();
            }
            if (changed == 0) {
                throw new SQLException("Incorrect row count for " + table + " (got " + changed + ") - " + "This usually means the primary key table does not have " + table + " or there is a case mismatch.");
            }
            if (changed > 1) {
                throw new SQLException("Did not update the correct number of rows for " + table + " (got " + changed + ")");
            }
            BigDecimal start = null;
            BigDecimal end = null;
            dbsp = this.getSelectDBSP(conn);
            ResultSet rs = null;
            try {
                dbsp.set("table_name", table);
                rs = dbsp.executeQuery();
                if (!rs.next()) {
                    throw new SQLException("No results returned for primary key");
                }
                start = rs.getBigDecimal("first_key");
                end = rs.getBigDecimal("last_key");
                if (rs.next()) {
                    throw new SQLException("Too many results returned for primary key");
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
                dbsp.close();
            }
            KeyStore ks = new KeyStore(start, end);
            this.getLogger().debug("Got a new keystore for %s:  %s", table, ks);
            this.caches.put(key, ks);
            complete = true;
        }
        finally {
            if (conn != null) {
                if (complete) {
                    try {
                        conn.commit();
                    }
                    catch (SQLException e) {
                        this.getLogger().error((Object)"Problem committing", e);
                    }
                } else {
                    try {
                        conn.rollback();
                    }
                    catch (SQLException e) {
                        this.getLogger().error((Object)"Problem rolling back", e);
                    }
                }
                try {
                    conn.setAutoCommit(true);
                }
                catch (SQLException e) {
                    this.getLogger().error((Object)"Problem resetting autocommit", e);
                }
            }
        }
    }
}

