/*
 * Decompiled with CFR 0.152.
 */
package net.spy.db;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.spy.SpyObject;
import net.spy.db.ConnectionSource;
import net.spy.db.ConnectionSourceFactory;
import net.spy.db.Savable;
import net.spy.db.SaveContext;
import net.spy.db.SaveException;
import net.spy.db.TransactionListener;
import net.spy.util.IdentityEqualifier;
import net.spy.util.SpyConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Saver
extends SpyObject {
    private static final int MAX_RECURSION_DEPTH = 100;
    private SaveContext context = null;
    private SpyConfig config = null;
    private int rdepth = 0;
    private Set<IdentityEqualifier> listedObjects = null;
    private ConnectionSource connSrc = null;
    private Connection conn = null;

    public Saver(SpyConfig conf) {
        this(conf, null);
    }

    public Saver(SpyConfig conf, SaveContext ctx) {
        this.context = ctx;
        if (this.context == null) {
            this.context = new SaveContext();
        }
        this.config = conf;
        ConnectionSourceFactory csf = ConnectionSourceFactory.getInstance();
        this.connSrc = csf.getConnectionSource(conf);
        this.listedObjects = new HashSet<IdentityEqualifier>();
    }

    public void save(Savable o) throws SaveException {
        this.save(o, null);
    }

    /*
     * Loose catch block
     */
    public void save(Savable o, Integer isoLevel) throws SaveException {
        block31: {
            int oldIsolationLevel;
            boolean complete;
            block27: {
                block29: {
                    block28: {
                        complete = false;
                        this.listedObjects.clear();
                        oldIsolationLevel = 0;
                        this.getLogger().debug("Beginning save transaction %s with isolation level %s", this.getSessId(), isoLevel);
                        this.conn = this.connSrc.getConnection(this.config);
                        if (isoLevel != null) {
                            oldIsolationLevel = this.conn.getTransactionIsolation();
                            this.conn.setTransactionIsolation(isoLevel);
                        }
                        this.conn.setAutoCommit(false);
                        this.rsave(o);
                        complete = true;
                        Object var7_5 = null;
                        if (this.conn == null) break block27;
                        if (complete) break block28;
                        try {
                            this.conn.rollback();
                        }
                        catch (SQLException se) {
                            this.getLogger().warn((Object)"Problem rolling back.", se);
                        }
                        break block29;
                    }
                    try {
                        this.conn.commit();
                    }
                    catch (SQLException se) {
                        throw new SaveException("Error committing", se);
                    }
                }
                try {
                    this.conn.setAutoCommit(true);
                }
                catch (SQLException sqe) {
                    this.getLogger().warn((Object)"Problem resetting autocommit.", sqe);
                }
                if (isoLevel != null) {
                    try {
                        this.conn.setTransactionIsolation(oldIsolationLevel);
                    }
                    catch (SQLException sqe) {
                        this.getLogger().warn((Object)"Problem resetting isolation level.", sqe);
                    }
                }
            }
            if (this.conn != null) {
                this.connSrc.returnConnection(this.conn);
            }
            break block31;
            {
                catch (SQLException se) {
                    this.getLogger().error((Object)"Exception saving object", se);
                    throw new SaveException("Error saving object", se);
                }
                catch (RuntimeException e) {
                    this.getLogger().error((Object)"Runtime exception saving object", e);
                    throw e;
                }
                catch (Error e) {
                    this.getLogger().error((Object)"Error saving object", e);
                    throw e;
                }
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                if (this.conn != null) {
                    if (!complete) {
                        try {
                            this.conn.rollback();
                        }
                        catch (SQLException se) {
                            this.getLogger().warn((Object)"Problem rolling back.", se);
                        }
                    } else {
                        try {
                            this.conn.commit();
                        }
                        catch (SQLException se) {
                            throw new SaveException("Error committing", se);
                        }
                    }
                    try {
                        this.conn.setAutoCommit(true);
                    }
                    catch (SQLException sqe) {
                        this.getLogger().warn((Object)"Problem resetting autocommit.", sqe);
                    }
                    if (isoLevel != null) {
                        try {
                            this.conn.setTransactionIsolation(oldIsolationLevel);
                        }
                        catch (SQLException sqe) {
                            this.getLogger().warn((Object)"Problem resetting isolation level.", sqe);
                        }
                    }
                }
                if (this.conn != null) {
                    this.connSrc.returnConnection(this.conn);
                }
                throw throwable;
            }
        }
        for (IdentityEqualifier ie : this.listedObjects) {
            if (!(ie.get() instanceof TransactionListener)) continue;
            TransactionListener tl = (TransactionListener)ie.get();
            tl.transactionCommited();
        }
        this.getLogger().debug("Save transaction %s complete", this.getSessId());
    }

    private String getSessId() {
        return Integer.toHexString(this.context.getId());
    }

    private void rsave(Savable o) throws SaveException, SQLException {
        ++this.rdepth;
        this.checkRecursionDepth();
        IdentityEqualifier ie = new IdentityEqualifier(o);
        if (!this.listedObjects.contains(ie)) {
            this.listedObjects.add(ie);
            this.saveLoop(o, o.getPreSavables(this.context));
            if (o.isNew() || o.isModified()) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Saving %s in %s", this.dbgString(o), this.getSessId());
                }
                o.save(this.conn, this.context);
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Completed saving %s in %s", this.dbgString(o), this.getSessId());
                }
            } else if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Not saving %s in %s (not modified)", this.dbgString(o), this.getSessId());
            }
            this.saveLoop(o, o.getPostSavables(this.context));
        }
        --this.rdepth;
    }

    private void checkRecursionDepth() throws SaveException {
        if (this.rdepth > 100) {
            throw new SaveException("Recursing too deep!  Max depth is 100");
        }
    }

    private String dbgString(Object o) {
        StringBuilder sb = new StringBuilder(80);
        if (o == null) {
            sb.append("<null>");
        } else {
            sb.append("{");
            sb.append(o.getClass().getName());
            sb.append("@");
            sb.append(Integer.toHexString(System.identityHashCode(o)));
            String s = o.toString();
            sb.append(" - ");
            if (s.length() < 64) {
                sb.append(s);
            } else {
                sb.append(s.substring(0, 63));
            }
            sb.append("}");
        }
        return sb.toString();
    }

    private void saveLoop(Savable o, Collection<?> name) throws SaveException, SQLException {
        ++this.rdepth;
        this.checkRecursionDepth();
        if (name != null) {
            for (Object tmpo : name) {
                if (tmpo == null) {
                    throw new NullPointerException("Got a null object from " + o + " (" + this.dbgString(o) + ")");
                }
                if (tmpo instanceof Savable) {
                    this.rsave((Savable)tmpo);
                    continue;
                }
                if (tmpo instanceof Collection) {
                    this.saveLoop(o, (Collection)tmpo);
                    continue;
                }
                throw new SaveException("Invalid object type found in save tree:  " + tmpo.getClass() + " from " + o + " (" + this.dbgString(o) + ")");
            }
        }
        --this.rdepth;
    }
}

