/*
 * Decompiled with CFR 0.152.
 */
package net.spy.db;

import java.io.Closeable;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.StringTokenizer;
import net.spy.SpyObject;
import net.spy.db.ConnectionSource;
import net.spy.db.ConnectionSourceFactory;
import net.spy.db.DBInitException;
import net.spy.util.SpyConfig;

public class SpyDB
extends SpyObject
implements Closeable {
    private Connection conn = null;
    private SpyConfig conf = null;
    private boolean isClosed = false;
    private ConnectionSource source = null;
    private DBInitException initializationException = null;
    protected static final int INIT_FROM_CONFIG = 1;
    protected static final int INIT_FROM_CONN = 2;
    private int initType = 0;

    public SpyDB(SpyConfig c) {
        this.conf = c;
        this.initType = 1;
        this.source = ConnectionSourceFactory.getInstance().getConnectionSource(c);
        this.init();
    }

    public SpyDB(Connection c) {
        this.conn = c;
        this.initType = 2;
        this.init();
    }

    public int getInitType() {
        return this.initType;
    }

    public ResultSet executeQuery(String query) throws SQLException {
        Connection c = this.getConn();
        Statement st = c.createStatement();
        ResultSet rs = st.executeQuery(query);
        return rs;
    }

    public int executeUpdate(String query) throws SQLException {
        int rv = 0;
        Connection c = this.getConn();
        Statement st = c.createStatement();
        rv = st.executeUpdate(query);
        return rv;
    }

    public PreparedStatement prepareStatement(String query) throws SQLException {
        Connection c = this.getConn();
        PreparedStatement pst = c.prepareStatement(query);
        return pst;
    }

    public CallableStatement prepareCall(String query) throws SQLException {
        Connection c = this.getConn();
        CallableStatement cst = c.prepareCall(query);
        return cst;
    }

    public Connection getConn() throws SQLException {
        if (this.conn == null) {
            this.getDBConn();
        }
        return this.conn;
    }

    public void freeDBConn() {
        if (this.source != null && this.conn != null) {
            this.source.returnConnection(this.conn);
            this.conn = null;
        }
        this.isClosed = true;
    }

    public void close() {
        this.freeDBConn();
    }

    protected void init() {
    }

    private void getDBConn() throws SQLException {
        if (this.initializationException != null) {
            throw this.initializationException;
        }
        this.conn = this.source.getConnection(this.conf);
    }

    public static String dbquoteStr(String in) {
        if (in == null) {
            return null;
        }
        String sout = null;
        if (in.indexOf(39) < 0) {
            sout = in;
        } else {
            StringBuilder sb = new StringBuilder(in.length());
            StringTokenizer st = new StringTokenizer(in, "'", true);
            while (st.hasMoreTokens()) {
                String part = st.nextToken();
                sb.append(part);
                if (!part.equals("'")) continue;
                sb.append('\'');
            }
            sout = sb.toString();
        }
        return sout;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public ConnectionSource getSource() {
        return this.source;
    }

    protected SpyConfig getConfig() {
        return this.conf;
    }
}

