/*
 * Decompiled with CFR 0.152.
 */
package net.spy.factory;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.spy.SpyObject;
import net.spy.factory.CacheKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheKeyFinder
extends SpyObject {
    private static CacheKeyFinder instance = null;
    private ConcurrentMap<Class<?>, Map<CacheKey, Accessor>> memo = new ConcurrentHashMap();

    protected CacheKeyFinder() {
    }

    public static synchronized CacheKeyFinder getInstance() {
        if (instance == null) {
            instance = new CacheKeyFinder();
        }
        return instance;
    }

    public static void setInstance(CacheKeyFinder to) {
        instance = to;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<CacheKey, Accessor> getCacheKeys(Class<?> c) {
        HashMap<CacheKey, Accessor> rv = (HashMap<CacheKey, Accessor>)this.memo.get(c);
        if (rv == null) {
            Class<?> clazz = c;
            synchronized (clazz) {
                rv = (Map)this.memo.get(c);
                if (rv == null) {
                    rv = new HashMap<CacheKey, Accessor>();
                    this.lookupCacheKeys(rv, c);
                }
            }
        }
        return rv;
    }

    private void lookupCacheKeys(Map<CacheKey, Accessor> rv, Class<?> c) {
        CacheKey ck;
        Class<?> sup = c.getSuperclass();
        if (sup != null) {
            this.lookupCacheKeys(rv, sup);
        }
        for (Class<?> clazz : c.getInterfaces()) {
            this.lookupCacheKeys(rv, clazz);
        }
        for (GenericDeclaration genericDeclaration : c.getDeclaredMethods()) {
            ck = ((Method)genericDeclaration).getAnnotation(CacheKey.class);
            if (ck == null) continue;
            rv.put(ck, new MethodAccessor((Method)genericDeclaration));
        }
        for (AnnotatedElement annotatedElement : c.getDeclaredFields()) {
            ck = ((Field)annotatedElement).getAnnotation(CacheKey.class);
            if (ck == null) continue;
            rv.put(ck, new FieldAccessor((Field)annotatedElement));
        }
    }

    private static class FieldAccessor
    extends Accessor {
        private Field field = null;

        public FieldAccessor(Field f) {
            super(f);
            this.field = f;
        }

        public Object realGet(Object o) throws Exception {
            return this.field.get(o);
        }
    }

    private static class MethodAccessor
    extends Accessor {
        private Method method = null;

        public MethodAccessor(Method m) {
            super(m);
            this.method = m;
        }

        protected Object realGet(Object o) throws Exception {
            Object rv = this.method.invoke(o, new Object[0]);
            return rv;
        }
    }

    public static abstract class Accessor {
        private AccessibleObject ao = null;

        protected Accessor(AccessibleObject o) {
            this.ao = o;
        }

        public final Object get(Object o) throws Exception {
            boolean accessible = this.ao.isAccessible();
            if (!accessible) {
                this.ao.setAccessible(true);
            }
            Object rv = this.realGet(o);
            if (!accessible) {
                this.ao.setAccessible(false);
            }
            return rv;
        }

        protected abstract Object realGet(Object var1) throws Exception;
    }
}

