/*
 * Decompiled with CFR 0.152.
 */
package net.spy.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BitArray {
    private List<Integer> bitList = null;

    public BitArray(int size) {
        this.bitList = new ArrayList<Integer>(size);
    }

    public BitArray() {
        this.bitList = new ArrayList<Integer>();
    }

    public BitArray(String bitString) {
        this(bitString.length());
        char[] acters;
        block4: for (char c : acters = bitString.toCharArray()) {
            if (Character.isWhitespace(c)) continue;
            switch (c) {
                case '0': {
                    this.add(false);
                    continue block4;
                }
                case '1': {
                    this.add(true);
                    continue block4;
                }
                default: {
                    throw new IllegalArgumentException("Only 0, 1, and whitespace is allowed.");
                }
            }
        }
    }

    public void add(boolean value) {
        if (value) {
            this.bitList.add(1);
        } else {
            this.bitList.add(0);
        }
    }

    public void addBits(int bitSet, int numBits) {
        ArrayList<Integer> bitsToAdd = new ArrayList<Integer>(numBits);
        for (int i = 0; i < numBits; ++i) {
            if ((bitSet & 1) == 0) {
                bitsToAdd.add(0);
            } else {
                bitsToAdd.add(1);
            }
            bitSet >>= 1;
        }
        Collections.reverse(bitsToAdd);
        this.bitList.addAll(bitsToAdd);
    }

    public void removeMSBBits(int howMany) {
        this.removeBits(0, howMany);
    }

    public void removeLSBBits(int howMany) {
        this.removeBits(this.bitList.size() - howMany, howMany);
    }

    public void removeBits(int from, int howMany) {
        this.bitList.subList(from, from + howMany).clear();
    }

    public int getBits(int from, int number) {
        if (number > 31) {
            throw new IllegalArgumentException("Bits requested would exceed integer precision.");
        }
        int rv = 0;
        List<Integer> l = this.bitList.subList(from, from + number);
        for (int iTmp : l) {
            rv <<= 1;
            rv |= iTmp;
        }
        return rv;
    }

    public int getMSBBits(int numBits) {
        return this.getBits(0, numBits);
    }

    public int getLSBBits(int numBits) {
        return this.getBits(this.bitList.size() - numBits, numBits);
    }

    public int size() {
        return this.bitList.size();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.bitList.size());
        for (int i : this.bitList) {
            sb.append(i);
        }
        return sb.toString();
    }
}

