/*
 * Decompiled with CFR 0.152.
 */
package net.spy.util;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RingBuffer<T>
extends AbstractCollection<T>
implements Serializable {
    T[] buf = null;
    int start = 0;
    int end = 0;
    private boolean wrapped = false;
    private int size = 0;
    private static final long serialVersionUID = 823830283278235L;

    public RingBuffer(int s) {
        this.buf = new Object[s];
        Arrays.fill(this.buf, null);
    }

    public RingBuffer(int s, Collection<? extends T> fill) {
        this(s);
        for (T ob : fill) {
            this.add(ob);
        }
    }

    @Override
    public boolean add(T o) {
        if (this.end >= this.buf.length) {
            this.end = 0;
            this.wrapped = true;
        }
        this.buf[this.end] = o;
        ++this.end;
        if (this.wrapped) {
            ++this.start;
            if (this.start >= this.buf.length) {
                this.start = 0;
            }
        } else {
            ++this.size;
        }
        return true;
    }

    public boolean hasWrapped() {
        return this.wrapped;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(256);
        sb.append("{RingBuffer cap=");
        sb.append(this.getCapacity());
        sb.append(" s=");
        sb.append(this.start);
        sb.append(", e=");
        sb.append(this.end);
        sb.append(" [");
        for (T ob : this.buf) {
            sb.append(ob);
            sb.append(" ");
        }
        sb.append("]\n\t");
        ArrayList a = new ArrayList(this);
        sb.append(a.toString());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public int size() {
        return this.size;
    }

    public int getCapacity() {
        return this.buf.length;
    }

    @Override
    public Iterator<T> iterator() {
        return new RingBufferIterator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class RingBufferIterator
    implements Iterator<T>,
    Serializable {
        private int pos = 0;
        private int startPos = 0;
        private int remaining = 0;

        public RingBufferIterator() {
            this.pos = RingBuffer.this.start;
            this.startPos = RingBuffer.this.start;
            this.remaining = RingBuffer.this.size();
        }

        @Override
        public boolean hasNext() {
            if (RingBuffer.this.start != this.startPos) {
                throw new ConcurrentModificationException("Looks like additions have been made to the RingBuffer since the creation of this iterator.");
            }
            return this.remaining > 0;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("Your buffer runneth under.");
            }
            --this.remaining;
            if (this.pos == RingBuffer.this.buf.length) {
                this.pos = 0;
            }
            return RingBuffer.this.buf[this.pos++];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Nope.");
        }
    }
}

