/*
 * Decompiled with CFR 0.152.
 */
package net.spy.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.sql.Types;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import net.spy.SpyObject;
import net.spy.util.CloseUtil;
import net.spy.util.SpyUtil;
import net.spy.util.TimeSpan;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SPGen
extends SpyObject {
    private BufferedReader in = null;
    private PrintWriter out = null;
    private String classname = null;
    private boolean isInterface = true;
    private boolean wantsResultSet = false;
    private boolean wantsCursor = false;
    private String section = "";
    private String description = "";
    private String procname = "";
    private String pkg = "";
    private String superclass = null;
    private String dbcpSuperclass = null;
    private String dbspSuperclass = null;
    private String superinterface = null;
    private long cachetime = 0L;
    private Map<String, List<String>> queries = null;
    private String currentQuery = "-default-";
    private List<Result> results = null;
    List<Parameter> args = null;
    private Set<String> interfaces = null;
    private Set<String> imports = null;
    private int timeout = 0;
    private static Set<String> types = null;
    static Map<String, String> javaTypes = null;
    static Map<String, String> javaResultTypes = null;
    boolean looseTypes = false;
    private boolean typeDbsp = false;
    private boolean typeDbcp = false;
    private boolean verbose = true;

    public SPGen(String cn, BufferedReader i, PrintWriter o) {
        this.in = i;
        this.out = o;
        this.classname = cn;
        this.queries = new TreeMap<String, List<String>>();
        this.results = new ArrayList<Result>();
        this.args = new ArrayList<Parameter>();
        this.interfaces = new HashSet<String>();
        this.imports = new TreeSet<String>();
        if (types == null) {
            SPGen.initTypes();
        }
    }

    public void setVerbose(boolean to) {
        this.verbose = to;
    }

    public void setSuperclass(String sc) {
        if (sc != null) {
            this.superclass = sc;
        }
    }

    public void addInterface(String intf) {
        this.interfaces.add(intf);
    }

    public void addInterfaces(Collection<String> set) {
        this.interfaces.addAll(set);
    }

    public void setDbcpSuperclass(String sc) {
        if (sc != null) {
            this.dbcpSuperclass = sc;
        }
    }

    public void setDbspSuperclass(String sc) {
        if (sc != null) {
            this.dbspSuperclass = sc;
        }
    }

    private static synchronized void initTypes() {
        if (types == null) {
            javaTypes = new HashMap<String, String>();
            javaResultTypes = new HashMap<String, String>();
            String jstypes = "java.sql.Types.";
            int jstypeslen = jstypes.length();
            String typ = "java.sql.Types.BIT";
            javaTypes.put(typ, "Boolean");
            javaResultTypes.put(typ, "boolean");
            typ = "java.sql.Types.DATE";
            javaTypes.put(typ, "Date");
            javaResultTypes.put(typ, "java.sql.Date");
            typ = "java.sql.Types.DOUBLE";
            javaTypes.put(typ, "Double");
            javaResultTypes.put(typ, "double");
            typ = "java.sql.Types.FLOAT";
            javaTypes.put(typ, "Float");
            javaResultTypes.put(typ, "float");
            typ = "java.sql.Types.INTEGER";
            javaTypes.put(typ, "Int");
            javaResultTypes.put(typ, "int");
            typ = "java.sql.Types.BIGINT";
            javaTypes.put(typ, "BigDecimal");
            javaResultTypes.put(typ, "java.math.BigDecimal");
            typ = "java.sql.Types.NUMERIC";
            javaTypes.put(typ, "BigDecimal");
            javaResultTypes.put(typ, "java.math.BigDecimal");
            typ = "java.sql.Types.DECIMAL";
            javaTypes.put(typ, "BigDecimal");
            javaResultTypes.put(typ, "java.math.BigDecimal");
            typ = "java.sql.Types.SMALLINT";
            javaTypes.put(typ, "Int");
            javaResultTypes.put(typ, "int");
            typ = "java.sql.Types.TINYINT";
            javaTypes.put(typ, "Int");
            javaResultTypes.put(typ, "int");
            typ = "java.sql.Types.OTHER";
            javaTypes.put(typ, "Object");
            javaResultTypes.put(typ, "Object");
            typ = "java.sql.Types.VARCHAR";
            javaTypes.put(typ, "String");
            javaResultTypes.put(typ, "String");
            typ = "java.sql.Types.CLOB";
            javaTypes.put(typ, "String");
            javaResultTypes.put(typ, "String");
            typ = "java.sql.Types.TIME";
            javaTypes.put(typ, "Time");
            javaResultTypes.put(typ, "java.sql.Time");
            typ = "java.sql.Types.TIMESTAMP";
            javaTypes.put(typ, "Timestamp");
            javaResultTypes.put(typ, "java.sql.Timestamp");
            HashMap<String, String> tmp = new HashMap<String, String>();
            for (Map.Entry<String, String> me : javaTypes.entrySet()) {
                String k = me.getKey();
                if (!k.startsWith(jstypes)) continue;
                tmp.put(k.substring(jstypeslen), me.getValue());
            }
            javaTypes.putAll(tmp);
            tmp.clear();
            for (Map.Entry<String, String> me : javaResultTypes.entrySet()) {
                if (!me.getKey().startsWith(jstypes)) continue;
                tmp.put(me.getKey().substring(jstypeslen), me.getValue());
            }
            javaResultTypes.putAll(tmp);
            Field[] fields = Types.class.getDeclaredFields();
            types = new HashSet<String>();
            for (int i = 0; i < fields.length; ++i) {
                types.add(fields[i].getName());
            }
        }
    }

    public static boolean isValidJDBCType(String name) {
        return types.contains(name);
    }

    public void generate() throws Exception {
        this.parse();
        this.write();
    }

    private String formatCacheTime() {
        long nowT = System.currentTimeMillis();
        long thenT = nowT - this.cachetime * 1000L;
        Date now = new Date(nowT);
        Date then = new Date(thenT);
        TimeSpan ts = new TimeSpan(now, then);
        return ts.toString();
    }

    private String methodify(String word) {
        StringBuilder sb = new StringBuilder(word.length());
        StringTokenizer st = new StringTokenizer(word, "_");
        while (st.hasMoreTokens()) {
            String part = st.nextToken();
            StringBuilder mntmp = new StringBuilder(part);
            char c = Character.toUpperCase(mntmp.charAt(0));
            mntmp.setCharAt(0, c);
            sb.append(mntmp.toString());
        }
        return sb.toString();
    }

    private String createSetMethod(Parameter p) throws Exception {
        String rv = null;
        String[] atypes = null;
        try {
            ResourceBundle typeMap = ResourceBundle.getBundle("net.spy.db.typemap");
            String typeString = typeMap.getString(p.getType());
            atypes = SpyUtil.split(" ", typeString);
        }
        catch (MissingResourceException e) {
            this.getLogger().warn((Object)("Can't set all types for " + p), e);
            String[] typesTmp = new String[]{"java.lang.Object"};
            atypes = typesTmp;
        }
        String methodName = this.methodify(p.getName());
        rv = "";
        for (int i = 0; i < atypes.length; ++i) {
            String type = atypes[i];
            this.getLogger().debug("Generating " + p + " for " + type);
            rv = rv + "\t/**\n\t * Set the ``" + p.getName() + "'' parameter.\n" + "\t * " + p.getDescription() + "\n" + "\t *\n" + "\t * @param to the value to which to set the parameter\n" + "\t */\n" + "\tpublic void set" + methodName + "(" + type + " to)\n" + "\t\tthrows SQLException";
            rv = this.isInterface ? rv + ";\n" : rv + " {\n\n\t\tsetArg(\"" + p.getName() + "\", to, " + p.getType() + ");\n\t}\n";
        }
        return rv;
    }

    private void write() throws Exception {
        Default d;
        if (this.verbose) {
            System.out.println("Writing out " + this.pkg + "." + this.classname);
        }
        this.out.println("// Copyright (c) 2001  SPY internetworking <dustin@spy.net>\n// Written by Dustin's SQL generator\n//\n// $Id$\n");
        this.out.flush();
        this.out.println("package " + this.pkg + ";\n");
        this.imports.add("java.sql.SQLException");
        if (!this.isInterface) {
            this.imports.add("java.sql.Connection");
            this.imports.add("java.util.Map");
            this.imports.add("java.util.HashMap");
            this.imports.add("net.spy.util.SpyConfig");
        }
        if (this.wantsResultSet && this.results.size() > 0) {
            this.imports.add("java.sql.ResultSet");
        }
        for (String tmpimp : this.imports) {
            this.out.print("import ");
            this.out.print(tmpimp);
            this.out.println(";");
        }
        this.out.println("\n");
        this.out.println("/**\n * \n * " + this.description + "\n" + " *\n" + " * <p>\n" + " *\n" + " * Generated by SPGen on " + new Date() + ".\n" + " *\n" + " * </p>\n" + " * <p>\n" + " *");
        if (this.wantsCursor) {
            this.out.println(" * <b>This query requests a cursor.</b>\n *\n * </p>\n *\n * <p>\n *");
        }
        if (this.typeDbsp) {
            this.out.println(" * <b>Procedure Name</b>\n *\n * <ul>\n *  <li>" + this.procname + "</li>\n" + " * </ul>");
        } else if (this.typeDbcp) {
            this.out.println(" * <b>Callable Name</b>\n *\n * <ul>\n *  <li>" + this.procname + "</li>\n" + " * </ul>");
        } else if (!this.isInterface) {
            this.out.println(" * <b>SQL Query</b>\n *\n * <ul>\n " + this.getDocQuery() + "\n" + " * </ul>");
        }
        this.out.println(" *\n * <b>Required Parameters</b>\n * <ul>");
        if (this.getRequiredArgs(false).size() == 0) {
            this.out.println(" *  <li><i>none</i></li>");
        } else {
            for (Parameter p : this.getRequiredArgs(false)) {
                this.out.print(" * <li>" + p.getName() + " - " + "{@link java.sql.Types#" + p.getShortType() + " " + p.getType() + "}\n * " + " - " + p.getDescription());
                d = p.getDefaultValue();
                if (d != null) {
                    this.out.print(" (default:  <i>" + d.getPrintValue() + "</i>)");
                }
                this.out.println("</li>");
            }
        }
        this.out.println(" * </ul>\n *\n * </p>\n * <p>\n *");
        this.out.println(" *\n * <b>Optional Parameters</b>\n * <ul>");
        if (this.getOptionalArgs().size() == 0) {
            this.out.println(" *  <li><i>none</i></li>");
        } else {
            for (Parameter p : this.getOptionalArgs()) {
                this.out.println(" * <li>" + p.getName() + " - " + "{@link java.sql.Types#" + p.getShortType() + " " + p.getType() + "}\n * " + " - " + p.getDescription() + "</li>");
            }
        }
        this.out.println(" * </ul>\n *\n * </p>\n * <p>\n *");
        if (this.typeDbcp) {
            this.out.println(" *\n * <b>Output Parameters</b>\n * <ul>");
            if (this.getOutputParameters().size() == 0) {
                this.out.println(" *  <li><i>none</i></li>");
            } else {
                for (Parameter p : this.getOutputParameters()) {
                    this.out.println(" * <li>" + p.getName() + " - " + "{@link java.sql.Types#" + p.getShortType() + " " + p.getType() + "}\n * " + " - " + p.getDescription() + "</li>");
                }
            }
            this.out.println(" * </ul>\n *\n * </p>\n * <p>\n *");
        }
        if (this.results.size() > 0) {
            this.out.println(" * <b>Results</b>\n * <ul>");
            for (Result r : this.results) {
                this.out.print(" *  <li>" + r.getName() + " - ");
                if (SPGen.isValidJDBCType(r.getType())) {
                    this.out.print("{@link java.sql.Types#" + r.getShortType() + " " + r.getType() + "}\n *   ");
                } else {
                    this.out.print(r.getType());
                }
                this.out.println(" - " + r.getDescription() + "</li>");
            }
            this.out.println(" * </ul>\n *");
        }
        this.out.println(" * <b>Cache Time</b>\n * <ul>");
        if (this.cachetime > 0L) {
            NumberFormat nf = NumberFormat.getNumberInstance();
            this.out.println(" *  <li>The results of this call will be cached for " + this.formatCacheTime() + " (" + nf.format(this.cachetime) + " seconds) by default.</li>");
        } else {
            this.out.println(" *  <li>The results of this call will not be cached by default.</li>");
        }
        this.out.println(" * </ul>");
        this.out.println(" * </p>\n */");
        this.out.print("public " + (this.isInterface ? "interface " : "class ") + this.classname + " extends " + (this.isInterface ? this.superinterface : this.superclass));
        if (this.interfaces.size() > 0) {
            if (this.isInterface) {
                this.out.print(", ");
            } else {
                this.out.print("\n\timplements ");
            }
            this.out.print(SpyUtil.join(this.interfaces, ", "));
        }
        this.out.println(" {\n");
        if (!this.isInterface) {
            if (!this.typeDbsp && !this.typeDbcp) {
                this.out.println("\tprivate static final Map<String, String> queries=getQueries();\n");
            }
            this.out.println("\t/**\n\t * Construct a DBSP which will get its connections from\n\t *   SpyDB using the given config.\n\t * @param conf the configuration to use\n\t * @exception SQLException if there's a failure to construct\n\t */");
            this.out.println("\tpublic " + this.classname + "(SpyConfig conf) " + "throws SQLException {\n" + "\t\t// Super constructor\n" + "\t\tsuper(conf);\n" + "\t\tspinit();\n" + "\t}\n");
            this.out.println("\t/**\n\t * Construct a DBSP which use the existing Connection\n\t *   for database operations.\n\t * @param conn the connection to use\n\t * @exception SQLException if there's a failure to construct\n\t */");
            this.out.println("\tpublic " + this.classname + "(Connection conn) " + "throws SQLException {\n" + "\t\t// Super constructor\n" + "\t\tsuper(conn);\n" + "\t\tspinit();\n" + "\t}\n");
            this.out.println("\tprivate void spinit() throws SQLException {");
            if (this.wantsCursor) {
                this.out.println("\t\t// Generate a cursor for this query\n\t\tgenerateCursorName();\n");
            }
            this.out.println("\t\tsetQueryTimeout(" + this.timeout + ");\n");
            if (this.typeDbsp || this.typeDbcp) {
                this.out.println("\t\t// Set the stored procedure name\n\t\tsetSPName(\"" + this.procname + "\");");
            } else {
                this.out.println("\t\t// Register the SQL queries");
                this.out.println("\t\tsetRegisteredQueryMap(queries);");
            }
            if (this.args.size() > 0) {
                this.out.println("\n\t\t// Set the parameters.");
                for (Parameter p : this.args) {
                    if (p.isRequired()) {
                        if (p.isOutput()) {
                            this.out.println("\t\tsetOutput(\"" + p.getName() + "\", " + p.getType() + ");");
                        } else {
                            this.out.println("\t\tsetRequired(\"" + p.getName() + "\", " + p.getType() + ");");
                        }
                    } else {
                        this.out.println("\t\tsetOptional(\"" + p.getName() + "\", " + p.getType() + ");");
                    }
                    if ((d = p.getDefaultValue()) == null) continue;
                    this.out.println("\t\t// Default for " + d.getName());
                    this.out.println("\t\tset(\"" + d.getName() + "\", " + d.getPrintValue() + ");");
                }
            }
            if (this.cachetime > 0L) {
                this.out.println("\n\t\t// Set the default cache time.");
                this.out.println("\t\tsetCacheTime(" + this.cachetime + ");");
            }
            this.out.println("\t}\n");
            if (!this.typeDbsp && !this.typeDbcp) {
                this.out.println("\t// Static initializer for query map.");
                this.out.println("\tprivate static Map<String, String> getQueries() {");
                this.out.println("\t\t" + this.getJavaQueries());
                this.out.println("\n\t\treturn(rv);");
                this.out.println("\t}\n");
            }
        }
        int count = 1;
        for (Parameter p : this.args) {
            if (p.isOutput()) {
                this.out.println(this.createGetOutputMethod(p, count));
            } else {
                this.out.println(this.createSetMethod(p));
            }
            ++count;
        }
        if (this.wantsResultSet && this.results.size() > 0) {
            this.out.println(this.createExecuteMethods());
            this.out.println(this.createResultClass());
        }
        this.out.println("}");
    }

    private String createExecuteMethods() {
        String rv = "\t/**\n\t * Execute this query and get a Result object.\n\t */\n\tpublic Result getResult() throws SQLException {\n\t\treturn(new Result(executeQuery()));\n\t}\n";
        return rv;
    }

    private String createGetMethod(Result r) {
        String rv = "\t\t/**\n\t\t * Get the " + r.getName() + " value.\n" + "\t\t */\n" + "\t\tpublic " + r.getJavaResultType() + " get" + this.methodify(r.getName()) + "() throws SQLException {\n" + "\t\t\treturn(get" + r.getJavaType() + "(\"" + r.getName() + "\"));\n" + "\t\t}\n\n";
        return rv;
    }

    private String createGetOutputMethod(Parameter p, int index) {
        String rv = "\tpublic Object get" + this.methodify(p.getName()) + "() throws SQLException {\n" + "\t\treturn(getCallableStatement().getObject(" + index + "));\n" + "\t}\n\n";
        return rv;
    }

    private String createResultClass() {
        String rv = "";
        rv = rv + "\t/**\n\t * ResultSet object representing the results of this query.\n\t */\n\tpublic class Result extends net.spy.db.DBSPResult {\n\n\t\tprivate Result(ResultSet rs) {\n\t\t\tsuper(rs);\n\t\t}\n\n";
        for (Result r : this.results) {
            rv = rv + this.createGetMethod(r);
        }
        rv = rv + "\n\t}\n";
        return rv;
    }

    private String docifySQL(String sql) {
        StringBuilder sb = new StringBuilder(sql.length());
        char[] acters = sql.toCharArray();
        block5: for (int i = 0; i < acters.length; ++i) {
            switch (acters[i]) {
                case '>': {
                    sb.append("&gt;");
                    continue block5;
                }
                case '<': {
                    sb.append("&lt;");
                    continue block5;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block5;
                }
                default: {
                    sb.append(acters[i]);
                }
            }
        }
        return sb.toString();
    }

    private String getDocQuery() {
        StringBuilder sb = new StringBuilder(1024);
        for (Map.Entry<String, List<String>> me : this.queries.entrySet()) {
            List<String> sqlquery = me.getValue();
            sb.append(" * <li>\n");
            sb.append(" *  <b>\n");
            sb.append(" *   ");
            sb.append(me.getKey());
            sb.append("\n");
            sb.append(" *  </b>\n");
            sb.append(" *  <pre>\n");
            for (String part : sqlquery) {
                sb.append(" * ");
                sb.append(this.docifySQL(part));
                sb.append("\n");
            }
            sb.append(" *  </pre>\n * </li>\n");
        }
        return sb.toString().trim();
    }

    private String getJavaQueries() {
        StringBuilder sb = new StringBuilder(1024);
        sb.append("StringBuilder query=null;\n");
        sb.append("\t\tMap<String, String> rv=new HashMap<String, String>();\n");
        for (Map.Entry<String, List<String>> me : this.queries.entrySet()) {
            List<String> sqlquery = me.getValue();
            sb.append("\n\t\tquery=new StringBuilder(1024);");
            for (String part : sqlquery) {
                sb.append("\n\t\tquery.append(\"");
                StringTokenizer st = new StringTokenizer(part, "\"", true);
                while (st.hasMoreTokens()) {
                    String tmp = st.nextToken();
                    if (tmp.equals("\"")) {
                        tmp = "\\\"";
                    }
                    sb.append(tmp);
                }
                sb.append("\\n\");");
            }
            sb.append("\n\t\trv.put(\"");
            sb.append(me.getKey());
            sb.append("\", ");
            sb.append("query.toString());\n");
        }
        return sb.toString().trim();
    }

    private void parse() throws Exception {
        StringBuilder userSuperclass = null;
        if (this.verbose) {
            System.out.println("Parsing " + this.classname + ".spt");
        }
        String tmp = this.in.readLine();
        while (tmp != null) {
            if (tmp.length() > 0) {
                if (tmp.charAt(0) == '@') {
                    this.section = tmp.substring(1).trim().toLowerCase();
                    if (this.section.equals("genresults")) {
                        this.wantsResultSet = true;
                    } else if (this.section.equals("cursor")) {
                        this.wantsCursor = true;
                    } else if (this.section.startsWith("loosetyp")) {
                        this.looseTypes = true;
                    } else if (this.section.startsWith("sql.")) {
                        this.currentQuery = this.section.substring(4);
                        this.section = "sql";
                    } else if (this.section.equals("sql")) {
                        this.currentQuery = "-default-";
                    }
                } else if (tmp.charAt(0) != '#') {
                    if (this.section.equals("description")) {
                        this.description = this.description + tmp;
                    } else if (this.section.equals("sql")) {
                        List<String> sqlquery;
                        this.isInterface = false;
                        if (this.superclass == null) {
                            this.superclass = "net.spy.db.DBSQL";
                        }
                        if ((sqlquery = this.queries.get(this.currentQuery)) == null) {
                            sqlquery = new ArrayList<String>();
                            this.queries.put(this.currentQuery, sqlquery);
                        }
                        sqlquery.add(tmp);
                    } else if (this.section.equals("procname")) {
                        this.isInterface = false;
                        this.procname = this.procname + tmp;
                        this.superclass = this.dbspSuperclass == null ? "net.spy.db.DBSP" : this.dbspSuperclass;
                        this.typeDbsp = true;
                    } else if (this.section.equals("callable")) {
                        this.isInterface = false;
                        this.procname = this.procname + tmp;
                        this.superclass = this.dbcpSuperclass == null ? "net.spy.db.DBCP" : this.dbcpSuperclass;
                        this.typeDbcp = true;
                    } else if (this.section.equals("defaults")) {
                        Default d = new Default(tmp);
                        this.registerDefault(d);
                    } else if (this.section.equals("params")) {
                        Parameter param = new Parameter(tmp);
                        this.args.add(param);
                    } else if (this.section.equals("results")) {
                        try {
                            this.results.add(new Result(tmp));
                        }
                        catch (IllegalArgumentException e) {
                            System.err.println("Warning in " + this.classname + ":  " + e.getMessage());
                        }
                    } else if (this.section.equals("package")) {
                        this.pkg = this.pkg + tmp;
                    } else if (this.section.equals("cachetime")) {
                        this.cachetime = Long.parseLong(tmp);
                    } else if (this.section.equals("timeout")) {
                        this.timeout = Integer.parseInt(tmp);
                    } else if (this.section.equals("superclass")) {
                        userSuperclass = new StringBuilder(96);
                        userSuperclass.append(tmp);
                    } else if (this.section.equals("import")) {
                        this.imports.add(tmp);
                    } else if (this.section.equals("implements")) {
                        this.interfaces.add(tmp);
                    } else {
                        throw new Exception("Unknown section: ``" + this.section + "''");
                    }
                }
            }
            tmp = this.in.readLine();
        }
        if (this.superinterface == null) {
            this.superinterface = "net.spy.db.DBSPLike";
        }
        if (userSuperclass != null) {
            if (this.isInterface) {
                this.superinterface = userSuperclass.toString();
            } else {
                this.superclass = userSuperclass.toString();
            }
        }
    }

    private void registerDefault(Default d) {
        boolean done = false;
        for (Parameter p : this.args) {
            if (!p.getName().equals(d.getName())) continue;
            p.setDefaultValue(d);
            done = true;
            break;
        }
        if (!done) {
            throw new IllegalArgumentException("Didn't find parameter " + d.getName() + " when registering");
        }
    }

    private Collection<Parameter> getRequiredArgs(boolean evenOutput) {
        ArrayList<Parameter> rv = new ArrayList<Parameter>(this.args.size());
        for (Parameter p : this.args) {
            if (!p.isRequired()) continue;
            if (p.isOutput()) {
                if (!evenOutput) continue;
                rv.add(p);
                continue;
            }
            rv.add(p);
        }
        return rv;
    }

    private Collection<Parameter> getOptionalArgs() {
        ArrayList<Parameter> rv = new ArrayList<Parameter>(this.args.size());
        for (Parameter p : this.args) {
            if (p.isRequired()) continue;
            rv.add(p);
        }
        return rv;
    }

    private Collection<Parameter> getOutputParameters() {
        ArrayList<Parameter> rv = new ArrayList<Parameter>(this.args.size());
        for (Parameter p : this.args) {
            if (!p.isOutput()) continue;
            rv.add(p);
        }
        return rv;
    }

    public static void main(String[] argv) throws Exception {
        String infile = argv[0];
        int lastslash = infile.lastIndexOf(File.separatorChar);
        String basename = infile.substring(0, infile.indexOf(".spt"));
        String cname = basename.substring(lastslash + 1);
        String outfile = basename + ".java";
        BufferedReader ireader = new BufferedReader(new FileReader(infile));
        PrintWriter owriter = new PrintWriter(new FileWriter(outfile));
        SPGen spg = new SPGen(cname, ireader, owriter);
        spg.generate();
        CloseUtil.close(ireader);
        CloseUtil.close(owriter);
    }

    class Default {
        private String name = null;
        private String type = null;
        private Object value = null;

        public Default(String line) {
            StringTokenizer st = new StringTokenizer(line, " \t");
            try {
                this.name = st.nextToken();
            }
            catch (NoSuchElementException ex) {
                throw new IllegalArgumentException("Missing parameter name! " + ex.toString());
            }
            this.type = this.findType();
            String rest = st.nextToken("\n");
            this.parse(rest);
        }

        public String getName() {
            return this.name;
        }

        public String getPrintValue() {
            String rv = null;
            boolean needsCast = false;
            if (this.value == null) {
                needsCast = true;
            }
            rv = needsCast ? "(" + javaResultTypes.get(this.type) + ")" + this.value : this.value.toString();
            return rv;
        }

        private void parse(String input) {
            if (input == null) {
                throw new NullPointerException("Can't parse a null string");
            }
            if ((input = input.trim()).length() == 0) {
                throw new IllegalArgumentException("Can't parse nothin'");
            }
            if (input.equals("NULL")) {
                this.value = null;
            } else if (this.type.equals("java.sql.Types.INTEGER")) {
                this.value = new Integer(input);
            } else if (this.type.equals("java.sql.Types.SMALLINT")) {
                this.value = new Short(input);
            } else if (this.type.equals("java.sql.Types.TINYINT")) {
                this.value = new Short(input);
            } else if (this.type.equals("java.sql.Types.BIGINT")) {
                this.value = new BigDecimal(input);
            } else if (this.type.equals("java.sql.Types.Decimal")) {
                this.value = new BigDecimal(input);
            } else if (this.type.equals("java.sql.Types.BIT")) {
                this.value = SpyUtil.getBoolean(input);
            } else if (this.type.equals("java.sql.Types.DOUBLE")) {
                this.value = new Double(input);
            } else if (this.type.equals("java.sql.Types.FLOAT")) {
                this.value = new Float(input);
            } else if (this.type.equals("java.sql.Types.VARCHAR")) {
                this.value = input;
            } else {
                throw new IllegalArgumentException("I don't know how to parse a default for " + this.type);
            }
        }

        private String findType() {
            String rv = null;
            for (Parameter p : SPGen.this.args) {
                if (!p.getName().equals(this.name)) continue;
                rv = p.getType();
                break;
            }
            if (rv == null) {
                throw new IllegalArgumentException("No parameter for this default:  " + this.name);
            }
            return rv;
        }

        public String toString() {
            String rv = "{Default " + this.name + " (" + this.type + ") " + this.value + "}";
            return rv;
        }
    }

    class Parameter {
        private String name = null;
        private boolean required = false;
        private String type = null;
        private String paramDescr = null;
        private boolean output = false;
        private Default defaultValue = null;

        public Parameter(String line) {
            StringTokenizer st = new StringTokenizer(line, " \t");
            try {
                this.name = st.nextToken();
            }
            catch (NoSuchElementException ex) {
                throw new IllegalArgumentException("Missing parameter name! " + ex.toString());
            }
            String tmp = null;
            try {
                tmp = st.nextToken();
            }
            catch (NoSuchElementException ex) {
                throw new IllegalArgumentException("Missing parameter requirement! " + ex.toString());
            }
            if (tmp.equals("required")) {
                this.required = true;
                this.output = false;
            } else if (tmp.equals("optional")) {
                this.required = false;
                this.output = false;
            } else if (tmp.equals("output")) {
                this.required = true;
                this.output = true;
            } else {
                throw new IllegalArgumentException("Parameter must be required or optional, not " + tmp + " like in " + line);
            }
            try {
                this.type = st.nextToken();
                if (SPGen.isValidJDBCType(this.type)) {
                    this.type = "java.sql.Types." + this.getParamTypeAlias(this.type);
                } else if (!SPGen.this.looseTypes) {
                    throw new IllegalArgumentException("Invalid JDBC type: " + this.type);
                }
            }
            catch (NoSuchElementException ex) {
                throw new IllegalArgumentException("Missing parameter type! " + ex.toString());
            }
            try {
                this.paramDescr = st.nextToken("\n");
            }
            catch (NoSuchElementException ex) {
                this.paramDescr = "";
            }
        }

        private String getParamTypeAlias(String pt) {
            String rv = pt;
            if (pt.equals("NUMERIC")) {
                rv = "DECIMAL";
            }
            return rv;
        }

        public String toString() {
            return "{Parameter " + this.name + "}";
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object o) {
            boolean rv = false;
            if (o instanceof Parameter) {
                Parameter p = (Parameter)o;
                rv = this.name.equals(p.name);
            }
            return rv;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public String getShortType() {
            String rv = this.type;
            int i = this.type.lastIndexOf(46);
            if (i > 0) {
                rv = this.type.substring(i + 1);
            }
            return rv;
        }

        public String getDescription() {
            return this.paramDescr;
        }

        public boolean isRequired() {
            return this.required;
        }

        public boolean isOutput() {
            return this.output;
        }

        public Default getDefaultValue() {
            return this.defaultValue;
        }

        public void setDefaultValue(Default d) {
            this.defaultValue = d;
        }
    }

    static class Result {
        private String name = null;
        private String type = null;
        private String description = null;

        public Result(String line) {
            StringTokenizer st = new StringTokenizer(line, " \t");
            try {
                this.name = st.nextToken();
            }
            catch (NoSuchElementException e) {
                throw new IllegalArgumentException("No name given for result");
            }
            try {
                this.type = st.nextToken();
                if (!SPGen.isValidJDBCType(this.type)) {
                    throw new IllegalArgumentException("Invalid JDBC type: " + this.type);
                }
            }
            catch (NoSuchElementException e) {
                throw new IllegalArgumentException("No type given for result ``" + this.name + "''");
            }
            try {
                this.description = st.nextToken("\n");
            }
            catch (NoSuchElementException e) {
                throw new IllegalArgumentException("No description given for result ``" + this.name + "''");
            }
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public String getShortType() {
            String rv = this.type;
            int i = this.type.lastIndexOf(46);
            if (i > 0) {
                rv = this.type.substring(i + 1);
            }
            return rv;
        }

        public String getJavaType() {
            String rv = javaTypes.get(this.type);
            if (rv == null) {
                throw new RuntimeException("Whoops!  " + this.type + " must have been overlooked");
            }
            return rv;
        }

        public String getJavaResultType() {
            String rv = javaResultTypes.get(this.type);
            if (rv == null) {
                throw new RuntimeException("Whoops!  " + this.type + " must have been overlooked");
            }
            return rv;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

