/*
 * Decompiled with CFR 0.152.
 */
package net.spy.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.spy.util.SPNode;
import net.spy.util.SPVertex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShortestPathFinder {
    public void calculatePaths(Collection<? extends SPNode<?>> nodes) {
        for (SPNode<?> node : nodes) {
            this.calculatePaths(node);
        }
    }

    public void calculatePaths(SPNode<?> node) {
        node.clearNextHops();
        for (SPVertex sPVertex : node.getConnections()) {
            this.recordLink(node, sPVertex.getCost(), (SPNode<?>)sPVertex.getTo(), (SPNode<?>)sPVertex.getTo(), new HashSet());
        }
    }

    private void addHopFrom(SPNode node, SPNode dest, SPNode next, int cost) {
        SPVertex currentHop = node.getNextHop(dest);
        if (currentHop == null) {
            node.addNextHop(dest, new SPVertex<SPNode>(next, cost));
        } else if (cost < currentHop.getCost()) {
            node.addNextHop(dest, new SPVertex<SPNode>(next, cost));
        }
    }

    private void recordLink(SPNode<?> node, int cost, SPNode<?> nextHop, SPNode<?> other, Set<SPNode<?>> s) {
        if (!s.contains(other)) {
            s.add(other);
            this.addHopFrom(node, other, nextHop, cost);
            for (SPVertex sPVertex : other.getConnections()) {
                int nextCost = cost + sPVertex.getCost();
                Object thisNode = sPVertex.getTo();
                this.recordLink(node, nextCost, nextHop, (SPNode<?>)thisNode, s);
            }
        }
    }
}

