/*
 * Decompiled with CFR 0.152.
 */
package net.spy.util;

import java.util.Date;

public class TimeSpan {
    private long days = 0L;
    private long hours = 0L;
    private long minutes = 0L;
    private long seconds = 0L;
    private long mseconds = 0L;

    public TimeSpan(Date from, Date to) {
        long diff = Math.abs(to.getTime() - from.getTime());
        if (diff > 86400000L) {
            this.days = diff / 86400000L;
            diff %= 86400000L;
        }
        if (diff > 3600000L) {
            this.hours = diff / 3600000L;
            diff %= 3600000L;
        }
        if (diff > 60000L) {
            this.minutes = diff / 60000L;
            diff %= 60000L;
        }
        if (diff > 1000L) {
            this.seconds = diff / 1000L;
            diff %= 1000L;
        }
        this.mseconds = diff;
    }

    private String zeroNumber(long in) {
        return (in < 10L ? "0" : "") + in;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        boolean hasDays = false;
        if (this.days > 0L) {
            hasDays = true;
            sb.append(this.days);
            sb.append(this.days > 1L ? " days" : " day");
        }
        if (this.hours > 0L || this.minutes > 0L || this.seconds > 0L || this.mseconds > 0L) {
            if (hasDays) {
                sb.append(" ");
            }
            sb.append(this.zeroNumber(this.hours));
            sb.append(":");
            sb.append(this.zeroNumber(this.minutes));
            sb.append(":");
            sb.append(this.zeroNumber(this.seconds));
            sb.append(".");
            sb.append(this.mseconds);
        }
        return sb.toString();
    }
}

