/*
 * Decompiled with CFR 0.152.
 */
package er.rest.entityDelegates;

import com.webobjects.eoaccess.EOAttribute;
import com.webobjects.eoaccess.EOEntity;
import com.webobjects.eoaccess.EORelationship;
import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.eocontrol.EOEnterpriseObject;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableSet;
import er.extensions.eof.ERXKey;
import er.extensions.eof.ERXKeyFilter;
import er.extensions.localization.ERXLocalizer;
import er.rest.ERXRestException;
import er.rest.entityDelegates.ERXDenyRestEntityDelegate;
import er.rest.entityDelegates.ERXRestContext;
import er.rest.entityDelegates.ERXRestEntityDelegateUtils;
import er.rest.entityDelegates.ERXRestKey;
import er.rest.entityDelegates.ERXRestNotFoundException;
import er.rest.entityDelegates.ERXRestSecurityException;
import er.rest.entityDelegates.ERXUnsafeRestEntityDelegate;
import er.rest.entityDelegates.IERXRestEntityDelegate;
import er.rest.entityDelegates.IERXRestResponseWriter;
import er.rest.format.IERXRestResponse;
import java.text.ParseException;
import java.util.Enumeration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ERXAbstractRestResponseWriter
implements IERXRestResponseWriter {
    private ERXKeyFilter _filter;
    private boolean _displayAllProperties;
    private boolean _displayAllToMany;

    public ERXAbstractRestResponseWriter() {
        this(false, false);
    }

    public ERXAbstractRestResponseWriter(boolean displayAllProperties, boolean displayAllToMany) {
        this._displayAllProperties = displayAllProperties;
        this._displayAllToMany = displayAllToMany;
    }

    public ERXAbstractRestResponseWriter(ERXKeyFilter filter) {
        this._filter = filter;
    }

    protected boolean displayDetails(ERXRestContext context, ERXRestKey key) throws ERXRestException, ERXRestNotFoundException, ERXRestSecurityException {
        boolean displayDetails;
        if (this._filter == null) {
            String entityName = key.entity().name();
            EOEntity entity = ERXRestEntityDelegateUtils.requiredEntityNamed(context, entityName);
            displayDetails = context.delegate().entityDelegate(entity).displayDetails(key, context);
        } else {
            ERXKeyFilter filter = this._filter;
            for (ERXRestKey pathKey = key.firstKey(); pathKey != null && pathKey != key; pathKey = pathKey.nextKey()) {
                if (pathKey.isKeyGID()) continue;
                filter = filter._filterForKey(new ERXKey(pathKey.key()));
            }
            displayDetails = filter.base() != ERXKeyFilter.Base.None || filter.includes().count() > 0;
        }
        return displayDetails;
    }

    protected String[] displayProperties(ERXRestContext context, ERXRestKey key) throws ERXRestException, ERXRestNotFoundException, ERXRestSecurityException {
        String[] displayProperties;
        if (this._filter == null) {
            String entityName = key.entity().name();
            EOEntity entity = ERXRestEntityDelegateUtils.requiredEntityNamed(context, entityName);
            displayProperties = context.delegate().entityDelegate(entity).displayProperties(key, this._displayAllProperties, this._displayAllToMany, context);
        } else {
            ERXKeyFilter filter = this._filter;
            for (ERXRestKey pathKey = key.firstKey(); pathKey != null && pathKey != key; pathKey = pathKey.nextKey()) {
                if (pathKey.isKeyGID()) continue;
                filter = filter._filterForKey(new ERXKey(pathKey.key()));
            }
            NSMutableSet displayPropertySet = new NSMutableSet();
            EOEntity entity = key.nextEntity();
            Enumeration attributesEnum = entity.attributes().objectEnumerator();
            while (attributesEnum.hasMoreElements()) {
                EOAttribute attribute = (EOAttribute)attributesEnum.nextElement();
                if (!entity.classProperties().containsObject((Object)attribute) || !filter.matches(new ERXKey(attribute.name()), ERXKey.Type.Attribute)) continue;
                displayPropertySet.addObject((Object)attribute.name());
            }
            Enumeration relationshipsEnum = entity.relationships().objectEnumerator();
            while (relationshipsEnum.hasMoreElements()) {
                EORelationship relationship = (EORelationship)relationshipsEnum.nextElement();
                if (!entity.classProperties().containsObject((Object)relationship) || !filter.matches(new ERXKey(relationship.name()), relationship.isToMany() ? ERXKey.Type.ToManyRelationship : ERXKey.Type.ToOneRelationship)) continue;
                displayPropertySet.addObject((Object)relationship.name());
            }
            for (ERXKey includeKey : filter.includes().allKeys()) {
                displayPropertySet.addObject((Object)includeKey.key());
            }
            displayProperties = (String[])displayPropertySet.toArray((Object[])new String[displayPropertySet.count()]);
        }
        return displayProperties;
    }

    @Override
    public void appendToResponse(ERXRestContext context, IERXRestResponse response, ERXRestKey result) throws ERXRestException, ERXRestSecurityException, ERXRestNotFoundException, ParseException {
        this.appendToResponse(context, response, result.trimPrevious(), 0, (NSMutableSet<Object>)new NSMutableSet());
    }

    protected void appendDictionaryToResponse(ERXRestContext context, IERXRestResponse response, ERXRestKey result, int indent, NSMutableSet<Object> visitedObjects) throws ERXRestException, ERXRestSecurityException, ERXRestNotFoundException, ParseException {
        EOEntity entity = result.nextEntity();
        IERXRestEntityDelegate entityDelegate = context.delegate().entityDelegate(entity);
        if (!(entityDelegate instanceof ERXDenyRestEntityDelegate)) {
            String entityAlias = entityDelegate.entityAliasForEntityNamed(entity.name());
            String arrayName = result.keyAlias() == null ? entityAlias : result.keyAlias();
            if (arrayName.equals(entityAlias)) {
                arrayName = ERXLocalizer.currentLocalizer().plurifiedString(arrayName, 2);
            }
            NSDictionary values = (NSDictionary)result.value();
            NSMutableArray valueKeys = new NSMutableArray();
            Enumeration valuesEnum = values.objectEnumerator();
            while (valuesEnum.hasMoreElements()) {
                EOEnterpriseObject eo = (EOEnterpriseObject)valuesEnum.nextElement();
                ERXRestKey eoKey = result.extend(entityDelegate.stringIDForEO(entity, eo), eo);
                valueKeys.addObject((Object)eoKey);
            }
            this.appendArrayToResponse(context, response, result, arrayName, entityAlias, (NSArray)valueKeys, indent, visitedObjects);
        }
    }

    protected void appendArrayToResponse(ERXRestContext context, IERXRestResponse response, ERXRestKey result, int indent, NSMutableSet<Object> visitedObjects) throws ERXRestException, ERXRestSecurityException, ERXRestNotFoundException, ParseException {
        EOEntity entity = result.nextEntity();
        IERXRestEntityDelegate entityDelegate = context.delegate().entityDelegate(entity);
        if (!(entityDelegate instanceof ERXDenyRestEntityDelegate)) {
            String entityAlias = entityDelegate.entityAliasForEntityNamed(entity.name());
            String arrayName = result.keyAlias() == null ? entityAlias : result.keyAlias();
            NSArray values = (NSArray)result.value();
            if (arrayName.equals(entityAlias)) {
                arrayName = ERXLocalizer.currentLocalizer().plurifiedString(arrayName, 2);
            }
            entityDelegate.preprocess(entity, values, context);
            NSMutableArray valueKeys = new NSMutableArray();
            Enumeration valuesEnum = values.objectEnumerator();
            while (valuesEnum.hasMoreElements()) {
                Object value = valuesEnum.nextElement();
                if (value instanceof EOEnterpriseObject) {
                    EOEnterpriseObject eo = (EOEnterpriseObject)value;
                    ERXRestKey eoKey = result.extend(entityDelegate.stringIDForEO(entity, eo), eo);
                    valueKeys.addObject((Object)eoKey);
                    continue;
                }
                ERXRestKey eoKey = result.extend(value.getClass().getSimpleName(), value);
                valueKeys.addObject((Object)eoKey);
            }
            this.appendArrayToResponse(context, response, result, arrayName, entityAlias, (NSArray)valueKeys, indent, visitedObjects);
        }
    }

    protected void appendToResponse(ERXRestContext context, IERXRestResponse response, ERXRestKey result, int indent, NSMutableSet<Object> visitedObjects) throws ERXRestException, ERXRestSecurityException, ERXRestNotFoundException, ParseException {
        Object value = result.value();
        if (value != null) {
            if (value instanceof NSArray) {
                this.appendArrayToResponse(context, response, result, indent, visitedObjects);
            } else if (value instanceof EOEnterpriseObject) {
                String entityName = ((EOEnterpriseObject)value).entityName();
                EOEntity entity = ERXRestEntityDelegateUtils.requiredEntityNamed(context, entityName);
                IERXRestEntityDelegate entityDelegate = context.delegate().entityDelegate(entity);
                String entityAlias = entityDelegate.entityAliasForEntityNamed(entity.name());
                String objectName = result.previousKey() == null || result.isKeyGID() ? entityAlias : result.keyAlias();
                EOEnterpriseObject eo = (EOEnterpriseObject)value;
                Object id = entityDelegate.idForEO(entity, eo);
                boolean alreadyVisited = visitedObjects.containsObject((Object)eo);
                if (alreadyVisited) {
                    this.appendVisitedToResponse(context, response, entity, eo, objectName, entityAlias, id, indent);
                } else {
                    if (!result.isKeyGID()) {
                        result = result.extend(entityDelegate.stringIDForEO(entity, eo), eo);
                    }
                    visitedObjects.addObject((Object)eo);
                    boolean displayDetails = this.displayDetails(context, result);
                    if (!displayDetails) {
                        this.appendNoDetailsToResponse(context, response, entity, eo, objectName, entityAlias, id, indent);
                    } else {
                        NSMutableArray displayKeys = new NSMutableArray();
                        String[] displayPropertyNames = this.displayProperties(context, result);
                        if (displayPropertyNames != null && displayPropertyNames.length > 0) {
                            for (int displayPropertyNum = 0; displayPropertyNum < displayPropertyNames.length; ++displayPropertyNum) {
                                String propertyName = displayPropertyNames[displayPropertyNum];
                                if (!entityDelegate.canViewProperty(entity, eo, propertyName, context)) continue;
                                ERXRestKey nextKey = result.extend(entityDelegate.propertyAliasForPropertyNamed(entity, propertyName));
                                displayKeys.addObject((Object)nextKey);
                            }
                        }
                        if (displayKeys.count() == 0) {
                            this.appendNoDetailsToResponse(context, response, entity, eo, objectName, entityAlias, id, indent);
                        } else {
                            this.appendDetailsToResponse(context, response, entity, eo, objectName, entityAlias, id, (NSArray)displayKeys, indent, visitedObjects);
                        }
                    }
                    visitedObjects.removeObject((Object)eo);
                }
            } else {
                this.appendPrimitiveToResponse(context, response, result, indent, value);
            }
        }
    }

    protected void indent(IERXRestResponse response, int indent) {
        for (int i = 0; i < indent; ++i) {
            response.appendContentString("  ");
        }
    }

    protected abstract void appendArrayToResponse(ERXRestContext var1, IERXRestResponse var2, ERXRestKey var3, String var4, String var5, NSArray var6, int var7, NSMutableSet<Object> var8) throws ERXRestException, ERXRestSecurityException, ERXRestNotFoundException, ParseException;

    protected abstract void appendVisitedToResponse(ERXRestContext var1, IERXRestResponse var2, EOEntity var3, EOEnterpriseObject var4, String var5, String var6, Object var7, int var8);

    protected abstract void appendNoDetailsToResponse(ERXRestContext var1, IERXRestResponse var2, EOEntity var3, EOEnterpriseObject var4, String var5, String var6, Object var7, int var8);

    protected abstract void appendDetailsToResponse(ERXRestContext var1, IERXRestResponse var2, EOEntity var3, EOEnterpriseObject var4, String var5, String var6, Object var7, NSArray var8, int var9, NSMutableSet<Object> var10) throws ERXRestException, ERXRestSecurityException, ERXRestNotFoundException, ParseException;

    protected abstract void appendPrimitiveToResponse(ERXRestContext var1, IERXRestResponse var2, ERXRestKey var3, int var4, Object var5) throws ERXRestException;

    @Override
    public String toString(Object value) throws ERXRestException, ERXRestSecurityException, ERXRestNotFoundException, ParseException {
        return ERXRestEntityDelegateUtils.toString(new ERXRestContext(new ERXUnsafeRestEntityDelegate(true)), this, value);
    }

    @Override
    public String toString(EOEntity entity, NSArray values) throws ERXRestException, ERXRestSecurityException, ERXRestNotFoundException, ParseException {
        return ERXRestEntityDelegateUtils.toString(new ERXRestContext(new ERXUnsafeRestEntityDelegate(true)), this, entity, values);
    }

    @Override
    public String toString(EOEditingContext editingContext, String entityName, NSArray values) throws ERXRestException, ERXRestSecurityException, ERXRestNotFoundException, ParseException {
        return ERXRestEntityDelegateUtils.toString(new ERXRestContext(new ERXUnsafeRestEntityDelegate(true)), this, ERXRestEntityDelegateUtils.requiredEntityNamed(editingContext, entityName), values);
    }
}

