/*
 * Decompiled with CFR 0.152.
 */
package er.rest.entityDelegates;

import com.webobjects.eoaccess.EOEntity;
import com.webobjects.eoaccess.EORelationship;
import com.webobjects.eocontrol.EOEnterpriseObject;
import com.webobjects.foundation.NSArray;
import er.extensions.foundation.ERXStringUtilities;
import er.extensions.localization.ERXLocalizer;
import er.rest.ERXRestException;
import er.rest.ERXRestRequestNode;
import er.rest.entityDelegates.ERXRestContext;
import er.rest.entityDelegates.ERXRestEntityDelegateUtils;
import er.rest.entityDelegates.ERXRestNotFoundException;
import er.rest.entityDelegates.ERXRestSecurityException;
import er.rest.entityDelegates.IERXRestEntityDelegate;

public class ERXRestKey {
    private ERXRestContext _context;
    private ERXRestKey _previousKey;
    private EOEntity _entity;
    private String _keyAlias;
    private String _key;
    private Object _value;
    private boolean _valueFetched;
    private EOEntity _nextEntity;
    private ERXRestKey _nextKey;

    protected ERXRestKey() {
    }

    public ERXRestKey(ERXRestContext context, EOEntity entity, String keyAlias) throws ERXRestException {
        if (entity == null) {
            throw new ERXRestException("Unable to evaluate the key '" + this._key + "' without an entity.");
        }
        this._context = context;
        this._entity = entity;
        this._keyAlias = keyAlias;
        this._key = context.delegate().entityDelegate(entity).propertyNameForPropertyAlias(entity, keyAlias);
    }

    public ERXRestKey(ERXRestContext context, EOEntity entity, String keyAlias, Object value) throws ERXRestException {
        this(context, entity, keyAlias);
        this._value = value;
        this._valueFetched = true;
    }

    public ERXRestKey trimPrevious() throws ERXRestException, ERXRestSecurityException, ERXRestNotFoundException {
        Object value = this._value(false);
        ERXRestKey trimmedKey = this.cloneKey(false, false);
        trimmedKey._entity = this.nextEntity();
        if (value instanceof EOEnterpriseObject) {
            IERXRestEntityDelegate entityDelegate = this._context.delegate().entityDelegate(trimmedKey._entity);
            trimmedKey._key = entityDelegate.stringIDForEO(trimmedKey._entity, (EOEnterpriseObject)value);
        } else {
            trimmedKey._key = null;
        }
        return trimmedKey;
    }

    protected ERXRestKey cloneKeyWithNewEntity(EOEntity entity, boolean clonePrevious, boolean cloneNext) throws ERXRestException {
        ERXRestKey clonedKey = this.cloneKey(clonePrevious, cloneNext);
        clonedKey._entity = entity;
        return clonedKey;
    }

    protected ERXRestKey cloneKey(boolean clonePrevious, boolean cloneNext) throws ERXRestException {
        ERXRestKey cloneKey = new ERXRestKey();
        cloneKey._context = this._context;
        cloneKey._entity = this._entity;
        cloneKey._key = this._key;
        cloneKey._value = this._value;
        cloneKey._valueFetched = this._valueFetched;
        if (this._previousKey != null && clonePrevious) {
            cloneKey._previousKey = this._previousKey.cloneKey(true, false);
            cloneKey._previousKey._nextKey = cloneKey;
        }
        if (cloneNext) {
            if (this._nextKey != null) {
                cloneKey._nextKey = this._nextKey.cloneKey(false, true);
                cloneKey._nextKey._previousKey = cloneKey;
            }
            cloneKey._nextEntity = this._nextEntity;
        }
        return cloneKey;
    }

    public ERXRestContext context() {
        return this._context;
    }

    public ERXRestKey extend(String key, Object value) throws ERXRestException {
        ERXRestKey nextKey = new ERXRestKey(this._context, this.nextEntity(), key, value);
        this._extend(nextKey, true);
        return nextKey;
    }

    public ERXRestKey extend(String key) throws ERXRestException {
        ERXRestKey nextKey = new ERXRestKey(this._context, this.nextEntity(), key);
        this._extend(nextKey, true);
        return nextKey;
    }

    protected ERXRestKey _extendWithoutClone(String key) throws ERXRestException {
        ERXRestKey nextKey = new ERXRestKey(this._context, this.nextEntity(), key);
        this._extend(nextKey, false);
        return nextKey;
    }

    protected void _extend(ERXRestKey nextKey, boolean clone) throws ERXRestException {
        if (this.isKeyAll()) {
            if (!nextKey.isKeyGID()) {
                throw new ERXRestException("You can only extend the 'all " + this._entity.name() + "' with an id, not '" + nextKey.key() + "'.");
            }
        } else if (clone) {
            ERXRestKey cloneKey = this.cloneKey(true, false);
            cloneKey._nextKey = nextKey;
            nextKey._previousKey = cloneKey;
        } else {
            if (this._nextKey != null) {
                throw new ERXRestException("You attempted to extend '" + nextKey._key + "' which has already been extended.");
            }
            this._nextKey = nextKey;
            nextKey._previousKey = this;
        }
    }

    public EOEntity entity() {
        return this._entity;
    }

    public String keyAlias() {
        return this._keyAlias;
    }

    public String key() {
        return this._key;
    }

    public ERXRestKey previousKey() {
        return this._previousKey;
    }

    public ERXRestKey firstKey() {
        ERXRestKey firstKey = this;
        if (this._previousKey != null) {
            firstKey = this._previousKey.firstKey();
        }
        return firstKey;
    }

    public ERXRestKey lastKey() {
        ERXRestKey lastKey = this;
        if (this._nextKey != null) {
            lastKey = this._nextKey.lastKey();
        }
        return lastKey;
    }

    public String path(boolean skipGID) {
        StringBuffer pathBuffer = new StringBuffer();
        pathBuffer.append(this._entity.name());
        this.appendKey(pathBuffer, skipGID);
        return pathBuffer.toString();
    }

    protected void appendKey(StringBuffer pathBuffer, boolean skipGID) {
        boolean showKey;
        boolean bl = showKey = !skipGID || !this.isKeyGID();
        if (showKey) {
            pathBuffer.append("/");
            pathBuffer.append(this._key);
        }
        if (this._nextKey != null) {
            this._nextKey.appendKey(pathBuffer, skipGID);
        }
    }

    public ERXRestKey nextKey() {
        return this._nextKey;
    }

    public EOEntity nextEntity() throws ERXRestException {
        EOEntity nextEntity = this._nextEntity;
        if (this._nextEntity == null) {
            if (this._value instanceof EOEnterpriseObject) {
                EOEnterpriseObject eo = (EOEnterpriseObject)this._value;
                nextEntity = this._entity.model().modelGroup().entityNamed(eo.entityName());
            } else if (this.isKeyAll()) {
                nextEntity = this._entity;
            } else if (this.isKeyGID()) {
                nextEntity = this._entity;
            } else {
                EORelationship relationship = this._entity.relationshipNamed(this._key);
                if (relationship != null) {
                    nextEntity = relationship.destinationEntity();
                } else {
                    nextEntity = this._context.delegate().entityDelegate(this._entity).nextEntity(this._entity, this._key);
                    if (nextEntity == null) {
                        nextEntity = this._entity;
                    }
                }
            }
            this._nextEntity = nextEntity;
        }
        return nextEntity;
    }

    public Object value() throws ERXRestException, ERXRestSecurityException, ERXRestNotFoundException {
        return this._value(true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Object _value(boolean checkToOnePermissions) throws ERXRestException, ERXRestSecurityException, ERXRestNotFoundException {
        Object value = this._value;
        if (this._valueFetched) return value;
        boolean cacheValue = true;
        IERXRestEntityDelegate entityDelegate = this._context.delegate().entityDelegate(this._entity);
        if (this.isKeyAll()) {
            value = entityDelegate.objectsForEntity(this._entity, this._context);
        } else {
            Object previousValue = null;
            if (this._previousKey != null) {
                previousValue = this._previousKey.value();
            }
            if (this.isKeyGID()) {
                if (previousValue == null) {
                    value = entityDelegate.objectWithKey(this._entity, this._key, this._context);
                } else {
                    if (!(previousValue instanceof NSArray)) throw new ERXRestException("Unable to evaluate the id '" + this._key + "' on an object of type '" + previousValue.getClass().getName() + "'.");
                    NSArray previousObjects = (NSArray)previousValue;
                    value = entityDelegate.objectWithKey(this._entity, this._key, previousObjects, this._context);
                }
            } else {
                if (previousValue == null) {
                    throw new ERXRestNotFoundException("Unable to evaluate the key '" + this._key + "' on a missing object.");
                }
                if (previousValue instanceof NSArray) {
                    throw new ERXRestException("Unable to evalute the key '" + this._key + "' on an array.");
                }
                if (!entityDelegate.canViewProperty(this._entity, previousValue, this._key, this._context)) {
                    throw new ERXRestSecurityException("You are not allowed to view the key '" + this._key + "' on the entity '" + this._entity.name() + "'.");
                }
                value = entityDelegate.valueForKey(this._entity, previousValue, this._key, this._context);
                EOEntity nextEntity = this.nextEntity();
                if (value instanceof NSArray) {
                    value = this._context.delegate().entityDelegate(nextEntity).visibleObjects(this._entity, previousValue, this._key, nextEntity, (NSArray)value, this._context);
                } else if (value instanceof EOEnterpriseObject && !this._context.delegate().entityDelegate(nextEntity).canViewObject(nextEntity, (EOEnterpriseObject)value, this._context)) {
                    if (checkToOnePermissions) {
                        if (this._previousKey == null) {
                            throw new ERXRestSecurityException("You are not allowed to view the " + nextEntity.name() + " with the id '" + this._key + "'.");
                        }
                        value = null;
                    }
                    cacheValue = false;
                }
            }
        }
        if (value instanceof NSArray) {
            ((NSArray)value).count();
        }
        if (!cacheValue) return value;
        this._value = value;
        this._valueFetched = true;
        return value;
    }

    public boolean isKeyAll() {
        return this._key == null;
    }

    public boolean isKeyGID() {
        return (this._previousKey == null || !this._previousKey.isKeyGID()) && this._context.delegate().entityDelegate(this._entity).isEOID(this);
    }

    public String toString() {
        return "[ERXRestKey: entity = " + this._entity + "; key = " + this._key + "]";
    }

    public static ERXRestKey parse(ERXRestContext context, ERXRestRequestNode node, String path) throws ERXRestException, ERXRestNotFoundException {
        if (path == null && node != null) {
            path = node.name();
            path = ERXLocalizer.currentLocalizer().singularifiedString(path);
        }
        return ERXRestKey.parse(context, path);
    }

    public static ERXRestKey parse(ERXRestContext context, String path) throws ERXRestException, ERXRestNotFoundException {
        ERXRestKey key = null;
        String[] paths = path.split("/");
        if (paths.length > 0) {
            String entityName = context.delegate().entityNameForAlias(paths[0]);
            EOEntity entity = ERXRestEntityDelegateUtils.requiredEntityNamed(context, entityName);
            if (entity == null) {
                String railsyEntityName = ERXStringUtilities.capitalize((String)ERXLocalizer.currentLocalizer().singularifiedString(entityName));
                if (!railsyEntityName.equals(entityName)) {
                    entity = ERXRestEntityDelegateUtils.requiredEntityNamed(context, railsyEntityName);
                }
                if (entity == null) {
                    throw new ERXRestNotFoundException("There is no entity named '" + entityName + "' or '" + railsyEntityName + "'.");
                }
            }
            if (paths.length > 1) {
                key = new ERXRestKey(context, entity, paths[1]);
                for (int pathNum = 2; pathNum < paths.length; ++pathNum) {
                    key = key._extendWithoutClone(paths[pathNum]);
                }
            } else {
                key = new ERXRestKey(context, entity, null);
            }
        }
        return key;
    }
}

