/*
 * Decompiled with CFR 0.152.
 */
package er.rest.entityDelegates;

import com.webobjects.eoaccess.EOEntity;
import com.webobjects.eocontrol.EOEnterpriseObject;
import com.webobjects.eocontrol.EOQualifier;
import com.webobjects.eocontrol.EOSortOrdering;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSMutableSet;
import com.webobjects.foundation.NSSelector;
import er.extensions.eof.ERXSortOrdering;
import er.extensions.foundation.ERXProperties;
import er.rest.ERXRestException;
import er.rest.entityDelegates.ERXAbstractRestEntityDelegate;
import er.rest.entityDelegates.ERXRestContext;
import er.rest.entityDelegates.ERXRestSecurityException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ERXStandardRestEntityDelegate
extends ERXAbstractRestEntityDelegate {
    private NSMutableSet<String> _viewPropertyNames = new NSMutableSet();
    private NSMutableSet<String> _updatePropertyNames = new NSMutableSet();
    private NSMutableSet<String> _insertPropertyNames = new NSMutableSet();
    private NSMutableDictionary<String, String> _propertyAliasForPropertyName = new NSMutableDictionary();
    private NSMutableDictionary<String, String> _propertyNameForPropertyAlias = new NSMutableDictionary();
    private String _defaultIDAttributeName;

    public ERXStandardRestEntityDelegate() {
    }

    public ERXStandardRestEntityDelegate(String entityName, boolean detailsPropertiesAreViewProperties) {
        this();
        if (detailsPropertiesAreViewProperties) {
            this.loadDetailsPropertiesAsViewPropertiesForEntityNamed(entityName);
        }
        this.loadViewPropertiesForEntityNamed(entityName);
        this.loadUpdatePropertiesForEntityNamed(entityName);
        this.loadInsertPropertiesForEntityNamed(entityName);
    }

    public ERXStandardRestEntityDelegate(String entityName) {
        this(entityName, true);
    }

    public void setDefaultIDAttributeName(String defaultIDAttributeName) {
        this._defaultIDAttributeName = defaultIDAttributeName;
    }

    protected String defaultIDAttributeName() {
        String defaultIDAttributeName = this._defaultIDAttributeName;
        if (defaultIDAttributeName == null) {
            defaultIDAttributeName = ERXProperties.stringForKey((String)"ERXRest..id");
        }
        return defaultIDAttributeName;
    }

    @Override
    protected String idAttributeName(EOEntity entity) {
        String idAttributeName = ERXProperties.stringForKey((String)("ERXRest." + entity.name() + ".id"));
        if (idAttributeName == null) {
            idAttributeName = this.defaultIDAttributeName();
        }
        return idAttributeName;
    }

    @Override
    public String entityAliasForEntityNamed(String entityName) {
        String entityAlias = ERXProperties.stringForKey((String)("ERXRest." + entityName + ".alias"));
        if (entityAlias == null) {
            entityAlias = super.entityAliasForEntityNamed(entityName);
        }
        return entityAlias;
    }

    @Override
    public String propertyAliasForPropertyNamed(EOEntity entity, String propertyName) {
        String propertyAlias = (String)this._propertyAliasForPropertyName.objectForKey((Object)(entity.name() + "." + propertyName));
        if (propertyAlias == null) {
            propertyAlias = super.propertyAliasForPropertyNamed(entity, propertyName);
        }
        return propertyAlias;
    }

    @Override
    public String propertyNameForPropertyAlias(EOEntity entity, String propertyAlias) {
        String propertyName = (String)this._propertyNameForPropertyAlias.objectForKey((Object)(entity.name() + "." + propertyAlias));
        if (propertyName == null) {
            propertyName = super.propertyNameForPropertyAlias(entity, propertyAlias);
        }
        return propertyName;
    }

    protected void loadViewPropertiesForEntityNamed(String entityName) {
        String propertiesKey = "ERXRest." + entityName + ".viewProperties";
        String propertyNamesStr = ERXProperties.stringForKey((String)propertiesKey);
        if (propertyNamesStr != null) {
            String[] propertyNames = propertyNamesStr.split(",");
            for (int propertyNum = 0; propertyNum < propertyNames.length; ++propertyNum) {
                String propertyName = propertyNames[propertyNum];
                this.addViewPropertyName(entityName, propertyName);
            }
        }
    }

    protected void loadUpdatePropertiesForEntityNamed(String entityName) {
        String propertiesKey = "ERXRest." + entityName + ".updateProperties";
        String propertyNamesStr = ERXProperties.stringForKey((String)propertiesKey);
        if (propertyNamesStr != null) {
            String[] propertyNames = propertyNamesStr.split(",");
            for (int propertyNum = 0; propertyNum < propertyNames.length; ++propertyNum) {
                String propertyName = propertyNames[propertyNum];
                this.addUpdatePropertyName(entityName, propertyName);
            }
        }
    }

    protected void loadInsertPropertiesForEntityNamed(String entityName) {
        String propertiesKey = "ERXRest." + entityName + ".insertProperties";
        String propertyNamesStr = ERXProperties.stringForKey((String)propertiesKey);
        if (propertyNamesStr != null) {
            String[] propertyNames = propertyNamesStr.split(",");
            for (int propertyNum = 0; propertyNum < propertyNames.length; ++propertyNum) {
                String propertyName = propertyNames[propertyNum];
                this.addInsertPropertyName(entityName, propertyName);
            }
        }
    }

    protected void loadDetailsPropertiesAsViewPropertiesForEntityNamed(String entityName) {
        String propertiesKey = "ERXRest." + entityName + ".detailsProperties";
        String propertyNamesStr = ERXProperties.stringForKey((String)propertiesKey);
        if (propertyNamesStr != null) {
            String[] propertyNames = propertyNamesStr.split(",");
            for (int propertyNum = 0; propertyNum < propertyNames.length; ++propertyNum) {
                String propertyName = propertyNames[propertyNum];
                this.addViewPropertyName(entityName, propertyName);
            }
        }
    }

    public void addViewPropertyName(String entityName, String visiblePropertyName) {
        this._viewPropertyNames.addObject((Object)(entityName + "." + visiblePropertyName));
        this.updatePropertyAliasForPropertyNamed(entityName, visiblePropertyName);
    }

    protected void updatePropertyAliasForPropertyNamed(String entityName, String propertyName) {
        String propertyAliasKey = "ERXRest." + entityName + "." + propertyName + ".alias";
        String propertyAlias = ERXProperties.stringForKey((String)propertyAliasKey);
        if (propertyAlias != null) {
            this._propertyAliasForPropertyName.setObjectForKey((Object)propertyAlias, (Object)(entityName + "." + propertyName));
            this._propertyNameForPropertyAlias.setObjectForKey((Object)propertyName, (Object)(entityName + "." + propertyAlias));
        }
    }

    public void addUpdatePropertyName(String entityName, String updatePropertyName) {
        this.addViewPropertyName(entityName, updatePropertyName);
        this.addInsertPropertyName(entityName, updatePropertyName);
        this._updatePropertyNames.addObject((Object)(entityName + "." + updatePropertyName));
    }

    public void addInsertPropertyName(String entityName, String insertPropertyName) {
        this.addViewPropertyName(entityName, insertPropertyName);
        this._insertPropertyNames.addObject((Object)(entityName + "." + insertPropertyName));
    }

    @Override
    public boolean canInsertProperty(EOEntity entity, EOEnterpriseObject eo, String propertyName, ERXRestContext context) {
        return this._insertPropertyNames.containsObject((Object)(entity.name() + "." + propertyName));
    }

    @Override
    public boolean canUpdateProperty(EOEntity entity, EOEnterpriseObject eo, String propertyName, ERXRestContext context) {
        return this._updatePropertyNames.containsObject((Object)(entity.name() + "." + propertyName));
    }

    @Override
    public boolean canViewProperty(EOEntity entity, Object obj, String propertyName, ERXRestContext context) {
        return this._viewPropertyNames.containsObject((Object)(entity.name() + "." + propertyName));
    }

    protected boolean hasViewProperties() {
        return this._viewPropertyNames.count() > 0;
    }

    @Override
    public void inserted(EOEntity entity, EOEnterpriseObject eo, ERXRestContext context) throws ERXRestException, ERXRestSecurityException {
    }

    @Override
    public void updated(EOEntity entity, EOEnterpriseObject eo, ERXRestContext context) throws ERXRestException, ERXRestSecurityException {
    }

    @Override
    public EOEntity nextEntity(EOEntity entity, String key) {
        EOEntity nextEntity = null;
        String nextEntityName = ERXProperties.stringForKey((String)("ERXRest." + entity.name() + "." + key + ".nextEntity"));
        if (nextEntityName != null) {
            nextEntity = entity.model().modelGroup().entityNamed(nextEntityName);
        }
        return nextEntity;
    }

    protected EOQualifier qualifierFromContext(ERXRestContext context) {
        EOQualifier qualifier = null;
        String qualifierStr = (String)context.valueForKey("qualifier");
        if (qualifierStr != null) {
            qualifier = EOQualifier.qualifierWithQualifierFormat((String)qualifierStr, null);
        }
        return qualifier;
    }

    protected NSArray<EOSortOrdering> sortOrderingsFromContext(ERXRestContext context) {
        ERXSortOrdering.ERXSortOrderings sortOrderings = null;
        String sortOrder = (String)context.valueForKey("order");
        if (sortOrder != null) {
            NSSelector selector = EOSortOrdering.CompareAscending;
            String selectorStr = (String)context.valueForKey("direction");
            if ("asc".equalsIgnoreCase(selectorStr)) {
                selector = EOSortOrdering.CompareAscending;
            } else if ("desc".equalsIgnoreCase(selectorStr)) {
                selector = EOSortOrdering.CompareDescending;
            }
            sortOrderings = ERXSortOrdering.sortOrderingWithKey((String)sortOrder, (NSSelector)selector).array();
        }
        return sortOrderings;
    }
}

