/*
 * Decompiled with CFR 0.152.
 */
package er.rest.routes;

import com.webobjects.appserver.WOApplication;
import com.webobjects.appserver.WOContext;
import com.webobjects.foundation.NSDictionary;
import er.extensions.appserver.ERXWOContext;
import er.extensions.eof.ERXGenericRecord;
import er.extensions.foundation.ERXStringUtilities;
import er.rest.routes.ERXRouteRequestHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ERXRouteUrlUtils {
    protected static String changeDirectActionRequestHandlerTo(String url, String newRequestHandler) {
        String newUrl = url.replaceFirst("/" + WOApplication.application().directActionRequestHandlerKey() + "(/|$)", "/" + newRequestHandler + "$1");
        return newUrl;
    }

    public static String actionUrlForRecord(WOContext context, ERXGenericRecord record, String action, String format, NSDictionary<String, Object> queryParameters, boolean secure, boolean includeSessionID) {
        String url = ERXWOContext.directActionUrl((WOContext)context, (String)ERXRouteUrlUtils.actionUrlPathForEntity(record.entityName(), record.primaryKeyInTransaction(), action, format), queryParameters, (Boolean)secure, (boolean)includeSessionID);
        url = ERXRouteUrlUtils.changeDirectActionRequestHandlerTo(url, "ra");
        return url;
    }

    public static String actionUrlForEntity(WOContext context, String entityName, Object entityID, String action, String format, NSDictionary<String, Object> queryParameters, boolean secure, boolean includeSessionID) {
        String url = ERXWOContext.directActionUrl((WOContext)context, (String)ERXRouteUrlUtils.actionUrlPathForEntity(entityName, entityID, action, format), queryParameters, (Boolean)secure, (boolean)includeSessionID);
        url = ERXRouteUrlUtils.changeDirectActionRequestHandlerTo(url, "ra");
        return url;
    }

    public static String actionUrlForEntityType(WOContext context, String entityName, String action, String format, NSDictionary<String, Object> queryParameters, boolean secure, boolean includeSessionID) {
        String url = ERXWOContext.directActionUrl((WOContext)context, (String)ERXRouteUrlUtils.actionUrlPathForEntity(entityName, null, action, format), queryParameters, (Boolean)secure, (boolean)includeSessionID);
        url = ERXRouteUrlUtils.changeDirectActionRequestHandlerTo(url, "ra");
        return url;
    }

    public static String actionUrlPathForEntity(String entityName, Object entityID, String action, String format) {
        StringBuffer sb = new StringBuffer();
        ERXRouteRequestHandler requestHandler = (ERXRouteRequestHandler)WOApplication.application().requestHandlerForKey("ra");
        sb.append(requestHandler.controllerPathForEntityNamed(entityName));
        if (entityID != null) {
            sb.append("/");
            sb.append(ERXStringUtilities.escapeNonXMLChars((String)String.valueOf(entityID)));
            if (action != null && !"show".equals(action)) {
                sb.append("/");
                sb.append(action);
            }
        } else if (action != null && !"index".equals(action)) {
            sb.append("/");
            sb.append(action);
        }
        sb.append(".");
        if (format == null) {
            sb.append("html");
        } else {
            sb.append(format);
        }
        return sb.toString();
    }
}

