/*
 * Decompiled with CFR 0.152.
 */
package er.rest.util;

import com.webobjects.eoaccess.EOAttribute;
import com.webobjects.eoaccess.EOEntity;
import com.webobjects.eoaccess.EOEntityClassDescription;
import com.webobjects.eocontrol.EOClassDescription;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation.NSMutableDictionary;
import er.extensions.eof.ERXKey;
import er.extensions.eof.ERXKeyFilter;
import er.rest.ERXRestClassDescriptionFactory;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ERXRestSchema {
    public static NSDictionary<String, Object> schemaForEntityNamed(String entityName, ERXKeyFilter filter) {
        NSMutableDictionary schema = new NSMutableDictionary();
        schema.setObjectForKey((Object)entityName, (Object)"name");
        NSDictionary<String, Object> properties = ERXRestSchema.schemaPropertiesForEntityNamed(entityName, filter, new HashSet<String>());
        schema.setObjectForKey(properties, (Object)"properties");
        return schema;
    }

    protected static NSDictionary<String, Object> schemaPropertiesForEntityNamed(String entityName, ERXKeyFilter filter, Set<String> entities) {
        ERXKeyFilter destinationFilter;
        EOClassDescription destinationClassDescription;
        ERXKey key;
        if (entities.contains(entityName)) {
            return null;
        }
        entities.add(entityName);
        NSMutableDictionary properties = new NSMutableDictionary();
        EOClassDescription classDescription = ERXRestClassDescriptionFactory.classDescriptionForEntityName(entityName);
        EOEntity entity = null;
        if (classDescription instanceof EOEntityClassDescription) {
            entity = ((EOEntityClassDescription)classDescription).entity();
        }
        for (String attributeName : classDescription.attributeKeys()) {
            key = new ERXKey(attributeName);
            if (!filter.matches(key, ERXKey.Type.Attribute)) continue;
            EOAttribute attribute = null;
            if (entity != null) {
                attribute = entity.attributeNamed(key.key());
            }
            NSMutableDictionary property = new NSMutableDictionary();
            boolean optional = attribute != null && attribute.allowsNull();
            property.setObjectForKey((Object)optional, (Object)"optional");
            Class attributeClass = classDescription.classForAttributeKey(key.key());
            if (String.class.isAssignableFrom(attributeClass)) {
                int width;
                property.setObjectForKey((Object)"string", (Object)"type");
                if (attribute != null && (width = attribute.width()) > 0) {
                    if (!optional) {
                        property.setObjectForKey((Object)1, (Object)"minLength");
                    }
                    property.setObjectForKey((Object)width, (Object)"maxLength");
                }
            } else if (Date.class.isAssignableFrom(attributeClass)) {
                property.setObjectForKey((Object)"string", (Object)"type");
                property.setObjectForKey((Object)"date-time", (Object)"format");
            } else if (Integer.class.isAssignableFrom(attributeClass)) {
                property.setObjectForKey((Object)"integer", (Object)"type");
            } else if (BigDecimal.class.isAssignableFrom(attributeClass)) {
                property.setObjectForKey((Object)"number", (Object)"type");
            } else if (Number.class.isAssignableFrom(attributeClass)) {
                property.setObjectForKey((Object)"number", (Object)"type");
            } else if (Boolean.class.isAssignableFrom(attributeClass)) {
                property.setObjectForKey((Object)"boolean", (Object)"type");
            } else {
                NSLog.out.appendln((Object)("Unknown schema type '" + attributeClass.getName() + "' for entity '" + entityName + "'"));
                property.setObjectForKey((Object)"any", (Object)"type");
            }
            properties.setObjectForKey((Object)property, (Object)key.key());
        }
        for (String toOneRelationshipName : classDescription.toOneRelationshipKeys()) {
            key = new ERXKey(toOneRelationshipName);
            if (!filter.matches(key, ERXKey.Type.ToOneRelationship)) continue;
            destinationClassDescription = classDescription.classDescriptionForDestinationKey(key.key());
            destinationFilter = filter._filterForKey(key);
            NSDictionary<String, Object> destinationSchema = ERXRestSchema.schemaPropertiesForEntityNamed(destinationClassDescription.entityName(), destinationFilter, entities);
            if (destinationSchema == null) continue;
            properties.setObjectForKey(destinationSchema, (Object)key.key());
        }
        for (String toManyRelationshipName : classDescription.toManyRelationshipKeys()) {
            key = new ERXKey(toManyRelationshipName);
            if (!filter.matches(key, ERXKey.Type.ToManyRelationship)) continue;
            destinationClassDescription = classDescription.classDescriptionForDestinationKey(key.key());
            destinationFilter = filter._filterForKey(key);
            NSDictionary<String, Object> destinationSchema = ERXRestSchema.schemaPropertiesForEntityNamed(destinationClassDescription.entityName(), destinationFilter, entities);
            if (destinationSchema == null) continue;
            properties.setObjectForKey(destinationSchema, (Object)key.key());
        }
        entities.remove(entityName);
        return properties;
    }
}

