/*
 * Decompiled with CFR 0.152.
 */
package er.rest.util;

import com.webobjects.appserver.WOApplication;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WORequest;
import com.webobjects.appserver.WOResponse;
import com.webobjects.appserver.WOSession;
import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableDictionary;
import er.extensions.appserver.ERXSession;
import er.extensions.eof.ERXEC;
import er.extensions.foundation.ERXProperties;
import er.rest.routes.ERXRouteRequestHandler;
import er.rest.util.ERXRestTransaction;
import er.rest.util.ERXRestTransactionManager;

public class ERXRestTransactionRequestAdaptor {
    private static final String CLIENT_ID_HEADER_KEY = "Client-Id";
    private static final String SEQUENCE_ID_HEADER_KEY = "Seq-Id";
    private static final String TRANSACTION_HEADER_KEY = "Transaction";
    private static final String OPEN_TRANSACTION_HEADER_VALUE = "open";
    private static final String COMMIT_TRANSACTION_HEADER_VALUE = "commit";
    private static final String EXECUTING_TRANSACTION_KEY = "er.rest.ERXRestTransaction.transaction";
    private static final String TRANSACTION_MANAGER_KEY = "er.rest.ERXRestTransaction.transactionManager";
    private static ERXRestTransactionRequestAdaptor _defaultAdaptor;
    private boolean _transactionsEnabled = ERXProperties.booleanForKeyWithDefault((String)"ERXRest.transactionsEnabled", (boolean)false);
    private int _maxEventsPerTransaction = ERXProperties.intForKeyWithDefault((String)"ERXRest.maxEventsPerTransaction", (int)50);

    public static synchronized ERXRestTransactionRequestAdaptor defaultAdaptor() {
        if (_defaultAdaptor == null) {
            _defaultAdaptor = new ERXRestTransactionRequestAdaptor();
        }
        return _defaultAdaptor;
    }

    protected EOEditingContext newEditingContext() {
        return ERXEC.newEditingContext();
    }

    public boolean transactionsEnabled() {
        return this._transactionsEnabled;
    }

    public boolean hasSequence(WOContext context, WORequest request) {
        return request.headerForKey((Object)SEQUENCE_ID_HEADER_KEY) != null;
    }

    public boolean hasTransaction(WOContext context, WORequest request) {
        return request.headerForKey((Object)TRANSACTION_HEADER_KEY) != null;
    }

    public boolean isExecutingTransaction(WOContext context, WORequest request) {
        return this.executingTransaction(context, request) != null;
    }

    public ERXRestTransaction executingTransaction(WOContext context, WORequest request) {
        ERXRestTransaction transaction = null;
        NSDictionary userInfo = request.userInfo();
        if (userInfo != null) {
            transaction = (ERXRestTransaction)userInfo.objectForKey((Object)EXECUTING_TRANSACTION_KEY);
        }
        return transaction;
    }

    protected void setExecutingTransaction(ERXRestTransaction transaction, WOContext context, WORequest request) {
        NSDictionary immutableUserInfo = request.userInfo();
        NSMutableDictionary userInfo = immutableUserInfo == null ? new NSMutableDictionary() : immutableUserInfo.mutableClone();
        userInfo.setObjectForKey((Object)transaction, (Object)EXECUTING_TRANSACTION_KEY);
        request.setUserInfo((NSDictionary)userInfo);
    }

    public ERXRestTransaction transaction(WOContext context, WORequest request) {
        ERXRestTransaction transaction = null;
        if (transaction == null) {
            ERXRestTransactionManager transactionManager = this.transactionManager(context, request);
            transaction = this.transaction(context, request, transactionManager);
        }
        return transaction;
    }

    public boolean willHandleRequest(WOContext context, WORequest request) {
        boolean shouldDispatchRequest = true;
        Integer sequenceIDInteger = this.sequenceID(request);
        if (sequenceIDInteger != null) {
            int sequenceID = sequenceIDInteger;
            ERXRestTransactionManager transactionManager = this.transactionManager(context, request);
            transactionManager.addSequenceID(sequenceID);
            ERXRestTransaction.State state = this.state(request);
            if (state != null) {
                ERXRestTransaction transaction = this.transaction(context, request, transactionManager);
                transaction.addEvent(sequenceID, state, request);
                shouldDispatchRequest = false;
                if (transaction.size() > this._maxEventsPerTransaction) {
                    transactionManager.removeTransaction(transaction);
                    throw new IllegalArgumentException("You exceeded the maximum number of events for a single transaction.");
                }
            }
        }
        return shouldDispatchRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean didHandleRequest(WOContext context, WORequest request) {
        ERXRestTransaction transaction;
        boolean shouldHandleRequest = true;
        ERXRestTransactionManager transactionManager = this.transactionManager(context, request);
        if (transactionManager.isTransactionReady(transaction = this.transaction(context, request, transactionManager))) {
            shouldHandleRequest = false;
            if (context._session() != null) {
                WOApplication.application().sessionStore().checkInSessionForContext(context);
                context._setSession(null);
                ERXSession.setSession(null);
            }
            try {
                EOEditingContext editingContext = transaction.editingContext();
                try {
                    for (Object record : transaction.records()) {
                        WORequest recordRequest = (WORequest)record;
                        this.setExecutingTransaction(transaction, context, recordRequest);
                        recordRequest.removeHeadersForKey((Object)CLIENT_ID_HEADER_KEY);
                        recordRequest.removeHeadersForKey((Object)SEQUENCE_ID_HEADER_KEY);
                        recordRequest.removeHeadersForKey((Object)TRANSACTION_HEADER_KEY);
                        ERXRouteRequestHandler requestHandler = (ERXRouteRequestHandler)WOApplication.application().handlerForRequest(recordRequest);
                        WOResponse response = requestHandler.handleRequest(recordRequest);
                        if (response.status() >= 200 && response.status() <= 299) continue;
                        throw new RuntimeException("Transaction failed: " + response.contentString());
                    }
                    editingContext.saveChanges();
                }
                finally {
                    transactionManager.removeTransaction(transaction);
                    editingContext.dispose();
                }
            }
            finally {
                context.session();
            }
        }
        return shouldHandleRequest;
    }

    protected String clientID(WORequest request) {
        return request.headerForKey((Object)CLIENT_ID_HEADER_KEY);
    }

    protected Integer sequenceID(WORequest request) {
        Integer sequenceID = null;
        String sequenceIDStr = request.headerForKey((Object)SEQUENCE_ID_HEADER_KEY);
        if (sequenceIDStr != null) {
            sequenceID = Integer.parseInt(sequenceIDStr);
        }
        return sequenceID;
    }

    protected ERXRestTransaction.State state(WORequest request) {
        ERXRestTransaction.State state;
        String stateStr = request.headerForKey((Object)TRANSACTION_HEADER_KEY);
        if (stateStr == null) {
            state = null;
        } else if (COMMIT_TRANSACTION_HEADER_VALUE.equals(stateStr)) {
            state = ERXRestTransaction.State.Commit;
        } else if (OPEN_TRANSACTION_HEADER_VALUE.equals(stateStr)) {
            state = ERXRestTransaction.State.Open;
        } else {
            throw new IllegalArgumentException("Unknown transaction state: " + stateStr);
        }
        return state;
    }

    protected ERXRestTransactionManager transactionManager(WOContext context, WORequest request) {
        WOSession session = context.session();
        ERXRestTransactionManager transactionManager = (ERXRestTransactionManager)session.objectForKey(TRANSACTION_MANAGER_KEY);
        if (transactionManager == null) {
            transactionManager = new ERXRestTransactionManager();
            session.setObjectForKey((Object)transactionManager, TRANSACTION_MANAGER_KEY);
        }
        return transactionManager;
    }

    protected ERXRestTransaction transaction(WOContext context, WORequest request, ERXRestTransactionManager transactionManager) {
        WOSession session = context.session();
        String clientID = this.clientID(request);
        if (clientID == null) {
            clientID = session.sessionID();
        }
        return transactionManager.transactionForID(clientID);
    }
}

