/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects._ideservices;

import com.webobjects._ideservices._IDEProject;
import com.webobjects._ideservices._PBXProjectWatcher;
import com.webobjects._ideservices._WOProject;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSBundle;
import com.webobjects.foundation.NSData;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSNotification;
import com.webobjects.foundation.NSNotificationCenter;
import com.webobjects.foundation.NSPathUtilities;
import com.webobjects.foundation.NSPropertyListSerialization;
import com.webobjects.foundation.NSSet;
import com.webobjects.foundation._NSStringUtilities;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class _IDEProjectPBX
implements _IDEProject {
    private static final String _extensionsFilename = "ExtensionsForResources.plist";
    private static final NSMutableArray<String> _fileTypeArray;
    private final String _cookie;
    private final NSMutableArray<String> _targets = new NSMutableArray();
    private final NSMutableDictionary<String, String> _targetsByNameDict = new NSMutableDictionary();
    private static final String SERVER_TARGET_NAME = "Application Server";
    private static final String CLIENT_TARGET_NAME = "Web Server";
    private static final String EJB_SERVER_TARGET_NAME = "EJB Deployment";
    private static final String EJB_CLIENT_TARGET_NAME = "EJB Client Interfaces";
    private static final String COMPONENTS_GROUP_NAME = "Web Components";
    private static final String RESOURCES_GROUP_NAME = "Resources";
    private static final String WEB_SERVER_RESOURCES_GROUP_NAME = "Web Server Resources";
    private static final String CLASSES_GROUP_NAME = "Classes";
    private static final NSArray<String> _languageTypeArray;
    private static final NSArray<String> _modelArray;
    private static final NSArray<String> _frameworkArray;

    static {
        NSMutableArray wofArray;
        NSMutableArray mainBundleArray;
        block35: {
            mainBundleArray = null;
            wofArray = null;
            NSBundle wofBundle = NSBundle.bundleForName((String)"JavaWebObjects");
            if (wofBundle == null) {
                NSLog.err.appendln((Object)"NSBundle is unable to find JavaWebObjects.framework -- unable to load \"ExtensionsForResources.plist\" from there.  Ignoring.");
            } else {
                String wofFileRelativePath = wofBundle.resourcePathForLocalizedResourceNamed(_extensionsFilename, "");
                if (wofFileRelativePath == null) {
                    NSLog.err.appendln((Object)"NSBundle is unable to find \"ExtensionsForResources.plist\" in JavaWebObjects.framework.  Ignoring.");
                } else {
                    try {
                        InputStream is = wofBundle.inputStreamForResourcePath(wofFileRelativePath);
                        String wofFileRelativeString = _NSStringUtilities.stringFromInputStream((InputStream)is);
                        Object o = NSPropertyListSerialization.propertyListFromString((String)wofFileRelativeString);
                        if (o instanceof NSArray) {
                            wofArray = new NSMutableArray((NSArray)o);
                            int waCount = wofArray.count();
                            if (waCount == 0) {
                                NSLog.err.appendln((Object)"The array parsed from \"ExtensionsForResources.plist\" in JavaWebObjects.framework is empty.  Ignoring.");
                                wofArray = null;
                            } else {
                                int i = 0;
                                while (i < waCount) {
                                    Object element = wofArray.objectAtIndex(i);
                                    if (!(element instanceof String)) {
                                        NSLog.err.appendln((Object)("Found non-string element in the array parsed from \"ExtensionsForResources.plist\" in JavaWebObjects.framework is empty.  Ignoring  \"" + element + "\"."));
                                        wofArray.removeObjectAtIndex(i);
                                        --waCount;
                                    }
                                    ++i;
                                }
                                if (wofArray.count() == 0) {
                                    NSLog.err.appendln((Object)"The array parsed from \"ExtensionsForResources.plist\" in JavaWebObjects.framework had no valid elements.  Ignoring.");
                                    wofArray = null;
                                }
                            }
                        } else {
                            NSLog.err.appendln((Object)"NSBundle is unable to parse an array from \"ExtensionsForResources.plist\" in JavaWebObjects.framework.  Ignoring.");
                        }
                    }
                    catch (Throwable t) {
                        NSLog.err.appendln((Object)"Unable to parse \"ExtensionsForResources.plist\" in JavaWebObjects.framework.  Ignoring.");
                    }
                }
            }
            NSBundle mainBundle = NSBundle.mainBundle();
            if (mainBundle == null) {
                NSLog.err.appendln((Object)"NSBundle is unable to find the main bundle -- unable to load \"ExtensionsForResources.plist\" from there.");
            } else {
                String mainBundleFileRelativePath = mainBundle.resourcePathForLocalizedResourceNamed(_extensionsFilename, "");
                if (mainBundleFileRelativePath == null) {
                    if (NSLog.debugLoggingAllowedForLevelAndGroups((int)2, (long)36L)) {
                        NSLog.debug.appendln((Object)"NSBundle is unable to find \"ExtensionsForResources.plist\" in the main bundle.  Ignoring optional configuration file.");
                    }
                } else {
                    try {
                        InputStream is = mainBundle.inputStreamForResourcePath(mainBundleFileRelativePath);
                        String mainBundleFileRelativeString = _NSStringUtilities.stringFromInputStream((InputStream)is);
                        Object o = NSPropertyListSerialization.propertyListFromString((String)mainBundleFileRelativeString);
                        if (o instanceof NSArray) {
                            mainBundleArray = new NSMutableArray((NSArray)o);
                            int mbaCount = mainBundleArray.count();
                            if (mbaCount == 0) {
                                if (NSLog.debugLoggingAllowedForLevelAndGroups((int)2, (long)36L)) {
                                    NSLog.debug.appendln((Object)"The array parsed from \"ExtensionsForResources.plist\" in the main bundle is empty.  Ignoring optional configuration file.");
                                }
                                mainBundleArray = null;
                            } else {
                                int i = 0;
                                while (i < mbaCount) {
                                    Object element = mainBundleArray.objectAtIndex(i);
                                    if (!(element instanceof String)) {
                                        if (NSLog.debugLoggingAllowedForLevelAndGroups((int)2, (long)36L)) {
                                            NSLog.debug.appendln((Object)("Found non-string element in the array parsed from optional configuration file \"ExtensionsForResources.plist\" in the main bundle.  Ignoring  \"" + element + "\"."));
                                        }
                                        mainBundleArray.removeObjectAtIndex(i);
                                        --mbaCount;
                                    }
                                    ++i;
                                }
                                if (mainBundleArray.count() == 0) {
                                    if (NSLog.debugLoggingAllowedForLevelAndGroups((int)2, (long)36L)) {
                                        NSLog.debug.appendln((Object)"The array parsed from \"ExtensionsForResources.plist\" in the main bundle had no valid elements.  Ignoring optional configuration file.");
                                    }
                                    mainBundleArray = null;
                                }
                            }
                        } else if (NSLog.debugLoggingAllowedForLevelAndGroups((int)2, (long)36L)) {
                            NSLog.debug.appendln((Object)"NSBundle is unable to parse an array from \"ExtensionsForResources.plist\" in the main bundle.  Ignoring optional configuration file.");
                        }
                    }
                    catch (Throwable t) {
                        if (!NSLog.debugLoggingAllowedForLevelAndGroups((int)2, (long)36L)) break block35;
                        NSLog.debug.appendln((Object)"Unable to parse \"ExtensionsForResources.plist\" in the main bundle.  Ignoring optional configuration file.");
                    }
                }
            }
        }
        if (wofArray == null && mainBundleArray == null) {
            throw new IllegalStateException("Unable to find any resource extensions in either JavaWebObjects.framework or the main bundle.");
        }
        if (wofArray != null) {
            if (mainBundleArray != null) {
                wofArray.addObjectsFromArray(mainBundleArray);
            }
            _fileTypeArray = wofArray;
        } else {
            _fileTypeArray = mainBundleArray != null ? mainBundleArray : null;
        }
        _languageTypeArray = new NSArray((Object[])new String[]{"wos", "java", "h", "m"});
        _modelArray = new NSArray((Object[])new String[]{"eomodel", "eomodeld"});
        _frameworkArray = new NSArray((Object[])new String[]{"framework"});
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static _IDEProjectPBX pbxProjectAtPath(String path) {
        _IDEProjectPBX project = null;
        String aPath = path;
        if (aPath == null) return project;
        try {
            NSArray openProjects = _PBXProjectWatcher.openProjectsAppropriateForFile(aPath);
            if (openProjects.count() == 0) {
                if (NSLog._debugLoggingAllowedForLevelAndGroups((int)2, (long)36L)) {
                    NSLog.debug.appendln((Object)("_IDEProjectPBX.pbxProjectAtPath() -- failed to find an open, development-mode project at: " + aPath + " ... Trying to find a pbdevelopment.plist at this path instead."));
                }
                String pbdevpath = aPath;
                NSDictionary pbdevdict = null;
                boolean isJar = aPath.endsWith(".jar");
                if (!isJar) {
                    pbdevpath = NSPathUtilities.stringByAppendingPathComponent((String)aPath, (String)"Contents");
                    pbdevpath = NSPathUtilities.stringByAppendingPathComponent((String)pbdevpath, (String)"pbdevelopment.plist");
                    if (NSLog._debugLoggingAllowedForLevelAndGroups((int)2, (long)36L)) {
                        NSLog.debug.appendln((Object)("_IDEProjectPBX.pbxProjectAtPath() -- Trying: " + pbdevpath));
                    }
                    try {
                        pbdevdict = (NSDictionary)NSPropertyListSerialization.propertyListWithPathURL((URL)new File(pbdevpath).toURL());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (pbdevdict == null) {
                    if (isJar) {
                        try {
                            URL url = new URL("jar:" + NSPathUtilities._fileURLPrefix + aPath + "!/Resources/pbdevelopment.plist");
                            NSData aData = new NSData(_NSStringUtilities.bytesFromInputStream((InputStream)url.openStream()));
                            pbdevdict = (NSDictionary)NSPropertyListSerialization.propertyListFromData((NSData)aData, null);
                        }
                        catch (Exception exception) {}
                    } else {
                        pbdevpath = NSPathUtilities.stringByAppendingPathComponent((String)aPath, (String)RESOURCES_GROUP_NAME);
                        pbdevpath = NSPathUtilities.stringByAppendingPathComponent((String)pbdevpath, (String)"pbdevelopment.plist");
                        if (NSLog._debugLoggingAllowedForLevelAndGroups((int)2, (long)36L)) {
                            NSLog.debug.appendln((Object)("_IDEProjectPBX.pbxProjectAtPath() -- Trying instead: " + pbdevpath));
                        }
                        try {
                            pbdevdict = (NSDictionary)NSPropertyListSerialization.propertyListWithPathURL((URL)new File(pbdevpath).toURL());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                if (pbdevdict == null) {
                    if (!NSLog._debugLoggingAllowedForLevelAndGroups((int)2, (long)36L)) return null;
                    NSLog.debug.appendln((Object)"_IDEProjectPBX.pbxProjectAtPath() -- Unable to find/parse a valid NSDictionary at either location.");
                    return null;
                }
                if (NSLog._debugLoggingAllowedForLevelAndGroups((int)2, (long)36L)) {
                    NSLog.debug.appendln((Object)("_IDEProjectPBX.pbxProjectAtPath() -- Found and parsed a valid NSDictionary at: " + pbdevpath));
                }
                if ((aPath = (String)pbdevdict.valueForKey("PBXProjectSourcePath")) == null) {
                    if (!NSLog._debugLoggingAllowedForLevelAndGroups((int)2, (long)36L)) return null;
                    NSLog.debug.appendln((Object)"_IDEProjectPBX.pbxProjectAtPath() -- Unfortunately, there's no value for the key 'PBXProjectSourcePath'.");
                    return null;
                }
                if (NSLog._debugLoggingAllowedForLevelAndGroups((int)2, (long)36L)) {
                    NSLog.debug.appendln((Object)("_IDEProjectPBX.pbxProjectAtPath() -- value for the key 'PBXProjectSourcePath': " + aPath));
                }
                if (!aPath.endsWith(".pbproj") && !aPath.endsWith(".xcode")) {
                    aPath = NSPathUtilities.stringByAppendingPathComponent((String)aPath, (String)NSPathUtilities.lastPathComponent((String)aPath));
                    aPath = NSPathUtilities.stringByAppendingPathExtension((String)aPath, (String)"pbproj");
                }
                openProjects = _PBXProjectWatcher.openProjectsAppropriateForFile(aPath);
            }
            if (openProjects != null && openProjects.count() > 0) {
                if (!NSLog._debugLoggingAllowedForLevelAndGroups((int)2, (long)36L)) return new _IDEProjectPBX((String)openProjects.objectAtIndex(0), aPath);
                NSLog.debug.appendln((Object)("_IDEProjectPBX.pbxProjectAtPath() -- openProjects == " + openProjects));
                return new _IDEProjectPBX((String)openProjects.objectAtIndex(0), aPath);
            }
            if (!NSLog._debugLoggingAllowedForLevelAndGroups((int)2, (long)36L)) return project;
            NSLog.debug.appendln((Object)("_IDEProjectPBX.pbxProjectAtPath() -- failed to find an open, development-mode project at: " + aPath));
            return project;
        }
        catch (Exception e) {
            if (!NSLog.debugLoggingAllowedForLevel((int)1)) return project;
            NSLog.err.appendln((Object)("_IDEProjectPBX: exception in pbxProjectAtPath:" + e));
            NSLog._conditionallyLogPrivateException((Throwable)e);
        }
        return project;
    }

    public _IDEProjectPBX(String cookie, String path) {
        this._cookie = cookie;
        this.createTargetList();
    }

    public void createTargetList() {
        this._targets.addObjectsFromArray(_PBXProjectWatcher.targetsInProject(this._cookie));
        for (String target : this._targets) {
            String name = _PBXProjectWatcher.nameOfTargetInProject(target, this._cookie);
            this._targetsByNameDict.takeValueForKey((Object)target, name);
        }
    }

    @Override
    public String projectDir() {
        return NSPathUtilities.stringByNormalizingExistingPath((String)NSPathUtilities.stringByDeletingLastPathComponent((String)this._cookie));
    }

    @Override
    public String projectDirNotNormalized() {
        return NSPathUtilities.stringByDeletingLastPathComponent((String)this._cookie);
    }

    @Override
    public String projectName() {
        return _PBXProjectWatcher.nameOfProject(this._cookie);
    }

    @Override
    public String languageDir() {
        return "languageDir unimplemented";
    }

    @Override
    public String projectTypeName() {
        return "projectTypeName unimplemented";
    }

    @Override
    public String languageName() {
        return "languageName unimplemented";
    }

    @Override
    public void addComponent(String componentDirectoryString, String javaFileString) {
        NSArray paths;
        String apiFilePath = NSPathUtilities.stringByAppendingPathExtension((String)NSPathUtilities.stringByDeletingPathExtension((String)componentDirectoryString), (String)"api");
        String groupName = NSPathUtilities.lastPathComponent((String)NSPathUtilities.stringByDeletingPathExtension((String)componentDirectoryString));
        NSMutableArray targets = new NSMutableArray();
        String serverTarget = (String)this._targetsByNameDict.objectForKey((Object)SERVER_TARGET_NAME);
        String nearFile = NSPathUtilities.stringByDeletingLastPathComponent((String)componentDirectoryString);
        if (serverTarget != null) {
            targets.addObject((Object)serverTarget);
        }
        _PBXProjectWatcher.addGroup(COMPONENTS_GROUP_NAME, null, this._cookie, nearFile);
        _PBXProjectWatcher.addGroupToPreferredInsertionGroup(groupName, null, this._cookie, nearFile, COMPONENTS_GROUP_NAME);
        if (componentDirectoryString != null && NSPathUtilities.fileExistsAtPathURL((URL)NSPathUtilities._URLWithPath((String)componentDirectoryString))) {
            paths = new NSArray((Object)componentDirectoryString);
            _PBXProjectWatcher.addFilesToProjectNearFilePreferredInsertionGroupNameAddToTargetsCopyIntoGroupFolderCreateGroupsRecursively(paths, this._cookie, nearFile, groupName, (NSArray)targets, true, false);
        }
        if (javaFileString != null && NSPathUtilities.fileExistsAtPathURL((URL)NSPathUtilities._URLWithPath((String)javaFileString))) {
            paths = new NSArray((Object)javaFileString);
            _PBXProjectWatcher.addFilesToProjectNearFilePreferredInsertionGroupNameAddToTargetsCopyIntoGroupFolderCreateGroupsRecursively(paths, this._cookie, nearFile, groupName, (NSArray)targets, true, false);
        }
        if (apiFilePath != null && NSPathUtilities.fileExistsAtPathURL((URL)NSPathUtilities._URLWithPath((String)apiFilePath))) {
            paths = new NSArray((Object)apiFilePath);
            _PBXProjectWatcher.addFilesToProjectNearFilePreferredInsertionGroupNameAddToTargetsCopyIntoGroupFolderCreateGroupsRecursively(paths, this._cookie, nearFile, groupName, (NSArray)targets, false, false);
        }
    }

    @Override
    public String pathToBucket(String aKey) {
        if (aKey.equals("EJB_META_INFO")) {
            return "META-INF";
        }
        return "";
    }

    @Override
    public void addFileKey(String aFile, String aKey) {
        String target = null;
        String group = RESOURCES_GROUP_NAME;
        NSArray paths = new NSArray((Object)aFile);
        String nearFile = NSPathUtilities.stringByDeletingLastPathComponent((String)aFile);
        if (aKey.equals("WO_COMPONENTS")) {
            target = (String)this._targetsByNameDict.objectForKey((Object)SERVER_TARGET_NAME);
            group = COMPONENTS_GROUP_NAME;
        } else if (aKey.equals("WEBSERVER_RESOURCES")) {
            target = (String)this._targetsByNameDict.objectForKey((Object)CLIENT_TARGET_NAME);
            group = WEB_SERVER_RESOURCES_GROUP_NAME;
        } else if (aKey.equals("WEBSERVER_RESOURCES")) {
            target = (String)this._targetsByNameDict.objectForKey((Object)SERVER_TARGET_NAME);
            group = COMPONENTS_GROUP_NAME;
        } else if (aKey.equals("RESOURCES")) {
            target = (String)this._targetsByNameDict.objectForKey((Object)SERVER_TARGET_NAME);
            group = RESOURCES_GROUP_NAME;
        } else if (aKey.equals("OTHER_RESOURCES")) {
            target = (String)this._targetsByNameDict.objectForKey((Object)SERVER_TARGET_NAME);
            group = RESOURCES_GROUP_NAME;
        } else if (aKey.equals("CLASSES")) {
            target = (String)this._targetsByNameDict.objectForKey((Object)SERVER_TARGET_NAME);
            group = CLASSES_GROUP_NAME;
        } else if (aKey.equals("H_FILES")) {
            target = (String)this._targetsByNameDict.objectForKey((Object)SERVER_TARGET_NAME);
            group = COMPONENTS_GROUP_NAME;
        } else if (aKey.equals("OTHER_LINKED")) {
            target = (String)this._targetsByNameDict.objectForKey((Object)SERVER_TARGET_NAME);
            group = CLASSES_GROUP_NAME;
        } else if (aKey.equals("EJB_SERVER_CLASSES")) {
            target = (String)this._targetsByNameDict.objectForKey((Object)EJB_SERVER_TARGET_NAME);
            group = CLASSES_GROUP_NAME;
        } else if (aKey.equals("EJB_CLIENT_CLASSES")) {
            target = (String)this._targetsByNameDict.objectForKey((Object)EJB_CLIENT_TARGET_NAME);
            group = CLASSES_GROUP_NAME;
        } else if (aKey.equals("EJB_META_INFO")) {
            target = (String)this._targetsByNameDict.objectForKey((Object)EJB_SERVER_TARGET_NAME);
            group = RESOURCES_GROUP_NAME;
        } else if (aKey.equals("EJB_COMMON_CLASSES")) {
            group = CLASSES_GROUP_NAME;
            NSMutableArray targetCookies = new NSMutableArray();
            target = (String)this._targetsByNameDict.objectForKey((Object)EJB_SERVER_TARGET_NAME);
            targetCookies.addObject((Object)target);
            target = (String)this._targetsByNameDict.objectForKey((Object)EJB_CLIENT_TARGET_NAME);
            targetCookies.addObject((Object)target);
            _PBXProjectWatcher.addFilesToProjectNearFilePreferredInsertionGroupNameAddToTargetsCopyIntoGroupFolderCreateGroupsRecursively(paths, this._cookie, nearFile, group, (NSArray)targetCookies, true, false);
            return;
        }
        if (target == null) {
            target = (String)this._targetsByNameDict.objectForKey((Object)SERVER_TARGET_NAME);
        }
        NSArray targetCookies = new NSArray((Object)target);
        _PBXProjectWatcher.addFilesToProjectNearFilePreferredInsertionGroupNameAddToTargetsCopyIntoGroupFolderCreateGroupsRecursively(paths, this._cookie, nearFile, group, targetCookies, true, false);
    }

    @Override
    public void openFile(String filename, int line, String errorMessage) {
        _PBXProjectWatcher.openFile(filename, line, errorMessage);
    }

    @Override
    public String pathForFrameworkNamed(String fwName) {
        return "pathForFrameworkNamed unimplemented";
    }

    @Override
    public void setPathForFramework(String path, String fwName) {
    }

    public boolean isPureJavaProject() {
        return true;
    }

    @Override
    public String ideApplicationName() {
        return "Xcode";
    }

    @Override
    public String ideProjectPath() {
        String projectPath = this.projectDir();
        projectPath = String.valueOf(projectPath) + File.separator + this.projectName() + ".xcodeproj";
        projectPath = String.valueOf(projectPath) + File.separator + "project.pbxproj";
        return NSPathUtilities.stringByNormalizingExistingPath((String)projectPath);
    }

    public NSArray<String> _filesOfTypes(NSArray<String> typesArray) {
        NSMutableArray pathArray = new NSMutableArray();
        if (this._targets != null) {
            Iterator iterator = this._targets.iterator();
            while (iterator.hasNext()) {
                NSArray<String> targetResources = _PBXProjectWatcher.filesOfTypesInTargetOfProject(typesArray, (String)iterator.next(), this._cookie);
                pathArray.addObjectsFromArray(targetResources);
            }
        }
        return new NSSet((NSArray)pathArray).allObjects();
    }

    @Override
    public void extractFilesIntoWOProject(_WOProject woProject) {
        NSArray<String> pathArray = this._filesOfTypes(_languageTypeArray);
        if (pathArray != null) {
            Iterator iterator = pathArray.iterator();
            while (iterator.hasNext()) {
                woProject.addInterfaceFilePath((String)iterator.next());
            }
        }
        if (woProject.includeFrameworks()) {
            this.extractFrameworksIntoWOProject(woProject);
        }
        this.extractResourcesIntoWOProject(woProject);
        this.extractModelsIntoWOProject(woProject);
    }

    public void extractModelsIntoWOProject(_WOProject woProject) {
        NSArray<String> pathArray = this._filesOfTypes(_modelArray);
        if (pathArray.count() > 0) {
            Iterator iterator = pathArray.iterator();
            while (iterator.hasNext()) {
                woProject.addModelFilePath((String)iterator.next());
            }
        }
    }

    public void extractFrameworksIntoWOProject(_WOProject woProject) {
        NSArray<String> pathArray = this._filesOfTypes(_frameworkArray);
        if (pathArray.count() > 0) {
            Iterator iterator = pathArray.iterator();
            while (iterator.hasNext()) {
                woProject.extractFrameworkAtPath((String)iterator.next());
            }
        }
    }

    @Override
    @Deprecated
    public NSArray frameworkBundlePaths() {
        NSArray<String> frameworkArray = this._filesOfTypes(_frameworkArray);
        NSMutableArray frameworkPathsArray = new NSMutableArray();
        int count = frameworkArray.count();
        if (count > 0) {
            int i = 0;
            while (i < count) {
                String framework = NSPathUtilities.lastPathComponent((String)((String)frameworkArray.objectAtIndex(i)));
                NSBundle frameworkBundle = NSBundle.bundleForName((String)framework);
                if (frameworkBundle == null) {
                    if (NSLog._debugLoggingAllowedForLevelAndGroups((int)2, (long)36L)) {
                        NSLog.debug.appendln((Object)("_IDEProjectPBX.frameworkBundlePaths() -- unable to find an NSBundle named: " + framework));
                    }
                } else {
                    frameworkPathsArray.addObject((Object)frameworkBundle.bundlePath());
                }
                ++i;
            }
        }
        return frameworkPathsArray;
    }

    @Override
    public NSArray frameworkBundlePathURLs() {
        NSArray<String> frameworkArray = this._filesOfTypes(_frameworkArray);
        NSMutableArray frameworkPathsArray = new NSMutableArray();
        int count = frameworkArray.count();
        if (count > 0) {
            int i = 0;
            while (i < count) {
                String framework = NSPathUtilities.lastPathComponent((String)((String)frameworkArray.objectAtIndex(i)));
                NSBundle frameworkBundle = NSBundle.bundleForName((String)framework);
                if (frameworkBundle == null) {
                    if (NSLog._debugLoggingAllowedForLevelAndGroups((int)2, (long)36L)) {
                        NSLog.debug.appendln((Object)("_IDEProjectPBX.frameworkBundlePathURLs() -- unable to find an NSBundle named: " + framework));
                    }
                } else {
                    frameworkPathsArray.addObject((Object)frameworkBundle.bundlePathURL());
                }
                ++i;
            }
        }
        return frameworkPathsArray;
    }

    @Override
    public void addFilenameExtensionToListOfKnowns(String anExtension) {
        String extension;
        NSMutableArray<String> fileTypesArray;
        if (anExtension != null && anExtension.length() > 0 && (fileTypesArray = _fileTypeArray).indexOfObject((Object)(extension = anExtension.startsWith(".") ? anExtension.substring(1) : anExtension)) == -1) {
            fileTypesArray.addObject((Object)extension);
        }
    }

    public void extractResourcesIntoWOProject(_WOProject woProject) {
        NSArray<String> pathArray = this._filesOfTypes((NSArray<String>)_fileTypeArray);
        if (pathArray.count() > 0) {
            int count = pathArray.count();
            int i = 0;
            while (i < count) {
                String resourcePath = (String)pathArray.objectAtIndex(i);
                String name = NSPathUtilities.lastPathComponent((String)resourcePath);
                String language = _WOProject.languageFromResourcePath(resourcePath);
                woProject.addResource(name, resourcePath, language);
                ++i;
            }
        }
    }

    public void _projectFileObserverNotification(NSNotification notification) {
        NSNotificationCenter.defaultCenter().postNotification("TheUnnamedNotification", (Object)this, notification.userInfo());
    }

    public void _openProjectObserverNotification(NSNotification notification) {
        NSNotificationCenter.defaultCenter().postNotification("TheUnnamedNotification", (Object)this, notification.userInfo());
    }

    public void _targetObserverNotification(NSNotification notification) {
        NSNotificationCenter.defaultCenter().postNotification("TheUnnamedNotification", (Object)this, notification.userInfo());
    }

    public void _targetFileObserverNotification(NSNotification notification) {
        NSNotificationCenter.defaultCenter().postNotification("TheUnnamedNotification", (Object)this, notification.userInfo());
    }

    @Override
    public void refreshUnderlyingProjectCache() {
    }

    @Override
    @Deprecated
    public String bundlePath() {
        return null;
    }

    @Override
    public URL bundlePathURL() {
        return null;
    }

    @Override
    public boolean shouldPreloadResources() {
        return true;
    }
}

