/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects._ideservices;

import com.webobjects._ideservices._IDEProject;
import com.webobjects._ideservices._PBProject;
import com.webobjects._ideservices._WOLipsProject;
import com.webobjects._ideservices._WOProject;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSBundle;
import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSPathUtilities;
import java.io.File;
import java.net.URL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class _IDEProjectWOLips
implements _IDEProject {
    private static final String LANGUAGE_RESOURCE_SEPARATOR = "_";
    private volatile _WOLipsProject _wolipsProject;

    public _IDEProjectWOLips(_WOLipsProject wolipsProject) {
        this._wolipsProject = wolipsProject;
    }

    public static _WOLipsProject wolipsProjectFromEclipseProject(String bundlePath) {
        try {
            File eclipseProjectFile;
            File projectFolder;
            _WOLipsProject project = null;
            File bundleFolder = new File(bundlePath);
            File buildFolder = bundleFolder.getParentFile();
            if (buildFolder != null && buildFolder.exists() && (projectFolder = buildFolder.getParentFile()) != null && projectFolder.exists() && (eclipseProjectFile = new File(projectFolder, ".project")).exists()) {
                project = new _WOLipsProject(bundleFolder);
                String bundleName = bundleFolder.getName();
                if (bundleName.endsWith(".framework")) {
                    project.setProjectType("JavaWebObjectsFramework");
                } else {
                    project.setProjectType("JavaWebObjectsApplication");
                }
                project.setProjectName(bundleName.substring(0, bundleName.lastIndexOf(46)));
                project.setProjectDir(bundleFolder.getAbsolutePath());
                project.setProjectVersion("2.8");
            }
            return project;
        }
        catch (Throwable e) {
            throw new NSForwardException(e);
        }
    }

    public static _IDEProjectWOLips wolipsProjectAtPath(String bundlePath) {
        _WOLipsProject project = _IDEProjectWOLips.wolipsProjectFromEclipseProject(bundlePath);
        _IDEProjectWOLips ideProjectWOLips = null;
        if (project != null) {
            ideProjectWOLips = new _IDEProjectWOLips(project);
        }
        return ideProjectWOLips;
    }

    @Override
    public void addComponent(String componentDirectoryString, String javaFileString) {
        this.addFileKey(javaFileString, "CLASSES");
        this.addFileKey(componentDirectoryString, "WO_COMPONENTS");
    }

    @Override
    public void addFileKey(String file, String key) {
        String projectName = NSPathUtilities.lastPathComponent((String)this._wolipsProject.projectDir());
        String newKey = key;
        if (key.equals("WO_COMPONENTS")) {
            newKey = "WEBCOMPONENTS";
        } else if (key.equals("EJB_META_INFO")) {
            newKey = "RESOURCES";
        } else if (key.equals("EJB_SERVER_CLASSES")) {
            projectName = String.valueOf(projectName) + "/EJBServer";
            newKey = "CLASSES";
        } else if (key.equals("EJB_CLIENT_CLASSES")) {
            projectName = String.valueOf(projectName) + "/EJBClient";
            newKey = "CLASSES";
        } else if (key.equals("EJB_COMMON_CLASSES")) {
            newKey = "CLASSES";
        }
        _WOLipsProject.addFileToPBBucket(projectName, file, newKey);
    }

    @Override
    public void addFilenameExtensionToListOfKnowns(String anExtension) {
    }

    @Override
    @Deprecated
    public String bundlePath() {
        String path = null;
        String projectType = this._wolipsProject.projectTypeName();
        if (projectType.equalsIgnoreCase("JavaWebObjectsFramework")) {
            path = NSBundle.bundleForName((String)this._wolipsProject.projectName()).bundlePath();
        } else if (projectType.equalsIgnoreCase("JavaWebObjectsApplication")) {
            path = NSBundle.mainBundle().bundlePath();
        }
        return NSPathUtilities.stringByNormalizingExistingPath((String)path);
    }

    @Override
    public URL bundlePathURL() {
        URL path = null;
        String projectType = this._wolipsProject.projectTypeName();
        if (projectType.equalsIgnoreCase("JavaWebObjectsFramework")) {
            path = NSBundle.bundleForName((String)this._wolipsProject.projectName()).bundlePathURL();
        } else if (projectType.equalsIgnoreCase("JavaWebObjectsApplication")) {
            path = NSBundle.mainBundle().bundlePathURL();
        }
        return path;
    }

    @Override
    public void extractFilesIntoWOProject(_WOProject woProject) {
        this.extractFilesFromProjectIntoWOProject(this._wolipsProject, woProject);
    }

    private void extractFilesFromProjectIntoWOProject(_WOLipsProject project, _WOProject woProject) {
        if (project == null) {
            return;
        }
        this.extractFilesForKeyFromProjectIntoWOProject("H_FILES", project, woProject);
        this.extractFilesForKeyFromProjectIntoWOProject("WOAPP_RESOURCES", project, woProject);
        this.extractFilesForKeyFromProjectIntoWOProject("CLASSES", project, woProject);
        this.extractFilesForKeyFromProjectIntoWOProject("OTHER_LINKED", project, woProject);
        if (woProject.includeFrameworks()) {
            this.extractFrameworksFromProjectIntoWOProject(project, woProject);
        }
        this.extractResourcesFromProjectIntoWOProject(project, woProject);
        this.extractEOModelsFromProjectIntoWOProject(project, woProject);
        NSArray subProjects = project.parseSubprojects();
        if (subProjects != null) {
            for (_PBProject _lpbproject : subProjects) {
                if (!(_lpbproject instanceof _WOLipsProject)) continue;
                this.extractFilesFromProjectIntoWOProject((_WOLipsProject)_lpbproject, woProject);
            }
        }
    }

    private void extractFrameworksFromProjectIntoWOProject(_WOLipsProject project, _WOProject woProject) {
        NSMutableArray<String> frameworks = project.fileListForKey("FRAMEWORKS", false);
        if (frameworks != null) {
            for (String name : frameworks) {
                woProject.extractFrameworkNamed(name);
            }
        }
    }

    private void extractEOModelsFromProjectIntoWOProject(_WOLipsProject project, _WOProject woProject) {
        String[] stringArray = new String[3];
        stringArray[0] = "OTHER_RESOURCES";
        stringArray[1] = "RESOURCES";
        String[] keys = stringArray;
        int i = 0;
        while (keys[i] != null) {
            NSMutableArray<String> resources = project.fileListForKey(keys[i], false);
            if (resources != null) {
                for (String name : resources) {
                    if (!"eomodeld".equals(NSPathUtilities.pathExtension((String)name))) continue;
                    String modelPath = String.valueOf(project.contentsFolder().getAbsolutePath()) + File.separator + "Resources" + File.separator + name;
                    woProject.addModelFilePath(modelPath);
                }
            }
            ++i;
        }
    }

    private void extractResourcesFromProjectIntoWOProject(_WOLipsProject project, _WOProject woProject) {
        NSMutableDictionary<String, NSMutableArray<String>> filesTable = project.filesTable();
        for (String fileKey : filesTable.allKeys()) {
            if (!fileKey.endsWith("WEBSERVER_RESOURCES") && !fileKey.endsWith("WOAPP_RESOURCES") && !fileKey.endsWith("OTHER_RESOURCES") && !fileKey.endsWith("WO_COMPONENTS")) continue;
            this.extractResourcesFromProjectWithKeyIntoWOProject(project, fileKey, woProject);
        }
    }

    private void extractResourcesFromProjectWithKeyIntoWOProject(_WOLipsProject project, String key, _WOProject woProject) {
        String basePath = "WEBSERVER_RESOURCES".equals(key) ? String.valueOf(project.contentsFolder().getAbsolutePath()) + File.separator + "WebServerResources" : ("WOAPP_RESOURCES".equals(key) ? String.valueOf(project.contentsFolder().getAbsolutePath()) + File.separator + "Resources" : ("OTHER_RESOURCES".equals(key) ? String.valueOf(project.contentsFolder().getAbsolutePath()) + File.separator + "Resources" : ("WO_COMPONENTS".equals(key) ? String.valueOf(project.contentsFolder().getAbsolutePath()) + File.separator + "Resources" : project.contentsFolder().getAbsolutePath())));
        NSMutableArray<String> fileList = project.fileListForKey(key, false);
        if (fileList != null) {
            String language = null;
            for (String filename : fileList) {
                language = _WOProject.languageFromResourcePath(filename);
                String parentDir = _WOProject.resourcePathByAppendingLanguageFileName(basePath, language, "");
                String resourcePath = String.valueOf(basePath) + File.separator + filename;
                File resourceFile = new File(resourcePath);
                if (NSPathUtilities.pathExtension((String)filename).length() <= 0 && resourceFile.exists() && resourceFile.isDirectory()) {
                    woProject.extractResourcesFromPath(parentDir, filename);
                    continue;
                }
                woProject.addResource(filename, resourcePath, language);
            }
        }
    }

    private void extractFilesForKeyFromProjectIntoWOProject(String projectKey, _WOLipsProject project, _WOProject woProject) {
        NSMutableArray<String> fileList = project.fileListForKey(projectKey, false);
        if (fileList != null) {
            for (String fileName : fileList) {
                if (!"java".equals(NSPathUtilities.pathExtension((String)fileName))) continue;
                String filePath = String.valueOf(project.projectDir()) + File.separator + fileName;
                woProject.addInterfaceFilePath(filePath);
            }
        }
    }

    public NSArray<URL> frameworkBundlePathURLs() {
        NSMutableArray frameworkPaths = new NSMutableArray();
        NSMutableArray<String> frameworkNames = this._wolipsProject.fileListForKey("FRAMEWORKS", false);
        if (frameworkNames != null) {
            for (String name : frameworkNames) {
                NSBundle frameworkBundle = NSBundle.bundleForName((String)name);
                if (frameworkBundle == null) continue;
                frameworkPaths.addObject((Object)frameworkBundle.bundlePathURL());
            }
        }
        return frameworkPaths;
    }

    @Deprecated
    public NSArray<String> frameworkBundlePaths() {
        NSMutableArray frameworkPaths = new NSMutableArray();
        NSMutableArray<String> frameworkNames = this._wolipsProject.fileListForKey("FRAMEWORKS", false);
        if (frameworkNames != null) {
            for (String name : frameworkNames) {
                NSBundle frameworkBundle = NSBundle.bundleForName((String)name);
                if (frameworkBundle == null) continue;
                frameworkPaths.addObject((Object)frameworkBundle.bundlePath());
            }
        }
        return frameworkPaths;
    }

    @Override
    public String ideApplicationName() {
        return "unimplemented";
    }

    @Override
    public String ideProjectPath() {
        return NSPathUtilities.stringByNormalizingExistingPath((String)this._wolipsProject.projectDir());
    }

    @Override
    public String languageDir() {
        return this._wolipsProject.languageDir();
    }

    @Override
    public String languageName() {
        return this._wolipsProject.languageName();
    }

    @Override
    public void openFile(String filename, int lineNumber, String message) {
        _WOLipsProject.openFile(filename, lineNumber, message);
    }

    @Override
    public String pathForFrameworkNamed(String fwName) {
        return "unimplemented";
    }

    @Override
    public String pathToBucket(String key) {
        if (key.equals("EJB_META_INFO")) {
            return "";
        }
        if (key.equals("EJB_SERVER_CLASSES")) {
            return "EJBServer.subproj";
        }
        if (key.equals("EJB_CLIENT_CLASSES")) {
            return "EJBClient.subproj";
        }
        if (key.equals("EJB_COMMON_CLASSES")) {
            return "";
        }
        return "";
    }

    @Override
    public String projectDir() {
        return NSPathUtilities.stringByNormalizingExistingPath((String)this._wolipsProject.projectDir());
    }

    @Override
    public String projectDirNotNormalized() {
        return this._wolipsProject.projectDir();
    }

    @Override
    public String projectName() {
        return this._wolipsProject.projectName();
    }

    @Override
    public String projectTypeName() {
        return this._wolipsProject.projectTypeName();
    }

    @Override
    public void refreshUnderlyingProjectCache() {
        this._wolipsProject.refreshIfNecessary();
    }

    @Override
    public void setPathForFramework(String path, String fwName) {
    }

    private String _languageFromKey(String fileKey) {
        int i;
        String language = "";
        String suffix = null;
        if (fileKey.endsWith("WEBSERVER_RESOURCES")) {
            suffix = "WEBSERVER_RESOURCES";
        } else if (fileKey.endsWith("WOAPP_RESOURCES")) {
            suffix = "WOAPP_RESOURCES";
        } else if (fileKey.endsWith("OTHER_RESOURCES")) {
            suffix = "OTHER_RESOURCES";
        } else if (fileKey.endsWith("WO_COMPONENTS")) {
            suffix = "WO_COMPONENTS";
        }
        if (suffix != null) {
            language = fileKey.substring(0, fileKey.indexOf(suffix));
        }
        if ((i = language.indexOf(LANGUAGE_RESOURCE_SEPARATOR)) > 0) {
            language = language.substring(0, i);
        }
        return language;
    }

    @Override
    public boolean shouldPreloadResources() {
        return true;
    }
}

