/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects._ideservices;

import com.webobjects._ideservices._IDEProject;
import com.webobjects._ideservices._WOProject;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSBundle;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSPathUtilities;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class _WOAntProject
implements _IDEProject {
    private static String _projectPath = null;
    private static String _normalizedProjectPath = null;
    private static String _buildFilePath = null;
    private static String _projectName = null;
    private static String _resourcesDir = null;
    private static String _webserverResourcesDir = null;
    private static NSMutableArray _frameworkBundlePaths = null;

    public _WOAntProject(String projectPath) {
        _projectPath = projectPath;
        _normalizedProjectPath = NSPathUtilities.stringByNormalizingExistingPath((String)_projectPath);
        _buildFilePath = String.valueOf(_normalizedProjectPath) + File.separator + "build.xml";
        _resourcesDir = String.valueOf(_normalizedProjectPath) + File.separator + "wo-resources" + File.separator + "Resources";
        _webserverResourcesDir = String.valueOf(_normalizedProjectPath) + File.separator + "wo-resources" + File.separator + "WebServerResources";
        _frameworkBundlePaths = new NSMutableArray();
    }

    public static _WOAntProject antProjectAtPath(String path) {
        int nameLength;
        if (path.endsWith(".jar") || path.endsWith(".framework")) {
            return null;
        }
        String mainBundleName = NSBundle.mainBundle().name();
        int idx = path.indexOf(mainBundleName);
        String projDir = path.substring(0, idx + (nameLength = mainBundleName.length()));
        if (!(projDir == null || projDir.endsWith(".woa") || _WOAntProject.pathContainsAntBuildFile(projDir) && _WOAntProject.pathContainsWOResources(projDir))) {
            return null;
        }
        return new _WOAntProject(projDir);
    }

    private static boolean pathContainsAntBuildFile(String path) {
        boolean fileExists = false;
        try {
            File file = new File(String.valueOf(path) + File.separator + "build.xml");
            fileExists = file.exists() && file.isFile();
        }
        catch (Exception e) {
            return false;
        }
        return fileExists;
    }

    private static boolean pathContainsWOResources(String path) {
        boolean fileExists = false;
        try {
            File file = new File(String.valueOf(path) + File.separator + "wo-resources");
            fileExists = file.exists() && file.isDirectory();
        }
        catch (Exception e) {
            return false;
        }
        return fileExists;
    }

    public String projectDir() {
        return _normalizedProjectPath;
    }

    public String projectDirNotNormalized() {
        return _projectPath;
    }

    public String languageDir() {
        return "languageDir unimplemented";
    }

    public String projectName() {
        if (_projectName == null) {
            _projectName = this.extractProjectName(_buildFilePath);
        }
        return _projectName;
    }

    public String projectTypeName() {
        return "WebObjects Application";
    }

    public String languageName() {
        return "languageName unimplemented";
    }

    public void addComponent(String componentDirectoryString, String javaFileString) {
    }

    public String pathToBucket(String aKey) {
        return null;
    }

    public void addFileKey(String aFile, String aKey) {
    }

    public void openFile(String aFile, int lineNumber, String message) {
    }

    public String pathForFrameworkNamed(String fwName) {
        return null;
    }

    public void setPathForFramework(String path, String fwName) {
    }

    public void extractFilesIntoWOProject(_WOProject woProject) {
        File rf2;
        try {
            rf2 = new File(_resourcesDir);
            this.extractResourceFilesIntoWOProject(woProject, rf2);
        }
        catch (Exception rf2) {
            // empty catch block
        }
        try {
            rf2 = new File(_webserverResourcesDir);
            this.extractResourceFilesIntoWOProject(woProject, rf2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void extractResourceFilesIntoWOProject(_WOProject woproject, File startingDir) {
        List<File> filesDirs = Arrays.asList(startingDir.listFiles());
        for (File file : filesDirs) {
            try {
                woproject.addResourcePath(file.getCanonicalPath());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (!file.isDirectory()) continue;
            this.extractResourceFilesIntoWOProject(woproject, file);
        }
    }

    public String ideApplicationName() {
        return null;
    }

    public String ideProjectPath() {
        return this.projectDir();
    }

    @Deprecated
    public NSArray frameworkBundlePaths() {
        return _frameworkBundlePaths;
    }

    public NSArray frameworkBundlePathURLs() {
        return _frameworkBundlePaths;
    }

    public void addFilenameExtensionToListOfKnowns(String anExtension) {
    }

    public void refreshUnderlyingProjectCache() {
    }

    @Deprecated
    public String bundlePath() {
        return NSBundle.mainBundle().bundlePath();
    }

    public URL bundlePathURL() {
        return NSBundle.mainBundle().bundlePathURL();
    }

    public Document documentForFile(String filePath) {
        Document document = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            File file = new File(filePath);
            document = builder.parse(file);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return document;
    }

    public String extractProjectName(String filePath) {
        String projectName = "";
        try {
            Document doc = this.documentForFile(filePath);
            NodeList list = doc.getElementsByTagName("project");
            Node aNode = null;
            NamedNodeMap map = null;
            int i = 0;
            while (i < list.getLength()) {
                aNode = list.item(i);
                map = aNode.getAttributes();
                projectName = this._parseNodeMap(map, "name");
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return projectName;
    }

    private String _parseNodeMap(NamedNodeMap map, String attName) {
        Node aNode = null;
        int i = 0;
        while (i < map.getLength()) {
            aNode = map.item(i);
            if (aNode.getNodeName().equals(attName)) {
                return aNode.getNodeValue();
            }
            ++i;
        }
        return null;
    }

    public boolean shouldPreloadResources() {
        return true;
    }
}

