/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.woenvironment.pb;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.objectstyle.woenvironment.plist.PropertyListParserException;
import org.objectstyle.woenvironment.plist.WOLPropertyListSerialization;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PBProject {
    public static final String DEFAULT_APP_PROJECT = "pbindex/woapp/PB.project";
    public static final String DEFAULT_FRAMEWORK_PROJECT = "pbindex/woframework/PB.project";
    public static final String DYNAMIC_CODE_GEN = "DYNAMIC_CODE_GEN";
    public static final String FILESTABLE = "FILESTABLE";
    public static final String CLASSES = "CLASSES";
    public static final String FRAMEWORKS = "FRAMEWORKS";
    public static final String FRAMEWORKSEARCH = "FRAMEWORKSEARCH";
    public static final String OTHER_LINKED = "OTHER_LINKED";
    public static final String OTHER_SOURCES = "OTHER_SOURCES";
    public static final String WOAPP_RESOURCES = "WOAPP_RESOURCES";
    public static final String WOCOMPONENTS = "WO_COMPONENTS";
    public static final String WEB_SERVER_RESOURCES = "WEBSERVER_RESOURCES";
    public static final String PROJECTNAME = "PROJECTNAME";
    public static final String PROJECTTYPE = "PROJECTTYPE";
    public static final String PROJECTVERSION = "PROJECTVERSION";
    public static final String SUBPROJECTS = "SUBPROJECTS";
    public static final String YES = "YES";
    public static final String NO = "NO";
    protected boolean isFramework;
    protected String pathToProjectFile;
    protected Map pbProject;
    protected Map filesTable;

    public PBProject(boolean bl) throws IOException, PropertyListParserException {
        this("PB.project", bl);
    }

    public PBProject(String string, boolean bl) throws IOException, PropertyListParserException {
        this.pathToProjectFile = string;
        this.isFramework = bl;
        if (string == null) {
            throw new NullPointerException("Path to project file is null.");
        }
        this.update();
    }

    public String getDefaultTemplate() {
        return this.isFramework ? DEFAULT_FRAMEWORK_PROJECT : DEFAULT_APP_PROJECT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() throws IOException, PropertyListParserException {
        File file = null;
        InputStream inputStream = null;
        try {
            file = new File(this.pathToProjectFile);
            inputStream = !file.exists() ? this.getClass().getClassLoader().getResourceAsStream(this.getDefaultTemplate()) : new FileInputStream(file);
            this.pbProject = (Map)WOLPropertyListSerialization.propertyListFromStream(inputStream);
        }
        finally {
            file = null;
            if (inputStream != null) {
                inputStream.close();
            }
            inputStream = null;
        }
        if (this.pbProject == null) {
            throw new IOException("Error reading project file: " + this.pathToProjectFile);
        }
        this.readFilesTable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveChanges() throws PropertyListParserException, IOException {
        this.saveFilesTable();
        Map map = this.sortedMap(this.pbProject);
        File file = null;
        try {
            file = new File(this.pathToProjectFile);
            WOLPropertyListSerialization.propertyListToFile("", file, map);
        }
        finally {
            file = null;
        }
    }

    private Map sortedMap(Map map) {
        TreeMap treeMap = new TreeMap(map);
        for (Map.Entry entry : treeMap.entrySet()) {
            Object v = entry.getValue();
            if (v instanceof List) {
                entry.setValue(this.sortedList((List)v));
                continue;
            }
            if (!(v instanceof Map)) continue;
            entry.setValue(this.sortedMap((Map)v));
        }
        return treeMap;
    }

    private List sortedList(List list) {
        LinkedList<Object> linkedList = new LinkedList<Object>(list);
        int n = linkedList.size();
        for (int i = 0; i < n; ++i) {
            Object e = linkedList.get(i);
            if (e instanceof List) {
                linkedList.set(i, this.sortedList((List)e));
                continue;
            }
            if (!(e instanceof Map)) continue;
            linkedList.set(i, this.sortedMap((Map)e));
        }
        Collections.sort(linkedList);
        return linkedList;
    }

    public boolean isDynamicCodeGen() {
        return YES.equals(this.pbProject.get(DYNAMIC_CODE_GEN));
    }

    public void setDynamicCodeGen(boolean bl) {
        String string = bl ? YES : NO;
        this.pbProject.put(DYNAMIC_CODE_GEN, string);
    }

    public List getClasses() {
        return (List)this.getFilesTable().get(CLASSES);
    }

    public void setClasses(List list) {
        this.getFilesTable().put(CLASSES, list);
    }

    public List getWebServerResources() {
        return (List)this.getFilesTable().get(WEB_SERVER_RESOURCES);
    }

    public void setWebServerResources(List list) {
        this.getFilesTable().put(WEB_SERVER_RESOURCES, list);
    }

    public List getWebServerResources(String string) {
        if (string == null) {
            return this.getWebServerResources();
        }
        return (List)this.getFilesTable().get(string + "_" + WEB_SERVER_RESOURCES);
    }

    public void setWebServerResources(List list, String string) {
        if (string == null) {
            this.setWebServerResources(list);
            return;
        }
        this.getFilesTable().put(string + "_" + WEB_SERVER_RESOURCES, list);
    }

    public List<String> getFrameworkSearch() {
        return (List)this.pbProject.get(FRAMEWORKSEARCH);
    }

    public void setFrameworkSearch(List list) {
        this.pbProject.put(FRAMEWORKSEARCH, list);
    }

    public List getFrameworks() {
        return (List)this.getFilesTable().get(FRAMEWORKS);
    }

    public void setFrameworks(List list) {
        this.getFilesTable().put(FRAMEWORKS, list);
    }

    public List getSubprojects() {
        return (List)this.getFilesTable().get(SUBPROJECTS);
    }

    public void setSubprojects(List list) {
        this.getFilesTable().put(SUBPROJECTS, list);
    }

    public List getOtherLinked() {
        return (List)this.getFilesTable().get(OTHER_LINKED);
    }

    public void setOtherLinked(List list) {
        this.getFilesTable().put(OTHER_LINKED, list);
    }

    public List getOtherSources() {
        return (List)this.getFilesTable().get(OTHER_SOURCES);
    }

    public void setOtherSources(List list) {
        this.getFilesTable().put(OTHER_SOURCES, list);
    }

    public List getWoAppResources() {
        return (List)this.getFilesTable().get(WOAPP_RESOURCES);
    }

    public void setWoAppResources(List list) {
        this.getFilesTable().put(WOAPP_RESOURCES, list);
    }

    public List getWoAppResources(String string) {
        if (string == null) {
            return this.getWoAppResources();
        }
        return (List)this.getFilesTable().get(string + "_" + WOAPP_RESOURCES);
    }

    public void setWoAppResources(List list, String string) {
        if (string == null) {
            this.setWoAppResources(list);
            return;
        }
        this.getFilesTable().put(string + "_" + WOAPP_RESOURCES, list);
    }

    public List getWoComponents() {
        return (List)this.getFilesTable().get(WOCOMPONENTS);
    }

    public void setWoComponents(List list) {
        this.getFilesTable().put(WOCOMPONENTS, list);
    }

    public List getWoComponents(String string) {
        if (string == null) {
            return this.getWoComponents();
        }
        return (List)this.getFilesTable().get(string + "_" + WOCOMPONENTS);
    }

    public void setWoComponents(List list, String string) {
        if (string == null) {
            this.setWoComponents(list);
            return;
        }
        this.getFilesTable().put(string + "_" + WOCOMPONENTS, list);
    }

    public String getProjectName() {
        return (String)this.pbProject.get(PROJECTNAME);
    }

    public void setProjectName(String string) {
        this.pbProject.put(PROJECTNAME, string);
    }

    public String getProjectType() {
        return (String)this.pbProject.get(PROJECTTYPE);
    }

    public void setProjectType(String string) {
        this.pbProject.put(PROJECTTYPE, string);
    }

    public String getProjectVersion() {
        return (String)this.pbProject.get(PROJECTVERSION);
    }

    public void setProjectVersion(String string) {
        this.pbProject.put(PROJECTVERSION, string);
    }

    protected Map getFilesTable() {
        return this.filesTable;
    }

    protected void saveFilesTable() {
        this.pbProject.put(FILESTABLE, this.filesTable);
    }

    protected void readFilesTable() {
        this.filesTable = (Map)this.pbProject.get(FILESTABLE);
    }

    public void forgetAllFiles() {
        this.setClasses(new ArrayList());
        this.setOtherLinked(new ArrayList());
        this.setOtherSources(new ArrayList());
        this.setWebServerResources(new ArrayList());
        this.setWoComponents(new ArrayList());
    }

    public String getPathToProjectFile() {
        return this.pathToProjectFile;
    }

    public void setPathToProjectFile(String string) {
        this.pathToProjectFile = string;
    }
}

