/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.woproject.ant;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.objectstyle.woproject.ant.JApplicationJavaWorker;
import org.objectstyle.woproject.ant.JApplicationMacWorker;
import org.objectstyle.woproject.ant.JApplicationWindowsWorker;
import org.objectstyle.woproject.ant.JApplicationWorker;

public class JApplication
extends Task {
    public static final String WINDOWS_OS = "windows";
    public static final String MAC_OS = "mac";
    public static final String JAVA_OS = "java";
    protected String name;
    protected String mainClass;
    protected String os;
    protected File destDir;
    protected String longName;
    protected File icon;
    protected String jvm;
    protected String jvmOptions;
    protected String version;
    protected Collection libs = new ArrayList();

    public String getDefaultOs() {
        String string = System.getProperty("os.name").toUpperCase();
        if (string.startsWith("WINDOWS")) {
            return WINDOWS_OS;
        }
        if (string.startsWith("MAC")) {
            return MAC_OS;
        }
        return JAVA_OS;
    }

    public void execute() throws BuildException {
        this.validate();
        this.initDefaults();
        this.log("Building Java Application '" + this.name + "', os: " + this.os + ", dir: " + this.destDir);
        JApplicationWorker jApplicationWorker = WINDOWS_OS.equals(this.os) ? new JApplicationWindowsWorker() : (MAC_OS.equals(this.os) ? new JApplicationMacWorker() : new JApplicationJavaWorker());
        jApplicationWorker.execute(this);
    }

    protected void validate() throws BuildException {
        if (this.isBlankString(this.name)) {
            throw new BuildException("'name' attribute is required");
        }
        this.validateMainClass();
    }

    protected void validateMainClass() throws BuildException {
        if (this.isBlankString(this.mainClass)) {
            throw new BuildException("'mainClass' attribute is required");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(this.mainClass, ".");
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            for (int i = 0; i < string.length(); ++i) {
                if (!(i == 0 ? !Character.isJavaIdentifierStart(string.charAt(0)) : !Character.isJavaIdentifierPart(string.charAt(i)))) continue;
                throw new BuildException("Invalid java class name: " + this.mainClass);
            }
        }
    }

    protected void validateOs() throws BuildException {
        if (!(this.os == null || this.os.equals(WINDOWS_OS) || this.os.equals(MAC_OS) || this.os.equals(JAVA_OS))) {
            throw new BuildException("Unsupported OS: " + this.os + ", only the following are supported: " + WINDOWS_OS + "," + MAC_OS + "," + JAVA_OS);
        }
    }

    protected Task createSubtask(Class clazz) throws BuildException {
        Task task;
        if (clazz == null) {
            throw new IllegalArgumentException("Null subtask class");
        }
        if (!Task.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Invalid subtask class, must be a subclass of Task: " + clazz.getName());
        }
        try {
            task = (Task)clazz.newInstance();
        }
        catch (Exception exception) {
            throw new BuildException("Can't create subtask: " + clazz.getName());
        }
        task.setOwningTarget(this.getOwningTarget());
        task.setProject(this.getProject());
        task.setTaskName(this.getTaskName());
        task.setLocation(this.getLocation());
        return task;
    }

    protected void initDefaults() {
        if (this.longName == null) {
            this.longName = this.name;
        }
        if (this.destDir == null) {
            this.destDir = this.getProject().getBaseDir();
        }
        if (this.os == null) {
            this.os = this.getDefaultOs();
        }
        if (this.version == null) {
            this.version = "0.0";
        }
        if (this.jvm == null) {
            this.jvm = "1.4+";
        }
    }

    private boolean isBlankString(String string) {
        return string == null || string.trim().length() == 0;
    }

    public Collection getLibs() {
        return this.libs;
    }

    public void addLib(FileSet fileSet) {
        this.libs.add(fileSet);
    }

    public void setDestDir(File file) {
        this.destDir = file;
    }

    public void setIcon(File file) {
        this.icon = file;
    }

    public void setJvm(String string) {
        this.jvm = string;
    }

    public void setJvmOptions(String string) {
        this.jvmOptions = string;
    }

    public void setLongName(String string) {
        this.longName = string;
    }

    public void setMainClass(String string) {
        this.mainClass = string;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setOs(String string) {
        this.os = string;
    }

    public File getDestDir() {
        return this.destDir;
    }

    public File getIcon() {
        return this.icon;
    }

    public String getJvm() {
        return this.jvm;
    }

    public String getJvmOptions() {
        return this.jvmOptions;
    }

    public String getLongName() {
        return this.longName;
    }

    public String getMainClass() {
        return this.mainClass;
    }

    public String getName() {
        return this.name;
    }

    public String getOs() {
        return this.os;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String string) {
        this.version = string;
    }
}

