/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.woproject.ant;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.FilterSet;
import org.apache.tools.ant.types.FilterSetCollection;
import org.objectstyle.woproject.ant.WOTask;

public abstract class ProjectFormat {
    protected WOTask task;

    public ProjectFormat(WOTask wOTask) {
        this.task = wOTask;
    }

    public String getName() {
        return this.task.getName();
    }

    public String getVersion() {
        return this.task.getVersion();
    }

    public String getCFBundleVersion() {
        return this.task.getCFBundleVersion();
    }

    public String getCFBundleShortVersion() {
        return this.task.getCFBundleShortVersion();
    }

    public String getCFBundleID() {
        return this.task.getCFBundleID();
    }

    public String getJavaVersion() {
        return this.task.getJavaVersion();
    }

    public String getJarName() {
        return this.task.getJarName() + ".jar";
    }

    public boolean processTemplates() throws BuildException {
        Iterator iterator = this.fileIterator();
        boolean bl = false;
        try {
            ClassLoader classLoader = ((Object)((Object)this.task)).getClass().getClassLoader();
            if (classLoader == null) {
                throw new BuildException("Could not load classloader");
            }
            while (iterator.hasNext()) {
                File file;
                String string = (String)iterator.next();
                String string2 = this.templateForTarget(string);
                FilterSetCollection filterSetCollection = this.filtersForTarget(string);
                InputStream inputStream = classLoader.getResourceAsStream(string2);
                if (!this.copyFile(inputStream, file = new File(string), filterSetCollection)) continue;
                bl = true;
            }
        }
        catch (IOException iOException) {
            throw new BuildException("Error doing project formatting.", (Throwable)iOException);
        }
        finally {
            iterator = null;
        }
        return bl;
    }

    public abstract Iterator fileIterator();

    public abstract String templateForTarget(String var1) throws BuildException;

    public abstract FilterSetCollection filtersForTarget(String var1) throws BuildException;

    public boolean copyFile(InputStream inputStream, File file, FilterSetCollection filterSetCollection) throws IOException {
        File file2;
        this.log("destFile.getName(): " + file.getName() + " this.getName(): " + this.getName(), 3);
        if (file.exists() && file.isFile() && file.getName().equals(this.getName())) {
            inputStream.close();
            return false;
        }
        if (file.exists() && file.isFile()) {
            file.delete();
        }
        if (!(file2 = new File(file.getParent())).exists()) {
            file2.mkdirs();
        }
        if (filterSetCollection != null && filterSetCollection.hasFilters()) {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
            this.log("filters: " + filterSetCollection, 3);
            String string = null;
            String string2 = bufferedReader.readLine();
            while (string2 != null) {
                if (string2.length() == 0) {
                    bufferedWriter.newLine();
                } else {
                    this.log("line: " + string2, 3);
                    string = filterSetCollection.replaceTokens(string2);
                    this.log("newline: " + string, 3);
                    bufferedWriter.write(string);
                    bufferedWriter.newLine();
                }
                string2 = bufferedReader.readLine();
            }
            bufferedWriter.close();
            bufferedReader.close();
        } else {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            byte[] byArray = new byte[8192];
            int n = 0;
            do {
                fileOutputStream.write(byArray, 0, n);
            } while ((n = inputStream.read(byArray, 0, byArray.length)) != -1);
            inputStream.close();
            fileOutputStream.close();
        }
        return file.getName().equals(this.getName());
    }

    private String libString(Iterator iterator) {
        String string = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<array>");
        if (this.task.hasClasses()) {
            stringBuffer.append(string).append("\t\t<string>").append(this.getJarName()).append("</string>");
        }
        if (iterator != null) {
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                stringBuffer.append(string).append("\t\t<string>");
                stringBuffer.append(string2);
                stringBuffer.append("</string>");
            }
        }
        stringBuffer.append(string).append("\t</array>");
        return stringBuffer.toString();
    }

    private String principalClassString() {
        String string = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer();
        if (this.task.getPrincipalClass() != null && this.task.getPrincipalClass().length() > 0) {
            stringBuffer.append("<key>NSPrincipalClass</key>").append(string);
            stringBuffer.append("\t<string>").append(this.task.getPrincipalClass()).append("</string>").append(string);
        }
        return stringBuffer.toString();
    }

    private String getCustomInfoPListContent() {
        String string = this.task.getCustomInfoPListContent();
        if (string != null) {
            return string;
        }
        return "";
    }

    public FilterSetCollection infoFilter(Iterator iterator) {
        FilterSet filterSet = new FilterSet();
        filterSet.addFilter("PRINCIPAL_CLASS", this.principalClassString());
        filterSet.addFilter("NAME", this.getName());
        filterSet.addFilter("VERSION", this.getVersion());
        filterSet.addFilter("JAVA_VERSION", this.getJavaVersion());
        filterSet.addFilter("JAR_NAME", this.getJarName());
        filterSet.addFilter("JAR_ARRAY", this.libString(iterator));
        filterSet.addFilter("CUSTOM_CONTENT", this.getCustomInfoPListContent());
        filterSet.addFilter("HAS_COMPONENTS", "<" + this.hasComponents() + "/>");
        filterSet.addFilter("CFBUNDLE_VERSION", this.getCFBundleVersion());
        filterSet.addFilter("CFBUNDLE_SHORTVERSION", this.getCFBundleShortVersion());
        filterSet.addFilter("CFBUNDLE_IDENTIFIER", this.getCFBundleID());
        return new FilterSetCollection(filterSet);
    }

    private boolean hasComponents() {
        return this.task.getHasComponents();
    }

    public void log(String string) {
        this.task.log(string);
    }

    public void log(String string, int n) {
        this.task.log(string, n);
    }

    public void release() {
        this.task = null;
    }
}

