/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.woproject.ant;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.Chmod;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.taskdefs.Jar;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.PatternSet;
import org.apache.tools.ant.types.ZipFileSet;
import org.apache.tools.ant.types.selectors.FilenameSelector;
import org.objectstyle.woenvironment.env.WOBuildPropertiesNotFoundException;
import org.objectstyle.woenvironment.env.WOEnvironment;
import org.objectstyle.woproject.ant.AppFormat;
import org.objectstyle.woproject.ant.FrameworkSet;
import org.objectstyle.woproject.ant.OtherClasspathSet;
import org.objectstyle.woproject.ant.WOTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WOApplication
extends WOTask {
    protected List<FrameworkSet> frameworkSets = new ArrayList<FrameworkSet>();
    protected List<OtherClasspathSet> otherClasspathSets = new ArrayList<OtherClasspathSet>();
    private WOEnvironment woEnvironment;
    protected String chmod = "750";
    protected String jvmOptions = "";
    protected String jvm = "java";
    protected String jdb = "jdb";
    protected String jdbOptions = "";
    protected boolean webXML = false;
    protected String webXML_WOROOT = null;
    protected String webXML_LOCALROOT = null;
    protected String webXML_WOAINSTALLROOT = null;
    protected String webXML_WOAppMode = null;
    protected String webXML_WOtaglib = null;
    protected String webXML_CustomContent = null;
    protected String startupScriptName = null;
    protected String frameworksBaseURL = null;
    protected boolean trueWar = false;

    @Override
    public void release() {
        super.release();
        this.frameworkSets = null;
        this.otherClasspathSets = null;
        this.woEnvironment = null;
    }

    public void setTrueWar(boolean bl) {
        this.trueWar = bl;
    }

    public boolean isTrueWar() {
        return this.trueWar;
    }

    @Override
    public String getPrincipalClass() {
        String string = super.getPrincipalClass();
        if (string == null || string.length() == 0) {
            string = "Application";
        }
        return string;
    }

    public void execute() throws BuildException {
        AppFormat appFormat;
        super.execute();
        this.validateAttributes();
        this.log("Installing " + this.name + " in " + this.destDir);
        this.createDirectories();
        if (this.hasClasses()) {
            this.jarClasses();
        }
        if (this.hasSources()) {
            this.jarSources();
        }
        if (this.hasLib()) {
            this.copyLibs();
        }
        if (this.hasResources()) {
            this.copyResources();
        }
        if (this.hasWs()) {
            this.copyWsresources();
        }
        if (this.hasEmbeddedFrameworks()) {
            this.copyEmbeddedFrameworks();
        }
        if (this.hasEmbeddedOtherClasspaths()) {
            this.copyEmbeddedOtherClasspaths();
        }
        if ((appFormat = new AppFormat(this)).processTemplates()) {
            this.chmodScripts();
        }
        appFormat.release();
        this.frameworkSets = new ArrayList<FrameworkSet>();
        this.otherClasspathSets = new ArrayList<OtherClasspathSet>();
        this.woEnvironment = null;
        this.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void chmodScripts() throws BuildException {
        if (System.getProperty("os.name").toLowerCase().indexOf("win") < 0) {
            File file = null;
            FileSet fileSet = null;
            Chmod chmod = null;
            try {
                file = this.taskDir();
                super.log("chmod scripts in " + file, 3);
                fileSet = new FileSet();
                fileSet.setDir(file);
                fileSet.createInclude().setName("**/" + this.name);
                if (this.startupScriptName != null) {
                    fileSet.createInclude().setName("**/" + this.startupScriptName);
                }
                fileSet.createInclude().setName("**/*.sh");
                chmod = this.getSubtaskFactory().getChmod();
                chmod.setPerm(this.getChmod());
                chmod.addFileset(fileSet);
                chmod.execute();
            }
            finally {
                file = null;
                fileSet = null;
                chmod = null;
            }
        } else {
            super.log("'" + System.getProperty("os.name") + "' is some kind of windows, skipping chmod.");
        }
    }

    protected void copyEmbeddedFrameworks() throws BuildException {
        if (this.trueWar) {
            Jar jar = new Jar();
            jar.setOwningTarget(this.getOwningTarget());
            jar.setProject(this.getProject());
            jar.setTaskName(this.getTaskName());
            for (FrameworkSet frameworkSet : this.getFrameworkSets()) {
                String[] stringArray;
                File file = frameworkSet.getDir(this.getProject());
                DirectoryScanner directoryScanner = frameworkSet.getDirectoryScanner(this.getProject());
                for (String string : stringArray = directoryScanner.getIncludedDirectories()) {
                    File[] fileArray;
                    if (!string.endsWith(".framework")) {
                        throw new BuildException("'name' attribute must end with '.framework'");
                    }
                    File file2 = new File(string + "/Resources/Java");
                    if (file2.exists() && (fileArray = file2.listFiles()) != null) {
                        for (File file3 : fileArray) {
                            ZipFileSet zipFileSet = new ZipFileSet();
                            FilenameSelector filenameSelector = new FilenameSelector();
                            filenameSelector.setName(file3.getAbsolutePath());
                            zipFileSet.addFilename(filenameSelector);
                            jar.addZipfileset(zipFileSet);
                        }
                    }
                    System.out.println("WOApplication.copyEmbeddedFrameworks:   directory = " + string);
                }
            }
        } else {
            Copy copy = new Copy();
            copy.setOwningTarget(this.getOwningTarget());
            copy.setProject(this.getProject());
            copy.setTaskName(this.getTaskName());
            copy.setLocation(this.getLocation());
            copy.setTodir(this.embeddedFrameworksDir());
            boolean bl = false;
            for (FrameworkSet frameworkSet : this.getFrameworkSets()) {
                String[] stringArray;
                if (!frameworkSet.getEmbed()) continue;
                File file = frameworkSet.getDir(this.getProject());
                DirectoryScanner directoryScanner = frameworkSet.getDirectoryScanner(this.getProject());
                for (String string : stringArray = directoryScanner.getIncludedDirectories()) {
                    if (!string.endsWith(".framework")) {
                        throw new BuildException("The includeded directory '" + string + "' must end with '.framework'");
                    }
                    FileSet fileSet = new FileSet();
                    fileSet.setDir(file);
                    PatternSet.NameEntry nameEntry = fileSet.createInclude();
                    nameEntry.setName(string + "/**");
                    copy.addFileset(fileSet);
                    bl = true;
                }
            }
            if (bl) {
                copy.execute();
            }
        }
    }

    protected void copyEmbeddedOtherClasspaths() throws BuildException {
        Copy copy = new Copy();
        copy.setOwningTarget(this.getOwningTarget());
        copy.setProject(this.getProject());
        copy.setTaskName(this.getTaskName());
        copy.setLocation(this.getLocation());
        copy.setTodir(this.contentsDir());
        boolean bl = false;
        for (OtherClasspathSet otherClasspathSet : this.getOtherClasspath()) {
            if (!otherClasspathSet.getEmbed()) continue;
            File file = otherClasspathSet.getDir(this.getProject());
            DirectoryScanner directoryScanner = otherClasspathSet.getDirectoryScanner(this.getProject());
            for (String string : directoryScanner.getIncludedDirectories()) {
                FileSet fileSet = new FileSet();
                fileSet.setDir(file);
                PatternSet.NameEntry nameEntry = fileSet.createInclude();
                if (!string.endsWith("/")) {
                    string = string + "/";
                }
                nameEntry.setName(string);
                copy.addFileset(fileSet);
                bl = true;
            }
        }
        if (bl) {
            copy.execute();
        }
    }

    @Override
    protected File taskDir() {
        return this.getProject().resolveFile(this.destDir + File.separator + this.name + ".woa");
    }

    protected File contentsDir() {
        return new File(this.taskDir(), "Contents");
    }

    protected String relativeEmbeddedFrameworksDir() {
        return "Frameworks";
    }

    protected File embeddedFrameworksDir() {
        return new File(this.contentsDir(), this.relativeEmbeddedFrameworksDir());
    }

    @Override
    protected File resourcesDir() {
        return new File(this.contentsDir(), "Resources");
    }

    @Override
    protected File wsresourcesDir() {
        return new File(this.contentsDir(), "WebServerResources");
    }

    @Override
    protected File wsresourcesDestDir() {
        File file = new File(this.webServerDir(), "WebObjects");
        File file2 = new File(file, this.name + ".woa");
        File file3 = new File(file2, "Contents");
        return new File(file3, "WebServerResources");
    }

    public String getWebXML_LOCALROOT() {
        return this.webXML_LOCALROOT;
    }

    public String getWebXML_WOAINSTALLROOT() {
        return this.webXML_WOAINSTALLROOT;
    }

    public String getWebXML_WOAppMode() {
        return this.webXML_WOAppMode;
    }

    public String getWebXML_WOROOT() {
        this.log(" WOApplication.getWebXML_WOROOT() webXML_WOROOT: " + this.webXML_WOROOT, 3);
        return this.webXML_WOROOT;
    }

    public String getWebXML_WOtaglib() {
        return this.webXML_WOtaglib;
    }

    public boolean getWebXML() {
        return this.webXML;
    }

    public void setWebXML_LOCALROOT(String string) {
        this.webXML_LOCALROOT = string;
    }

    public void setWebXML_WOAINSTALLROOT(String string) {
        this.webXML_WOAINSTALLROOT = string;
    }

    public void setWebXML_WOAppMode(String string) {
        this.webXML_WOAppMode = string;
    }

    public void setWebXML_WOROOT(String string) {
        this.webXML_WOROOT = string;
    }

    public void setWebXML_WOtaglib(String string) {
        this.webXML_WOtaglib = string;
    }

    public void setWebXML(boolean bl) {
        this.webXML = bl;
    }

    @Override
    protected boolean hasLib() {
        return this.lib.size() > 0;
    }

    protected boolean hasEmbeddedFrameworks() {
        List<FrameworkSet> list = this.getFrameworkSets();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            FrameworkSet frameworkSet = list.get(i);
            if (!frameworkSet.getEmbed()) continue;
            return true;
        }
        return false;
    }

    public FrameworkSet createFrameworks() {
        FrameworkSet frameworkSet = new FrameworkSet();
        this.frameworkSets.add(frameworkSet);
        return frameworkSet;
    }

    public List<FrameworkSet> getFrameworkSets() {
        return this.frameworkSets;
    }

    protected boolean hasEmbeddedOtherClasspaths() {
        List<OtherClasspathSet> list = this.getOtherClasspath();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            OtherClasspathSet otherClasspathSet = list.get(i);
            if (!otherClasspathSet.getEmbed()) continue;
            return true;
        }
        return false;
    }

    public OtherClasspathSet createOtherclasspath() {
        OtherClasspathSet otherClasspathSet = new OtherClasspathSet();
        this.otherClasspathSets.add(otherClasspathSet);
        return otherClasspathSet;
    }

    public List<OtherClasspathSet> getOtherClasspath() {
        return this.otherClasspathSets;
    }

    public WOEnvironment getWOEnvironment() {
        if (this.woEnvironment != null) {
            return this.woEnvironment;
        }
        this.woEnvironment = new WOEnvironment(this.getProject().getProperties());
        if (!this.woEnvironment.variablesConfigured()) {
            this.getProject().fireBuildFinished((Throwable)new WOBuildPropertiesNotFoundException());
        }
        return this.woEnvironment;
    }

    public String getChmod() {
        return this.chmod;
    }

    public void setChmod(String string) {
        this.chmod = string;
    }

    public void setJDB(String string) {
        if (string == null || string.equals("${jdb}") || string.trim().length() <= 0) {
            string = "jdb";
        }
        this.jdb = string;
    }

    public String getJDB() {
        return this.jdb;
    }

    public void setJVM(String string) {
        if (string == null || string.equals("${jvm}") || string.trim().length() <= 0) {
            this.jvm = "java";
        }
        this.jvm = string;
    }

    public String getJVM() {
        return this.jvm;
    }

    public void setJDBOptions(String string) {
        if (string == null || string.equals("${jdbOptions}") || string.trim().length() <= 0) {
            string = "";
        }
        this.jdbOptions = string;
    }

    public String getJDBOptions() {
        return this.jdbOptions;
    }

    public void setJvmOptions(String string) {
        if (string == null || string.equals("${jvmOptions}") || string.trim().length() <= 0) {
            string = "";
        }
        this.jvmOptions = string;
    }

    public String getJvmOptions() {
        return this.jvmOptions;
    }

    @Override
    protected void validateAttributes() throws BuildException {
        this.log(" this.getName().validateAttributes(): " + this.getName() + " webXML: " + this.webXML + " webXML_WOROOT: " + this.webXML_WOROOT, 3);
        if (this.webXML) {
            if (this.webXML_WOROOT == null) {
                this.webXML_WOROOT = this.getWOEnvironment().getWOVariables().systemRoot();
                if (this.webXML_WOROOT == null) {
                    throw new BuildException("'webXML_WOROOT' attribute is missing.");
                }
            }
            if (this.webXML_LOCALROOT == null) {
                this.webXML_LOCALROOT = this.getWOEnvironment().getWOVariables().localRoot();
                if (this.webXML_LOCALROOT == null) {
                    throw new BuildException("'webXML_LOCALROOT' attribute is missing.");
                }
            }
            if (this.webXML_WOAINSTALLROOT == null) {
                this.webXML_WOAINSTALLROOT = this.getWOEnvironment().getWOVariables().appsRoot();
                if (this.webXML_WOAINSTALLROOT == null) {
                    throw new BuildException("'webXML_WOAINSTALLROOT' attribute is missing.");
                }
            }
            if (this.webXML_WOAppMode == null) {
                this.webXML_WOAppMode = "Development";
                if (this.webXML_WOAppMode == null) {
                    throw new BuildException("'webXML_WOAppMode' attribute is missing.");
                }
            }
            if (this.webXML_WOtaglib == null) {
                this.webXML_WOtaglib = "/WEB-INF/tlds/WOtaglib_1_0.tld";
                if (this.webXML_WOtaglib == null) {
                    throw new BuildException("'webXML_WOtaglib' attribute is missing.");
                }
            }
        }
    }

    public String getWebXML_CustomContent() {
        return this.webXML_CustomContent;
    }

    public void setWebXML_CustomContent(String string) {
        this.webXML_CustomContent = string;
    }

    public String getStartupScriptName() {
        return this.startupScriptName;
    }

    public void setStartupScriptName(String string) {
        this.startupScriptName = string;
    }

    public String getFrameworksBaseURL() {
        return this.frameworksBaseURL;
    }

    public void setFrameworksBaseURL(String string) {
        this.frameworksBaseURL = string;
    }
}

