/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.appserver._private;

import com.webobjects.appserver.WOAssociation;
import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WOElement;
import com.webobjects.appserver.WOResponse;
import com.webobjects.appserver._private.WOBrowser;
import com.webobjects.appserver._private.WOShared;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableArray;

public class ERXOptGroupBrowser
extends WOBrowser {
    protected WOAssociation group;
    protected WOAssociation label;
    protected WOAssociation itemStyle;
    protected WOAssociation itemClass;

    public ERXOptGroupBrowser(String arg0, NSDictionary arg1, WOElement arg2) {
        super(arg0, arg1, arg2);
        this.group = (WOAssociation)this._associations.removeObjectForKey("group");
        this.label = (WOAssociation)this._associations.removeObjectForKey("label");
        this.itemStyle = (WOAssociation)this._associations.removeObjectForKey("itemStyle");
        this.itemClass = (WOAssociation)this._associations.removeObjectForKey("itemClass");
        if (this.group == null) {
            throw new RuntimeException("Group is a required binding");
        }
    }

    public void appendChildrenToResponse(WOResponse response, WOContext context) {
        WOComponent parent = context.component();
        Object selections = null;
        if (this._selections != null) {
            selections = this._selections.valueInComponent(parent);
        } else if (this._selectedValues != null) {
            selections = this._selectedValues.valueInComponent(parent);
        }
        NSMutableArray selectedObjects = null;
        if (selections != null) {
            selectedObjects = !(selections instanceof NSArray) ? new NSMutableArray(selections) : (!(selections instanceof NSMutableArray) ? new NSMutableArray((NSArray)selections) : (NSMutableArray)selections);
        }
        NSArray list = (NSArray)this._list.valueInComponent(parent);
        Object previousGroup = null;
        boolean didOpenOptionGroup = false;
        boolean shouldEscapeHTML = this._escapeHTML != null ? this._escapeHTML.booleanValueInComponent(parent) : true;
        for (int i = 0; i < list.count(); ++i) {
            String cssClass;
            String style;
            Object listItem = list.objectAtIndex(i);
            this._item.setValue(listItem, parent);
            Object currentGroup = this.group.valueInComponent(parent);
            if (!currentGroup.equals(previousGroup)) {
                previousGroup = currentGroup;
                if (didOpenOptionGroup) {
                    response._appendContentAsciiString("\n</optgroup>");
                }
                response._appendContentAsciiString("\n<optgroup label=\"");
                if (this.label != null) {
                    if (shouldEscapeHTML) {
                        response.appendContentHTMLString(this.label.valueInComponent(parent).toString());
                    } else {
                        response.appendContentString(this.label.valueInComponent(parent).toString());
                    }
                }
                response._appendContentAsciiString("\">");
                didOpenOptionGroup = true;
            }
            response._appendContentAsciiString("\n<option");
            if (this.itemStyle != null && (style = (String)this.itemStyle.valueInComponent(parent)) != null) {
                response._appendTagAttributeAndValue("style", style, true);
            }
            if (this.itemClass != null && (cssClass = (String)this.itemClass.valueInComponent(parent)) != null) {
                response._appendTagAttributeAndValue("class", cssClass, true);
            }
            String valueAsString = null;
            String displayStringAsString = null;
            if (this._displayString != null || this._value != null) {
                if (this._displayString != null) {
                    Object displayString = this._displayString.valueInComponent(parent);
                    if (displayString != null) {
                        displayStringAsString = displayString.toString();
                        if (this._value != null) {
                            Object value = this._value.valueInComponent(parent);
                            if (value != null) {
                                valueAsString = value.toString();
                            }
                        } else {
                            valueAsString = displayStringAsString;
                        }
                    }
                } else {
                    Object value = this._value.valueInComponent(parent);
                    if (value != null) {
                        displayStringAsString = valueAsString = value.toString();
                    }
                }
            } else {
                valueAsString = displayStringAsString = listItem.toString();
            }
            boolean isSelectedItem = false;
            if (this._selections != null) {
                isSelectedItem = selectedObjects == null ? false : selectedObjects.containsObject(listItem);
            } else if (this._selectedValues != null && this._value != null) {
                boolean bl = isSelectedItem = selectedObjects == null ? false : selectedObjects.containsObject(valueAsString);
            }
            if (isSelectedItem) {
                response.appendContentCharacter(' ');
                response._appendContentAsciiString("selected");
            }
            if (this._value != null) {
                response._appendTagAttributeAndValue("value", valueAsString, true);
            } else {
                String indexAsValue = WOShared.unsignedIntString((int)i);
                response._appendTagAttributeAndValue("value", indexAsValue, false);
            }
            response.appendContentCharacter('>');
            if (shouldEscapeHTML) {
                response.appendContentHTMLString(displayStringAsString);
            } else {
                response.appendContentString(displayStringAsString);
            }
            response._appendContentAsciiString("</option>");
        }
        if (didOpenOptionGroup) {
            response._appendContentAsciiString("\n</optgroup>");
        }
    }
}

