/*
 * Decompiled with CFR 0.152.
 */
package er.extensions;

import com.webobjects.appserver.WOSession;
import com.webobjects.eoaccess.EOAttribute;
import com.webobjects.eoaccess.EODatabase;
import com.webobjects.eoaccess.EODatabaseContext;
import com.webobjects.eoaccess.EOEntity;
import com.webobjects.eoaccess.EOModelGroup;
import com.webobjects.eoaccess.EOQualifierSQLGeneration;
import com.webobjects.eoaccess.EORelationship;
import com.webobjects.eoaccess.EOSQLExpression;
import com.webobjects.eoaccess.EOUtilities;
import com.webobjects.eoaccess.ERXEntityDependencyOrderingDelegate;
import com.webobjects.eoaccess.ERXModel;
import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.eocontrol.EOEnterpriseObject;
import com.webobjects.eocontrol.EOFetchSpecification;
import com.webobjects.eocontrol.EOKeyValueQualifier;
import com.webobjects.eocontrol.EOQualifier;
import com.webobjects.eocontrol.EORelationshipManipulation;
import com.webobjects.eocontrol.EOSharedEditingContext;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSBundle;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSKeyValueCoding;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSNotification;
import com.webobjects.foundation.NSNotificationCenter;
import com.webobjects.foundation.NSSelector;
import com.webobjects.jdbcadaptor.JDBCAdaptorException;
import er.extensions.ERXFrameworkPrincipal;
import er.extensions.appserver.ERXApplication;
import er.extensions.appserver.ERXSession;
import er.extensions.eof.ERXAdaptorChannelDelegate;
import er.extensions.eof.ERXConstant;
import er.extensions.eof.ERXDatabaseContext;
import er.extensions.eof.ERXDatabaseContextDelegate;
import er.extensions.eof.ERXDatabaseContextMulticastingDelegate;
import er.extensions.eof.ERXEC;
import er.extensions.eof.ERXEOAccessUtilities;
import er.extensions.eof.ERXEntityClassDescription;
import er.extensions.eof.ERXModelGroup;
import er.extensions.eof.ERXObjectStoreCoordinatorPool;
import er.extensions.eof.ERXSharedEOLoader;
import er.extensions.eof.qualifiers.ERXFullTextQualifier;
import er.extensions.eof.qualifiers.ERXFullTextQualifierSupport;
import er.extensions.eof.qualifiers.ERXPrimaryKeyListQualifier;
import er.extensions.eof.qualifiers.ERXRegExQualifier;
import er.extensions.eof.qualifiers.ERXToManyQualifier;
import er.extensions.formatters.ERXSimpleHTMLFormatter;
import er.extensions.foundation.ERXArrayUtilities;
import er.extensions.foundation.ERXConfigurationManager;
import er.extensions.foundation.ERXFileUtilities;
import er.extensions.foundation.ERXPatcher;
import er.extensions.foundation.ERXProperties;
import er.extensions.foundation.ERXRuntimeUtilities;
import er.extensions.foundation.ERXStringUtilities;
import er.extensions.foundation.ERXSystem;
import er.extensions.foundation.ERXValueUtilities;
import er.extensions.jdbc.ERXJDBCAdaptor;
import er.extensions.localization.ERXLocalizer;
import er.extensions.logging.ERXLogger;
import er.extensions.partials.ERXPartialInitializer;
import er.extensions.qualifiers.ERXFalseQualifier;
import er.extensions.qualifiers.ERXFalseQualifierSupport;
import er.extensions.remoteSynchronizer.ERXRemoteSynchronizer;
import er.extensions.validation.ERXValidationFactory;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;

public class ERXExtensions
extends ERXFrameworkPrincipal {
    public static final String objectsWillChangeInEditingContext = "ObjectsWillChangeInEditingContext";
    public static final String eoAdaptorLoggingWillChangeNotification = "EOAdaptorLoggingWillChange";
    private static Logger _log;
    private static boolean _initialized;
    protected volatile ERXModelGroup defaultModelGroup;
    private static Map _qualifierKeys;
    public static Logger adaptorLogger;
    public static Logger sharedEOadaptorLogger;
    private static Boolean adaptorEnabled;
    private static boolean _isConfigureAdaptorContextRapidTurnAround;
    private static NSMutableDictionary _editingContextsPerSession;
    private static NSSelector _sharedEntityDataWasRefreshedSelector;
    private static Random _random;
    private static boolean _appInitialized;
    private static boolean _eofInitialized;
    private static final Lock _eofInitializeLock;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EOModelGroup defaultModelGroup() {
        if (this.defaultModelGroup == null) {
            Object object = ERXModel._ERXGlobalModelLock;
            synchronized (object) {
                if (this.defaultModelGroup == null) {
                    String defaultModelGroupClassName = ERXProperties.stringForKey("er.extensions.defaultModelGroupClassName");
                    if (defaultModelGroupClassName == null) {
                        this.defaultModelGroup = new ERXModelGroup();
                    } else {
                        try {
                            this.defaultModelGroup = Class.forName(defaultModelGroupClassName).asSubclass(ERXModelGroup.class).newInstance();
                        }
                        catch (Exception e) {
                            throw new RuntimeException("Failed to create custom ERXModelGroup subclass '" + defaultModelGroupClassName + "'.", e);
                        }
                    }
                    this.defaultModelGroup.loadModelsFromLoadedBundles();
                }
            }
        }
        return this.defaultModelGroup;
    }

    protected void initialize() {
        NSNotificationCenter.defaultCenter().addObserver((Object)this, new NSSelector("bundleDidLoad", ERXConstant.NotificationClassArray), "NSBundleAllBundlesLoaded", null);
    }

    public void bundleDidLoad(NSNotification n) {
        if (_initialized) {
            return;
        }
        _initialized = true;
        try {
            ERXConfigurationManager.defaultManager().initialize();
            EOModelGroup.setClassDelegate((Object)this);
            ERXSystem.updateProperties();
            String className = ERXProperties.stringForKey("er.extensions.erxloggerclass");
            if (className != null) {
                Class<?> loggerClass = Class.forName(className);
                Method method = loggerClass.getDeclaredMethod("configureLoggingWithSystemProperties", null);
                method.invoke(loggerClass, (Object[])null);
            } else {
                ERXLogger.configureLoggingWithSystemProperties();
            }
            ERXArrayUtilities.initialize();
            if (ERXValueUtilities.booleanValue(System.getProperty("er.extensions.ERXSharedEOLoader.PatchSharedEOLoading"))) {
                ERXSharedEOLoader.patchSharedEOLoading();
            }
            ERXExtensions.configureAdaptorContextRapidTurnAround(this);
            ERXJDBCAdaptor.registerJDBCAdaptor();
            if (EODatabaseContext.defaultDelegate() == null) {
                if (ERXProperties.booleanForKey("com.webobjects.eoaccess.ERXEntityDependencyOrderingDelegate.active")) {
                    ERXDatabaseContextMulticastingDelegate.addDefaultDelegate(new ERXEntityDependencyOrderingDelegate());
                    ERXDatabaseContextMulticastingDelegate.addDefaultDelegate(ERXDatabaseContextDelegate.defaultDelegate());
                } else {
                    EODatabaseContext.setDefaultDelegate((Object)ERXDatabaseContextDelegate.defaultDelegate());
                }
            }
            ERXAdaptorChannelDelegate.setupDelegate();
            NSNotificationCenter.defaultCenter().addObserver((Object)this, new NSSelector("sharedEditingContextWasInitialized", ERXConstant.NotificationClassArray), "EODefaultSharedEditingContextWasInitializedNotification", null);
            ERXEntityClassDescription.registerDescription();
            ERXPartialInitializer.registerModelGroupListener();
            if (!ERXProperties.webObjectsVersionIs52OrHigher()) {
                NSNotificationCenter.defaultCenter().addObserver((Object)this, new NSSelector("sessionDidTimeOut", ERXConstant.NotificationClassArray), "SessionDidTimeOutNotification", null);
                NSNotificationCenter.defaultCenter().addObserver((Object)this, new NSSelector("editingContextDidCreate", ERXConstant.NotificationClassArray), "EOEditingContextDidCreate", null);
            }
        }
        catch (Exception e) {
            throw NSForwardException._runtimeExceptionForThrowable((Throwable)e);
        }
    }

    public void finishInitialization() {
        ERXJDBCAdaptor.registerJDBCAdaptor();
        ERXConfigurationManager.defaultManager().loadConfiguration();
        ERXProperties.populateSystemProperties();
        ERXConfigurationManager.defaultManager().configureRapidTurnAround();
        ERXLocalizer.initialize();
        ERXValidationFactory.defaultFactory().configureFactory();
        _log = Logger.getLogger(ERXExtensions.class);
        ERXProperties.pathsForUserAndBundleProperties(true);
        try {
            ERXExtensions.registerSQLSupportForSelector(new NSSelector("isContainedInArray"), EOQualifierSQLGeneration.Support.supportForClass(Class.forName(ERXPrimaryKeyListQualifier.class.getName())));
            ERXExtensions.registerSQLSupportForSelector(new NSSelector("matchesAllInArray"), EOQualifierSQLGeneration.Support.supportForClass(Class.forName(ERXToManyQualifier.class.getName())));
            ERXExtensions.registerSQLSupportForSelector(new NSSelector("matches"), EOQualifierSQLGeneration.Support.supportForClass(Class.forName(ERXRegExQualifier.class.getName())));
            ERXExtensions.registerSQLSupportForSelector(new NSSelector("fulltextContains"), EOQualifierSQLGeneration.Support.supportForClass(Class.forName(ERXFullTextQualifier.class.getName())));
        }
        catch (Throwable t) {
            throw NSForwardException._runtimeExceptionForThrowable((Throwable)t);
        }
        EOQualifierSQLGeneration.Support.setSupportForClass((EOQualifierSQLGeneration.Support)new ERXFullTextQualifierSupport(), ERXFullTextQualifier.class);
        EOQualifierSQLGeneration.Support.setSupportForClass((EOQualifierSQLGeneration.Support)new ERXFalseQualifierSupport(), ERXFalseQualifier.class);
        if (ERXRemoteSynchronizer.remoteSynchronizerEnabled() || ERXProperties.booleanForKey("er.extensions.ERXDatabaseContext.activate")) {
            String className = ERXProperties.stringForKeyWithDefault("er.extensions.ERXDatabaseContext.className", ERXDatabaseContext.class.getName());
            Class c = ERXPatcher.classForName(className);
            if (c == null) {
                throw new IllegalStateException("er.extensions.ERXDatabaseContext.className not found: " + className);
            }
            EODatabaseContext.setContextClassToRegister((Class)c);
        }
        ERXObjectStoreCoordinatorPool.initializeIfNecessary();
    }

    public static synchronized void registerSQLSupportForSelector(NSSelector selector, EOQualifierSQLGeneration.Support support) {
        if (_qualifierKeys == null) {
            _qualifierKeys = new HashMap();
            EOQualifierSQLGeneration.Support old = EOQualifierSQLGeneration.Support.supportForClass(EOKeyValueQualifier.class);
            EOQualifierSQLGeneration.Support.setSupportForClass((EOQualifierSQLGeneration.Support)new KeyValueQualifierSQLGenerationSupport(old), EOKeyValueQualifier.class);
        }
        _qualifierKeys.put(selector.name(), support);
    }

    public void configureAdaptorContext(NSNotification n) {
        ERXExtensions.configureAdaptorContext();
    }

    public void sessionDidTimeOut(NSNotification n) {
        String sessionID = (String)n.object();
        ERXExtensions.sessionDidTimeOut(sessionID);
    }

    public void editingContextDidCreate(NSNotification n) {
        EOEditingContext ec = (EOEditingContext)n.object();
        ERXExtensions.retainEditingContextForCurrentSession(ec);
    }

    public void sharedEditingContextWasInitialized(NSNotification n) {
        EOSharedEditingContext sec = EOSharedEditingContext.defaultSharedEditingContext();
        ERXEC.factory().setDefaultDelegateOnEditingContext((EOEditingContext)sec, true);
    }

    public static void configureAdaptorContextRapidTurnAround(Object anObserver) {
        if (!_isConfigureAdaptorContextRapidTurnAround) {
            adaptorLogger = Logger.getLogger((String)"er.transaction.adaptor.EOAdaptorDebugEnabled");
            sharedEOadaptorLogger = Logger.getLogger((String)"er.transaction.adaptor.EOSharedEOAdaptorDebugEnabled");
            if (adaptorLogger.isDebugEnabled() && !NSLog.debugLoggingAllowedForGroups((long)196608L) || ERXProperties.booleanForKey("EOAdaptorDebugEnabled")) {
                NSLog.allowDebugLoggingForGroups((long)196608L);
                NSLog.setAllowedDebugLevel((int)2);
            }
            adaptorEnabled = NSLog.debugLoggingAllowedForGroups((long)196608L) ? Boolean.TRUE : Boolean.FALSE;
            NSNotificationCenter.defaultCenter().addObserver(anObserver, new NSSelector("configureAdaptorContext", ERXConstant.NotificationClassArray), "ConfigurationDidChangeNotification", null);
            _isConfigureAdaptorContextRapidTurnAround = true;
        }
    }

    public static void configureAdaptorContext() {
        Boolean targetState = null;
        if (adaptorLogger != null) {
            if (adaptorLogger.isDebugEnabled() && !adaptorEnabled.booleanValue()) {
                targetState = Boolean.TRUE;
            } else if (!adaptorLogger.isDebugEnabled() && adaptorEnabled.booleanValue()) {
                targetState = Boolean.FALSE;
            }
            if (targetState != null) {
                ERXExtensions.setAdaptorLogging(targetState);
            }
        }
    }

    public static boolean adaptorLogging() {
        return NSLog.debugLoggingAllowedForGroups((long)196608L);
    }

    public static void setAdaptorLogging(boolean onOff) {
        Boolean targetState;
        Boolean bl = targetState = onOff ? Boolean.TRUE : Boolean.FALSE;
        if (NSLog.debugLoggingAllowedForGroups((long)196608L) != targetState) {
            NSNotificationCenter.defaultCenter().postNotification(new NSNotification(eoAdaptorLoggingWillChangeNotification, (Object)targetState));
            if (targetState.booleanValue()) {
                NSLog.allowDebugLoggingForGroups((long)196608L);
            } else {
                NSLog.refuseDebugLoggingForGroups((long)196608L);
            }
        }
        if (adaptorLogger != null) {
            if (targetState.booleanValue()) {
                adaptorLogger.info((Object)"Adaptor debug on");
            } else {
                adaptorLogger.info((Object)"Adaptor debug off");
            }
        }
        adaptorEnabled = targetState;
    }

    public static void sessionDidTimeOut(String sessionID) {
        if (sessionID != null && _editingContextsPerSession != null) {
            NSArray ecs;
            if (_log.isDebugEnabled()) {
                NSArray a = (NSArray)_editingContextsPerSession.objectForKey(sessionID);
                _log.debug((Object)("Session " + sessionID + " is timing out "));
                _log.debug((Object)("Found " + (a == null ? 0 : a.count()) + " editing context(s)"));
            }
            if ((ecs = (NSArray)_editingContextsPerSession.removeObjectForKey(sessionID)) != null && ecs.count() > 0) {
                Enumeration ecEnumerator = ecs.objectEnumerator();
                while (ecEnumerator.hasMoreElements()) {
                    ((EOEditingContext)ecEnumerator.nextElement()).dispose();
                }
            }
        }
    }

    public static void retainEditingContextForCurrentSession(EOEditingContext ec) {
        ERXSession s = ERXExtensions.session();
        if (s != null) {
            NSMutableArray<EOEditingContext> a;
            if (_editingContextsPerSession == null) {
                _editingContextsPerSession = new NSMutableDictionary();
            }
            if ((a = (NSMutableArray<EOEditingContext>)_editingContextsPerSession.objectForKey(s.sessionID())) == null) {
                a = new NSMutableArray<EOEditingContext>();
                _editingContextsPerSession.setObjectForKey(a, s.sessionID());
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Creating array for " + s.sessionID()));
                }
            }
            a.addObject(ec);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Added new ec to array for " + s.sessionID()));
            }
        } else if (_log.isDebugEnabled()) {
            _log.debug((Object)"Editing Context created with null session.");
        }
    }

    public static String removeHTMLTagsFromString(String s) {
        StringBuffer result = new StringBuffer();
        if (s != null && s.length() > 0) {
            int position = 0;
            while (position < s.length()) {
                int indexOfOpeningTag = s.indexOf("<", position);
                if (indexOfOpeningTag != -1) {
                    if (indexOfOpeningTag != position) {
                        result.append(s.substring(position, indexOfOpeningTag));
                    }
                    position = indexOfOpeningTag + 1;
                } else {
                    result.append(s.substring(position, s.length()));
                    position = s.length();
                }
                int indexOfClosingTag = s.indexOf(">", position);
                if (indexOfClosingTag != -1) {
                    position = indexOfClosingTag + 1;
                    continue;
                }
                result.append(s.substring(position, s.length()));
                position = s.length();
            }
        }
        return ERXStringUtilities.replaceStringByStringInString("&nbsp;", " ", result.toString());
    }

    public static void forceGC(int maxLoop) {
        long wasFree;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Forcing full Garbage Collection");
        }
        Runtime runtime = Runtime.getRuntime();
        long isFree = runtime.freeMemory();
        int i = 0;
        do {
            wasFree = isFree;
            runtime.gc();
        } while ((isFree = runtime.freeMemory()) > wasFree && (maxLoop <= 0 || ++i < maxLoop));
        runtime.runFinalization();
    }

    public static String capitalize(String s) {
        return ERXStringUtilities.capitalize(s);
    }

    public static String plurify(String s, int howMany, String language) {
        return ERXLocalizer.localizerForLanguage(language).plurifiedString(s, howMany);
    }

    public static boolean safeEquals(Object v1, Object v2) {
        return v1 == v2 || v1 != null && v2 != null && v1.equals(v2);
    }

    public static boolean safeDifferent(Object v1, Object v2) {
        return v1 != v2 && (v1 == null || v2 == null || !v1.equals(v2));
    }

    public static boolean stringIsParseableInteger(String s) {
        try {
            Integer.parseInt(s);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static int intFromParseableIntegerString(String s) {
        try {
            int x = Integer.parseInt(s);
            return x;
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public static String substituteStringByStringInString(String s1, String s2, String s) {
        NSArray<String> a = NSArray.componentsSeparatedByString(s, s1);
        return a != null ? a.componentsJoinedByString(s2) : s;
    }

    public static ERXSimpleHTMLFormatter htmlFormatter() {
        return ERXSimpleHTMLFormatter.formatter();
    }

    public static void addObjectToBothSidesOfPotentialRelationshipFromObjectWithKeyPath(EOEnterpriseObject to, EOEnterpriseObject from, String keyPath) {
        if (from != null) {
            EOEntity e;
            EORelationship r;
            if (keyPath.indexOf(46) != -1) {
                String partialKeyPath = ERXStringUtilities.keyPathWithoutLastProperty(keyPath);
                from = (EOEnterpriseObject)from.valueForKeyPath(partialKeyPath);
                keyPath = ERXStringUtilities.lastPropertyKeyInKeyPath(keyPath);
            }
            if ((r = (e = ERXEOAccessUtilities.entityNamed(from.editingContext(), from.entityName())).relationshipNamed(keyPath)) != null) {
                from.addObjectToBothSidesOfRelationshipWithKey((EORelationshipManipulation)to, keyPath);
            } else {
                from.takeValueForKeyPath((Object)to, keyPath);
            }
        }
    }

    public static byte[] bytesFromFile(File f) throws IOException {
        return ERXFileUtilities.bytesFromFile(f);
    }

    public static String stringFromFile(File f) throws IOException {
        return ERXFileUtilities.stringFromFile(f);
    }

    public static String stringFromFile(File f, String encoding) throws IOException {
        return ERXFileUtilities.stringFromFile(f, encoding);
    }

    public static long lastModifiedDateForFileInFramework(String fileName, String frameworkName) {
        return ERXFileUtilities.lastModifiedDateForFileInFramework(fileName, frameworkName);
    }

    public static Object readPropertyListFromFileinFramework(String fileName, String aFrameWorkName) {
        return ERXFileUtilities.readPropertyListFromFileInFramework(fileName, aFrameWorkName);
    }

    public static Object readPropertyListFromFileInFramework(String fileName, String aFrameWorkName, NSArray languageList) {
        return ERXFileUtilities.readPropertyListFromFileInFramework(fileName, aFrameWorkName, languageList);
    }

    public static String userInfoUnit(EOEnterpriseObject object, String key) {
        EOEntity entity = null;
        String lastKey = null;
        String result = null;
        if (key.indexOf(".") == -1) {
            String entityName = object.entityName();
            entity = ERXEOAccessUtilities.entityNamed(object.editingContext(), entityName);
            lastKey = key;
        } else {
            String partialKeyPath = ERXStringUtilities.keyPathWithoutLastProperty(key);
            EOEnterpriseObject objectForPropertyDisplayed = (EOEnterpriseObject)object.valueForKeyPath(partialKeyPath);
            if (objectForPropertyDisplayed != null) {
                entity = ERXEOAccessUtilities.entityNamed(object.editingContext(), objectForPropertyDisplayed.entityName());
                lastKey = ERXStringUtilities.lastPropertyKeyInKeyPath(key);
            }
        }
        if (entity != null && lastKey != null) {
            EOAttribute a = entity.attributeNamed(lastKey);
            NSDictionary userInfo = null;
            if (a != null) {
                userInfo = a.userInfo();
            } else {
                EORelationship r = entity.relationshipNamed(lastKey);
                if (r != null) {
                    userInfo = r.userInfo();
                }
            }
            result = (String)(userInfo != null ? userInfo.valueForKey("unit") : null);
        }
        return result;
    }

    public static String resolveUnit(String userInfoUnitString, EOEnterpriseObject object, String prefixKeyPath) {
        if (userInfoUnitString != null && userInfoUnitString.indexOf("@") > -1) {
            String keyPath = userInfoUnitString.substring(1);
            String PropertyKeyWithoutLastProperty = ERXStringUtilities.keyPathWithoutLastProperty(prefixKeyPath);
            EOEnterpriseObject objectForPropertyDisplayed = null;
            objectForPropertyDisplayed = PropertyKeyWithoutLastProperty != null ? (object != null ? (EOEnterpriseObject)object.valueForKeyPath(PropertyKeyWithoutLastProperty) : null) : object;
            userInfoUnitString = objectForPropertyDisplayed != null ? (String)objectForPropertyDisplayed.valueForKeyPath(keyPath) : null;
        }
        return userInfoUnitString;
    }

    public static void refreshSharedObjectsWithNames(NSArray names) {
        Enumeration e = names.objectEnumerator();
        while (e.hasMoreElements()) {
            ERXExtensions.refreshSharedObjectsWithName((String)e.nextElement());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void refreshSharedObjectsWithName(String entityName) {
        EOSharedEditingContext sharedEC;
        block12: {
            block11: {
                if (entityName == null) {
                    throw new IllegalArgumentException("Entity name argument is null for method: refreshSharedObjectsWithName");
                }
                sharedEC = EOSharedEditingContext.defaultSharedEditingContext();
                sharedEC.lock();
                try {
                    try {
                        NSArray fetchSpecNames;
                        int count;
                        EOEntity entity = ERXEOAccessUtilities.entityNamed((EOEditingContext)sharedEC, entityName);
                        if (entity == null) {
                            _log.warn((Object)("Attempting to refresh a non-existent (or not accessible) EO: " + entityName));
                            Object var9_4 = null;
                            break block11;
                        }
                        if (entity.cachesObjects()) {
                            EODatabaseContext databaseContext = EOUtilities.databaseContextForModelNamed((EOEditingContext)sharedEC, (String)entity.model().name());
                            EODatabase database = databaseContext.database();
                            database.invalidateResultCacheForEntityNamed(entityName);
                        }
                        int n = count = (fetchSpecNames = entity.sharedObjectFetchSpecificationNames()) != null ? fetchSpecNames.count() : 0;
                        if (count > 0) {
                            for (int index = 0; index < count; ++index) {
                                String oneFetchSpecName = (String)fetchSpecNames.objectAtIndex(index);
                                EOFetchSpecification fs = entity.fetchSpecificationNamed(oneFetchSpecName);
                                if (fs == null) continue;
                                fs.setRefreshesRefetchedObjects(true);
                                sharedEC.bindObjectsWithFetchSpecification(fs, oneFetchSpecName);
                            }
                            String className = entity.className();
                            Class<?> entityClass = Class.forName(className);
                            if (_sharedEntityDataWasRefreshedSelector.implementedByClass(entityClass)) {
                                _sharedEntityDataWasRefreshedSelector.invoke(entityClass);
                            }
                            break block12;
                        }
                        _log.warn((Object)("Attempting to refresh a non-shared EO: " + entityName));
                        break block12;
                    }
                    catch (Exception e) {
                        throw new NSForwardException((Throwable)e, "Exception while refreshing shared objects for entity named " + entityName);
                    }
                }
                catch (Throwable throwable) {
                    Object var9_6 = null;
                    sharedEC.unlock();
                    throw throwable;
                }
            }
            sharedEC.unlock();
            return;
        }
        Object var9_5 = null;
        sharedEC.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String randomizeDirectActionURL(String daURL) {
        Random random = _random;
        synchronized (random) {
            int r = _random.nextInt();
            char c = daURL.indexOf(63) == -1 ? (char)'?' : '&';
            return daURL + c + "r=" + r;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addRandomizeDirectActionURL(StringBuffer daURL) {
        Random random = _random;
        synchronized (random) {
            int r = _random.nextInt();
            int c = 63;
            for (int i = 0; i < daURL.length(); ++i) {
                if (daURL.charAt(i) != '?') continue;
                c = 38;
                break;
            }
            daURL.append((char)c);
            daURL.append("r=");
            daURL.append(r);
        }
    }

    public static String addWosidFormValue(String url, WOSession s) {
        String result = url;
        if (result != null && s != null) {
            result = result + (result.indexOf("?") == -1 ? "?" : "&") + "wosid=" + s.sessionID();
        } else {
            _log.warn((Object)("not adding sid: url=" + url + " session=" + s));
        }
        return result;
    }

    public static String cleanString(String newString, NSArray toBeCleaneds) {
        String result = newString;
        if (newString != null) {
            Enumeration e = toBeCleaneds.objectEnumerator();
            while (e.hasMoreElements()) {
                String toBeCleaned = (String)e.nextElement();
                if (newString.toUpperCase().indexOf(toBeCleaned) <= -1) continue;
                result = newString.substring(0, newString.toUpperCase().indexOf(toBeCleaned));
            }
        }
        return result;
    }

    public static void setBooleanFlagOnSessionForKey(WOSession s, String key, boolean newValue) {
        s.setObjectForKey((Object)(newValue ? Boolean.TRUE : Boolean.FALSE), key);
    }

    public static boolean booleanFlagOnSessionForKeyWithDefault(WOSession s, String key, boolean defaultValue) {
        return s.objectForKey(key) != null ? ERXValueUtilities.booleanValue(s.objectForKey(key)) : defaultValue;
    }

    public static synchronized void setSession(ERXSession session) {
        ERXSession.setSession(session);
    }

    public static synchronized ERXSession session() {
        return ERXSession.session();
    }

    public static String userPreferencesKeyFromContext(String key, NSKeyValueCoding context) {
        StringBuffer result = new StringBuffer(key);
        result.append('.');
        String pc = (String)context.valueForKey("pageConfiguration");
        if (pc == null || pc.length() == 0) {
            String en = "_All_";
            EOEntity e = (EOEntity)context.valueForKey("entity");
            if (e != null) {
                en = e.name();
            }
            result.append("__");
            result.append(context.valueForKey("task"));
            result.append("_");
            result.append(en);
        } else {
            result.append(pc);
        }
        return result.toString();
    }

    public static void freeProcessResources(Process p) {
        if (p != null) {
            try {
                if (p.getInputStream() != null) {
                    p.getInputStream().close();
                }
                if (p.getOutputStream() != null) {
                    p.getOutputStream().close();
                }
                if (p.getErrorStream() != null) {
                    p.getErrorStream().close();
                }
                p.destroy();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static boolean objectImplementsMethod(Object object, String methodName, Class[] parameters) {
        boolean implementsMethod = false;
        Enumeration<Method> e = new NSArray<Method>(object.getClass().getMethods()).objectEnumerator();
        while (e.hasMoreElements()) {
            Method m = e.nextElement();
            if (!m.getName().equals(methodName) || !m.getParameterTypes().equals(parameters)) continue;
            implementsMethod = true;
            break;
        }
        return implementsMethod;
    }

    public static void initApp(Class applicationSubclass, String[] args) {
        try {
            File woaFolder = new File(".").getCanonicalFile();
            if (!woaFolder.getName().endsWith(".woa") && new File(woaFolder, ".project").exists()) {
                File buildFolder = new File(new File(woaFolder, "build"), woaFolder.getName() + ".woa");
                if (buildFolder.exists()) {
                    woaFolder = buildFolder;
                } else {
                    File distFolder = new File(new File(woaFolder, "dist"), woaFolder.getName() + ".woa");
                    if (distFolder.exists()) {
                        woaFolder = distFolder;
                    }
                }
            }
            ERXExtensions.initApp(null, woaFolder.toURL(), applicationSubclass, args);
        }
        catch (IOException e) {
            throw new NSForwardException((Throwable)e);
        }
    }

    public static void initApp(String mainBundleName, Class applicationSubclass, String[] args) {
        ERXExtensions.initApp(mainBundleName, null, applicationSubclass, args);
    }

    public static void initApp(String mainBundleName, URL mainBundleURL, Class applicationSubclass, String[] args) {
        if (_appInitialized) {
            return;
        }
        try {
            ERXApplication.setup(args);
            if (mainBundleURL != null) {
                System.setProperty("webobjects.user.dir", new File(mainBundleURL.getFile()).getCanonicalPath());
            }
            System.setProperty("er.extensions.ERXApplication.developmentMode", "true");
            ERXApplication.primeApplication((String)mainBundleName, (URL)mainBundleURL, (String)applicationSubclass.getName());
        }
        catch (IOException e) {
            throw new NSForwardException((Throwable)e);
        }
        _appInitialized = true;
    }

    public static void initEOF(String[] args) {
        ERXExtensions.initEOF(new File("."), args);
    }

    public static void initEOF(File mainBundleFolder, String[] args) {
        ERXExtensions.initEOF(mainBundleFolder, args, true, true, true);
    }

    public static void initEOF(File mainBundleFile, String[] args, boolean assertsBundleExists) {
        ERXExtensions.initEOF(mainBundleFile, args, assertsBundleExists, false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initEOF(File mainBundleFile, String[] args, boolean assertsBundleExists, boolean assertsBundleIsWOApplicationFolder, boolean fallbackToUserDirAsBundle) {
        _eofInitializeLock.lock();
        try {
            if (!_eofInitialized) {
                try {
                    block13: {
                        File bundleFile = mainBundleFile;
                        if (!(!assertsBundleIsWOApplicationFolder || bundleFile.exists() && bundleFile.getName().endsWith(".woa") || (bundleFile = new File(".").getCanonicalFile()).exists() && bundleFile.getName().endsWith(".woa"))) {
                            throw new IllegalArgumentException("Assertion failure. You must run your application from the .woa folder to call this method.");
                        }
                        if (assertsBundleExists && (bundleFile == null || !bundleFile.exists())) {
                            if (fallbackToUserDirAsBundle) {
                                bundleFile = new File(".").getCanonicalFile();
                            } else {
                                throw new IllegalArgumentException("Assertion failure. The main bundle is required to exist to call this method.");
                            }
                        }
                        if (bundleFile != null && bundleFile.isDirectory()) {
                            System.setProperty("webobjects.user.dir", bundleFile.getCanonicalPath());
                        }
                        NSBundle mainBundle = null;
                        try {
                            mainBundle = ERXRuntimeUtilities.loadBundleIfNeeded(bundleFile);
                            if (mainBundle == null) {
                                throw new IllegalArgumentException("The main bundle failed to load.");
                            }
                            NSBundle._setMainBundle((NSBundle)mainBundle);
                            NSLog.debug.appendln((Object)("initEOF setting main bundle to " + mainBundle));
                        }
                        catch (Exception e) {
                            if (!assertsBundleExists) break block13;
                            throw e;
                        }
                    }
                    ERXApplication.setup(args);
                    ERXFrameworkPrincipal.sharedInstance(ERXExtensions.class).bundleDidLoad(null);
                }
                catch (Exception e) {
                    throw new NSForwardException((Throwable)e);
                }
                _eofInitialized = true;
            }
            Object var9_9 = null;
            _eofInitializeLock.unlock();
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            _eofInitializeLock.unlock();
            throw throwable;
        }
    }

    static {
        _isConfigureAdaptorContextRapidTurnAround = false;
        _sharedEntityDataWasRefreshedSelector = new NSSelector("sharedEntityDataWasRefreshed");
        _random = new Random();
        _appInitialized = false;
        _eofInitialized = false;
        _eofInitializeLock = new ReentrantLock();
    }

    public static class KeyValueQualifierSQLGenerationSupport
    extends EOQualifierSQLGeneration.Support {
        private EOQualifierSQLGeneration.Support _old;

        public KeyValueQualifierSQLGenerationSupport(EOQualifierSQLGeneration.Support old) {
            this._old = old;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private EOQualifierSQLGeneration.Support supportForQualifier(EOQualifier qualifier) {
            EOQualifierSQLGeneration.Support support = null;
            if (qualifier instanceof EOKeyValueQualifier) {
                Map map = _qualifierKeys;
                synchronized (map) {
                    support = (EOQualifierSQLGeneration.Support)_qualifierKeys.get(((EOKeyValueQualifier)qualifier).selector().name());
                }
            }
            if (support == null) {
                support = this._old;
            }
            return support;
        }

        public String sqlStringForSQLExpression(EOQualifier eoqualifier, EOSQLExpression e) {
            try {
                return this.supportForQualifier(eoqualifier).sqlStringForSQLExpression(eoqualifier, e);
            }
            catch (JDBCAdaptorException ex) {
                _log.error((Object)("Failed to generate sql string for qualifier " + eoqualifier + " on entity " + e.entity() + "."));
                throw ex;
            }
        }

        public EOQualifier schemaBasedQualifierWithRootEntity(EOQualifier eoqualifier, EOEntity eoentity) {
            EOQualifier result = this.supportForQualifier(eoqualifier).schemaBasedQualifierWithRootEntity(eoqualifier, eoentity);
            return result;
        }

        public EOQualifier qualifierMigratedFromEntityRelationshipPath(EOQualifier eoqualifier, EOEntity eoentity, String s) {
            return this.supportForQualifier(eoqualifier).qualifierMigratedFromEntityRelationshipPath(eoqualifier, eoentity, s);
        }
    }
}

