/*
 * Decompiled with CFR 0.152.
 */
package er.extensions;

import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSNotification;
import com.webobjects.foundation.NSNotificationCenter;
import com.webobjects.foundation.NSSelector;
import er.extensions.eof.ERXConstant;
import er.extensions.foundation.ERXStringUtilities;
import java.lang.reflect.Field;
import java.util.Enumeration;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ERXFrameworkPrincipal {
    protected final Logger log = Logger.getLogger(this.getClass());
    protected static final NSMutableDictionary initializedFrameworks = new NSMutableDictionary();
    protected static final NSMutableArray launchingFrameworks = new NSMutableArray();
    private static Observer observer;

    public static <T extends ERXFrameworkPrincipal> T sharedInstance(Class<T> c) {
        return (T)((ERXFrameworkPrincipal)initializedFrameworks.objectForKey(c.getName()));
    }

    public static void setUpFrameworkPrincipalClass(Class c) {
        block11: {
            if (initializedFrameworks.objectForKey(c.getName()) != null) {
                return;
            }
            try {
                if (observer == null) {
                    observer = new Observer();
                    NSNotificationCenter center = NSNotificationCenter.defaultCenter();
                    center.addObserver((Object)observer, new NSSelector("willFinishInitialization", ERXConstant.NotificationClassArray), "NSApplicationDidCreateNotification", null);
                    center.addObserver((Object)observer, new NSSelector("didFinishInitialization", ERXConstant.NotificationClassArray), "NSApplicationDidFinishInitializationNotification", null);
                }
                if (initializedFrameworks.objectForKey(c.getName()) == null) {
                    try {
                        Field f = c.getField("REQUIRES");
                        Class[] requires = (Class[])f.get(c);
                        for (int i = 0; i < requires.length; ++i) {
                            Class requirement = requires[i];
                            if (initializedFrameworks.objectForKey(requirement.getName()) != null) continue;
                            ERXFrameworkPrincipal.setUpFrameworkPrincipalClass(requirement);
                        }
                    }
                    catch (NoSuchFieldException e) {
                    }
                    catch (IllegalAccessException e) {
                        NSLog.err.appendln((Object)("Can't read field REQUIRES from " + c.getName() + ", check if it is 'public static Class[] REQUIRES= new Class[] {...}' in this class"));
                        throw NSForwardException._runtimeExceptionForThrowable((Throwable)e);
                    }
                    if (initializedFrameworks.objectForKey(c.getName()) == null) {
                        ERXFrameworkPrincipal principal = (ERXFrameworkPrincipal)c.newInstance();
                        initializedFrameworks.setObjectForKey(principal, c.getName());
                        principal.initialize();
                        launchingFrameworks.addObject(principal);
                        NSLog.debug.appendln((Object)("Initialized : " + c.getName()));
                    }
                    break block11;
                }
                NSLog.debug.appendln((Object)("Was already inited: " + c.getName()));
            }
            catch (InstantiationException e) {
                throw NSForwardException._runtimeExceptionForThrowable((Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw NSForwardException._runtimeExceptionForThrowable((Throwable)e);
            }
        }
    }

    protected void initialize() {
    }

    public abstract void finishInitialization();

    public void didFinishInitialization() {
    }

    public String toString() {
        return ERXStringUtilities.lastPropertyKeyInKeyPath(this.getClass().getName());
    }

    public static class Observer {
        public final void willFinishInitialization(NSNotification n) {
            NSNotificationCenter.defaultCenter().removeObserver((Object)this, "NSApplicationDidCreateNotification", null);
            Enumeration enumerator = launchingFrameworks.objectEnumerator();
            while (enumerator.hasMoreElements()) {
                ERXFrameworkPrincipal principal = (ERXFrameworkPrincipal)enumerator.nextElement();
                principal.finishInitialization();
                NSLog.debug.appendln((Object)("Finished initialization after launch: " + principal));
            }
        }

        public final void didFinishInitialization(NSNotification n) {
            NSNotificationCenter.defaultCenter().removeObserver((Object)this);
            Enumeration enumerator = launchingFrameworks.objectEnumerator();
            while (enumerator.hasMoreElements()) {
                ERXFrameworkPrincipal principal = (ERXFrameworkPrincipal)enumerator.nextElement();
                principal.didFinishInitialization();
            }
        }
    }
}

