/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.appserver;

import com.webobjects.appserver.WOApplication;
import com.webobjects.appserver.WORequest;
import com.webobjects.appserver.WOResponse;
import com.webobjects.appserver.WOSession;
import com.webobjects.appserver._private.WODirectActionRequestHandler;
import com.webobjects.appserver._private.WOServerSessionStore;
import er.extensions.appserver.ERXBrowser;
import er.extensions.appserver.ERXMessageEncoding;
import er.extensions.appserver.ERXRequest;
import er.extensions.appserver.ERXSession;
import er.extensions.appserver.ERXWOResponseCache;
import er.extensions.foundation.ERXProperties;
import org.apache.log4j.Logger;

public class ERXDirectActionRequestHandler
extends WODirectActionRequestHandler {
    public static final Logger log = Logger.getLogger(ERXDirectActionRequestHandler.class);
    protected static Boolean automaticMessageEncodingEnabled;

    public static boolean automaticMessageEncodingEnabled() {
        if (automaticMessageEncodingEnabled == null) {
            automaticMessageEncodingEnabled = ERXProperties.booleanForKeyWithDefault("er.extensions.ERXMessageEncoding.Enabled", true) ? Boolean.TRUE : Boolean.FALSE;
        }
        return automaticMessageEncodingEnabled;
    }

    public ERXDirectActionRequestHandler() {
    }

    public ERXDirectActionRequestHandler(String actionClassName, String defaultActionName, boolean shouldAddToStatistics) {
        super(actionClassName, defaultActionName, shouldAddToStatistics);
    }

    protected boolean isSystemRequest(WORequest request) {
        return request.requestHandlerPath() != null && request.requestHandlerPath().toLowerCase().indexOf("stats") >= 0;
    }

    public WOResponse handleRequest(WORequest request) {
        WOResponse response = null;
        String actionName = null;
        Class actionClass = null;
        boolean shouldCacheResult = false;
        if (ERXWOResponseCache.sharedInstance().isEnabled()) {
            try {
                Object[] actionClassAndName = this.getRequestActionClassAndNameForPath(this.getRequestHandlerPathForRequest(request));
                if (actionClassAndName != null && actionClassAndName.length == 3) {
                    actionName = (String)actionClassAndName[1];
                    actionClass = (Class)actionClassAndName[2];
                    if (ERXWOResponseCache.Cacheable.class.isAssignableFrom(actionClass)) {
                        response = ERXWOResponseCache.sharedInstance().cachedResponseForRequest(actionClass, actionName, request);
                        shouldCacheResult = response == null;
                    }
                }
            }
            catch (Exception e) {
                log.error((Object)("Caught exception checking for cache. Leaving it up to the regular exception handler to cache. Request: " + request), (Throwable)e);
            }
        }
        if (response == null) {
            WOApplication app = WOApplication.application();
            if (app.isRefusingNewSessions() && request.isUsingWebServer() && !this.isSystemRequest(request)) {
                if (this.isSessionIDInRequest(request)) {
                    if (app.sessionStore().getClass() == WOServerSessionStore.class && app.sessionStore().restoreSessionWithID(request.sessionID(), request) == null) {
                        response = this.generateRequestRefusal(request);
                        response.setStatus(302);
                    }
                } else {
                    response = this.generateRequestRefusal(request);
                }
            }
            if (response == null) {
                response = super.handleRequest(request);
            }
        } else {
            this.registerWillHandleActionRequest();
            this.registerDidHandleActionRequestWithActionNamed(actionName);
        }
        if (shouldCacheResult && response != null) {
            try {
                ERXWOResponseCache.sharedInstance().cacheResponseForRequest(actionClass, actionName, request, response);
            }
            catch (Exception e) {
                log.error((Object)("Caught exception when caching response. Request: " + request), (Throwable)e);
            }
        }
        if (ERXDirectActionRequestHandler.automaticMessageEncodingEnabled()) {
            ERXMessageEncoding messageEncoding = null;
            WOSession session = ERXSession.anySession();
            if (session != null && session instanceof ERXSession) {
                ERXSession erxSession = (ERXSession)session;
                messageEncoding = erxSession.messageEncoding();
                erxSession.lastActionWasDA = true;
            } else if (request instanceof ERXRequest) {
                ERXBrowser browser = ((ERXRequest)request).browser();
                messageEncoding = browser.messageEncodingForRequest(request);
            } else {
                messageEncoding = new ERXMessageEncoding(request.browserLanguages());
            }
            messageEncoding.setEncodingToResponse(response);
        }
        return response;
    }
}

