/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.appserver;

import com.webobjects.appserver.WORequest;
import com.webobjects.appserver.WOResponse;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableDictionary;
import er.extensions.foundation.ERXDictionaryUtilities;
import er.extensions.foundation.ERXSimpleTemplateParser;
import java.io.Serializable;
import java.util.Enumeration;

public class ERXMessageEncoding
implements Serializable {
    private String _encoding;
    private static NSDictionary _encodings;
    private static NSDictionary _languagesAndDefaultEncodings;
    private static String _defaultEncoding;
    private String _toString;

    public String encoding() {
        return this._encoding;
    }

    public ERXMessageEncoding(String languageOrEncoding) {
        this._encoding = ERXMessageEncoding.availableEncodings().containsObject(languageOrEncoding) ? languageOrEncoding : (ERXMessageEncoding.availableLanguages().containsObject(languageOrEncoding) ? ERXMessageEncoding.defaultEncodingForLanguage(languageOrEncoding) : ERXMessageEncoding.defaultEncoding());
    }

    public ERXMessageEncoding(NSArray preferedLanguages) {
        this._encoding = null;
        NSArray availableLanguages = ERXMessageEncoding.availableLanguages();
        Enumeration e = preferedLanguages.objectEnumerator();
        while (e.hasMoreElements()) {
            String aPreferedLanguage = (String)e.nextElement();
            if (!availableLanguages.containsObject(aPreferedLanguage)) continue;
            this._encoding = ERXMessageEncoding.defaultEncodingForLanguage(aPreferedLanguage);
            break;
        }
        if (this._encoding == null) {
            this._encoding = ERXMessageEncoding.defaultEncoding();
        }
    }

    public static void resetToFactoryDefault() {
        _encodings = null;
        _languagesAndDefaultEncodings = null;
    }

    public static NSArray availableEncodings() {
        return ERXMessageEncoding._encodings().allKeys();
    }

    public static NSArray availableLanguages() {
        return ERXMessageEncoding._languagesAndDefaultEncodings().allKeys();
    }

    private static NSDictionary _encodings() {
        if (_encodings == null) {
            _encodings = ERXDictionaryUtilities.dictionaryWithObjectsAndKeys(new Object[]{"ISO-8859-1", "ISO8859_1", "ISO-8859-1", "ISO-8859-1", "Shift_JIS", "SJIS", "Shift_JIS", "SHIFT_JIS", "EUC-JP", "EUC_JP", "EUC-JP", "EUC-JP", "iso-2022-jp", "ISO2022JP", "iso-2022-jp", "ISO-2022-JP", "UTF-8", "UTF8", "UTF-8", "UTF-8"});
        }
        return _encodings;
    }

    private static NSDictionary _languagesAndDefaultEncodings() {
        if (_languagesAndDefaultEncodings == null) {
            _languagesAndDefaultEncodings = ERXDictionaryUtilities.dictionaryWithObjectsAndKeys(new Object[]{"ISO8859_1", "English", "ISO8859_1", "German", "SJIS", "Japanese"});
        }
        return _languagesAndDefaultEncodings;
    }

    private static void _setLanguagesAndDefaultEncodings(NSDictionary newLanguagesAndDefaultEncodings) {
        _languagesAndDefaultEncodings = newLanguagesAndDefaultEncodings;
    }

    public static String defaultEncoding() {
        if (_defaultEncoding == null) {
            _defaultEncoding = "ISO8859_1";
        }
        return _defaultEncoding;
    }

    public static void setDefaultEncoding(String newDefaultEncoding) {
        if (!ERXMessageEncoding.availableEncodings().containsObject(newDefaultEncoding.toUpperCase())) {
            throw ERXMessageEncoding.createIllegalArgumentException(newDefaultEncoding, "encoding", "availableEncodings()");
        }
        _defaultEncoding = newDefaultEncoding;
    }

    public static void setDefaultEncodingForAllLanguages(String newDefaultEncoding) {
        ERXMessageEncoding.setDefaultEncoding(newDefaultEncoding);
        NSMutableDictionary<String, String> d = new NSMutableDictionary<String, String>(ERXMessageEncoding._languagesAndDefaultEncodings());
        Enumeration e = d.keyEnumerator();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            d.setObjectForKey(newDefaultEncoding, key);
        }
        ERXMessageEncoding._setLanguagesAndDefaultEncodings(d);
    }

    public static String defaultEncodingForLanguage(String language) {
        String defaultEncoding = null;
        if (ERXMessageEncoding.availableLanguages().containsObject(language)) {
            defaultEncoding = (String)_languagesAndDefaultEncodings.objectForKey(language);
        }
        if (defaultEncoding == null) {
            defaultEncoding = ERXMessageEncoding.defaultEncoding();
        }
        return defaultEncoding;
    }

    public static void setDefaultEncodingForLanguage(String encoding, String language) {
        if (!ERXMessageEncoding.availableLanguages().containsObject(language)) {
            throw ERXMessageEncoding.createIllegalArgumentException(language, "language", "availableLanguages()");
        }
        if (!ERXMessageEncoding.availableEncodings().containsObject(encoding)) {
            throw ERXMessageEncoding.createIllegalArgumentException(encoding, "encoding", "availableEncodings()");
        }
        NSMutableDictionary<String, String> d = new NSMutableDictionary<String, String>(_languagesAndDefaultEncodings);
        d.setObjectForKey(encoding, language);
        _languagesAndDefaultEncodings = d;
    }

    public static void setEncodingToResponse(WOResponse response, String encoding) {
        encoding = encoding.toUpperCase();
        if (!ERXMessageEncoding.availableEncodings().containsObject(encoding)) {
            throw ERXMessageEncoding.createIllegalArgumentException(encoding, "encoding", "availableEncodings()");
        }
        String mimeType = response.headerForKey((Object)"Content-Type");
        if (mimeType != null && (mimeType.equals("text/html") || mimeType.equals("text/xml"))) {
            response.setContentEncoding(encoding);
            response.setHeader(mimeType + "; charset=" + ERXMessageEncoding._encodings().objectForKey(encoding), "Content-Type");
        }
    }

    public void setEncodingToResponse(WOResponse response) {
        ERXMessageEncoding.setEncodingToResponse(response, this.encoding());
    }

    public static void setDefaultFormValueEncodingToRequest(WORequest request, String encoding) {
        encoding = encoding.toUpperCase();
        if (!ERXMessageEncoding.availableEncodings().containsObject(encoding)) {
            throw ERXMessageEncoding.createIllegalArgumentException(encoding, "encoding", "availableEncodings()");
        }
        request.setDefaultFormValueEncoding(encoding);
    }

    public void setDefaultFormValueEncodingToRequest(WORequest request) {
        ERXMessageEncoding.setDefaultFormValueEncodingToRequest(request, this.encoding());
    }

    protected static IllegalArgumentException createIllegalArgumentException(String value, String target, String listingMethod) {
        NSDictionary d = ERXDictionaryUtilities.dictionaryWithObjectsAndKeys(new Object[]{value, "value", target, "target", listingMethod, "listingMethod"});
        ERXSimpleTemplateParser parser = ERXSimpleTemplateParser.sharedInstance();
        String message = parser.parseTemplateWithObject("@@value@@ isn't a supported @@target@@. (Not listed under @@listingMethod@@)", null, d, null);
        return new IllegalArgumentException(message);
    }

    public String toString() {
        if (this._toString == null) {
            this._toString = "<" + this.getClass().getName() + " encoding: " + this._encoding + ">";
        }
        return this._toString;
    }
}

