/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.appserver;

import com.webobjects.appserver.WODirectAction;
import com.webobjects.appserver.WORequest;
import com.webobjects.appserver._private.WOURLEncoder;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSRange;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Enumeration;
import org.apache.log4j.Logger;

public class ERXPathDirectAction
extends WODirectAction {
    protected static final Logger log = Logger.getLogger(ERXPathDirectAction.class);
    protected NSArray pathParts;
    protected NSDictionary pathPartsByKeys;
    protected NSDictionary pathPartsByKeysCaseInsensitive;

    public ERXPathDirectAction(WORequest aRequest) {
        super(aRequest);
    }

    public NSArray pathParts() {
        if (this.pathParts == null) {
            if (this.request().requestHandlerPathArray().count() > 2) {
                this.pathParts = this.request().requestHandlerPathArray().subarrayWithRange(new NSRange(1, this.request().requestHandlerPathArray().count() - 2));
            }
            if (this.pathParts == null) {
                this.pathParts = NSArray.EmptyArray;
            } else {
                NSMutableArray<int> temp = new NSMutableArray<int>(this.pathParts.count());
                Enumeration pathPartEnumerator = this.pathParts.objectEnumerator();
                while (pathPartEnumerator.hasMoreElements()) {
                    try {
                        temp.addObject((int)URLDecoder.decode((String)pathPartEnumerator.nextElement(), WOURLEncoder.WO_URL_ENCODING));
                    }
                    catch (UnsupportedEncodingException e) {
                        log.error((Object)("Encoding not found: " + WOURLEncoder.WO_URL_ENCODING), (Throwable)e);
                    }
                }
                this.pathParts = temp;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Generated path parts: " + this.pathParts + " for uri: " + this.request().uri()));
            }
        }
        return this.pathParts;
    }

    public NSDictionary pathPartsByKeys() {
        if (this.pathPartsByKeys == null) {
            NSMutableDictionary<String, String> temp = null;
            NSMutableDictionary<String, String> tempCaseInsensitive = null;
            Enumeration pathEnumerator = this.pathParts().objectEnumerator();
            while (pathEnumerator.hasMoreElements()) {
                NSArray<String> parts;
                String path = (String)pathEnumerator.nextElement();
                if (path.indexOf(61) == -1) continue;
                if (temp == null) {
                    temp = new NSMutableDictionary<String, String>();
                    tempCaseInsensitive = new NSMutableDictionary<String, String>();
                }
                if ((parts = NSArray.componentsSeparatedByString(path, "=")).count() != 2) continue;
                temp.setObjectForKey(parts.objectAtIndex(1), parts.objectAtIndex(0));
                tempCaseInsensitive.setObjectForKey(parts.objectAtIndex(1), parts.objectAtIndex(0).toLowerCase());
            }
            this.pathPartsByKeys = temp != null ? temp : NSDictionary.EmptyDictionary;
            this.pathPartsByKeysCaseInsensitive = tempCaseInsensitive != null ? tempCaseInsensitive : NSDictionary.EmptyDictionary;
        }
        return this.pathPartsByKeys;
    }

    public NSDictionary pathPartsByKeysCaseInsensitive() {
        if (this.pathPartsByKeysCaseInsensitive == null) {
            this.pathPartsByKeys();
        }
        return this.pathPartsByKeysCaseInsensitive;
    }

    public boolean hasPathPartForKey(String key) {
        return this.hasPathPartForKey(key, false);
    }

    public boolean hasPathPartForKey(String key, boolean caseInsensitive) {
        if (caseInsensitive) {
            key = key.toLowerCase();
        }
        return caseInsensitive ? this.pathPartsByKeysCaseInsensitive().objectForKey(key) != null : this.pathPartsByKeys().objectForKey(key) != null;
    }

    public String pathPartForKey(String key) {
        return this.pathPartForKeyWithDefault(key, null);
    }

    public String pathPartForKeyWithDefault(String key, String defaultValue) {
        return this.pathPartForKeyWithDefault(key, defaultValue, false);
    }

    public String pathPartForKeyWithDefault(String key, String defaultValue, boolean caseInsensitiveCompare) {
        String value = null;
        if (caseInsensitiveCompare) {
            key = key.toLowerCase();
            value = (String)this.pathPartsByKeysCaseInsensitive().objectForKey(key);
        } else {
            value = (String)this.pathPartsByKeys().objectForKey(key);
        }
        return value != null ? value : defaultValue;
    }
}

