/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.appserver;

import com.webobjects.appserver.WOApplication;
import com.webobjects.appserver.WORequest;
import com.webobjects.appserver.WOResponse;
import er.extensions.foundation.ERXMultiKey;
import er.extensions.foundation.ERXProperties;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ERXWOResponseCache {
    protected static ERXWOResponseCache sharedInstance;
    public static String NO_CACHE_KEY;
    protected Map cache = WOApplication.application().isConcurrentRequestHandlingEnabled() ? Collections.synchronizedMap(new HashMap()) : new HashMap();
    protected Policy policy;
    protected Boolean isEnabled;

    public static ERXWOResponseCache sharedInstance() {
        if (sharedInstance == null) {
            sharedInstance = new ERXWOResponseCache();
        }
        return sharedInstance;
    }

    public boolean isEnabled() {
        if (this.isEnabled == null) {
            this.isEnabled = ERXProperties.booleanForKey("er.extensions.ERXWOResponseCache.Enabled") ? Boolean.TRUE : Boolean.FALSE;
        }
        return this.isEnabled;
    }

    public void setIsEnabled(boolean enabled) {
        this.isEnabled = enabled ? Boolean.TRUE : Boolean.FALSE;
    }

    public Policy policy() {
        return this.policy;
    }

    public void setPolicy(Policy policy) {
        this.policy = policy;
    }

    public boolean hasPolicy() {
        return this.policy != null;
    }

    public boolean actionNameIsCachableForClass(Class actionClass, String actionName) {
        return this.hasPolicy() ? this.policy().actionNameIsCachableForClass(actionClass, actionName) : false;
    }

    public void flushCache() {
        this.cache.clear();
    }

    public WOResponse cachedResponseForRequest(Class actionClass, String actionName, WORequest request) {
        ERXMultiKey cacheKey;
        if (this.policy().shouldResetCache()) {
            this.flushCache();
        }
        return (cacheKey = this.policy().cacheKeyForRequest(actionClass, actionName, request)) != null ? (WOResponse)this.cache.get(cacheKey) : null;
    }

    public void cacheResponseForRequest(Class actionClass, String actionName, WORequest request, WOResponse response) {
        if (response.headerForKey((Object)NO_CACHE_KEY) == null) {
            ERXMultiKey cacheKey = this.policy().cacheKeyForRequest(actionClass, actionName, request);
            if (cacheKey != null) {
                this.cache.put(cacheKey, response);
            }
        } else {
            response.removeHeadersForKey((Object)NO_CACHE_KEY);
        }
    }

    static {
        NO_CACHE_KEY = "ERXDirectActionRequestHandler.DontCache";
    }

    public static interface Cacheable {
    }

    public static interface Policy {
        public boolean actionNameIsCachableForClass(Class var1, String var2);

        public ERXMultiKey cacheKeyForRequest(Class var1, String var2, WORequest var3);

        public boolean shouldResetCache();
    }
}

