/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.appserver;

import com.webobjects.appserver.WORequest;
import com.webobjects.foundation.NSArray;
import er.extensions.appserver.ERXWOResponseCache;
import er.extensions.foundation.ERXMultiKey;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

public class ERXWOResponseCacheKeyPolicy
implements ERXWOResponseCache.Policy {
    protected static ERXWOResponseCacheKeyPolicy sharedInstance;
    protected Map cacheKeyMap = new HashMap();

    public static ERXWOResponseCacheKeyPolicy sharedInstance() {
        if (sharedInstance == null) {
            sharedInstance = new ERXWOResponseCacheKeyPolicy();
        }
        return sharedInstance;
    }

    public void createPolicyEntryForClass(Class actionClass, NSArray actionNames, NSArray formKeys, NSArray headerKeys, NSArray cookieKeys) {
        PolicyCacheEntry policyCacheEntry = new PolicyCacheEntry(formKeys, headerKeys, cookieKeys);
        if (actionNames.count() > 0) {
            Enumeration actionNameEnumerator = actionNames.objectEnumerator();
            while (actionNameEnumerator.hasMoreElements()) {
                String actionName = (String)actionNameEnumerator.nextElement();
                this.cacheKeyMap.put(actionClass.getName() + "@" + actionName, policyCacheEntry);
            }
        } else {
            this.cacheKeyMap.put(actionClass.getName(), policyCacheEntry);
        }
    }

    public boolean actionNameIsCachableForClass(Class actionClass, String actionName) {
        return this.policyCacheEntryForClass(actionClass, actionName) != null;
    }

    public ERXMultiKey cacheKeyForRequest(Class actionClass, String actionName, WORequest request) {
        ERXMultiKey cacheKey = null;
        PolicyCacheEntry cacheEntry = this.policyCacheEntryForClass(actionClass, actionName);
        if (cacheEntry != null) {
            int count = 0;
            Object[] cache = new Object[cacheEntry.count + 2];
            cache[count++] = actionClass;
            cache[count++] = actionName;
            if (cacheEntry.formKeys.count() > 0) {
                Enumeration formKeyEnumerator = cacheEntry.formKeys.objectEnumerator();
                while (formKeyEnumerator.hasMoreElements()) {
                    String formKey = (String)formKeyEnumerator.nextElement();
                    cache[count++] = request.formValueForKey(formKey);
                }
            }
            if (cacheEntry.headerKeys.count() > 0) {
                Enumeration headerKeyEnumerator = cacheEntry.headerKeys.objectEnumerator();
                while (headerKeyEnumerator.hasMoreElements()) {
                    String headerKey = (String)headerKeyEnumerator.nextElement();
                    cache[count++] = request.headerForKey((Object)headerKey);
                }
            }
            if (cacheEntry.cookieKeys.count() > 0) {
                Enumeration cookieKeyEnumerator = cacheEntry.cookieKeys.objectEnumerator();
                while (cookieKeyEnumerator.hasMoreElements()) {
                    String cookieKey = (String)cookieKeyEnumerator.nextElement();
                    cache[count++] = request.cookieValueForKey(cookieKey);
                }
            }
            cacheKey = new ERXMultiKey(cache);
        }
        return cacheKey;
    }

    public PolicyCacheEntry policyCacheEntryForClass(Class actionClass, String actionName) {
        PolicyCacheEntry cacheEntry = (PolicyCacheEntry)this.cacheKeyMap.get(actionClass.getName() + "@" + actionName);
        return cacheEntry != null ? cacheEntry : (PolicyCacheEntry)this.cacheKeyMap.get(actionClass.getName());
    }

    public boolean shouldResetCache() {
        return false;
    }

    public static class PolicyCacheEntry {
        public NSArray formKeys;
        public NSArray headerKeys;
        public NSArray cookieKeys;
        public int count;

        public PolicyCacheEntry(NSArray formKeys, NSArray headerKeys, NSArray cookieKeys) {
            this.formKeys = formKeys != null ? formKeys : NSArray.EmptyArray;
            this.headerKeys = headerKeys != null ? headerKeys : NSArray.EmptyArray;
            this.cookieKeys = cookieKeys != null ? cookieKeys : NSArray.EmptyArray;
            this.count = this.formKeys.count() + this.headerKeys.count() + this.cookieKeys.count();
        }
    }
}

