/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.appserver.navigation;

import com.webobjects.appserver.WOApplication;
import com.webobjects.appserver.WOSession;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSNotification;
import com.webobjects.foundation.NSSelector;
import com.webobjects.foundation._NSUtilities;
import er.extensions.ERXExtensions;
import er.extensions.appserver.navigation.ERXNavigationItem;
import er.extensions.appserver.navigation.ERXNavigationState;
import er.extensions.eof.ERXConstant;
import er.extensions.foundation.ERXFileNotificationCenter;
import er.extensions.foundation.ERXFileUtilities;
import er.extensions.foundation.ERXPatcher;
import er.extensions.foundation.ERXUtilities;
import java.util.Enumeration;
import org.apache.log4j.Logger;

public class ERXNavigationManager {
    public static final Logger log = Logger.getLogger(ERXNavigationManager.class);
    protected static ERXNavigationManager manager;
    protected NSDictionary navigationItemsByName = NSDictionary.EmptyDictionary;
    protected ERXNavigationItem rootNavigationItem;
    protected String navigationMenuFileName;
    protected boolean hasRegistered = false;

    public static ERXNavigationManager manager() {
        if (manager == null) {
            manager = new ERXNavigationManager();
        }
        return manager;
    }

    public ERXNavigationState navigationStateForSession(WOSession session) {
        ERXNavigationState state = (ERXNavigationState)session.objectForKey(this.navigationStateSessionKey());
        if (state == null) {
            state = new ERXNavigationState();
            session.setObjectForKey((Object)state, this.navigationStateSessionKey());
        }
        return state;
    }

    public String navigationStateSessionKey() {
        return "NavigationState";
    }

    public String navigationMenuFileName() {
        if (this.navigationMenuFileName == null) {
            this.navigationMenuFileName = System.getProperty("er.extensions.ERXNavigationManager.NavigationMenuFileName");
        }
        return this.navigationMenuFileName;
    }

    public void setNavigationMenuFileName(String name) {
        this.navigationMenuFileName = name;
    }

    public NSDictionary navigationItemsByName() {
        return this.navigationItemsByName;
    }

    public ERXNavigationItem rootNavigationItem() {
        return this.rootNavigationItem;
    }

    public ERXNavigationItem navigationItemForName(String name) {
        return (ERXNavigationItem)this.navigationItemsByName.objectForKey(name);
    }

    protected void setNavigationItems(NSArray items) {
        NSMutableDictionary<String, ERXNavigationItem> itemsByName = new NSMutableDictionary<String, ERXNavigationItem>();
        if (items != null && items.count() > 0) {
            Enumeration e = items.objectEnumerator();
            while (e.hasMoreElements()) {
                ERXNavigationItem item = (ERXNavigationItem)e.nextElement();
                if (itemsByName.objectForKey(item.name()) != null) {
                    log.warn((Object)("Attempting to register multiple navigation items for the same name: " + item.name()));
                    continue;
                }
                itemsByName.setObjectForKey(item, item.name());
                if (!item.name().equals("Root")) continue;
                this.rootNavigationItem = item;
            }
        }
        if (this.rootNavigationItem == null) {
            log.warn((Object)"No root navigation item set. You need one.");
        }
        this.navigationItemsByName = itemsByName.immutableClone();
    }

    public void configureNavigation() {
        this.loadNavigationMenu();
        this.hasRegistered = true;
    }

    public void loadNavigationMenu() {
        NSMutableArray navigationMenus = new NSMutableArray();
        NSArray appNavigationMenu = (NSArray)ERXExtensions.readPropertyListFromFileinFramework(this.navigationMenuFileName(), null);
        if (appNavigationMenu != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Found navigation menu in application: " + WOApplication.application().name()));
            }
            navigationMenus.addObjectsFromArray(this.createNavigationItemsFromDictionaries(appNavigationMenu));
            this.registerObserverForFramework(null);
        }
        Enumeration e = ERXUtilities.allFrameworkNames().objectEnumerator();
        while (e.hasMoreElements()) {
            String frameworkName = (String)e.nextElement();
            NSArray aNavigationMenu = (NSArray)ERXExtensions.readPropertyListFromFileinFramework(this.navigationMenuFileName(), frameworkName);
            if (aNavigationMenu == null || aNavigationMenu.count() <= 0) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Found navigation menu in framework: " + frameworkName));
            }
            navigationMenus.addObjectsFromArray(this.createNavigationItemsFromDictionaries(aNavigationMenu));
            this.registerObserverForFramework(frameworkName);
        }
        this.setNavigationItems(navigationMenus);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Navigation Menu Configured");
        }
    }

    public void registerObserverForFramework(String frameworkName) {
        if (!WOApplication.application().isCachingEnabled() && !this.hasRegistered) {
            String filePath = ERXFileUtilities.pathForResourceNamed(this.navigationMenuFileName(), frameworkName, null);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Registering observer for filePath: " + filePath));
            }
            ERXFileNotificationCenter.defaultCenter().addObserver((Object)this, new NSSelector("reloadNavigationMenu", ERXConstant.NotificationClassArray), filePath);
        }
    }

    public ERXNavigationItem newNavigationItem(NSDictionary dict) {
        String className = (String)dict.objectForKey("navigationItemClassName");
        if (className != null) {
            Class c = ERXPatcher.classForName(className);
            return (ERXNavigationItem)_NSUtilities.instantiateObject((Class)c, (Class[])new Class[]{NSDictionary.class}, (Object[])new Object[]{dict}, (boolean)true, (boolean)true);
        }
        return new ERXNavigationItem(dict);
    }

    protected NSArray createNavigationItemsFromDictionaries(NSArray navItems) {
        NSMutableArray<ERXNavigationItem> navigationItems = null;
        if (navItems != null && navItems.count() > 0) {
            navigationItems = new NSMutableArray<ERXNavigationItem>();
            Enumeration e = navItems.objectEnumerator();
            while (e.hasMoreElements()) {
                navigationItems.addObject(this.newNavigationItem((NSDictionary)e.nextElement()));
            }
        }
        return navigationItems != null ? navigationItems : NSArray.EmptyArray;
    }

    public void reloadNavigationMenu(NSNotification notification) {
        log.info((Object)"Reloading Navigation Menu");
        this.loadNavigationMenu();
    }
}

