/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.components;

import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WOMessage;
import com.webobjects.appserver.WOResponse;
import er.extensions.foundation.ERXFileContext;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.log4j.Logger;

public class ERXDownloadResponse
extends WOComponent {
    private static final Logger log = Logger.getLogger(ERXDownloadResponse.class);
    private String _downloadFilename;
    private int _streamingContentSize = 0;
    private File _fileToDownload;
    private InputStream _inputStreamToDownload;
    private String _contentDisposition;
    private String _contentType;

    public ERXDownloadResponse(WOContext context) {
        super(context);
    }

    public void setFileContext(ERXFileContext fileContext) {
        this._fileToDownload = fileContext.file();
        this._downloadFilename = fileContext.clientFileName();
        this._contentType = fileContext.mimeType();
    }

    private String downloadFilename() {
        if (this._downloadFilename == null) {
            this._downloadFilename = this.fileToDownload() != null ? this.fileToDownload().getName() : "downloadedfile";
        }
        return this._downloadFilename;
    }

    public void setDownloadFilename(String newDownloadFilename) {
        this._downloadFilename = newDownloadFilename;
    }

    private File fileToDownload() {
        return this._fileToDownload;
    }

    public void setFileToDownload(File aFile) {
        this._fileToDownload = aFile;
    }

    private InputStream inputStreamToDownload() {
        return this._inputStreamToDownload;
    }

    public void setInputStreamToDownload(InputStream inStream, int contentSize) {
        this._inputStreamToDownload = inStream;
        this._streamingContentSize = contentSize;
    }

    public void appendToResponse(WOResponse aResponse, WOContext aContext) {
        super.appendToResponse(aResponse, aContext);
        aResponse.setContentEncoding(WOMessage.defaultEncoding());
        InputStream is = null;
        if (this.fileToDownload() != null) {
            try {
                is = new FileInputStream(this.fileToDownload());
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
            this._streamingContentSize = (int)this.fileToDownload().length();
        }
        if (is == null && this.inputStreamToDownload() != null) {
            is = this.inputStreamToDownload();
        }
        if (is == null) {
            throw new IllegalStateException("At least one of 'fileContext', 'fileToDownload' or 'inputStreamToDownload' must be set!");
        }
        aResponse.setContentStream(is, 0, this._streamingContentSize);
        aResponse.setHeader(this.contentType(), "content-type");
        aResponse.setHeader(this.contentDisposition(), "content-disposition");
        if (log.isDebugEnabled()) {
            log.debug((Object)("DownloadResponse = " + (Object)((Object)this)));
        }
    }

    private String contentDisposition() {
        if (this._contentDisposition == null) {
            this._contentDisposition = "attachment;filename=\"" + this.downloadFilename() + "\"";
        }
        return this._contentDisposition;
    }

    public void setContentDisposition(String contentDisposition) {
        this._contentDisposition = contentDisposition;
    }

    private String contentType() {
        if (this._contentType == null) {
            this._contentType = "application/octet-stream";
        }
        return this._contentType;
    }

    public void setContentType(String contentType) {
        this._contentType = contentType;
    }

    public String toString() {
        ToStringBuilder b = new ToStringBuilder((Object)this);
        b.append("File To Download", (Object)this._fileToDownload);
        b.append("Stream to Download", (Object)this._inputStreamToDownload);
        b.append("Download Filename", (Object)this._downloadFilename);
        b.append("Content Type", (Object)this._contentType);
        b.append("Content Disposition", (Object)this._contentDisposition);
        b.append("Content Size", this._streamingContentSize);
        return b.toString();
    }
}

