/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.components;

import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WOResponse;
import com.webobjects.foundation.NSForwardException;
import er.extensions.components.ERXStatelessComponent;
import er.extensions.foundation.ERXFileUtilities;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import org.apache.log4j.Logger;

public class ERXExternalContent
extends ERXStatelessComponent {
    private static final Logger log = Logger.getLogger(ERXExternalContent.class);

    public ERXExternalContent(WOContext context) {
        super(context);
    }

    private URL url() {
        URL result = null;
        Object o = this.valueForBinding("url");
        if (o instanceof String) {
            try {
                result = new URL((String)o);
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("Wrong URL: " + o + ", " + ex);
            }
        } else if (o instanceof URL) {
            result = (URL)o;
        }
        return result;
    }

    protected String contentString() {
        String result = null;
        String encoding = null;
        try {
            URL url = this.url();
            URLConnection connection = url.openConnection();
            connection.setDoInput(true);
            connection.setDoOutput(false);
            connection.setUseCaches(false);
            Enumeration e = this.bindingKeys().objectEnumerator();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                if (!key.startsWith("?")) continue;
                connection.setRequestProperty(key.substring(1), this.valueForBinding(key).toString());
            }
            if (connection.getContentEncoding() != null) {
                encoding = connection.getContentEncoding();
            }
            if (encoding == null) {
                encoding = (String)this.valueForBinding("encoding");
            }
            if (encoding == null) {
                encoding = "UTF-8";
            }
            InputStream stream = connection.getInputStream();
            byte[] bytes = ERXFileUtilities.bytesFromInputStream(stream);
            stream.close();
            result = new String(bytes, encoding);
        }
        catch (IOException ex) {
            throw NSForwardException._runtimeExceptionForThrowable((Throwable)ex);
        }
        return result;
    }

    public void appendToResponse(WOResponse response, WOContext arg1) {
        String content = this.contentString();
        response.appendContentString(content);
    }
}

