/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.components;

import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WORequest;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSMutableArray;
import er.extensions.eof.ERXConstant;
import java.util.Enumeration;
import org.apache.log4j.Logger;

public class ERXLayoutTable
extends WOComponent {
    static final Logger log = Logger.getLogger(ERXLayoutTable.class);
    NSArray _list;
    NSArray _colCounts;
    int _maxColumns;
    public int currentRow;
    public int currentCol;
    public int currentItemIndex;

    public ERXLayoutTable(WOContext aContext) {
        super(aContext);
        this._resetInternalCaches();
    }

    public boolean isStateless() {
        return true;
    }

    protected int intForBinding(String name, int defaultValue) {
        Object valueStr = this.valueForBinding(name);
        if (valueStr != null) {
            try {
                int value = Integer.parseInt(valueStr.toString());
                return value;
            }
            catch (NumberFormatException e) {
                throw new IllegalStateException("Problem parsing int from " + name + " binding " + e);
            }
        }
        return defaultValue;
    }

    public int cellRowSpan() {
        return this.intForBinding("cellRowSpan", 1);
    }

    public int cellColSpan() {
        return this.intForBinding("cellColSpan", 1);
    }

    public int maxColumns() {
        if (this._maxColumns == -1) {
            Object maxStr = this.valueForBinding("maxColumns");
            if (maxStr != null) {
                try {
                    this._maxColumns = Integer.parseInt(maxStr.toString());
                }
                catch (NumberFormatException e) {
                    throw new IllegalStateException("WOTable - problem parsing int from maxColumns binding " + e);
                }
            }
            if (this._maxColumns <= 0) {
                this._maxColumns = 1;
            }
        }
        return this._maxColumns;
    }

    public NSArray colCounts() {
        if (this._colCounts == null) {
            this._colCounts = (NSArray)this.valueForBinding("colCounts");
            if (this._colCounts == null) {
                NSMutableArray<Integer> colCounts = new NSMutableArray<Integer>();
                int maxColumns = this.maxColumns();
                int row = 0;
                int col = 0;
                int index = 0;
                int total = 0;
                Enumeration iter = this.list().objectEnumerator();
                while (iter.hasMoreElements()) {
                    int i;
                    Object item = iter.nextElement();
                    this.setValueForBinding(item, "item");
                    this.setValueForBinding(ERXConstant.integerForInt(row), "row");
                    this.setValueForBinding(ERXConstant.integerForInt(col), "col");
                    this.setValueForBinding(ERXConstant.integerForInt(index), "index");
                    int rowSpan = this.cellRowSpan();
                    int colSpan = this.cellColSpan();
                    for (i = colCounts.count(); i < rowSpan + row; ++i) {
                        colCounts.addObject(new Integer(maxColumns));
                    }
                    for (i = row; i < row + rowSpan; ++i) {
                        int currentMaxColumns = (Integer)colCounts.objectAtIndex(i);
                        colCounts.replaceObjectAtIndex(new Integer(currentMaxColumns -= colSpan - (i == row ? 1 : 0)), i);
                    }
                    int currentRowMaxColums = (Integer)colCounts.objectAtIndex(row);
                    total += rowSpan * colSpan;
                    if ((col += colSpan) >= currentRowMaxColums) {
                        ++row;
                        col = 0;
                    }
                    ++index;
                }
                if (total > maxColumns * colCounts.count()) {
                    colCounts.addObject(new Integer(total - maxColumns * colCounts.count()));
                }
                this._colCounts = colCounts;
            }
        }
        return this._colCounts;
    }

    public NSArray list() {
        if (this._list == null) {
            this._list = (NSArray)this.valueForBinding("list");
        }
        return this._list;
    }

    public int rowCount() {
        return this.colCounts().count();
    }

    public int colCount() {
        return ((Number)this.colCounts().objectAtIndex(this.currentRow)).intValue();
    }

    public void setCurrentRow(int newValue) {
        this.currentRow = newValue;
        this.currentCol = -1;
    }

    public void pushItem() {
        int index = this.currentItemIndex;
        NSArray aList = this.list();
        Object item = index < aList.count() ? aList.objectAtIndex(index) : null;
        this.setValueForBinding(item, "item");
        this.setValueForBinding(ERXConstant.integerForInt(this.currentRow), "row");
        this.setValueForBinding(ERXConstant.integerForInt(this.currentCol), "col");
        this.setValueForBinding(ERXConstant.integerForInt(index), "index");
        ++this.currentItemIndex;
    }

    public void setCurrentCol(int newValue) {
        this.currentCol = newValue;
        if (this.colCount() != newValue) {
            this.pushItem();
        } else {
            this.setValueForBinding(null, "item");
        }
    }

    protected void _resetInternalCaches() {
        this._list = null;
        this.currentCol = -1;
        this.currentRow = -1;
        this.currentItemIndex = 0;
        this._maxColumns = -1;
        this._colCounts = null;
    }

    public void takeValuesFromRequest(WORequest aRequest, WOContext aContext) {
        this._resetInternalCaches();
        super.takeValuesFromRequest(aRequest, aContext);
    }

    public void reset() {
        this._resetInternalCaches();
        this.setValueForBinding(null, "item");
    }
}

