/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.components;

import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;
import com.webobjects.eocontrol.EOSortOrdering;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSNotificationCenter;
import com.webobjects.foundation.NSSelector;
import er.extensions.foundation.ERXStringUtilities;
import er.extensions.localization.ERXLocalizer;
import er.extensions.woextensions.WOSortOrder;
import org.apache.log4j.Logger;

public class ERXSortOrder
extends WOSortOrder {
    public static final Logger log = Logger.getLogger(ERXSortOrder.class);
    public static final String SortOrderingChanged = "SortOrderingChanged";
    public static final int Reset = -1;
    public static final int Unsorted = 0;
    public static final int SortedAscending = 1;
    public static final int SortedDescending = 2;
    protected int _currentState = -1;

    public ERXSortOrder(WOContext context) {
        super(context);
    }

    public boolean synchronizesVariablesWithBindings() {
        return false;
    }

    public void reset() {
        super.reset();
        this._currentState = -1;
    }

    public int currentState() {
        if (this._currentState == -1) {
            this._currentState = 0;
            if (this._isCurrentKeyPrimary()) {
                NSSelector aCurrentState = this._primaryKeySortOrderingSelector();
                if (aCurrentState.equals((Object)EOSortOrdering.CompareAscending) || aCurrentState.equals((Object)EOSortOrdering.CompareCaseInsensitiveAscending)) {
                    this._currentState = 1;
                } else if (aCurrentState.equals((Object)EOSortOrdering.CompareDescending) || aCurrentState.equals((Object)EOSortOrdering.CompareCaseInsensitiveDescending)) {
                    this._currentState = 2;
                }
            }
        }
        return this._currentState;
    }

    public boolean hasCustomImageSrcForCurrentState() {
        boolean hasCustomImage = false;
        switch (this.currentState()) {
            case 0: {
                hasCustomImage = !ERXStringUtilities.stringIsNullOrEmpty((String)this.valueForBinding("unsortedImageSrc"));
                break;
            }
            case 1: {
                hasCustomImage = !ERXStringUtilities.stringIsNullOrEmpty((String)this.valueForBinding("sortedAscendingImageSrc"));
                break;
            }
            case 2: {
                hasCustomImage = !ERXStringUtilities.stringIsNullOrEmpty((String)this.valueForBinding("sortedAscendingImageSrc"));
            }
        }
        return hasCustomImage;
    }

    public boolean hasCustomImageNameForCurrentState() {
        boolean hasCustomImage = false;
        switch (this.currentState()) {
            case 0: {
                hasCustomImage = !ERXStringUtilities.stringIsNullOrEmpty((String)this.valueForBinding("unsortedImageName"));
                break;
            }
            case 1: {
                hasCustomImage = !ERXStringUtilities.stringIsNullOrEmpty((String)this.valueForBinding("sortedAscendingImageName"));
                break;
            }
            case 2: {
                hasCustomImage = !ERXStringUtilities.stringIsNullOrEmpty((String)this.valueForBinding("sortedDescendingImageName"));
            }
        }
        return hasCustomImage;
    }

    public String imageNameForCurrentState() {
        String imageName = null;
        switch (this.currentState()) {
            case 0: {
                imageName = this.unsortedImageName();
                break;
            }
            case 1: {
                imageName = this.sortedAscendingImageName();
                break;
            }
            case 2: {
                imageName = this.sortedDescendingImageName();
            }
        }
        return imageName;
    }

    public String customImageSrcForCurrentState() {
        String src = null;
        switch (this.currentState()) {
            case 0: {
                src = (String)this.valueForBinding("unsortedImageSrc");
                break;
            }
            case 1: {
                src = (String)this.valueForBinding("sortedAscendingImageSrc");
                break;
            }
            case 2: {
                src = (String)this.valueForBinding("sortedDescendingImageSrc");
            }
        }
        return src;
    }

    public String frameworkName() {
        return this.hasCustomImageNameForCurrentState() ? (this.hasBinding("frameworkName") ? (String)this.valueForBinding("frameworkName") : "app") : "JavaWOExtensions";
    }

    public String unsortedImageName() {
        return this.hasBinding("unsortedImageName") ? (String)this.valueForBinding("unsortedImageName") : "Unsorted.gif";
    }

    public String sortedAscendingImageName() {
        return this.hasBinding("sortedAscendingImageName") ? (String)this.valueForBinding("sortedAscendingImageName") : "Ascending.gif";
    }

    public String sortedDescendingImageName() {
        return this.hasBinding("sortedDescendingImageName") ? (String)this.valueForBinding("sortedDescendingImageName") : "Descending.gif";
    }

    public Object width() {
        return this.hasBinding("width") ? this.valueForBinding("width") : "9";
    }

    public Object height() {
        return this.hasBinding("height") ? this.valueForBinding("height") : "11";
    }

    public WOComponent toggleClicked() {
        super.toggleClicked();
        if (log.isDebugEnabled()) {
            log.debug((Object)("toggleClicked " + this.valueForBinding("d2wContext")));
        }
        if (this.valueForBinding("d2wContext") != null) {
            NSNotificationCenter.defaultCenter().postNotification(SortOrderingChanged, (Object)this.displayGroup().sortOrderings(), new NSDictionary<String, Object>(this.valueForBinding("d2wContext"), "d2wContext"));
        }
        return null;
    }

    public String helpString() {
        return ERXLocalizer.currentLocalizer().localizedTemplateStringForKeyWithObject("ERXSortOrder.sortBy", (Object)this);
    }

    protected EOSortOrdering _primarySortOrdering() {
        NSArray nsarray = this.displayGroup().sortOrderings();
        if (nsarray != null && nsarray.count() > 0) {
            EOSortOrdering eosortordering = (EOSortOrdering)nsarray.objectAtIndex(0);
            return eosortordering;
        }
        return null;
    }

    protected NSSelector _primaryKeySortOrderingSelector() {
        EOSortOrdering eosortordering = this._primarySortOrdering();
        NSSelector nsselector = null;
        if (eosortordering != null) {
            nsselector = eosortordering.selector();
        }
        return nsselector;
    }

    protected boolean _isCurrentKeyPrimary() {
        EOSortOrdering eosortordering = this._primarySortOrdering();
        return eosortordering != null && eosortordering.key() != null && eosortordering.key().equals(this.key());
    }
}

