/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.components._private;

import com.webobjects.appserver.WOAssociation;
import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WODynamicElement;
import com.webobjects.appserver.WOElement;
import com.webobjects.appserver.WORequest;
import com.webobjects.appserver.WOResponse;
import com.webobjects.appserver._private.WODynamicElementCreationException;
import com.webobjects.appserver._private.WOInput;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation.NSTimeZone;
import com.webobjects.foundation.NSTimestampFormatter;
import er.extensions.appserver.ERXSession;
import er.extensions.formatters.ERXNumberFormatter;
import er.extensions.formatters.ERXTimestampFormatter;
import er.extensions.foundation.ERXKeyValueCodingUtilities;
import er.extensions.foundation.ERXPatcher;
import er.extensions.validation.ERXValidationException;
import java.math.BigDecimal;
import java.text.Format;
import java.text.ParseException;
import java.util.TimeZone;
import org.apache.log4j.Logger;

public class ERXWOTextField
extends WOInput {
    public static Logger log = Logger.getLogger(ERXWOTextField.class);
    protected WOAssociation _formatter;
    protected WOAssociation _dateFormat;
    protected WOAssociation _numberFormat;
    protected WOAssociation _useDecimalNumber;
    protected WOAssociation _blankIsNull;
    protected WOAssociation _readonly;

    public ERXWOTextField(String tagname, NSDictionary nsdictionary, WOElement woelement) {
        super("input", nsdictionary, woelement);
        if (this._value == null || !this._value.isValueSettable()) {
            throw new WODynamicElementCreationException("<" + ((Object)((Object)this)).getClass().getName() + "> 'value' attribute not present or is a constant");
        }
        this._formatter = (WOAssociation)this._associations.removeObjectForKey("formatter");
        this._dateFormat = (WOAssociation)this._associations.removeObjectForKey("dateformat");
        this._numberFormat = (WOAssociation)this._associations.removeObjectForKey("numberformat");
        this._useDecimalNumber = (WOAssociation)this._associations.removeObjectForKey("useDecimalNumber");
        this._blankIsNull = (WOAssociation)this._associations.removeObjectForKey("blankIsNull");
        this._readonly = (WOAssociation)this._associations.removeObjectForKey("readonly");
        if (this._dateFormat != null && this._numberFormat != null) {
            throw new WODynamicElementCreationException("<" + ((Object)((Object)this)).getClass().getName() + "> Cannot have 'dateFormat' and 'numberFormat' attributes at the same time.");
        }
    }

    public String type() {
        return "text";
    }

    protected boolean isDisabledInContext(WOContext context) {
        WOAssociation disabled = (WOAssociation)ERXKeyValueCodingUtilities.privateValueForKey((Object)this, "_disabled");
        return disabled != null && disabled.booleanValueInComponent(context.component());
    }

    protected boolean isReadonlyInContext(WOContext context) {
        return this._readonly != null && this._readonly.booleanValueInComponent(context.component());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void takeValuesFromRequest(WORequest worequest, WOContext wocontext) {
        String name;
        WOComponent component = wocontext.component();
        if (!this.isDisabledInContext(wocontext) && wocontext._wasFormSubmitted() && !this.isReadonlyInContext(wocontext) && (name = this.nameInContext(wocontext, component)) != null) {
            Object objValue;
            boolean blankIsNull;
            boolean bl = blankIsNull = this._blankIsNull == null || this._blankIsNull.booleanValueInComponent(component);
            String stringValue = blankIsNull ? worequest.stringFormValueForKey(name) : ((objValue = worequest.formValueForKey(name)) == null ? null : objValue.toString());
            Object result = stringValue;
            if (stringValue != null) {
                Object formatString;
                Format format = null;
                boolean hasFormatter = false;
                if (stringValue.length() != 0) {
                    if (this._formatter != null) {
                        format = (Format)this._formatter.valueInComponent(component);
                    }
                    if (format == null) {
                        if (this._dateFormat != null) {
                            formatString = (String)this._dateFormat.valueInComponent(component);
                            if (formatString != null) {
                                format = ERXTimestampFormatter.dateFormatterForPattern((String)formatString);
                            }
                        } else if (this._numberFormat != null && (formatString = (String)this._numberFormat.valueInComponent(component)) != null) {
                            format = ERXNumberFormatter.numberFormatterForPattern((String)formatString);
                        }
                    } else {
                        hasFormatter = true;
                    }
                }
                if (format != null) {
                    if (ERXSession.autoAdjustTimeZone() && !hasFormatter && format instanceof NSTimestampFormatter && wocontext.hasSession() && ERXSession.class.isAssignableFrom(wocontext.session().getClass())) {
                        formatString = format;
                        synchronized (formatString) {
                            ERXSession session = (ERXSession)wocontext.session();
                            NSTimeZone zone = NSTimeZone._nstimeZoneWithTimeZone((TimeZone)session.timeZone());
                            NSTimestampFormatter tsFormat = (NSTimestampFormatter)format;
                            NSTimeZone parseZone = tsFormat.defaultParseTimeZone();
                            NSTimeZone formatZone = tsFormat.defaultFormatTimeZone();
                            tsFormat.setDefaultFormatTimeZone(zone);
                            tsFormat.setDefaultParseTimeZone(zone);
                            try {
                                try {
                                    Object parsedObject = format.parseObject(stringValue);
                                    String reformatedObject = format.format(parsedObject);
                                    result = format.parseObject(reformatedObject);
                                }
                                catch (ParseException parseexception) {
                                    String keyPath = this._value.keyPath();
                                    ERXValidationException validationexception = new ERXValidationException("InvalidValueException", parseexception, keyPath, stringValue);
                                    component.validationFailedWithException((Throwable)((Object)validationexception), (Object)stringValue, keyPath);
                                    Object var20_25 = null;
                                    tsFormat.setDefaultFormatTimeZone(formatZone);
                                    tsFormat.setDefaultParseTimeZone(parseZone);
                                    return;
                                }
                                Object var20_24 = null;
                            }
                            catch (Throwable throwable) {
                                Object var20_26 = null;
                                tsFormat.setDefaultFormatTimeZone(formatZone);
                                tsFormat.setDefaultParseTimeZone(parseZone);
                                throw throwable;
                            }
                            tsFormat.setDefaultFormatTimeZone(formatZone);
                            tsFormat.setDefaultParseTimeZone(parseZone);
                        }
                    }
                    try {
                        Object parsedObject = format.parseObject(stringValue);
                        String reformatedObject = format.format(parsedObject);
                        result = format.parseObject(reformatedObject);
                    }
                    catch (ParseException parseexception) {
                        String keyPath = this._value.keyPath();
                        ERXValidationException validationexception = new ERXValidationException("InvalidValueException", parseexception, keyPath, stringValue);
                        component.validationFailedWithException((Throwable)((Object)validationexception), (Object)stringValue, keyPath);
                        return;
                    }
                    if (result != null && this._useDecimalNumber != null && this._useDecimalNumber.booleanValueInComponent(component)) {
                        result = new BigDecimal(result.toString());
                    }
                } else if (blankIsNull && result.toString().length() == 0) {
                    result = null;
                }
            }
            this._value.setValue(result, component);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void _appendValueAttributeToResponse(WOResponse woresponse, WOContext wocontext) {
        block21: {
            Object formatString;
            boolean hasFormatter;
            Format format;
            String stringValue;
            Object valueInComponent;
            block23: {
                block22: {
                    WOComponent component = wocontext.component();
                    valueInComponent = this._value.valueInComponent(component);
                    if (valueInComponent == null) break block21;
                    stringValue = null;
                    format = null;
                    hasFormatter = false;
                    if (this._formatter != null) {
                        format = (Format)this._formatter.valueInComponent(component);
                    }
                    if (format != null) break block22;
                    if (this._dateFormat != null) {
                        formatString = (String)this._dateFormat.valueInComponent(component);
                        if (formatString != null) {
                            format = ERXTimestampFormatter.dateFormatterForPattern((String)formatString);
                        }
                        break block23;
                    } else if (this._numberFormat != null && (formatString = (String)this._numberFormat.valueInComponent(component)) != null) {
                        format = ERXNumberFormatter.numberFormatterForPattern((String)formatString);
                    }
                    break block23;
                }
                hasFormatter = true;
            }
            if (format != null) {
                if (ERXSession.autoAdjustTimeZone() && !hasFormatter && format instanceof NSTimestampFormatter && wocontext.hasSession() && ERXSession.class.isAssignableFrom(wocontext.session().getClass())) {
                    formatString = format;
                    synchronized (formatString) {
                        block20: {
                            ERXSession session = (ERXSession)wocontext.session();
                            NSTimeZone zone = NSTimeZone._nstimeZoneWithTimeZone((TimeZone)session.timeZone());
                            NSTimestampFormatter tsFormat = (NSTimestampFormatter)format;
                            NSTimeZone parseZone = tsFormat.defaultParseTimeZone();
                            NSTimeZone formatZone = tsFormat.defaultFormatTimeZone();
                            tsFormat.setDefaultFormatTimeZone(zone);
                            tsFormat.setDefaultParseTimeZone(zone);
                            try {
                                try {
                                    String formatedValue = format.format(valueInComponent);
                                    Object reparsedObject = format.parseObject(formatedValue);
                                    stringValue = format.format(reparsedObject);
                                }
                                catch (IllegalArgumentException illegalargumentexception) {
                                    NSLog._conditionallyLogPrivateException((Throwable)illegalargumentexception);
                                    stringValue = null;
                                    Object var17_22 = null;
                                    tsFormat.setDefaultFormatTimeZone(formatZone);
                                    tsFormat.setDefaultParseTimeZone(parseZone);
                                    break block20;
                                }
                                catch (ParseException parseexception) {
                                    NSLog._conditionallyLogPrivateException((Throwable)parseexception);
                                    stringValue = null;
                                    Object var17_23 = null;
                                    tsFormat.setDefaultFormatTimeZone(formatZone);
                                    tsFormat.setDefaultParseTimeZone(parseZone);
                                    break block20;
                                }
                                Object var17_21 = null;
                            }
                            catch (Throwable throwable) {
                                Object var17_24 = null;
                                tsFormat.setDefaultFormatTimeZone(formatZone);
                                tsFormat.setDefaultParseTimeZone(parseZone);
                                throw throwable;
                            }
                            tsFormat.setDefaultFormatTimeZone(formatZone);
                            tsFormat.setDefaultParseTimeZone(parseZone);
                        }
                    }
                } else {
                    try {
                        String formatedValue = format.format(valueInComponent);
                        Object reparsedObject = format.parseObject(formatedValue);
                        stringValue = format.format(reparsedObject);
                    }
                    catch (IllegalArgumentException illegalargumentexception) {
                        NSLog._conditionallyLogPrivateException((Throwable)illegalargumentexception);
                        stringValue = null;
                    }
                    catch (ParseException parseexception) {
                        NSLog._conditionallyLogPrivateException((Throwable)parseexception);
                        stringValue = null;
                    }
                }
            }
            if (stringValue == null) {
                stringValue = valueInComponent.toString();
            }
            woresponse._appendTagAttributeAndValue("value", stringValue, true);
        }
        if (this.isReadonlyInContext(wocontext)) {
            woresponse._appendTagAttributeAndValue("readonly", "readonly", false);
        }
    }

    protected void _appendCloseTagToResponse(WOResponse woresponse, WOContext wocontext) {
    }

    public String toString() {
        StringBuffer stringbuffer = new StringBuffer();
        stringbuffer.append("<");
        stringbuffer.append(((Object)((Object)this)).getClass().getName());
        stringbuffer.append(" formatter=" + this._formatter);
        stringbuffer.append(" dateFormat=" + this._dateFormat);
        stringbuffer.append(" numberFormat=" + this._numberFormat);
        stringbuffer.append(" useDecimalNumber=" + this._useDecimalNumber);
        stringbuffer.append(">");
        return stringbuffer.toString();
    }

    public void appendToResponse(WOResponse woresponse, WOContext wocontext) {
        WOResponse newResponse = ERXPatcher.DynamicElementsPatches.cleanupXHTML ? new WOResponse() : woresponse;
        super.appendToResponse(newResponse, wocontext);
        ERXPatcher.DynamicElementsPatches.processResponse((WODynamicElement)this, newResponse, wocontext, 0, this.nameInContext(wocontext, wocontext.component()));
        if (ERXPatcher.DynamicElementsPatches.cleanupXHTML) {
            woresponse.appendContentString(newResponse.contentString());
        }
    }
}

