/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.components.javascript;

import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WOResponse;
import er.extensions.appserver.ERXResponseRewriter;
import er.extensions.components.ERXStatelessComponent;
import er.extensions.components._private.ERXWOForm;
import er.extensions.foundation.ERXStringUtilities;
import er.extensions.localization.ERXLocalizer;
import org.apache.log4j.Logger;

public class ERXEditDateJavascript
extends ERXStatelessComponent {
    static final Logger log = Logger.getLogger(ERXEditDateJavascript.class);
    private static String _datePickerJavaScriptUrl;
    private String elementID;

    public ERXEditDateJavascript(WOContext context) {
        super(context);
    }

    public void awake() {
        this.elementID = this.context().elementID().replace('.', '_');
    }

    public void appendToResponse(WOResponse response, WOContext context) {
        ERXResponseRewriter.addScriptResourceInHead(response, context, "ERExtensions", "date-picker.js");
        super.appendToResponse(response, context);
    }

    public String dateformat() {
        String format = this.stringValueForBinding("dateformat");
        if (format == null) {
            format = "%m/%d/%Y";
        }
        return format;
    }

    public void setDateformat(String value) {
        this.setValueForBinding(value, "dateformat");
    }

    public String dateString() {
        return this.stringValueForBinding("dateString");
    }

    public void setDateString(String value) {
        this.setValueForBinding(value, "dateString");
    }

    public String name() {
        return "datebox" + this.elementID;
    }

    public String href() {
        String formName = ERXWOForm.formName(this.context(), "EditForm");
        return "show_calendar('" + formName + "." + this.name() + "', null, null, '" + this.formatterStringForScript() + "'); return false;";
    }

    public String formatterStringForScript() {
        String format = ERXLocalizer.currentLocalizer().localizedStringForKeyWithDefault(this.dateformat());
        return ERXEditDateJavascript.formatterStringForScript(format);
    }

    public static String formatterStringForScript(String format) {
        String result = format;
        result = ERXStringUtilities.replaceStringByStringInString("%Y", "yyyy", result);
        result = ERXStringUtilities.replaceStringByStringInString("%y", "yy", result);
        result = ERXStringUtilities.replaceStringByStringInString("%m", "MM", result);
        result = ERXStringUtilities.replaceStringByStringInString("%d", "dd", result);
        result = ERXStringUtilities.replaceStringByStringInString("%b", "MON", result);
        return result;
    }
}

