/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.eof;

import com.webobjects.eoaccess.EOAttribute;
import com.webobjects.eoaccess.EODatabase;
import com.webobjects.eoaccess.EODatabaseContext;
import com.webobjects.eoaccess.EODatabaseOperation;
import com.webobjects.eoaccess.EOEntity;
import com.webobjects.eoaccess.ERXEOAccessHelper;
import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.eocontrol.EOFetchSpecification;
import com.webobjects.eocontrol.EOGlobalID;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSKeyValueCoding;
import com.webobjects.foundation.NSMutableDictionary;
import er.extensions.eof.ERXDatabase;
import org.apache.log4j.Logger;

public class ERXDatabaseContext
extends EODatabaseContext {
    public static final Logger log = Logger.getLogger(ERXDatabaseContext.class);
    private static ThreadLocal _fetching = new ThreadLocal();

    public ERXDatabaseContext(EODatabase database) {
        super((EODatabase)new ERXDatabase(database));
    }

    public static boolean isFetching() {
        Boolean fetching = (Boolean)_fetching.get();
        return fetching != null && fetching != false;
    }

    public static void setFetching(boolean fetching) {
        _fetching.set(fetching);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public NSArray objectsForSourceGlobalID(EOGlobalID gid, String name, EOEditingContext context) {
        NSArray results;
        boolean fetching = ERXDatabaseContext.isFetching();
        if (!fetching) {
            ERXDatabaseContext.setFetching(true);
        }
        try {
            results = super.objectsForSourceGlobalID(gid, name, context);
            Object var7_6 = null;
            if (fetching) return results;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (fetching) throw throwable;
            ERXDatabaseContext.setFetching(false);
            throw throwable;
        }
        ERXDatabaseContext.setFetching(false);
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public NSArray _objectsWithFetchSpecificationEditingContext(EOFetchSpecification fetchSpec, EOEditingContext context) {
        NSArray results;
        boolean fetching = ERXDatabaseContext.isFetching();
        if (!fetching) {
            ERXDatabaseContext.setFetching(!fetchSpec.refreshesRefetchedObjects());
        }
        try {
            results = super._objectsWithFetchSpecificationEditingContext(fetchSpec, context);
            Object var6_5 = null;
            if (fetching) return results;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (fetching) throw throwable;
            ERXDatabaseContext.setFetching(false);
            throw throwable;
        }
        ERXDatabaseContext.setFetching(false);
        return results;
    }

    public void _followFetchSpecification(EOFetchSpecification fetchSpec, String relationshipName, NSArray sourceObjects, EOEditingContext context) {
        fetchSpec = ERXEOAccessHelper.adjustPrefetching(this, fetchSpec, relationshipName, sourceObjects, context);
        super._followFetchSpecification(fetchSpec, relationshipName, sourceObjects, context);
    }

    public void _verifyNoChangesToReadonlyEntity(EODatabaseOperation dbOp) {
        EOEntity entity = dbOp.entity();
        if (entity.isReadOnly()) {
            switch (dbOp.databaseOperator()) {
                case 0: {
                    return;
                }
                case 1: {
                    throw new IllegalStateException("cannot insert object:" + dbOp.object() + " that corresponds to read-only entity: " + entity.name() + " in databaseContext " + (Object)((Object)this));
                }
                case 3: {
                    throw new IllegalStateException("cannot delete object:" + dbOp.object() + " that corresponds to read-only entity:" + entity.name() + " in databaseContext " + (Object)((Object)this));
                }
                case 2: {
                    if (!dbOp.dbSnapshot().equals(dbOp.newRow())) {
                        throw new IllegalStateException("cannot update '" + dbOp.rowDiffsForAttributes(entity.attributes()).allKeys() + "' keys on object:" + dbOp.object() + " that corresponds to read-only entity: " + entity.name() + " in databaseContext " + (Object)((Object)this));
                    }
                    return;
                }
            }
        }
        if (dbOp.databaseOperator() == 2 && ((Boolean)NSKeyValueCoding.Utility.valueForKey((Object)entity, (String)"_hasNonUpdateableAttributes")).booleanValue()) {
            NSArray keys = (NSArray)NSKeyValueCoding.Utility.valueForKey((Object)entity, (String)"dbSnapshotKeys");
            NSDictionary dbSnapshot = dbOp.dbSnapshot();
            NSMutableDictionary newRow = dbOp.newRow();
            for (int i = keys.count() - 1; i >= 0; --i) {
                String key = (String)keys.objectAtIndex(i);
                EOAttribute att = entity.attributeNamed(key);
                if (att == null || !att._isNonUpdateable() || dbSnapshot.objectForKey(key).equals(newRow.objectForKey(key))) continue;
                if (att.isReadOnly()) {
                    throw new IllegalStateException("cannot update read-only key '" + key + "' on object:" + dbOp.object() + " of entity: " + entity.name() + " in databaseContext " + (Object)((Object)this));
                }
                throw new IllegalStateException("cannot update primary-key '" + key + "' from '" + dbSnapshot.objectForKey(key) + "' to '" + newRow.objectForKey(key) + "' on object:" + dbOp.object() + " of entity: " + entity.name() + " in databaseContext " + (Object)((Object)this));
            }
        }
    }
}

