/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.eof;

import com.webobjects.eoaccess.EODatabaseContext;
import com.webobjects.eoaccess.EOEntity;
import com.webobjects.eoaccess.EORelationship;
import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.eocontrol.EOEnterpriseObject;
import com.webobjects.eocontrol.EOFaultHandler;
import com.webobjects.eocontrol.EOFetchSpecification;
import com.webobjects.eocontrol.EOGlobalID;
import com.webobjects.eocontrol.EOKeyGlobalID;
import com.webobjects.eocontrol.EOObjectStoreCoordinator;
import com.webobjects.eocontrol.EOOrQualifier;
import com.webobjects.eocontrol.EOQualifier;
import com.webobjects.eocontrol.EOTemporaryGlobalID;
import com.webobjects.eocontrol._EOIntegralKeyGlobalID;
import com.webobjects.eocontrol._EOVectorKeyGlobalID;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSData;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSTimestamp;
import er.extensions.eof.ERXEOAccessUtilities;
import er.extensions.foundation.ERXArrayUtilities;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ERXEOGlobalIDUtilities {
    public static final Logger log = Logger.getLogger(ERXEOGlobalIDUtilities.class);

    public static NSDictionary globalIDsGroupedByEntityName(NSArray globalIDs) {
        return ERXArrayUtilities.arrayGroupedByKeyPath(globalIDs, "entityName");
    }

    public static NSArray<Object> primaryKeyValuesWithGlobalIDs(NSArray<EOGlobalID> globalIDs) {
        NSMutableArray<Object> result = new NSMutableArray<Object>();
        if (globalIDs.count() > 0) {
            NSDictionary gidsByEntity = ERXEOGlobalIDUtilities.globalIDsGroupedByEntityName(globalIDs);
            Enumeration e = gidsByEntity.keyEnumerator();
            while (e.hasMoreElements()) {
                String entityName = (String)e.nextElement();
                NSArray gidsForEntity = (NSArray)gidsByEntity.objectForKey(entityName);
                Enumeration gids = gidsForEntity.objectEnumerator();
                while (gids.hasMoreElements()) {
                    EOKeyGlobalID keyGID = (EOKeyGlobalID)gids.nextElement();
                    if (keyGID.keyCount() == 1) {
                        result.addObject(keyGID.keyValues()[0]);
                        continue;
                    }
                    throw new IllegalArgumentException("GID has more than one key: " + keyGID);
                }
            }
        }
        return result;
    }

    public static NSArray<EOGlobalID> globalIDsWithPrimaryKeyValues(String entityName, NSArray<Object> values) {
        NSMutableArray<EOGlobalID> result = new NSMutableArray<EOGlobalID>();
        if (values.count() > 0) {
            Enumeration<Object> pks = values.objectEnumerator();
            while (pks.hasMoreElements()) {
                Object value = pks.nextElement();
                EOKeyGlobalID gid = EOKeyGlobalID.globalIDWithEntityName((String)entityName, (Object[])new Object[]{value});
                result.addObject((EOGlobalID)gid);
            }
        }
        return result;
    }

    public static EOEnterpriseObject fetchObjectWithGlobalID(EOEditingContext ec, EOGlobalID gid) {
        NSMutableArray results = ERXEOGlobalIDUtilities.fetchObjectsWithGlobalIDs(ec, new NSArray<EOGlobalID>(gid));
        EOEnterpriseObject eo = ((NSArray)results).count() > 0 ? (EOEnterpriseObject)results.objectAtIndex(0) : null;
        return eo;
    }

    public static NSMutableArray fetchObjectsWithGlobalIDs(EOEditingContext ec, NSArray globalIDs) {
        return ERXEOGlobalIDUtilities.fetchObjectsWithGlobalIDs(ec, globalIDs, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NSMutableArray fetchObjectsWithGlobalIDs(EOEditingContext ec, NSArray globalIDs, boolean refreshesRefetchedObjects) {
        NSMutableArray<EOEnterpriseObject> result = new NSMutableArray<EOEnterpriseObject>();
        ec.lock();
        ec.rootObjectStore().lock();
        try {
            NSDictionary gidsByEntity = ERXEOGlobalIDUtilities.globalIDsGroupedByEntityName(globalIDs);
            Enumeration e = gidsByEntity.keyEnumerator();
            while (e.hasMoreElements()) {
                String entityName = (String)e.nextElement();
                NSArray gidsForEntity = (NSArray)gidsByEntity.objectForKey(entityName);
                NSMutableArray<EOQualifier> qualifiers = new NSMutableArray<EOQualifier>();
                EOEntity entity = ERXEOAccessUtilities.entityNamed(ec, entityName);
                Enumeration gids = gidsForEntity.objectEnumerator();
                while (gids.hasMoreElements()) {
                    EOGlobalID g = (EOGlobalID)gids.nextElement();
                    boolean fetch = refreshesRefetchedObjects;
                    if (!fetch) {
                        EOEnterpriseObject eo = ec.objectForGlobalID(g);
                        if (eo != null && !EOFaultHandler.isFault((Object)eo)) {
                            result.addObject(eo);
                        } else {
                            Object var17_17;
                            NSDictionary row;
                            EODatabaseContext databaseContext = (EODatabaseContext)((EOObjectStoreCoordinator)ec.rootObjectStore()).objectStoreForGlobalID(g);
                            databaseContext.lock();
                            try {
                                row = databaseContext.snapshotForGlobalID(g, ec.fetchTimestamp());
                                var17_17 = null;
                            }
                            catch (Throwable throwable) {
                                var17_17 = null;
                                databaseContext.unlock();
                                throw throwable;
                            }
                            databaseContext.unlock();
                            if (row == null) {
                                fetch = true;
                            } else {
                                eo = ec.faultForGlobalID(g, ec);
                                result.addObject(eo);
                            }
                        }
                    }
                    if (!fetch) continue;
                    EOQualifier qualifier = entity.qualifierForPrimaryKey(entity.primaryKeyForGlobalID(g));
                    qualifiers.addObject(qualifier);
                }
                if (qualifiers.count() <= 0) continue;
                EOOrQualifier qualifier = new EOOrQualifier(qualifiers);
                EOFetchSpecification fetchSpec = new EOFetchSpecification(entityName, (EOQualifier)qualifier, null);
                fetchSpec.setRefreshesRefetchedObjects(refreshesRefetchedObjects);
                NSArray details = ec.objectsWithFetchSpecification(fetchSpec);
                result.addObjectsFromArray(details);
            }
            Object var19_19 = null;
        }
        catch (Throwable throwable) {
            Object var19_20 = null;
            ec.rootObjectStore().unlock();
            ec.unlock();
            throw throwable;
        }
        ec.rootObjectStore().unlock();
        ec.unlock();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NSArray fireFaultsForGlobalIDs(EOEditingContext ec, NSArray globalIDs, NSArray prefetchingKeypaths) {
        NSMutableArray<int> result = new NSMutableArray<int>(globalIDs.count());
        if (globalIDs.count() > 0) {
            NSMutableArray<int> faults = new NSMutableArray<int>(globalIDs.count());
            Enumeration ids = globalIDs.objectEnumerator();
            while (ids.hasMoreElements()) {
                EOGlobalID gid = (EOGlobalID)ids.nextElement();
                EOEnterpriseObject eo = ec.faultForGlobalID(gid, ec);
                if (EOFaultHandler.isFault((Object)eo)) {
                    faults.addObject((int)gid);
                    continue;
                }
                result.addObject((int)eo);
            }
            NSMutableArray loadedObjects = ERXEOGlobalIDUtilities.fetchObjectsWithGlobalIDs(ec, faults);
            result.addObjectsFromArray(loadedObjects);
            if (prefetchingKeypaths != null && prefetchingKeypaths.count() > 0) {
                NSDictionary objectsByEntity = ERXArrayUtilities.arrayGroupedByKeyPath(result, "entityName");
                Enumeration e = objectsByEntity.keyEnumerator();
                while (e.hasMoreElements()) {
                    String entityName = (String)e.nextElement();
                    NSArray<int> objects = objectsByEntity.objectForKey(entityName);
                    EOEntity entity = ERXEOAccessUtilities.entityNamed(ec, entityName);
                    Enumeration keyPaths = prefetchingKeypaths.objectEnumerator();
                    while (keyPaths.hasMoreElements()) {
                        Object var16_15;
                        String keypath = (String)keyPaths.nextElement();
                        EORelationship relationship = entity.relationshipNamed(keypath);
                        EODatabaseContext dbc = ERXEOAccessUtilities.databaseContextForEntityNamed((EOObjectStoreCoordinator)ec.rootObjectStore(), entityName);
                        dbc.lock();
                        try {
                            dbc.batchFetchRelationship(relationship, objects, ec);
                            var16_15 = null;
                        }
                        catch (Throwable throwable) {
                            var16_15 = null;
                            dbc.unlock();
                            throw throwable;
                        }
                        dbc.unlock();
                        {
                        }
                    }
                }
            }
        }
        return result;
    }

    public static NSArray fireFaultsForGlobalIDs(EOEditingContext ec, NSArray globalIDs) {
        return ERXEOGlobalIDUtilities.fireFaultsForGlobalIDs(ec, globalIDs, NSArray.EmptyArray);
    }

    public static EOKeyGlobalID createGlobalID(String entityName, Object[] values) {
        Object primaryKey;
        if (values != null && values.length == 1 && (primaryKey = values[0]) instanceof Number) {
            return new _EOIntegralKeyGlobalID(entityName, (Number)primaryKey);
        }
        return new _EOVectorKeyGlobalID(entityName, values);
    }

    public static class Info {
        private byte[] _data;
        private static final int _HostIdentificationStartIndex = 0;
        private static final int _ProcessIdentificationStartIndex = 6;
        private static final int _CounterStartIndex = 10;
        private static final int _TimestampStartIndex = 12;
        private static final int _RandomStartIndex = 20;

        public Info(EOGlobalID gid) {
            EOKeyGlobalID keyGid;
            Object value;
            if (gid instanceof EOTemporaryGlobalID) {
                this._data = ((EOTemporaryGlobalID)gid)._rawBytes();
            } else if (gid instanceof EOKeyGlobalID && (value = (keyGid = (EOKeyGlobalID)gid).keyValues()[0]) instanceof NSData && keyGid.keyValues().length == 1) {
                this._data = ((NSData)value)._bytesNoCopy();
            }
            if (this._data == null) {
                throw new IllegalArgumentException("This class only works with EOTemporaryGlobalID or EOKeyGlobalID with a single 24-byte data PK");
            }
        }

        private byte extractByte(int offset) {
            return this._data[offset + 0];
        }

        private short extractShort(int offset) {
            short result = 0;
            result = (short)(result | this.extractByte(offset + 0) & 0xFF);
            result = (short)(result << 8);
            result = (short)(result | this.extractByte(offset + 1) & 0xFF);
            return result;
        }

        private int extractInt(int offset) {
            int result = 0;
            result |= this.extractShort(offset + 0) & 0xFFFF;
            result <<= 16;
            return result |= this.extractShort(offset + 2) & 0xFFFF;
        }

        private long extractLong(int offset) {
            long result = 0L;
            result |= (long)this.extractInt(offset + 0) & 0xFFFFFFFFL;
            result <<= 32;
            return result |= (long)this.extractInt(offset + 4) & 0xFFFFFFFFL;
        }

        public NSTimestamp timestamp() {
            return new NSTimestamp(this.milliseconds());
        }

        public long milliseconds() {
            return this.extractLong(12);
        }

        public InetAddress host() {
            try {
                byte[] data = new byte[4];
                System.arraycopy(this._data, 2, data, 0, 4);
                return InetAddress.getByAddress(data);
            }
            catch (UnknownHostException e) {
                return null;
            }
        }

        public long port() {
            return this.extractInt(6);
        }

        public short counter() {
            return this.extractShort(10);
        }

        public long random() {
            return this.extractLong(20);
        }

        public String toString() {
            return this.host().getHostAddress() + ":" + this.port() + " " + this.counter() + "@" + this.timestamp();
        }
    }
}

