/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.eof;

import com.webobjects.eoaccess.EOAttribute;
import com.webobjects.eoaccess.EOEntity;
import com.webobjects.eoaccess.EOModelGroup;
import com.webobjects.eocontrol.EOEnterpriseObject;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSForwardException;
import er.extensions.eof.ERXModelGroup;
import er.extensions.foundation.ERXProperties;
import er.extensions.foundation.ERXSystem;
import er.extensions.foundation.ERXValueUtilities;
import er.extensions.jdbc.ERXJDBCConnectionBroker;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import org.apache.log4j.Logger;

public class ERXLongPrimaryKeyFactory {
    private static final int CODE_LENGTH = 6;
    private static final int HOST_CODE_LENGTH = 10;
    private static final String HOST_CODE_KEY = "er.extensions.ERXLongPrimaryKeyFactory.hostCode";
    private static final Logger log = Logger.getLogger(ERXLongPrimaryKeyFactory.class);
    private static long MAX_PK_VALUE = (long)Math.pow(2.0, 48.0);
    private Boolean encodeEntityInPkValue;
    private Boolean encodeHostInPkValue;
    private Integer hostCode;
    private Hashtable pkCache = new Hashtable();
    private Integer increaseBy;
    private static ERXLongPrimaryKeyFactory _factory;

    private Long getNextPkValueForEntity(String ename) {
        long realPk;
        long l;
        Long pk = this.cachedPkValue(ename);
        if (this.encodeHostInPkValue()) {
            l = pk;
            if (l > MAX_PK_VALUE) {
                throw new IllegalStateException("max PK value reached for entity " + ename + " cannot continue!");
            }
            realPk = l << 10;
            realPk |= (long)this.hostCode();
            if (log.isDebugEnabled()) {
                log.debug((Object)("new pk value for " + ename + "(" + ((ERXModelGroup)EOModelGroup.defaultGroup()).entityCode(ename) + "), db value = " + pk + ", new value = " + realPk));
            }
            pk = new Long(realPk);
        }
        if (this.encodeEntityInPkValue()) {
            l = pk;
            if (l > MAX_PK_VALUE) {
                throw new IllegalStateException("max PK value reached for entity " + ename + " cannot continue!");
            }
            realPk = l << 6;
            realPk |= (long)((ERXModelGroup)EOModelGroup.defaultGroup()).entityCode(ename);
            if (log.isDebugEnabled()) {
                log.debug((Object)("new pk value for " + ename + "(" + ((ERXModelGroup)EOModelGroup.defaultGroup()).entityCode(ename) + "), db value = " + pk + ", new value = " + realPk));
            }
            pk = new Long(realPk);
        }
        return pk;
    }

    public EOEntity subEntityForEntity(EOEntity entity, NSDictionary pkDict) {
        if (this.encodeEntityInPkValue()) {
            long pkValueWithCode;
            NSArray values = pkDict.allValues();
            if (values.count() > 1) {
                throw new IllegalArgumentException("subEntityForEntity in its default implementation works only with single pk long values " + entity.name() + " has " + pkDict);
            }
            try {
                Number n = (Number)values.objectAtIndex(0);
                pkValueWithCode = n.longValue();
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException("subEntityForEntity in its default implementation works only with single pk long values, expected a java.lang.Number but got a " + values.objectAtIndex(0));
            }
            long entityCode = pkValueWithCode & 0x3FL;
            if (entityCode == 0L) {
                return null;
            }
            Enumeration subEntities = entity.subEntities().objectEnumerator();
            while (subEntities.hasMoreElements()) {
                EOEntity subEntity = (EOEntity)subEntities.nextElement();
                if ((long)((ERXModelGroup)EOModelGroup.defaultGroup()).entityCode(subEntity) != entityCode) continue;
                return subEntity;
            }
        }
        return null;
    }

    private int hostCode() {
        if (this.hostCode == null) {
            this.hostCode = new Integer(ERXSystem.getProperty(HOST_CODE_KEY));
        }
        return this.hostCode;
    }

    private boolean encodeEntityInPkValue() {
        if (this.encodeEntityInPkValue == null) {
            boolean b = ERXValueUtilities.booleanValueWithDefault(System.getProperty("er.extensions.ERXLongPrimaryKeyFactory.encodeEntityInPkValue"), false);
            this.encodeEntityInPkValue = b ? Boolean.TRUE : Boolean.FALSE;
        }
        return this.encodeEntityInPkValue;
    }

    private boolean encodeHostInPkValue() {
        if (this.encodeHostInPkValue == null) {
            boolean b = ERXValueUtilities.booleanValueWithDefault(System.getProperty("er.extensions.ERXLongPrimaryKeyFactory.encodeHostInPkValue"), false);
            this.encodeHostInPkValue = b ? Boolean.TRUE : Boolean.FALSE;
        }
        return this.encodeHostInPkValue;
    }

    public static synchronized Object primaryKeyValue(String entityName) {
        return ERXLongPrimaryKeyFactory.factory().primaryKeyDictionary(entityName).objectEnumerator().nextElement();
    }

    public static synchronized NSDictionary primaryKeyDictionary(EOEnterpriseObject eo) {
        String entityName = eo.entityName();
        return ERXLongPrimaryKeyFactory.factory().primaryKeyDictionary(entityName);
    }

    private static ERXLongPrimaryKeyFactory factory() {
        if (_factory == null && (_factory = new ERXLongPrimaryKeyFactory()).encodeEntityInPkValue()) {
            EOModelGroup.defaultGroup().setDelegate((Object)_factory);
        }
        return _factory;
    }

    private NSDictionary primaryKeyDictionary(String entityName) {
        EOEntity entity = EOModelGroup.defaultGroup().entityNamed(entityName);
        while (entity.parentEntity() != null) {
            entity = entity.parentEntity();
        }
        entityName = entity.name();
        if (entity.primaryKeyAttributeNames().count() != 1) {
            throw new IllegalArgumentException("Can handle only entities with one PK: " + entityName + " has " + entity.primaryKeyAttributeNames());
        }
        Long pk = this.getNextPkValueForEntity(entityName);
        String pkName = (String)entity.primaryKeyAttributeNames().objectAtIndex(0);
        return new NSDictionary<Object, Object>(new Object[]{pk}, new Object[]{pkName});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Long getNextPkValueForEntityIncreaseBy(String entityName, int count, int increasePkBy) {
        if (increasePkBy < 1) {
            increasePkBy = 1;
        }
        String where = "where eoentity_name = '" + entityName + "'";
        ERXJDBCConnectionBroker broker = ERXJDBCConnectionBroker.connectionBrokerForEntityNamed(entityName);
        Connection con = broker.getConnection();
        try {
            try {
                con.setAutoCommit(false);
                con.setReadOnly(false);
            }
            catch (SQLException e) {
                log.error((Object)e, (Throwable)e);
            }
            for (int tries = 0; tries < count; ++tries) {
                Long l;
                try {
                    ResultSet resultSet = con.createStatement().executeQuery("select pk_value from pk_table " + where);
                    con.commit();
                    boolean hasNext = resultSet.next();
                    long pk = 1L;
                    if (hasNext) {
                        pk = resultSet.getLong("pk_value");
                        con.createStatement().executeUpdate("update pk_table set pk_value = " + (pk + (long)increasePkBy) + " " + where);
                    } else {
                        pk = this.maxIdFromTable(entityName);
                        con.createStatement().executeUpdate("insert into pk_table (eoentity_name, pk_value) values ('" + entityName + "', " + (pk + (long)increasePkBy) + ")");
                    }
                    con.commit();
                    l = new Long(pk);
                }
                catch (SQLException ex) {
                    String s = ex.getMessage().toLowerCase();
                    boolean creationError = s.indexOf("error code 116") != -1;
                    creationError |= s.indexOf("pk_table") != -1 && s.indexOf("does not exist") != -1;
                    if (!(creationError |= s.indexOf("ora-00942") != -1)) throw new NSForwardException((Throwable)ex, "Error fetching PK");
                    try {
                        con.rollback();
                        log.info((Object)"creating pk table");
                        con.createStatement().executeUpdate("create table pk_table (eoentity_name varchar(100) not null, pk_value integer)");
                        con.createStatement().executeUpdate("alter table pk_table add primary key (eoentity_name)");
                        con.commit();
                        continue;
                    }
                    catch (SQLException ee) {
                        throw new NSForwardException((Throwable)ee, "could not create pk table");
                    }
                }
                Object var14_16 = null;
                broker.freeConnection(con);
                return l;
            }
        }
        catch (Throwable throwable) {
            Object var14_18 = null;
            broker.freeConnection(con);
            throw throwable;
        }
        Object var14_17 = null;
        broker.freeConnection(con);
        throw new IllegalStateException("Couldn't get PK");
    }

    private long maxIdFromTable(String ename) {
        EOEntity entity = EOModelGroup.defaultGroup().entityNamed(ename);
        if (entity == null) {
            throw new NullPointerException("could not find an entity named " + ename);
        }
        String tableName = entity.externalName();
        String colName = ((EOAttribute)entity.primaryKeyAttributes().lastObject()).columnName();
        String sql = "select max(" + colName + ") from " + tableName;
        ERXJDBCConnectionBroker broker = ERXJDBCConnectionBroker.connectionBrokerForEntityNamed(ename);
        Connection con = broker.getConnection();
        try {
            ResultSet resultSet = con.createStatement().executeQuery(sql);
            con.commit();
            boolean hasNext = resultSet.next();
            long v = 1L;
            if (hasNext) {
                v = resultSet.getLong(1);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("received max id from table " + tableName + ", setting value in PK_TABLE to " + v));
                }
                if (this.encodeEntityInPkValue()) {
                    v >>= 6;
                }
                if (this.encodeHostInPkValue()) {
                    v >>= 10;
                }
            }
            long l = v + 1L;
            Object var15_13 = null;
            broker.freeConnection(con);
            return l;
        }
        catch (SQLException e) {
            try {
                log.error((Object)("could not call database with sql " + sql), (Throwable)e);
                throw new IllegalStateException("could not get value from " + sql);
            }
            catch (Throwable throwable) {
                Object var15_14 = null;
                broker.freeConnection(con);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Long cachedPkValue(String ename) {
        Stack s = this.cacheStack(ename);
        if (s.empty()) {
            Stack stack = s;
            synchronized (stack) {
                if (s.empty()) {
                    this.fillPkCache(s, ename);
                }
            }
        }
        Long pkValue = (Long)s.pop();
        return pkValue;
    }

    private Stack cacheStack(String ename) {
        Stack s = (Stack)this.pkCache.get(ename);
        if (s == null) {
            s = new Stack();
            this.pkCache.put(ename, s);
        }
        return s;
    }

    private void fillPkCache(Stack s, String ename) {
        Long pkValueStart = this.getNextPkValueForEntityIncreaseBy(ename, 10, this.increaseBy());
        long value = pkValueStart;
        log.debug((Object)("filling pkCache for " + ename + ", starting at " + value));
        for (int i = this.increaseBy(); i > 0; --i) {
            s.push(new Long((long)i + value));
        }
    }

    private int increaseBy() {
        if (this.increaseBy == null) {
            this.increaseBy = new Integer(ERXProperties.intForKeyWithDefault("er.extensions.ERXLongPrimaryKeyFactory.increaseBy", 1000));
        }
        return this.increaseBy;
    }
}

